/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mp3;

import codecLib.mp3.Decoder;
import codecLib.mp3.FrameInfo;
import codecLib.mp3.MPADException;
import codecLib.mp3.OutputConverter;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class JS_MP3DecoderStream
extends AudioInputStream {
    public static boolean DEBUG = false;
    private byte[] pendingData = new byte[8096];
    private int pendingDataSize = 0;
    private int pendingDataOffset = 0;
    private boolean streamEOF = false;
    private Decoder decoder = null;
    private AudioFormat sourceFormat = null;
    private float[][] fsamp = new float[12][1152];
    private int[] fsampOffset = new int[12];
    private static final int OUTSIZE = 9216;
    private byte[] outData = new byte[9216];
    private int outFrameSize = 0;
    private int outDataOffset = 0;
    private boolean outputBigEndian = false;

    JS_MP3DecoderStream(AudioInputStream stream, AudioFormat format, long length) {
        super(stream, format, length);
        this.sourceFormat = stream.getFormat();
        this.outputBigEndian = this.getFormat().isBigEndian();
        this.open();
    }

    private synchronized void open() {
        if (this.decoder != null) {
            this.close();
        }
        this.decoder = new Decoder();
        this.pendingDataSize = 0;
        this.streamEOF = false;
        if (DEBUG) {
            System.out.println("JS_MP3DecoderStream: input format:  " + this.sourceFormat);
        }
        if (DEBUG) {
            System.out.println("JS_MP3DecoderStream: output format: " + this.getFormat());
        }
        this.outFrameSize = 0;
        this.outDataOffset = 0;
    }

    public synchronized void close() {
        if (this.decoder != null) {
            this.decoder = null;
        }
    }

    public synchronized void reset() throws IOException {
        super.reset();
        if (this.decoder != null) {
            this.close();
        }
        this.open();
    }

    public int read() throws IOException {
        throw new IOException("cannot read a single byte from stream");
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public synchronized int read(byte[] b2, int off, int len) throws IOException {
        if (len % this.frameSize != 0) {
            len -= len % this.getFormat().getFrameSize();
        }
        int totalRead = 0;
        if (this.decoder == null) {
            return -1;
        }
        boolean endDecoding = false;
        while (totalRead < len) {
            int toCopyFromOutBuffer = len - totalRead;
            if (toCopyFromOutBuffer > this.outFrameSize - this.outDataOffset) {
                toCopyFromOutBuffer = this.outFrameSize - this.outDataOffset;
            }
            if (toCopyFromOutBuffer > 0) {
                System.arraycopy(this.outData, this.outDataOffset, b2, off, toCopyFromOutBuffer);
                off += toCopyFromOutBuffer;
                this.outDataOffset += toCopyFromOutBuffer;
                totalRead += toCopyFromOutBuffer;
            } else if (endDecoding) break;
            if (endDecoding || totalRead >= len) continue;
            endDecoding = this.decodeNextFrame();
        }
        if (totalRead > 0) {
            return totalRead;
        }
        if (endDecoding) {
            if (DEBUG) {
                System.out.println("Close.   outTotalSize=" + this.outFrameSize + "  outOffset=" + this.outDataOffset + "  remaining pendingData=" + this.pendingDataSize);
            }
            this.close();
            return -1;
        }
        return totalRead;
    }

    private boolean decodeNextFrame() throws IOException {
        boolean ERROR = false;
        boolean needRead = false;
        boolean skipFrame = false;
        FrameInfo info = new FrameInfo();
        do {
            if (!this.streamEOF && (needRead || this.pendingDataSize < 2024)) {
                if (this.pendingDataOffset > 0 && this.pendingDataSize > 0) {
                    System.arraycopy(this.pendingData, this.pendingDataOffset, this.pendingData, 0, this.pendingDataSize);
                }
                this.pendingDataOffset = 0;
                while (this.pendingDataSize + 20 < this.pendingData.length && !this.streamEOF) {
                    int read = super.read(this.pendingData, this.pendingDataSize, this.pendingData.length - this.pendingDataSize);
                    if (read < 0) {
                        this.streamEOF = true;
                        continue;
                    }
                    this.pendingDataSize += read;
                    if (this.pendingDataSize >= this.pendingData.length) continue;
                    Thread.yield();
                }
            }
            if (skipFrame) {
                skipFrame = false;
                try {
                    this.decoder.getCurrFrameInfo(info);
                }
                catch (MPADException e2) {
                    try {
                        this.decoder.getNextFrameInfo(info, this.pendingData, this.pendingDataOffset, this.pendingDataSize);
                    }
                    catch (MPADException e3) {
                        if (this.streamEOF) {
                            this.pendingDataSize = 0;
                            return true;
                        }
                        skipFrame = true;
                        needRead = true;
                        continue;
                    }
                }
                int byteCount = info.getHeaderOffset() + info.getFrameLength();
                if (byteCount > this.pendingDataSize) {
                    byteCount = this.pendingDataSize;
                }
                this.pendingDataOffset += byteCount;
                this.pendingDataSize -= byteCount;
                if (this.pendingDataSize < 0) {
                    this.pendingDataSize = 0;
                }
            }
            if (this.streamEOF && this.pendingDataSize <= 13) {
                return true;
            }
            try {
                int byteCount;
                boolean useDecodeLast = false;
                if (this.streamEOF && this.pendingDataSize > 0) {
                    this.decoder.getNextFrameInfo(info, this.pendingData, this.pendingDataOffset, this.pendingDataSize);
                    boolean bl = useDecodeLast = info.getFrameLength() + info.getHeaderOffset() >= this.pendingDataSize;
                }
                if (useDecodeLast) {
                    if (DEBUG) {
                        System.out.println("Using DecodeLast");
                    }
                    byteCount = this.decoder.decodeLast(this.fsamp, this.fsampOffset, this.pendingData, this.pendingDataOffset, this.pendingDataSize);
                } else {
                    byteCount = this.decoder.decode(this.fsamp, this.fsampOffset, this.pendingData, this.pendingDataOffset, this.pendingDataSize);
                }
                this.decoder.getCurrFrameInfo(info);
                this.outFrameSize = info.getNumberOfSamples() * info.getNumberOfChannels() * 2;
                if (info.getNumberOfChannels() == 1) {
                    if (this.outputBigEndian) {
                        OutputConverter.convert(this.outData, 0, this.fsamp[0], this.fsampOffset[0], info.getNumberOfSamples());
                    } else {
                        JS_MP3DecoderStream.convertLE(this.outData, 0, this.fsamp[0], this.fsampOffset[0], info.getNumberOfSamples());
                    }
                } else if (this.outputBigEndian) {
                    OutputConverter.convert(this.outData, 0, this.fsamp[0], this.fsampOffset[0], this.fsamp[1], this.fsampOffset[1], info.getNumberOfSamples());
                } else {
                    JS_MP3DecoderStream.convertLE(this.outData, 0, this.fsamp[0], this.fsampOffset[0], this.fsamp[1], this.fsampOffset[1], info.getNumberOfSamples());
                }
                this.outDataOffset = 0;
                this.pendingDataOffset += byteCount;
                this.pendingDataSize -= byteCount;
                if (this.pendingDataSize < 0) {
                    this.pendingDataSize = 0;
                }
                needRead = false;
            }
            catch (MPADException e2) {
                if (e2.getState() == -10) {
                    if (DEBUG) {
                        System.out.println("JS_MP3DecoderStream: frame not supported.");
                    }
                    skipFrame = true;
                    continue;
                }
                if (e2.getState() == -3) {
                    if (!this.streamEOF) {
                        if (this.pendingDataOffset > 0 || this.pendingDataSize < 13) {
                            if (DEBUG) {
                                System.out.println("JS_MP3DecoderStream: Low buffer -> need to read from input.");
                            }
                            needRead = true;
                            continue;
                        }
                        if (DEBUG) {
                            System.out.println("JS_MP3DecoderStream: Low buffer  but enough input data available! -> skip this frame.");
                        }
                        skipFrame = true;
                        continue;
                    }
                    if (DEBUG) {
                        System.out.println("JS_MP3DecoderStream: Low buffer but EOF -> finish");
                    }
                    this.pendingDataSize = 0;
                    break;
                }
                if (e2.getState() == -9) {
                    if (DEBUG) {
                        System.out.println("JS_MP3DecoderStream: NO_PREV-> skip this frame");
                    }
                    skipFrame = true;
                    continue;
                }
                if (e2.getState() == -7) {
                    if (DEBUG) {
                        System.out.println("JS_MP3DecoderStream: no header found -> skip this frame");
                    }
                    skipFrame = true;
                    continue;
                }
                if (DEBUG) {
                    System.out.println("JS_MP3DecoderStream: Unknown state: " + e2.getState() + ". Skipping frame.");
                }
                skipFrame = true;
            }
            catch (Exception e3) {
                if (DEBUG) {
                    System.out.println("Unexpected Exception! Advancing to next frame.");
                    e3.printStackTrace();
                }
                skipFrame = true;
            }
        } while (needRead || skipFrame);
        return this.streamEOF && this.pendingDataSize <= 13 || ERROR;
    }

    public static void convertLE(byte[] out, int outoff, float[] in, int inoff, int number) {
        for (int i2 = 0; i2 < number; ++i2) {
            float xd;
            int tmp;
            tmp = (tmp = (int)(xd = in[inoff++])) >= Short.MAX_VALUE ? Short.MAX_VALUE : (tmp <= Short.MIN_VALUE ? Short.MIN_VALUE : tmp);
            out[outoff + i2 * 2] = (byte)tmp;
            out[outoff + i2 * 2 + 1] = (byte)(tmp >> 8);
        }
    }

    public static void convertLE(byte[] out, int outoff, float[] in1, int inoff1, float[] in2, int inoff2, int number) {
        for (int i2 = 0; i2 < number; ++i2) {
            float xd;
            int tmp;
            tmp = (tmp = (int)(xd = in1[inoff1++])) >= Short.MAX_VALUE ? Short.MAX_VALUE : (tmp <= Short.MIN_VALUE ? Short.MIN_VALUE : tmp);
            out[outoff + i2 * 4] = (byte)tmp;
            out[outoff + i2 * 4 + 1] = (byte)(tmp >> 8);
            xd = in2[inoff2++];
            tmp = (int)xd;
            tmp = tmp >= Short.MAX_VALUE ? Short.MAX_VALUE : (tmp <= Short.MIN_VALUE ? Short.MIN_VALUE : tmp);
            out[outoff + i2 * 4 + 2] = (byte)tmp;
            out[outoff + i2 * 4 + 3] = (byte)(tmp >> 8);
        }
    }

    static {
        if (DEBUG) {
            System.out.println("JS_MP3DecoderStream: DEBUG enabled");
        }
    }
}

