/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.StaticGLInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public final class FunctionAvailabilityCache {
    private static final boolean DEBUG = Debug.debug("FunctionAvailabilityCache");
    private HashMap availabilityCache = new HashMap(50);
    private HashSet availableExtensionCache = new HashSet(50);
    private GLContextImpl context;

    FunctionAvailabilityCache(GLContextImpl gLContextImpl) {
        this.context = gLContextImpl;
    }

    public void flush() {
        this.availabilityCache.clear();
        this.availableExtensionCache.clear();
    }

    public boolean isFunctionAvailable(String string) {
        Boolean bl;
        if (DEBUG) {
            System.err.println("!!! CHECKING FOR AVAILABILITY OF: " + string);
        }
        if ((bl = (Boolean)this.availabilityCache.get(string)) == null) {
            bl = this.isPartOfAvailableExtensions(string) || FunctionAvailabilityCache.isPartOfGLCore(this.context.getGL().glGetString(7938), string) ? Boolean.TRUE : Boolean.FALSE;
            this.availabilityCache.put(string, bl);
        }
        if (DEBUG) {
            System.err.println("!!! AVAILABILITY OF " + string + ": " + bl);
        }
        return bl;
    }

    public boolean isExtensionAvailable(String string) {
        this.initAvailableExtensions();
        return this.availableExtensionCache.contains(string);
    }

    protected void initAvailableExtensions() {
        if (this.availableExtensionCache.isEmpty()) {
            Object object;
            GL gL = this.context.getGL();
            if (DEBUG) {
                System.err.println("!!! Pre-caching extension availability");
            }
            String string = gL.glGetString(7939) + " " + this.context.getPlatformExtensionsString();
            if (DEBUG) {
                System.err.println("!!! Available extensions: " + string);
                System.err.println("!!! GL vendor: " + gL.glGetString(7936));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                object = ((String)object).intern();
                this.availableExtensionCache.add(object);
                if (!DEBUG) continue;
                System.err.println("!!!   Available: " + (String)object);
            }
            object = new Version(gL.glGetString(7938));
            int n = ((Version)object).getMajor();
            int n2 = ((Version)object).getMinor();
            switch (n) {
                default: {
                    if (n < 2) break;
                }
                case 2: {
                    this.availableExtensionCache.add("GL_VERSION_2_0");
                    n2 = 5;
                }
                case 1: {
                    switch (n2) {
                        case 5: {
                            this.availableExtensionCache.add("GL_VERSION_1_5");
                        }
                        case 4: {
                            this.availableExtensionCache.add("GL_VERSION_1_4");
                        }
                        case 3: {
                            this.availableExtensionCache.add("GL_VERSION_1_3");
                        }
                        case 2: {
                            this.availableExtensionCache.add("GL_VERSION_1_2");
                        }
                        case 1: {
                            this.availableExtensionCache.add("GL_VERSION_1_1");
                        }
                        case 0: {
                            this.availableExtensionCache.add("GL_VERSION_1_0");
                        }
                    }
                }
            }
            this.availableExtensionCache.add("<INTERNAL_DUMMY_PLACEHOLDER>");
        }
    }

    protected boolean isPartOfAvailableExtensions(String string) {
        this.initAvailableExtensions();
        String string2 = FunctionAvailabilityCache.getExtensionCorrespondingToFunction(string);
        boolean bl = this.availableExtensionCache.contains(string2);
        return bl;
    }

    public static boolean isPartOfGLCore(String string, String string2) {
        Version version;
        Version version2;
        String string3 = StaticGLInfo.getFunctionAssociation(string2);
        if (string3 == null) {
            throw new GLException("Function \"" + string2 + "\" does not " + "correspond to any known OpenGL extension or core version.");
        }
        try {
            version2 = new Version(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        try {
            version = new Version(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Illegally formatted OpenGL version identifier: \"" + string + "\"");
        }
        if (version2.compareTo(version) <= 0) {
            if (DEBUG) {
                System.err.println(string2 + " is in core OpenGL " + string + " because it is in OpenGL " + string3);
            }
            return true;
        }
        if (DEBUG) {
            System.err.println(string2 + " is NOT a part of the OpenGL " + string + " core" + "; it is part of OpenGL " + string3);
        }
        return false;
    }

    protected static String getExtensionCorrespondingToFunction(String string) {
        return StaticGLInfo.getFunctionAssociation(string);
    }

    private static class Version
    implements Comparable {
        private int major;
        private int minor;
        private int sub;

        public Version(int n, int n2, int n3) {
            this.major = n;
            this.minor = n2;
            this.sub = n3;
        }

        public Version(String string) {
            try {
                if (string.startsWith("GL_VERSION_")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.major = 0;
                        return;
                    }
                    this.major = Integer.valueOf(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.minor = 0;
                        return;
                    }
                    this.minor = Integer.valueOf(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.sub = 0;
                        return;
                    }
                    this.sub = Integer.valueOf(stringTokenizer.nextToken());
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
                    this.major = Integer.valueOf(stringTokenizer.nextToken());
                    this.minor = Integer.valueOf(stringTokenizer.nextToken());
                    stringTokenizer = new StringTokenizer(string, " ");
                    if (stringTokenizer.hasMoreTokens()) {
                        Pattern pattern;
                        Matcher matcher;
                        stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens() && (matcher = (pattern = Pattern.compile("\\D*(\\d+)\\.(\\d+)\\.?(\\d*).*")).matcher(stringTokenizer.nextToken())).matches()) {
                            int n = Integer.valueOf(matcher.group(1));
                            int n2 = Integer.valueOf(matcher.group(2));
                            if (n == this.major && n2 > this.minor) {
                                this.minor = n2;
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw (IllegalArgumentException)new IllegalArgumentException("Illegally formatted version identifier: \"" + string + "\"").initCause(exception);
            }
        }

        public int compareTo(Object object) {
            Version version = (Version)object;
            if (this.major > version.major) {
                return 1;
            }
            if (this.major < version.major) {
                return -1;
            }
            if (this.minor > version.minor) {
                return 1;
            }
            if (this.minor < version.minor) {
                return -1;
            }
            if (this.sub > version.sub) {
                return 1;
            }
            if (this.sub < version.sub) {
                return -1;
            }
            return 0;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }
    }
}

