/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.gluegen.runtime.DynamicLookupHelper;
import com.sun.opengl.impl.GLDrawableImpl;
import java.nio.Buffer;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLDrawableFactory;

public abstract class GLDrawableFactoryImpl
extends GLDrawableFactory
implements DynamicLookupHelper {
    private boolean gammaShutdownHookRegistered;
    private Thread gammaShutdownHook;
    private Buffer originalGammaRamp;

    public abstract GLDrawableImpl createOffscreenDrawable(GLCapabilities var1, GLCapabilitiesChooser var2);

    public abstract long dynamicLookupFunction(String var1);

    public abstract void lockAWTForJava2D();

    public abstract void unlockAWTForJava2D();

    public static GLDrawableFactoryImpl getFactoryImpl() {
        return (GLDrawableFactoryImpl)GLDrawableFactoryImpl.getFactory();
    }

    public abstract void loadGLULibrary();

    public boolean setDisplayGamma(float f, float f2, float f3) throws IllegalArgumentException {
        if (f2 < -1.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Brightness must be between -1.0 and 1.0");
        }
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("Contrast must be greater than 0.0");
        }
        int n = this.getGammaRampLength();
        if (n == 0) {
            return false;
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            float f4 = (float)i / (float)(n - 1);
            float f5 = (float)Math.pow(f4, f);
            f5 += f2;
            if ((f5 = (f5 - 0.5f) * f3 + 0.5f) > 1.0f) {
                f5 = 1.0f;
            } else if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            fArray[i] = f5;
        }
        this.registerGammaShutdownHook();
        return this.setGammaRamp(fArray);
    }

    public synchronized void resetDisplayGamma() {
        if (this.gammaShutdownHook == null) {
            throw new IllegalArgumentException("Should not call this unless setDisplayGamma called first");
        }
        this.resetGammaRamp(this.originalGammaRamp);
        this.unregisterGammeShutdownHook();
    }

    protected int getGammaRampLength() {
        return 0;
    }

    protected boolean setGammaRamp(float[] fArray) {
        return false;
    }

    protected Buffer getGammaRamp() {
        return null;
    }

    protected void resetGammaRamp(Buffer buffer) {
    }

    private synchronized void registerGammaShutdownHook() {
        if (this.gammaShutdownHookRegistered) {
            return;
        }
        if (this.gammaShutdownHook == null) {
            this.gammaShutdownHook = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    GLDrawableFactoryImpl gLDrawableFactoryImpl = GLDrawableFactoryImpl.this;
                    synchronized (gLDrawableFactoryImpl) {
                        GLDrawableFactoryImpl.this.resetGammaRamp(GLDrawableFactoryImpl.this.originalGammaRamp);
                    }
                }
            });
            this.originalGammaRamp = this.getGammaRamp();
        }
        Runtime.getRuntime().addShutdownHook(this.gammaShutdownHook);
        this.gammaShutdownHookRegistered = true;
    }

    private synchronized void unregisterGammeShutdownHook() {
        if (!this.gammaShutdownHookRegistered) {
            return;
        }
        if (this.gammaShutdownHook == null) {
            throw new InternalError("Error in gamma shutdown hook logic");
        }
        Runtime.getRuntime().removeShutdownHook(this.gammaShutdownHook);
        this.gammaShutdownHookRegistered = false;
    }
}

