/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLDrawableHelper;
import com.sun.opengl.impl.GLDrawableImpl;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.Threading;

public class GLPbufferImpl
implements GLPbuffer {
    private GLDrawableImpl pbufferDrawable;
    private GLContextImpl context;
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private int floatMode;
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();
    private DisplayOnEventDispatchThreadAction displayOnEventDispatchThreadAction = new DisplayOnEventDispatchThreadAction();
    private SwapBuffersOnEventDispatchThreadAction swapBuffersOnEventDispatchThreadAction = new SwapBuffersOnEventDispatchThreadAction();
    private DestroyAction destroyAction = new DestroyAction();

    public GLPbufferImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        this.pbufferDrawable = gLDrawableImpl;
        this.context = (GLContextImpl)gLDrawableImpl.createContext(gLContext);
        this.context.setSynchronized(true);
    }

    public GLContext createContext(GLContext gLContext) {
        return this.pbufferDrawable.createContext(gLContext);
    }

    public void setRealized(boolean bl) {
    }

    public void setSize(int n, int n2) {
        throw new GLException("Not yet implemented");
    }

    public int getWidth() {
        return this.pbufferDrawable.getWidth();
    }

    public int getHeight() {
        return this.pbufferDrawable.getHeight();
    }

    public void display() {
        this.maybeDoSingleThreadedWorkaround(this.displayOnEventDispatchThreadAction, this.displayAction, false);
    }

    public void repaint() {
        this.display();
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    public GLContext getContext() {
        return this.context;
    }

    public GLDrawable getDrawable() {
        return this.pbufferDrawable;
    }

    public GL getGL() {
        return this.getContext().getGL();
    }

    public void setGL(GL gL) {
        this.getContext().setGL(gL);
    }

    public void setAutoSwapBufferMode(boolean bl) {
        this.drawableHelper.setAutoSwapBufferMode(bl);
    }

    public boolean getAutoSwapBufferMode() {
        return this.drawableHelper.getAutoSwapBufferMode();
    }

    public void swapBuffers() {
        this.maybeDoSingleThreadedWorkaround(this.swapBuffersOnEventDispatchThreadAction, this.swapBuffersAction, false);
    }

    public void bindTexture() {
        this.context.bindPbufferToTexture();
    }

    public void releaseTexture() {
        this.context.releasePbufferFromTexture();
    }

    public void addComponentListener(ComponentListener componentListener) {
    }

    public void removeComponentListener(ComponentListener componentListener) {
    }

    public void addFocusListener(FocusListener focusListener) {
    }

    public void removeFocusListener(FocusListener focusListener) {
    }

    public void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
    }

    public void removeHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
    }

    public void addHierarchyListener(HierarchyListener hierarchyListener) {
    }

    public void removeHierarchyListener(HierarchyListener hierarchyListener) {
    }

    public void addInputMethodListener(InputMethodListener inputMethodListener) {
    }

    public void removeInputMethodListener(InputMethodListener inputMethodListener) {
    }

    public void addKeyListener(KeyListener keyListener) {
    }

    public void removeKeyListener(KeyListener keyListener) {
    }

    public void addMouseListener(MouseListener mouseListener) {
    }

    public void removeMouseListener(MouseListener mouseListener) {
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
    }

    public void destroy() {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(this.destroyAction);
        } else {
            this.destroyAction.run();
        }
    }

    public int getFloatingPointMode() {
        if (this.floatMode == 0) {
            throw new GLException("Pbuffer not initialized, or floating-point support not requested");
        }
        return this.floatMode;
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable, Runnable runnable2, boolean bl) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
        } else {
            this.drawableHelper.invokeGL(this.pbufferDrawable, this.context, runnable2, this.initAction);
        }
    }

    class DestroyAction
    implements Runnable {
        DestroyAction() {
        }

        public void run() {
            GLContext gLContext = GLContext.getCurrent();
            if (gLContext == GLPbufferImpl.this.context) {
                GLPbufferImpl.this.context.release();
            }
            GLPbufferImpl.this.context.destroy();
            GLPbufferImpl.this.pbufferDrawable.destroy();
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            GLPbufferImpl.this.drawableHelper.display(GLPbufferImpl.this);
        }
    }

    class DisplayOnEventDispatchThreadAction
    implements Runnable {
        DisplayOnEventDispatchThreadAction() {
        }

        public void run() {
            GLPbufferImpl.this.drawableHelper.invokeGL(GLPbufferImpl.this.pbufferDrawable, GLPbufferImpl.this.context, GLPbufferImpl.this.displayAction, GLPbufferImpl.this.initAction);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLPbufferImpl.this.floatMode = GLPbufferImpl.this.context.getFloatingPointMode();
            GLPbufferImpl.this.drawableHelper.init(GLPbufferImpl.this);
        }
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        public void run() {
            GLPbufferImpl.this.pbufferDrawable.swapBuffers();
        }
    }

    class SwapBuffersOnEventDispatchThreadAction
    implements Runnable {
        SwapBuffersOnEventDispatchThreadAction() {
        }

        public void run() {
            GLPbufferImpl.this.drawableHelper.invokeGL(GLPbufferImpl.this.pbufferDrawable, GLPbufferImpl.this.context, GLPbufferImpl.this.swapBuffersAction, GLPbufferImpl.this.initAction);
        }
    }
}

