/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx;

import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.macosx.CGL;
import com.sun.opengl.impl.macosx.CGLExt;
import com.sun.opengl.impl.macosx.CGLExtImpl;
import com.sun.opengl.impl.macosx.CGLExtProcAddressTable;
import com.sun.opengl.impl.macosx.MacOSXGLDrawable;
import java.nio.ByteBuffer;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;

public abstract class MacOSXGLContext
extends GLContextImpl {
    protected MacOSXGLDrawable drawable;
    protected long nsContext;
    private CGLExt cglExt;
    private CGLExtProcAddressTable cglExtProcAddressTable;

    public MacOSXGLContext(MacOSXGLDrawable macOSXGLDrawable, GLContext gLContext) {
        super(gLContext);
        this.drawable = macOSXGLDrawable;
    }

    public Object getPlatformGLExtensions() {
        return this.getCGLExt();
    }

    public CGLExt getCGLExt() {
        if (this.cglExt == null) {
            this.cglExt = new CGLExtImpl(this);
        }
        return this.cglExt;
    }

    public GLDrawable getGLDrawable() {
        return this.drawable;
    }

    protected String mapToRealGLFunctionName(String string) {
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        return string;
    }

    protected abstract boolean create();

    protected boolean create(boolean bl, boolean bl2) {
        MacOSXGLContext macOSXGLContext = (MacOSXGLContext)GLContextShareSet.getShareContext(this);
        long l = 0L;
        if (macOSXGLContext != null && (l = macOSXGLContext.getNSContext()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        int[] nArray = new int[1];
        GLCapabilities gLCapabilities = this.drawable.getCapabilities();
        this.nsContext = CGL.createContext(l, this.drawable.getView(), gLCapabilities.getDoubleBuffered() ? 1 : 0, gLCapabilities.getStereo() ? 1 : 0, gLCapabilities.getRedBits(), gLCapabilities.getGreenBits(), gLCapabilities.getBlueBits(), gLCapabilities.getAlphaBits(), gLCapabilities.getDepthBits(), gLCapabilities.getStencilBits(), gLCapabilities.getAccumRedBits(), gLCapabilities.getAccumGreenBits(), gLCapabilities.getAccumBlueBits(), gLCapabilities.getAccumAlphaBits(), gLCapabilities.getSampleBuffers() ? 1 : 0, gLCapabilities.getNumSamples(), bl ? 1 : 0, bl2 ? 1 : 0, nArray, 0);
        if (this.nsContext == 0L) {
            if (nArray[0] == 1) {
                if (DEBUG) {
                    System.err.println("!!! View not ready for " + this.getClass().getName());
                }
                return false;
            }
            throw new GLException("Error creating nsContext");
        }
        GLContextShareSet.contextCreated(this);
        return true;
    }

    protected int makeCurrentImpl() throws GLException {
        boolean bl = false;
        if (this.nsContext == 0L) {
            if (!this.create()) {
                return 0;
            }
            if (DEBUG) {
                System.err.println("!!! Created GL nsContext for " + this.getClass().getName());
            }
            bl = true;
        }
        if (!CGL.makeCurrentContext(this.nsContext)) {
            throw new GLException("Error making nsContext current");
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            return 2;
        }
        return 1;
    }

    protected void releaseImpl() throws GLException {
        if (!CGL.clearCurrentContext(this.nsContext)) {
            throw new GLException("Error freeing OpenGL nsContext");
        }
    }

    protected void destroyImpl() throws GLException {
        if (this.nsContext != 0L) {
            if (!CGL.deleteContext(this.nsContext)) {
                throw new GLException("Unable to delete OpenGL context");
            }
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL context " + this.nsContext);
            }
            this.nsContext = 0L;
            GLContextShareSet.contextDestroyed(this);
        }
    }

    public boolean isCreated() {
        return this.nsContext != 0L;
    }

    protected void resetGLFunctionAvailability() {
        super.resetGLFunctionAvailability();
        if (DEBUG) {
            System.err.println("!!! Initializing CGL extension address table");
        }
        this.resetProcAddressTable(this.getCGLExtProcAddressTable());
    }

    public CGLExtProcAddressTable getCGLExtProcAddressTable() {
        if (this.cglExtProcAddressTable == null) {
            this.cglExtProcAddressTable = new CGLExtProcAddressTable();
        }
        return this.cglExtProcAddressTable;
    }

    public String getPlatformExtensionsString() {
        return "";
    }

    public void setSwapInterval(int n) {
        if (this.nsContext == 0L) {
            throw new GLException("OpenGL context not current");
        }
        CGL.setSwapInterval(this.nsContext, n);
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Not yet implemented");
    }

    protected boolean isFunctionAvailable(String string) {
        return super.isFunctionAvailable(string);
    }

    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return true;
        }
        return super.isExtensionAvailable(string);
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    public long getNSContext() {
        return this.nsContext;
    }
}

