/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.macosx.CGL;
import com.sun.opengl.impl.macosx.MacOSXGLDrawable;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLContext;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class MacOSXPbufferGLDrawable
extends MacOSXGLDrawable {
    private static final boolean DEBUG = Debug.debug("MacOSXPbufferGLContext");
    protected int initWidth;
    protected int initHeight;
    protected long pBuffer;
    protected int width;
    protected int height;
    private int textureTarget;
    private int texture;

    public MacOSXPbufferGLDrawable(GLCapabilities gLCapabilities, int n, int n2) {
        super(gLCapabilities, null);
        this.initWidth = n;
        this.initHeight = n2;
        this.createPbuffer();
    }

    public GLContext createContext(GLContext gLContext) {
        return new MacOSXPbufferGLContext(this, gLContext);
    }

    public void destroy() {
        if (this.pBuffer != 0L) {
            CGL.destroyPBuffer(0L, this.pBuffer);
            this.pBuffer = 0L;
            if (DEBUG) {
                System.err.println("Destroyed pbuffer " + this.width + " x " + this.height);
            }
        }
    }

    public void setSize(int n, int n2) {
        throw new GLException("Not yet implemented");
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public GLCapabilities getCapabilities() {
        return this.capabilities;
    }

    public long getPbuffer() {
        return this.pBuffer;
    }

    public void swapBuffers() throws GLException {
    }

    protected void createPbuffer() {
        int n;
        if (this.capabilities.getPbufferRenderToTextureRectangle()) {
            this.width = this.initWidth;
            this.height = this.initHeight;
            n = 34037;
        } else {
            this.width = this.getNextPowerOf2(this.initWidth);
            this.height = this.getNextPowerOf2(this.initHeight);
            n = 3553;
        }
        int n2 = 6408;
        if (this.capabilities.getPbufferFloatingPointBuffers()) {
            switch (this.capabilities.getRedBits()) {
                case 16: {
                    n2 = 34842;
                    break;
                }
                case 32: {
                    n2 = 34836;
                    break;
                }
                default: {
                    throw new GLException("Invalid floating-point bit depth (only 16 and 32 supported)");
                }
            }
        }
        this.pBuffer = CGL.createPBuffer(n, n2, this.width, this.height);
        if (this.pBuffer == 0L) {
            throw new GLException("pbuffer creation error: CGL.createPBuffer() failed");
        }
        if (DEBUG) {
            System.err.println("Created pbuffer 0x" + MacOSXPbufferGLDrawable.toHexString(this.pBuffer) + ", " + this.width + " x " + this.height + " for " + this);
        }
    }

    private int getNextPowerOf2(int n) {
        if ((n - 1 & n) == 0) {
            return n;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return 1 << n2;
    }
}

