/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.windows.PIXELFORMATDESCRIPTOR;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WGLExt;
import com.sun.opengl.impl.windows.WindowsDummyGLDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLException;

public abstract class WindowsGLDrawable
extends GLDrawableImpl {
    protected static final boolean DEBUG;
    protected long hdc;
    protected GLCapabilities capabilities;
    protected GLCapabilitiesChooser chooser;
    protected boolean pixelFormatChosen;
    protected static final int MAX_PFORMATS = 256;
    protected static final int MAX_ATTRIBS = 256;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WindowsGLDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        this.capabilities = (GLCapabilities)gLCapabilities.clone();
        this.chooser = gLCapabilitiesChooser;
    }

    public void setRealized(boolean bl) {
        throw new GLException("Should not call this (should only be called for onscreen GLDrawables)");
    }

    public void destroy() {
        throw new GLException("Should not call this (should only be called for offscreen GLDrawables)");
    }

    public void swapBuffers() throws GLException {
    }

    public long getHDC() {
        return this.hdc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void choosePixelFormat(boolean bl) {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = null;
        int n = 0;
        if (bl) {
            if (WGL.GetPixelFormat(this.hdc) != 0) {
                if (DEBUG) {
                    System.err.println("NOTE: pixel format already chosen (by Java2D/OpenGL pipeline?) for window: " + WGL.GetPixelFormat(this.hdc));
                }
                this.pixelFormatChosen = true;
                return;
            }
            GLCapabilities[] gLCapabilitiesArray = null;
            int n2 = 0;
            pIXELFORMATDESCRIPTOR = WindowsGLDrawable.newPixelFormatDescriptor();
            WindowsDummyGLDrawable windowsDummyGLDrawable = null;
            GLContextImpl gLContextImpl = null;
            WGLExt wGLExt = null;
            if (this.capabilities.getSampleBuffers() && (gLContextImpl = (GLContextImpl)(windowsDummyGLDrawable = new WindowsDummyGLDrawable()).createContext(null)) != null) {
                gLContextImpl.makeCurrent();
                wGLExt = (WGLExt)gLContextImpl.getPlatformGLExtensions();
            }
            int n3 = -1;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (wGLExt != null) {
                try {
                    bl2 = wGLExt.isExtensionAvailable("WGL_ARB_pixel_format");
                    if (bl2) {
                        bl3 = wGLExt.isExtensionAvailable("WGL_ARB_multisample");
                        int[] nArray = new int[512];
                        int[] nArray2 = new int[512];
                        float[] fArray = new float[1];
                        if (WindowsGLDrawable.glCapabilities2iattributes(this.capabilities, nArray, wGLExt, false, null)) {
                            int[] nArray3 = new int[256];
                            int[] nArray4 = new int[1];
                            if (wGLExt.wglChoosePixelFormatARB(this.hdc, nArray, 0, fArray, 0, 256, nArray3, 0, nArray4, 0)) {
                                n2 = nArray4[0];
                                if (n2 > 0) {
                                    n3 = nArray3[0] - 1;
                                    if (DEBUG) {
                                        System.err.println(WindowsGLDrawable.getThreadName() + ": Used wglChoosePixelFormatARB to recommend pixel format " + n3);
                                    }
                                }
                            } else if (DEBUG) {
                                System.err.println(WindowsGLDrawable.getThreadName() + ": wglChoosePixelFormatARB failed: " + WGL.GetLastError());
                                Thread.dumpStack();
                            }
                            if (DEBUG && n3 < 0) {
                                System.err.print(WindowsGLDrawable.getThreadName() + ": wglChoosePixelFormatARB didn't recommend a pixel format");
                                if (this.capabilities.getSampleBuffers()) {
                                    System.err.print(" for multisampled GLCapabilities");
                                }
                                System.err.println();
                            }
                            int n4 = 0;
                            nArray[0] = 8192;
                            if (wGLExt.wglGetPixelFormatAttribivARB(this.hdc, 0, 0, 1, nArray, 0, nArray2, 0)) {
                                n2 = nArray2[0];
                                if (DEBUG) {
                                    System.err.println("wglGetPixelFormatAttribivARB reported WGL_NUMBER_PIXEL_FORMATS_ARB = " + n2);
                                }
                                nArray[n4++] = 8193;
                                nArray[n4++] = 8195;
                                nArray[n4++] = 8208;
                                nArray[n4++] = 8226;
                                nArray[n4++] = 8227;
                                nArray[n4++] = 8209;
                                nArray[n4++] = 8210;
                                nArray[n4++] = 8211;
                                nArray[n4++] = 8213;
                                nArray[n4++] = 8215;
                                nArray[n4++] = 8217;
                                nArray[n4++] = 8219;
                                nArray[n4++] = 8222;
                                nArray[n4++] = 8223;
                                nArray[n4++] = 8224;
                                nArray[n4++] = 8225;
                                if (bl3) {
                                    nArray[n4++] = 8257;
                                    nArray[n4++] = 8258;
                                }
                                gLCapabilitiesArray = new GLCapabilities[n2];
                                for (int i = 0; i < n2; ++i) {
                                    if (!wGLExt.wglGetPixelFormatAttribivARB(this.hdc, i + 1, 0, n4, nArray, 0, nArray2, 0)) {
                                        throw new GLException("Error getting pixel format attributes for pixel format " + (i + 1) + " of device context");
                                    }
                                    gLCapabilitiesArray[i] = WindowsGLDrawable.iattributes2GLCapabilities(nArray, n4, nArray2, true);
                                }
                                bl4 = true;
                            } else {
                                long l = WGL.GetLastError();
                                if (l != 0L) {
                                    throw new GLException("Unable to enumerate pixel formats of window using wglGetPixelFormatAttribivARB: error code " + WGL.GetLastError());
                                }
                            }
                        }
                    }
                }
                finally {
                    gLContextImpl.release();
                    gLContextImpl.destroy();
                    ((WindowsGLDrawable)windowsDummyGLDrawable).destroy();
                }
            }
            if (!bl4) {
                if (DEBUG) {
                    if (!this.capabilities.getSampleBuffers()) {
                        System.err.println(WindowsGLDrawable.getThreadName() + ": Using ChoosePixelFormat because multisampling not requested");
                    } else {
                        System.err.println(WindowsGLDrawable.getThreadName() + ": Using ChoosePixelFormat because no wglChoosePixelFormatARB");
                    }
                }
                pIXELFORMATDESCRIPTOR = WindowsGLDrawable.glCapabilities2PFD(this.capabilities, bl);
                n3 = WGL.ChoosePixelFormat(this.hdc, pIXELFORMATDESCRIPTOR) - 1;
                n2 = WGL.DescribePixelFormat(this.hdc, 1, 0, null);
                if (n2 == 0) {
                    throw new GLException("Unable to enumerate pixel formats of window for GLCapabilitiesChooser");
                }
                gLCapabilitiesArray = new GLCapabilities[n2];
                for (int i = 0; i < n2; ++i) {
                    if (WGL.DescribePixelFormat(this.hdc, 1 + i, pIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0) {
                        throw new GLException("Error describing pixel format " + (1 + i) + " of device context");
                    }
                    gLCapabilitiesArray[i] = WindowsGLDrawable.pfd2GLCapabilities(pIXELFORMATDESCRIPTOR);
                }
            }
            if ((n = this.chooser.chooseCapabilities(this.capabilities, gLCapabilitiesArray, n3)) < 0 || n >= n2) {
                throw new GLException("Invalid result " + n + " from GLCapabilitiesChooser (should be between 0 and " + (n2 - 1) + ")");
            }
            if (DEBUG) {
                System.err.println(WindowsGLDrawable.getThreadName() + ": Chosen pixel format (" + n + "):");
                System.err.println(gLCapabilitiesArray[n]);
            }
            if (WGL.DescribePixelFormat(this.hdc, ++n, pIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0) {
                throw new GLException("Error re-describing the chosen pixel format: " + WGL.GetLastError());
            }
        } else {
            pIXELFORMATDESCRIPTOR = WindowsGLDrawable.glCapabilities2PFD(this.capabilities, bl);
            n = WGL.ChoosePixelFormat(this.hdc, pIXELFORMATDESCRIPTOR);
        }
        if (!WGL.SetPixelFormat(this.hdc, n, pIXELFORMATDESCRIPTOR)) {
            long l = WGL.GetLastError();
            if (DEBUG) {
                System.err.println(WindowsGLDrawable.getThreadName() + ": SetPixelFormat failed: current context = " + WGL.wglGetCurrentContext() + ", current DC = " + WGL.wglGetCurrentDC());
                System.err.println(WindowsGLDrawable.getThreadName() + ": GetPixelFormat(hdc " + WindowsGLDrawable.toHexString(this.hdc) + ") returns " + WGL.GetPixelFormat(this.hdc));
            }
            throw new GLException("Unable to set pixel format " + n + " for device context " + WindowsGLDrawable.toHexString(this.hdc) + ": error code " + l);
        }
        this.pixelFormatChosen = true;
    }

    protected static PIXELFORMATDESCRIPTOR glCapabilities2PFD(GLCapabilities gLCapabilities, boolean bl) {
        int n = gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
        if (n < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsGLDrawable.newPixelFormatDescriptor();
        int n2 = 4128;
        if (gLCapabilities.getDoubleBuffered()) {
            n2 |= 1;
        }
        n2 = bl ? (n2 |= 4) : (n2 |= 8);
        if (gLCapabilities.getStereo()) {
            n2 |= 2;
        }
        pIXELFORMATDESCRIPTOR.dwFlags(n2);
        pIXELFORMATDESCRIPTOR.iPixelType((byte)0);
        pIXELFORMATDESCRIPTOR.cColorBits((byte)n);
        pIXELFORMATDESCRIPTOR.cRedBits((byte)gLCapabilities.getRedBits());
        pIXELFORMATDESCRIPTOR.cGreenBits((byte)gLCapabilities.getGreenBits());
        pIXELFORMATDESCRIPTOR.cBlueBits((byte)gLCapabilities.getBlueBits());
        pIXELFORMATDESCRIPTOR.cAlphaBits((byte)gLCapabilities.getAlphaBits());
        int n3 = gLCapabilities.getAccumRedBits() + gLCapabilities.getAccumGreenBits() + gLCapabilities.getAccumBlueBits();
        pIXELFORMATDESCRIPTOR.cAccumBits((byte)n3);
        pIXELFORMATDESCRIPTOR.cAccumRedBits((byte)gLCapabilities.getAccumRedBits());
        pIXELFORMATDESCRIPTOR.cAccumGreenBits((byte)gLCapabilities.getAccumGreenBits());
        pIXELFORMATDESCRIPTOR.cAccumBlueBits((byte)gLCapabilities.getAccumBlueBits());
        pIXELFORMATDESCRIPTOR.cAccumAlphaBits((byte)gLCapabilities.getAccumAlphaBits());
        pIXELFORMATDESCRIPTOR.cDepthBits((byte)gLCapabilities.getDepthBits());
        pIXELFORMATDESCRIPTOR.cStencilBits((byte)gLCapabilities.getStencilBits());
        pIXELFORMATDESCRIPTOR.iLayerType((byte)0);
        return pIXELFORMATDESCRIPTOR;
    }

    protected static PIXELFORMATDESCRIPTOR newPixelFormatDescriptor() {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = PIXELFORMATDESCRIPTOR.create();
        pIXELFORMATDESCRIPTOR.nSize((short)pIXELFORMATDESCRIPTOR.size());
        pIXELFORMATDESCRIPTOR.nVersion((short)1);
        return pIXELFORMATDESCRIPTOR;
    }

    protected static GLCapabilities pfd2GLCapabilities(PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        if ((pIXELFORMATDESCRIPTOR.dwFlags() & 0x20) == 0) {
            return null;
        }
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setRedBits(pIXELFORMATDESCRIPTOR.cRedBits());
        gLCapabilities.setGreenBits(pIXELFORMATDESCRIPTOR.cGreenBits());
        gLCapabilities.setBlueBits(pIXELFORMATDESCRIPTOR.cBlueBits());
        gLCapabilities.setAlphaBits(pIXELFORMATDESCRIPTOR.cAlphaBits());
        gLCapabilities.setAccumRedBits(pIXELFORMATDESCRIPTOR.cAccumRedBits());
        gLCapabilities.setAccumGreenBits(pIXELFORMATDESCRIPTOR.cAccumGreenBits());
        gLCapabilities.setAccumBlueBits(pIXELFORMATDESCRIPTOR.cAccumBlueBits());
        gLCapabilities.setAccumAlphaBits(pIXELFORMATDESCRIPTOR.cAccumAlphaBits());
        gLCapabilities.setDepthBits(pIXELFORMATDESCRIPTOR.cDepthBits());
        gLCapabilities.setStencilBits(pIXELFORMATDESCRIPTOR.cStencilBits());
        gLCapabilities.setDoubleBuffered((pIXELFORMATDESCRIPTOR.dwFlags() & 1) != 0);
        gLCapabilities.setStereo((pIXELFORMATDESCRIPTOR.dwFlags() & 2) != 0);
        gLCapabilities.setHardwareAccelerated((pIXELFORMATDESCRIPTOR.dwFlags() & 0x40) == 0 || (pIXELFORMATDESCRIPTOR.dwFlags() & 0x1000) != 0);
        return gLCapabilities;
    }

    protected static boolean glCapabilities2iattributes(GLCapabilities gLCapabilities, int[] nArray, WGLExt wGLExt, boolean bl, int[] nArray2) throws GLException {
        if (!wGLExt.isExtensionAvailable("WGL_ARB_pixel_format")) {
            return false;
        }
        int n = 0;
        nArray[n++] = 8208;
        nArray[n++] = 1;
        if (bl) {
            nArray[n++] = 8237;
            nArray[n++] = 1;
        } else {
            nArray[n++] = 8193;
            nArray[n++] = 1;
        }
        nArray[n++] = 8209;
        nArray[n++] = gLCapabilities.getDoubleBuffered() ? 1 : 0;
        nArray[n++] = 8210;
        nArray[n++] = gLCapabilities.getStereo() ? 1 : 0;
        nArray[n++] = 8226;
        nArray[n++] = gLCapabilities.getDepthBits();
        nArray[n++] = 8213;
        nArray[n++] = gLCapabilities.getRedBits();
        nArray[n++] = 8215;
        nArray[n++] = gLCapabilities.getGreenBits();
        nArray[n++] = 8217;
        nArray[n++] = gLCapabilities.getBlueBits();
        nArray[n++] = 8219;
        nArray[n++] = gLCapabilities.getAlphaBits();
        nArray[n++] = 8227;
        nArray[n++] = gLCapabilities.getStencilBits();
        if (gLCapabilities.getAccumRedBits() > 0 || gLCapabilities.getAccumGreenBits() > 0 || gLCapabilities.getAccumBlueBits() > 0 || gLCapabilities.getAccumAlphaBits() > 0) {
            nArray[n++] = 8221;
            nArray[n++] = gLCapabilities.getAccumRedBits() + gLCapabilities.getAccumGreenBits() + gLCapabilities.getAccumBlueBits() + gLCapabilities.getAccumAlphaBits();
            nArray[n++] = 8222;
            nArray[n++] = gLCapabilities.getAccumRedBits();
            nArray[n++] = 8223;
            nArray[n++] = gLCapabilities.getAccumGreenBits();
            nArray[n++] = 8224;
            nArray[n++] = gLCapabilities.getAccumBlueBits();
            nArray[n++] = 8225;
            nArray[n++] = gLCapabilities.getAccumAlphaBits();
        }
        if (wGLExt.isExtensionAvailable("WGL_ARB_multisample") && gLCapabilities.getSampleBuffers()) {
            nArray[n++] = 8257;
            nArray[n++] = 1;
            nArray[n++] = 8258;
            nArray[n++] = gLCapabilities.getNumSamples();
        }
        boolean bl2 = gLCapabilities.getPbufferRenderToTexture();
        boolean bl3 = gLCapabilities.getPbufferRenderToTextureRectangle();
        boolean bl4 = gLCapabilities.getPbufferFloatingPointBuffers();
        boolean bl5 = false;
        if (bl) {
            if (bl3 && !bl2) {
                throw new GLException("Render-to-texture-rectangle requires render-to-texture to be specified");
            }
            if (bl3 && !wGLExt.isExtensionAvailable("GL_NV_texture_rectangle")) {
                throw new GLException("Render-to-texture-rectangle requires GL_NV_texture_rectangle extension");
            }
            if (bl4) {
                if (!wGLExt.isExtensionAvailable("WGL_ATI_pixel_format_float") && !wGLExt.isExtensionAvailable("WGL_NV_float_buffer")) {
                    throw new GLException("Floating-point pbuffers not supported by this hardware");
                }
                if (wGLExt.isExtensionAvailable("WGL_NV_float_buffer")) {
                    bl5 = false;
                    nArray2[0] = 3;
                } else {
                    bl5 = true;
                    nArray2[0] = 2;
                }
                if (DEBUG) {
                    System.err.println("Using " + (bl5 ? "ATI" : "NVidia") + " floating-point extension");
                }
            }
            if (bl4 && bl5) {
                if (bl2) {
                    throw new GLException("Render-to-floating-point-texture not supported on ATI hardware");
                }
                nArray[n++] = 8211;
                nArray[n++] = 8608;
            } else if (!bl2) {
                nArray[n++] = 8211;
                nArray[n++] = 8235;
            }
            if (bl4 && !bl5) {
                nArray[n++] = 8368;
                nArray[n++] = 1;
            }
            if (bl2) {
                if (bl4) {
                    if (!$assertionsDisabled && bl5) {
                        throw new AssertionError();
                    }
                    if (!bl3) {
                        throw new GLException("Render-to-floating-point-texture only supported on NVidia hardware with render-to-texture-rectangle");
                    }
                    nArray[n++] = 8371;
                    nArray[n++] = 1;
                } else {
                    nArray[n++] = bl3 ? 8352 : 8304;
                    nArray[n++] = 1;
                }
            }
        } else {
            nArray[n++] = 8211;
            nArray[n++] = 8235;
        }
        return true;
    }

    protected static GLCapabilities iattributes2GLCapabilities(int[] nArray, int n, int[] nArray2, boolean bl) {
        GLCapabilities gLCapabilities = new GLCapabilities();
        block20: for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            switch (n2) {
                case 8193: {
                    if (nArray2[i] == 1) continue block20;
                    return null;
                }
                case 8195: {
                    gLCapabilities.setHardwareAccelerated(nArray2[i] == 8231);
                    continue block20;
                }
                case 8208: {
                    if (nArray2[i] == 1) continue block20;
                    return null;
                }
                case 8226: {
                    gLCapabilities.setDepthBits(nArray2[i]);
                    continue block20;
                }
                case 8227: {
                    gLCapabilities.setStencilBits(nArray2[i]);
                    continue block20;
                }
                case 8209: {
                    gLCapabilities.setDoubleBuffered(nArray2[i] == 1);
                    continue block20;
                }
                case 8210: {
                    gLCapabilities.setStereo(nArray2[i] == 1);
                    continue block20;
                }
                case 8211: {
                    if (nArray2[i] == 8235) continue block20;
                    return null;
                }
                case 8213: {
                    gLCapabilities.setRedBits(nArray2[i]);
                    continue block20;
                }
                case 8215: {
                    gLCapabilities.setGreenBits(nArray2[i]);
                    continue block20;
                }
                case 8217: {
                    gLCapabilities.setBlueBits(nArray2[i]);
                    continue block20;
                }
                case 8219: {
                    gLCapabilities.setAlphaBits(nArray2[i]);
                    continue block20;
                }
                case 8222: {
                    gLCapabilities.setAccumRedBits(nArray2[i]);
                    continue block20;
                }
                case 8223: {
                    gLCapabilities.setAccumGreenBits(nArray2[i]);
                    continue block20;
                }
                case 8224: {
                    gLCapabilities.setAccumBlueBits(nArray2[i]);
                    continue block20;
                }
                case 8225: {
                    gLCapabilities.setAccumAlphaBits(nArray2[i]);
                    continue block20;
                }
                case 8257: {
                    gLCapabilities.setSampleBuffers(nArray2[i] != 0);
                    continue block20;
                }
                case 8258: {
                    gLCapabilities.setNumSamples(nArray2[i]);
                    continue block20;
                }
                default: {
                    throw new GLException("Unknown pixel format attribute " + nArray[i]);
                }
            }
        }
        return gLCapabilities;
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    static {
        $assertionsDisabled = !WindowsGLDrawable.class.desiredAssertionStatus();
        DEBUG = Debug.debug("WindowsGLDrawable");
    }
}

