/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.GLPbufferImpl;
import com.sun.opengl.impl.NativeLibLoader;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WGLExt;
import com.sun.opengl.impl.windows.WindowsDummyGLDrawable;
import com.sun.opengl.impl.windows.WindowsExternalGLContext;
import com.sun.opengl.impl.windows.WindowsExternalGLDrawable;
import com.sun.opengl.impl.windows.WindowsGLContext;
import com.sun.opengl.impl.windows.WindowsOffscreenGLDrawable;
import com.sun.opengl.impl.windows.WindowsOnscreenGLDrawable;
import com.sun.opengl.impl.windows.WindowsPbufferGLDrawable;
import java.awt.Component;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import javax.media.opengl.AbstractGraphicsConfiguration;
import javax.media.opengl.AbstractGraphicsDevice;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.Threading;

public class WindowsGLDrawableFactory
extends GLDrawableFactoryImpl {
    private static final boolean DEBUG = Debug.debug("WindowsGLDrawableFactory");
    private static final boolean VERBOSE = Debug.verbose();
    private long hglu32;
    private boolean pbufferSupportInitialized = false;
    private boolean canCreateGLPbuffer = false;
    private static final int GAMMA_RAMP_LENGTH = 256;

    public AbstractGraphicsConfiguration chooseGraphicsConfiguration(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsDevice abstractGraphicsDevice) {
        return null;
    }

    public GLDrawable getGLDrawable(Object object, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        if (object == null) {
            throw new IllegalArgumentException("Null target");
        }
        if (!(object instanceof Component)) {
            throw new IllegalArgumentException("GLDrawables not supported for objects of type " + object.getClass().getName() + " (only Components are supported in this implementation)");
        }
        if (gLCapabilities == null) {
            gLCapabilities = new GLCapabilities();
        }
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        return new WindowsOnscreenGLDrawable((Component)object, gLCapabilities, gLCapabilitiesChooser);
    }

    public GLDrawableImpl createOffscreenDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        return new WindowsOffscreenGLDrawable(gLCapabilities, gLCapabilitiesChooser);
    }

    public boolean canCreateGLPbuffer() {
        if (!this.pbufferSupportInitialized) {
            Runnable runnable = new Runnable(){

                public void run() {
                    WindowsDummyGLDrawable windowsDummyGLDrawable = new WindowsDummyGLDrawable();
                    GLContext gLContext = windowsDummyGLDrawable.createContext(null);
                    if (gLContext != null) {
                        GLContext gLContext2 = GLContext.getCurrent();
                        if (gLContext2 != null) {
                            gLContext2.release();
                        }
                        gLContext.makeCurrent();
                        GL gL = gLContext.getGL();
                        WindowsGLDrawableFactory.this.canCreateGLPbuffer = gL.isExtensionAvailable("GL_ARB_pbuffer");
                        WindowsGLDrawableFactory.this.pbufferSupportInitialized = true;
                        gLContext.release();
                        gLContext.destroy();
                        windowsDummyGLDrawable.destroy();
                        if (gLContext2 != null) {
                            gLContext2.makeCurrent();
                        }
                    }
                }
            };
            this.maybeDoSingleThreadedWorkaround(runnable);
        }
        return this.canCreateGLPbuffer;
    }

    public GLPbuffer createGLPbuffer(final GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, final int n, final int n2, final GLContext gLContext) {
        if (!this.canCreateGLPbuffer()) {
            throw new GLException("Pbuffer support not available with current graphics card");
        }
        final ArrayList arrayList = new ArrayList();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                WindowsDummyGLDrawable windowsDummyGLDrawable = new WindowsDummyGLDrawable();
                WindowsGLContext windowsGLContext = (WindowsGLContext)windowsDummyGLDrawable.createContext(null);
                GLContext gLContext2 = GLContext.getCurrent();
                if (gLContext2 != null) {
                    gLContext2.release();
                }
                windowsGLContext.makeCurrent();
                WGLExt wGLExt = windowsGLContext.getWGLExt();
                try {
                    WindowsPbufferGLDrawable windowsPbufferGLDrawable = new WindowsPbufferGLDrawable(gLCapabilities, n, n2, windowsDummyGLDrawable, wGLExt);
                    GLPbufferImpl gLPbufferImpl = new GLPbufferImpl(windowsPbufferGLDrawable, gLContext);
                    arrayList.add(gLPbufferImpl);
                    windowsGLContext.release();
                    windowsGLContext.destroy();
                    windowsDummyGLDrawable.destroy();
                }
                finally {
                    if (gLContext2 != null) {
                        gLContext2.makeCurrent();
                    }
                }
            }
        };
        this.maybeDoSingleThreadedWorkaround(runnable);
        return (GLPbuffer)arrayList.get(0);
    }

    public GLContext createExternalGLContext() {
        return new WindowsExternalGLContext();
    }

    public boolean canCreateExternalGLDrawable() {
        return true;
    }

    public GLDrawable createExternalGLDrawable() {
        return new WindowsExternalGLDrawable();
    }

    public void loadGLULibrary() {
        if (this.hglu32 == 0L) {
            this.hglu32 = WGL.LoadLibraryA("GLU32");
            if (this.hglu32 == 0L) {
                throw new GLException("Error loading GLU32.DLL");
            }
        }
    }

    public long dynamicLookupFunction(String string) {
        long l = WGL.wglGetProcAddress(string);
        if (l == 0L && this.hglu32 != 0L) {
            l = WGL.GetProcAddress(this.hglu32, string);
        }
        return l;
    }

    static String wglGetLastError() {
        long l = WGL.GetLastError();
        String string = null;
        switch ((int)l) {
            case 2000: {
                string = "ERROR_INVALID_PIXEL_FORMAT";
                break;
            }
            case 1450: {
                string = "ERROR_NO_SYSTEM_RESOURCES";
                break;
            }
            case 13: {
                string = "ERROR_INVALID_DATA";
                break;
            }
            case 127: {
                string = "ERROR_PROC_NOT_FOUND";
                break;
            }
            case 1400: {
                string = "ERROR_INVALID_WINDOW_HANDLE";
                break;
            }
            default: {
                string = "(Unknown error code " + l + ")";
            }
        }
        return string;
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
        } else {
            runnable.run();
        }
    }

    public void lockAWTForJava2D() {
    }

    public void unlockAWTForJava2D() {
    }

    protected int getGammaRampLength() {
        return 256;
    }

    protected boolean setGammaRamp(float[] fArray) {
        short[] sArray = new short[768];
        for (int i = 0; i < 256; ++i) {
            short s;
            sArray[i] = s = (short)(fArray[i] * 65535.0f);
            sArray[i + 256] = s;
            sArray[i + 512] = s;
        }
        long l = WGL.GetDC(0L);
        boolean bl = WGL.SetDeviceGammaRamp(l, ShortBuffer.wrap(sArray));
        WGL.ReleaseDC(0L, l);
        return bl;
    }

    protected Buffer getGammaRamp() {
        ShortBuffer shortBuffer = ShortBuffer.allocate(768);
        long l = WGL.GetDC(0L);
        boolean bl = WGL.GetDeviceGammaRamp(l, shortBuffer);
        WGL.ReleaseDC(0L, l);
        if (!bl) {
            return null;
        }
        return shortBuffer;
    }

    protected void resetGammaRamp(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l = WGL.GetDC(0L);
        WGL.SetDeviceGammaRamp(l, buffer);
        WGL.ReleaseDC(0L, l);
    }

    static {
        NativeLibLoader.loadCore();
    }
}

