/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.Actions;
import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.DragFromComponent;
import edu.cmu.cs.stage3.alice.authoringtool.StatusBar;
import edu.cmu.cs.stage3.alice.authoringtool.TabbedEditorComponent;
import edu.cmu.cs.stage3.alice.authoringtool.WorldTreeComponent;
import edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor.BehaviorGroupsEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.sceneeditor.SceneEditor;
import edu.cmu.cs.stage3.alice.authoringtool.util.AlicePopupMenu;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDClipboard;
import edu.cmu.cs.stage3.alice.authoringtool.util.InvisibleSplitPaneUI;
import edu.cmu.cs.stage3.alice.authoringtool.util.TrashComponent;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.ConfigurationEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.ConfigurationListener;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;

public class JAliceFrame
extends JFrame {
    protected AuthoringTool authoringTool;
    public static boolean isLogging = false;
    public static int SCENE_EDITOR_SMALL_MODE = 1;
    public static int SCENE_EDITOR_LARGE_MODE = 2;
    protected int guiMode = SCENE_EDITOR_SMALL_MODE;
    WorldTreeComponent worldTreeComponent;
    DragFromComponent dragFromComponent;
    TabbedEditorComponent tabbedEditorComponent;
    public SceneEditor sceneEditor;
    BehaviorGroupsEditor behaviorGroupsEditor;
    TrashComponent trashComponent;
    protected ComponentImageFactory componentImageFactory = new ComponentImageFactory();
    StatusBar statusBar;
    protected Configuration authoringToolConfig = Configuration.getLocalConfiguration(this.getClass().getPackage());
    protected int recentWorldsPosition = -1;
    protected ArrayList recentWorlds = new ArrayList();
    protected int maxRecentWorlds;
    protected ActionListener recentWorldsListener;
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem newWorldItem = new JMenuItem();
    JMenuItem openWorldItem = new JMenuItem();
    JMenuItem openZippedWorldItem = new JMenuItem();
    JMenuItem saveWorldItem = new JMenuItem();
    JMenuItem saveWorldAsItem = new JMenuItem();
    JMenuItem saveForWebItem = new JMenuItem();
    JMenuItem addCharacterItem = new JMenuItem();
    JMenuItem importItem = new JMenuItem();
    JMenuItem makeBillboardItem = new JMenuItem();
    JMenuItem exitItem = new JMenuItem();
    JMenu editMenu = new JMenu();
    JMenuItem preferencesItem = new JMenuItem();
    JMenu helpMenu = new JMenu();
    JMenuItem exampleWorldsItem = new JMenuItem();
    JMenuItem aboutItem = new JMenuItem();
    JMenuItem worldInfoItem = new JMenuItem();
    JMenuItem instructorDemoItem = new JMenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel toolBarPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel buttonPanel = new JPanel();
    JButton playButton = new JButton();
    JPanel clipboardPanel = new JPanel();
    JPanel trashPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JButton undoButton = new JButton();
    JButton redoButton = new JButton();
    JPanel authoringPanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    JSplitPane leftRightSplitPane = new JSplitPane();
    JPanel leftPanel = new JPanel();
    JPanel rightPanel = new JPanel();
    JPanel scenePanel = new JPanel();
    JSplitPane worldTreeDragFromSplitPane = new JSplitPane();
    JPanel smallSceneBehaviorPanel = new JPanel();
    JSplitPane smallSceneBehaviorSplitPane = new JSplitPane();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel worldTreePanel = new JPanel();
    JPanel dragFromPanel = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    BorderLayout borderLayout8 = new BorderLayout();
    JSplitPane editorBehaviorSplitPane = new JSplitPane();
    JPanel editorPanel = new JPanel();
    JPanel behaviorPanel = new JPanel();
    BorderLayout borderLayout9 = new BorderLayout();
    BorderLayout borderLayout10 = new BorderLayout();
    BorderLayout borderLayout11 = new BorderLayout();
    Component glue;
    JMenuItem onScreenHelpItem = new JMenuItem();
    JMenu toolsMenu = new JMenu();
    BorderLayout borderLayout12 = new BorderLayout();
    BorderLayout borderLayout13 = new BorderLayout();
    Border border1;
    Border border2;
    Border border3;
    Border border4;
    Border border5;
    Border border6;
    Border border7;
    Border border8;
    JButton addObjectButton = new JButton();
    JMenuItem add3DTextItem = new JMenuItem();
    JMenuItem exportMovieItem = new JMenuItem();
    JButton teachMeButton = new JButton();
    JMenuItem selectTutorialMenuItem = new JMenuItem();
    JMenuItem tutorialEditor = new JMenuItem();
    JMenuItem softwareUpdate = new JMenuItem();
    JMenuItem license = new JMenuItem();
    JMenuItem showStdOutItem = new JMenuItem();
    JMenuItem showStdErrItem = new JMenuItem();
    JMenuItem printItem = new JMenuItem();

    public JAliceFrame(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.jbInit();
        this.guiInit();
        this.setGuiMode(SCENE_EDITOR_SMALL_MODE);
        this.recentWorldsInit();
        this.setIconImage(AuthoringToolResources.getAliceSystemIconImage());
    }

    public Image getImageForComponent(JComponent c) {
        BufferedImage image = this.componentImageFactory.manufactureImage(c);
        return image;
    }

    public void HACK_goToRedAlert() {
        this.getContentPane().setBackground(new Color(192, 0, 0));
    }

    public void HACK_standDownFromRedAlert() {
        this.getContentPane().setBackground(edu.cmu.cs.stage3.alice.scenegraph.Color.valueOf(this.authoringToolConfig.getValue("backgroundColor")).createAWTColor());
    }

    private void guiInit() {
        String t;
        this.setDefaultCloseOperation(0);
        if (this.authoringToolConfig.getValue("useSingleFileLoadStore").equalsIgnoreCase("true")) {
            this.fileMenu.remove(this.openZippedWorldItem);
        }
        if ((t = this.authoringToolConfig.getValue("backgroundColor")) == null) {
            this.getContentPane().setBackground(new Color(0, 78, 152));
        } else {
            this.getContentPane().setBackground(edu.cmu.cs.stage3.alice.scenegraph.Color.valueOf(this.authoringToolConfig.getValue("backgroundColor")).createAWTColor());
        }
        Configuration.addConfigurationListener(new ConfigurationListener(){

            @Override
            public void changing(ConfigurationEvent ev) {
            }

            @Override
            public void changed(ConfigurationEvent ev) {
                if (ev.getKeyName().equals("edu.cmu.cs.stage3.alice.authoringtool.backgroundColor")) {
                    JAliceFrame.this.getContentPane().setBackground(edu.cmu.cs.stage3.alice.scenegraph.Color.valueOf(JAliceFrame.this.authoringToolConfig.getValue("backgroundColor")).createAWTColor());
                } else if (ev.getKeyName().equals("edu.cmu.cs.stage3.alice.authoringtool.useSingleFileLoadStore")) {
                    if (ev.getNewValue().equalsIgnoreCase("true")) {
                        JAliceFrame.this.fileMenu.remove(JAliceFrame.this.openZippedWorldItem);
                    } else if (!JAliceFrame.this.fileMenu.isMenuComponent(JAliceFrame.this.openZippedWorldItem)) {
                        JAliceFrame.this.fileMenu.add((Component)JAliceFrame.this.openZippedWorldItem, 2);
                    }
                }
            }
        });
        this.worldTreeComponent = new WorldTreeComponent(this.authoringTool);
        this.dragFromComponent = new DragFromComponent(this.authoringTool);
        this.tabbedEditorComponent = new TabbedEditorComponent(this.authoringTool);
        this.behaviorGroupsEditor = new BehaviorGroupsEditor();
        this.sceneEditor = new SceneEditor();
        this.sceneEditor.setAuthoringTool(this.authoringTool);
        this.trashComponent = new TrashComponent(this.authoringTool);
        this.statusBar = new StatusBar(this.authoringTool);
        this.worldTreePanel.add((Component)this.worldTreeComponent, "Center");
        this.dragFromPanel.add((Component)this.dragFromComponent, "Center");
        this.editorPanel.add((Component)this.tabbedEditorComponent, "Center");
        this.scenePanel.add((Component)this.sceneEditor, "Center");
        this.behaviorPanel.add((Component)this.behaviorGroupsEditor, "Center");
        this.trashPanel.add((Component)this.trashComponent, "South");
        if (this.authoringToolConfig.getValue("showWorldStats").equalsIgnoreCase("true")) {
            this.getContentPane().add((Component)this.statusBar, "South");
        }
        int screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        String boundsString = this.authoringToolConfig.getValue("mainWindowBounds");
        StringTokenizer st = new StringTokenizer(boundsString, " \t,");
        int x = 0;
        int y = 0;
        int width = screenWidth;
        int height = screenHeight;
        if (st.countTokens() == 4) {
            try {
                x = Integer.parseInt(st.nextToken());
                y = Integer.parseInt(st.nextToken());
                width = Integer.parseInt(st.nextToken());
                height = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                AuthoringTool.showErrorDialog(Messages.getString("Parse_error_in_config_value__mainWindowBounds"), null);
            }
        } else {
            AuthoringTool.showErrorDialog(Messages.getString("Incorrect_number_of_tokens_in_config_value__mainWindowBounds"), null);
        }
        if (width > screenWidth || height > screenHeight) {
            this.setExtendedState(6);
        } else {
            this.setBounds(x, y, width, height);
        }
        this.leftRightSplitPane.setDividerLocation(300);
        this.leftRightSplitPane.setResizeWeight(0.0);
        this.worldTreeDragFromSplitPane.setDividerLocation((int)(0.32 * (double)height));
        this.worldTreeDragFromSplitPane.setResizeWeight(0.0);
        this.editorBehaviorSplitPane.setDividerLocation((int)(0.275 * (double)height));
        this.editorBehaviorSplitPane.setResizeWeight(0.0);
        this.smallSceneBehaviorSplitPane.setDividerLocation((int)(1.3333333333333333 * (double)(this.editorBehaviorSplitPane.getDividerLocation() - 36)));
        this.smallSceneBehaviorSplitPane.setResizeWeight(0.0);
        this.leftRightSplitPane.setUI(new InvisibleSplitPaneUI());
        this.worldTreeDragFromSplitPane.setUI(new InvisibleSplitPaneUI());
        this.editorBehaviorSplitPane.setUI(new InvisibleSplitPaneUI());
        this.smallSceneBehaviorSplitPane.setUI(new InvisibleSplitPaneUI());
        this.leftRightSplitPane.setBorder(null);
        this.worldTreeDragFromSplitPane.setBorder(null);
        this.editorBehaviorSplitPane.setBorder(null);
        this.smallSceneBehaviorSplitPane.setBorder(null);
        this.worldTreePanel.setMinimumSize(new Dimension(0, 0));
        this.dragFromPanel.setMinimumSize(new Dimension(0, 0));
        this.editorPanel.setMinimumSize(new Dimension(0, 0));
        this.smallSceneBehaviorPanel.setMinimumSize(new Dimension(0, 0));
        this.scenePanel.setMinimumSize(new Dimension(0, 0));
        this.behaviorPanel.setMinimumSize(new Dimension(0, 0));
        this.rightPanel.setMinimumSize(new Dimension(0, 0));
        this.authoringTool.addElementSelectionListener(this.dragFromComponent);
        this.clipboardPanel.setLayout(new BoxLayout(this.clipboardPanel, 0));
        this.updateClipboards();
        this.worldTreeComponent.startListening(this.authoringTool);
        if (AuthoringToolResources.areExperimentalFeaturesEnabled()) {
            this.helpMenu.add((Component)this.onScreenHelpItem, 1);
            this.buttonPanel.add((Component)this.teachMeButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 16, 0, 0), 0, 0));
        }
        this.getContentPane().add((Component)this.componentImageFactory, "West");
        if (AikMin.isMAC()) {
            this.addWindowFocusListener(new WindowFocusListener(){
                Boolean flag = ToolTipManager.sharedInstance().isEnabled();

                @Override
                public void windowGainedFocus(WindowEvent arg0) {
                    if (this.flag.booleanValue()) {
                        ToolTipManager.sharedInstance().setEnabled(true);
                    }
                    JAliceFrame.this.setEnabled(true);
                    AlicePopupMenu.showPopup();
                }

                @Override
                public void windowLostFocus(WindowEvent arg0) {
                    if (this.flag.booleanValue()) {
                        ToolTipManager.sharedInstance().setEnabled(false);
                    }
                }
            });
        }
    }

    private void recentWorldsInit() {
        this.recentWorldsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JMenuItem item = (JMenuItem)ev.getSource();
                if (JAliceFrame.this.authoringTool.loadWorld(item.getText(), true) == 2) {
                    JAliceFrame.this.recentWorlds.remove(item.getText());
                    JAliceFrame.this.updateRecentWorlds();
                }
            }
        };
        String[] recentWorldsStrings = this.authoringToolConfig.getValueList("recentWorlds.worlds");
        int i = 0;
        while (i < recentWorldsStrings.length) {
            this.recentWorlds.add(recentWorldsStrings[i]);
            ++i;
        }
        String max = this.authoringToolConfig.getValue("recentWorlds.maxWorlds");
        this.maxRecentWorlds = Integer.parseInt(max);
        this.recentWorldsPosition = this.fileMenu.getMenuComponentCount() - 2;
        this.fileMenu.insertSeparator(this.recentWorldsPosition++);
        this.updateRecentWorlds();
    }

    public void actionInit(Actions actions) {
        this.newWorldItem.setAction(actions.newWorldAction);
        this.openWorldItem.setAction(actions.openWorldAction);
        this.saveWorldItem.setAction(actions.saveWorldAction);
        this.saveWorldAsItem.setAction(actions.saveWorldAsAction);
        this.saveForWebItem.setAction(actions.saveForWebAction);
        this.addCharacterItem.setAction(actions.addCharacterAction);
        this.add3DTextItem.setAction(actions.add3DTextAction);
        this.exportMovieItem.setAction(actions.exportMovieAction);
        this.importItem.setAction(actions.importObjectAction);
        this.makeBillboardItem.setAction(actions.makeBillboardAction);
        this.exitItem.setAction(actions.quitAction);
        this.preferencesItem.setAction(actions.preferencesAction);
        this.worldInfoItem.setAction(actions.showWorldInfoAction);
        this.exampleWorldsItem.setAction(actions.openExampleWorldAction);
        this.aboutItem.setAction(actions.aboutAction);
        this.onScreenHelpItem.setAction(actions.onScreenHelpAction);
        this.playButton.setAction(actions.playAction);
        this.undoButton.setAction(actions.undoAction);
        this.redoButton.setAction(actions.redoAction);
        this.addObjectButton.setAction(actions.addCharacterAction);
        this.teachMeButton.setAction(actions.launchTutorialAction);
        this.selectTutorialMenuItem.setAction(actions.launchTutorialFileAction);
        this.tutorialEditor.setAction(actions.launchTutorialEditor);
        this.softwareUpdate.setAction(actions.launchSoftwareUpdate);
        this.license.setAction(actions.licenseAction);
        this.showStdOutItem.setAction(actions.showStdOutDialogAction);
        this.showStdErrItem.setAction(actions.showStdErrDialogAction);
        this.printItem.setAction(actions.showPrintDialogAction);
        this.instructorDemoItem.setAction(actions.logInstructorIntervention);
    }

    public void setWorld(World world) {
        this.worldTreeComponent.setWorld(world);
        this.behaviorGroupsEditor.setObject(world);
        this.sceneEditor.setObject(world);
        this.tabbedEditorComponent.setWorld(world);
    }

    public void setGuiMode(int guiMode) {
        this.guiMode = guiMode;
        int dividerLocation1 = this.leftRightSplitPane.getDividerLocation();
        int dividerLocation2 = this.smallSceneBehaviorSplitPane.getDividerLocation();
        this.rightPanel.removeAll();
        this.scenePanel.removeAll();
        if (guiMode == SCENE_EDITOR_SMALL_MODE) {
            this.scenePanel.add((Component)this.sceneEditor, "Center");
            this.rightPanel.add((Component)this.editorBehaviorSplitPane, "Center");
            this.sceneEditor.setGuiMode(SceneEditor.SMALL_MODE);
        } else if (guiMode == SCENE_EDITOR_LARGE_MODE) {
            this.rightPanel.add((Component)this.sceneEditor, "Center");
            this.sceneEditor.setGuiMode(SceneEditor.LARGE_MODE);
        }
        this.leftRightSplitPane.setDividerLocation(dividerLocation1);
        this.smallSceneBehaviorSplitPane.setDividerLocation(dividerLocation2);
    }

    public int getGuiMode() {
        return this.guiMode;
    }

    public void showStatusPanel(boolean b) {
        if (b) {
            this.getContentPane().add((Component)this.statusBar, "South");
        } else {
            this.getContentPane().remove(this.statusBar);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void registerKeyboardAction(ActionListener actionListener, String command, KeyStroke keyStroke, int condition) {
        this.mainPanel.registerKeyboardAction(actionListener, command, keyStroke, condition);
    }

    public void updateRecentWorlds(String pathname) {
        int pos = this.recentWorlds.indexOf(pathname);
        if (pos > -1) {
            this.recentWorlds.remove(pos);
        }
        this.recentWorlds.add(0, pathname);
        this.updateRecentWorlds();
    }

    public void updateRecentWorlds() {
        int numExtra = this.recentWorlds.size() - this.maxRecentWorlds;
        int i = 0;
        while (i < numExtra) {
            this.recentWorlds.remove(this.maxRecentWorlds);
            ++i;
        }
        int recentWorldsEndPosition = this.fileMenu.getMenuComponentCount() - 2;
        int numEntries = recentWorldsEndPosition - this.recentWorldsPosition;
        int i2 = 0;
        while (i2 < numEntries) {
            this.fileMenu.remove(this.recentWorldsPosition);
            ++i2;
        }
        if (this.recentWorlds.size() > 0) {
            i2 = 0;
            for (String pathname : this.recentWorlds) {
                JMenuItem item = new JMenuItem(pathname);
                item.addActionListener(this.recentWorldsListener);
                this.fileMenu.insert(item, this.recentWorldsPosition + i2);
                if (pathname.length() > 60) {
                    int fontSize = Integer.parseInt(this.authoringToolConfig.getValue("fontSize"));
                    item.setToolTipText(pathname);
                    item.setPreferredSize(new Dimension(500, fontSize + 10));
                }
                ++i2;
            }
        } else {
            JMenuItem item = new JMenuItem(Messages.getString("_No_Recent_Worlds_"));
            item.setEnabled(false);
            this.fileMenu.insert(item, this.recentWorldsPosition);
        }
        this.authoringToolConfig.setValueList("recentWorlds.worlds", this.recentWorlds.toArray(new String[0]));
    }

    public void updateClipboards() {
        try {
            int numClipboards = Integer.parseInt(this.authoringToolConfig.getValue("numberOfClipboards"));
            int current = this.clipboardPanel.getComponentCount();
            if (numClipboards > current) {
                int i = current;
                while (i < numClipboards) {
                    this.clipboardPanel.add(new DnDClipboard());
                    ++i;
                }
            } else if (numClipboards < current && numClipboards >= 0) {
                int i = numClipboards;
                while (i < current) {
                    this.clipboardPanel.remove(0);
                    ++i;
                }
            }
            this.clipboardPanel.revalidate();
            this.clipboardPanel.repaint();
        }
        catch (NumberFormatException e) {
            AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("illegal_number_of_clipboards__")) + this.authoringToolConfig.getValue("numberOfClipboards"), null);
        }
    }

    public WorldTreeComponent getWorldTreeComponent() {
        return this.worldTreeComponent;
    }

    public TabbedEditorComponent getTabbedEditorComponent() {
        return this.tabbedEditorComponent;
    }

    private void jbInit() {
        this.glue = Box.createGlue();
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        this.border2 = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        this.border3 = BorderFactory.createEmptyBorder(2, 10, 10, 10);
        this.border4 = BorderFactory.createLineBorder(Color.black, 1);
        this.border5 = BorderFactory.createLineBorder(Color.black, 1);
        this.border6 = BorderFactory.createLineBorder(Color.black, 1);
        this.border7 = BorderFactory.createLineBorder(Color.black, 1);
        this.border8 = BorderFactory.createLineBorder(Color.black, 1);
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText(Messages.getString("File"));
        this.newWorldItem.setText(Messages.getString("New_World"));
        this.openWorldItem.setText(Messages.getString("Open_World"));
        this.openZippedWorldItem.setText(Messages.getString("Open_Single_File_World"));
        this.saveWorldItem.setText(Messages.getString("Save_World"));
        this.saveWorldAsItem.setText(Messages.getString("Save_World_As___"));
        this.saveForWebItem.setText(Messages.getString("Export_As_A_Web_Page___"));
        this.addCharacterItem.setText(Messages.getString("Add_Character"));
        this.importItem.setText(Messages.getString("Import___"));
        this.makeBillboardItem.setText(Messages.getString("Make_Billboard"));
        this.exitItem.setText(Messages.getString("Exit"));
        this.editMenu.setMnemonic('E');
        this.editMenu.setText(Messages.getString("Edit"));
        this.preferencesItem.setText(Messages.getString("Preferences___"));
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText(Messages.getString("Help"));
        this.exampleWorldsItem.setText(Messages.getString("Example_Worlds___"));
        this.aboutItem.setText(Messages.getString("About_Alice"));
        this.getContentPane().setLayout(this.borderLayout1);
        this.toolBarPanel.setLayout(this.gridBagLayout1);
        this.playButton.setText(Messages.getString("Play"));
        this.trashPanel.setAlignmentY(0.0f);
        this.trashPanel.setOpaque(false);
        this.trashPanel.setLayout(this.borderLayout11);
        this.clipboardPanel.setLayout(this.gridBagLayout2);
        this.mainPanel.setLayout(this.borderLayout2);
        this.buttonPanel.setLayout(this.gridBagLayout4);
        this.undoButton.setText(Messages.getString("Undo"));
        this.redoButton.setText(Messages.getString("Redo"));
        this.authoringPanel.setLayout(this.borderLayout3);
        this.leftPanel.setLayout(this.borderLayout5);
        this.worldTreeDragFromSplitPane.setOrientation(0);
        this.worldTreeDragFromSplitPane.setOpaque(false);
        this.rightPanel.setLayout(this.borderLayout6);
        this.worldTreePanel.setLayout(this.borderLayout7);
        this.dragFromPanel.setLayout(this.borderLayout8);
        this.editorBehaviorSplitPane.setOrientation(0);
        this.editorBehaviorSplitPane.setOpaque(false);
        this.behaviorPanel.setLayout(this.borderLayout9);
        this.editorPanel.setLayout(this.borderLayout10);
        this.leftRightSplitPane.setDoubleBuffered(true);
        this.leftRightSplitPane.setOpaque(false);
        this.setJMenuBar(this.menuBar);
        this.onScreenHelpItem.setToolTipText("");
        this.onScreenHelpItem.setActionCommand("OnScreenHelp");
        this.onScreenHelpItem.setText(Messages.getString("On_Screen_Help"));
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.setText(Messages.getString("Tools"));
        this.worldInfoItem.setActionCommand("worldInfo");
        this.worldInfoItem.setText(Messages.getString("World_Statistics___"));
        this.smallSceneBehaviorPanel.setLayout(this.borderLayout12);
        this.scenePanel.setLayout(this.borderLayout13);
        this.worldTreePanel.setBorder(this.border4);
        this.worldTreePanel.setOpaque(false);
        this.dragFromPanel.setOpaque(false);
        this.scenePanel.setBorder(this.border6);
        this.scenePanel.setOpaque(false);
        this.behaviorPanel.setBorder(this.border7);
        this.behaviorPanel.setOpaque(false);
        this.editorPanel.setOpaque(false);
        this.toolBarPanel.setBorder(this.border3);
        this.toolBarPanel.setOpaque(false);
        this.buttonPanel.setOpaque(false);
        this.clipboardPanel.setOpaque(false);
        this.mainPanel.setBorder(this.border2);
        this.mainPanel.setOpaque(false);
        this.authoringPanel.setOpaque(false);
        this.leftPanel.setOpaque(false);
        this.rightPanel.setOpaque(false);
        this.smallSceneBehaviorPanel.setOpaque(false);
        this.smallSceneBehaviorSplitPane.setOpaque(false);
        this.addObjectButton.setText(Messages.getString("Add_Object"));
        this.add3DTextItem.setText(Messages.getString("Add_3D_Text"));
        this.exportMovieItem.setText(Messages.getString("Export_Video"));
        this.teachMeButton.setText(Messages.getString("Teach_Me"));
        this.selectTutorialMenuItem.setText(Messages.getString("Select_a_Tutorial"));
        this.tutorialEditor.setText("Create or edit a tutorial");
        this.softwareUpdate.setText(Messages.getString("Update_Software"));
        this.license.setText(Messages.getString("View_License"));
        this.showStdOutItem.setText(Messages.getString("Text_Output___"));
        this.showStdErrItem.setText(Messages.getString("Standard_Error___"));
        this.printItem.setText(Messages.getString("Print___"));
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.toolsMenu);
        this.menuBar.add(this.helpMenu);
        this.fileMenu.add(this.newWorldItem);
        this.fileMenu.add(this.openWorldItem);
        this.fileMenu.add(this.openZippedWorldItem);
        this.fileMenu.add(this.saveWorldItem);
        this.fileMenu.add(this.saveWorldAsItem);
        this.fileMenu.add(this.exportMovieItem);
        this.fileMenu.add(this.printItem);
        this.fileMenu.add(this.importItem);
        this.fileMenu.add(this.add3DTextItem);
        this.fileMenu.add(this.makeBillboardItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitItem);
        this.editMenu.add(this.preferencesItem);
        this.toolsMenu.add(this.worldInfoItem);
        this.toolsMenu.add(this.showStdOutItem);
        this.toolsMenu.add(this.showStdErrItem);
        if (this.authoringTool.getConfig().getValue("enableLoggingMode").equalsIgnoreCase("true")) {
            this.toolsMenu.add(this.instructorDemoItem);
            isLogging = true;
        }
        this.helpMenu.add(this.exampleWorldsItem);
        this.helpMenu.add(this.selectTutorialMenuItem);
        this.helpMenu.add(this.softwareUpdate);
        this.helpMenu.add(this.license);
        this.helpMenu.add(this.aboutItem);
        this.getContentPane().add((Component)this.toolBarPanel, "North");
        this.toolBarPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.playButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.undoButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 16, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.redoButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.toolBarPanel.add((Component)this.clipboardPanel, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.toolBarPanel.add((Component)this.trashPanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 16, 3, new Insets(0, 14, 0, 0), 0, 0));
        this.toolBarPanel.add(this.glue, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.worldTreeDragFromSplitPane.add((Component)this.worldTreePanel, "top");
        this.worldTreeDragFromSplitPane.add((Component)this.dragFromPanel, "bottom");
        this.leftPanel.add((Component)this.worldTreeDragFromSplitPane, "Center");
        this.smallSceneBehaviorSplitPane.add((Component)this.scenePanel, "left");
        this.smallSceneBehaviorSplitPane.add((Component)this.behaviorPanel, "right");
        this.smallSceneBehaviorPanel.add((Component)this.smallSceneBehaviorSplitPane, "Center");
        this.editorBehaviorSplitPane.add((Component)this.smallSceneBehaviorPanel, "top");
        this.editorBehaviorSplitPane.add((Component)this.editorPanel, "bottom");
        this.rightPanel.add((Component)this.editorBehaviorSplitPane, "Center");
        this.leftRightSplitPane.add((Component)this.leftPanel, "left");
        this.leftRightSplitPane.add((Component)this.rightPanel, "right");
        this.authoringPanel.add((Component)this.leftRightSplitPane, "Center");
        this.mainPanel.add((Component)this.authoringPanel, "Center");
    }

    protected class ComponentImageFactory
    extends JPanel {
        public ComponentImageFactory() {
            this.setPreferredSize(new Dimension(0, 0));
        }

        public BufferedImage manufactureImage(JComponent component) {
            boolean isShowing = component.isShowing();
            Container parent = component.getParent();
            if (!isShowing) {
                if (parent != null) {
                    parent.remove(component);
                }
                this.add(component);
            }
            this.doLayout();
            Dimension d = component.getPreferredSize();
            BufferedImage image = new BufferedImage(d.width, d.height, 2);
            Graphics2D g = image.createGraphics();
            component.paintAll(g);
            if (!isShowing) {
                this.remove(component);
                if (parent != null) {
                    parent.add(component);
                }
            }
            return image;
        }
    }
}

