/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.JAliceFrame;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.event.UndoRedoListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.ChangeLogger;
import edu.cmu.cs.stage3.alice.authoringtool.util.ChildChangeUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CompoundUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.ContextAssignableUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.PropertyUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.ScriptProperty;
import edu.cmu.cs.stage3.alice.core.visualization.ModelVisualization;
import java.util.HashSet;
import java.util.Iterator;

public class MainUndoRedoStack
extends DefaultUndoRedoStack
implements PropertyListener,
ObjectArrayPropertyListener,
ChildrenListener,
AuthoringToolStateListener {
    protected AuthoringTool authoringTool;
    private boolean isListening = true;
    private boolean inCompound = false;
    private CompoundUndoableRedoable compoundItem;
    private int unmodifiedIndex = -1;
    private boolean scriptHasChanged = false;
    protected HashSet listeners = new HashSet();
    protected ChangeLogger changeLogger = null;
    protected Object preChangeValue;

    public MainUndoRedoStack(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.loggingInit(authoringTool);
    }

    private void loggingInit(AuthoringTool authoringTool) {
        this.changeLogger = new ChangeLogger(authoringTool);
    }

    public void logInstructorIntervention(String type, String comment) {
        if (this.changeLogger != null) {
            this.changeLogger.recordInstructorIntervention(type, comment);
        }
    }

    public void addUndoRedoListener(UndoRedoListener listener) {
        this.listeners.add(listener);
    }

    public void removeUndoRedoListener(UndoRedoListener listener) {
        this.listeners.remove(listener);
    }

    public int getUnmodifiedIndex() {
        return this.unmodifiedIndex;
    }

    public boolean isScriptDirty() {
        return this.scriptHasChanged;
    }

    protected synchronized void fireChange() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((UndoRedoListener)iter.next()).onChange();
        }
    }

    public synchronized void setUnmodified() {
        this.unmodifiedIndex = this.getCurrentUndoableRedoableIndex();
        this.scriptHasChanged = false;
        this.fireChange();
    }

    public synchronized void setIsListening(boolean isListening) {
        this.isListening = isListening;
    }

    public synchronized boolean getIsListening() {
        return this.isListening;
    }

    public synchronized void startCompound() {
        if (!this.inCompound) {
            this.compoundItem = new CompoundUndoableRedoable();
            this.compoundItem.setContext(this.authoringTool.getContext());
            this.push(this.compoundItem);
            this.inCompound = true;
        }
    }

    public synchronized void stopCompound() {
        this.inCompound = false;
    }

    @Override
    public synchronized UndoableRedoable undo() {
        Variable v;
        this.stopCompound();
        boolean temp = this.isListening;
        this.isListening = false;
        UndoableRedoable ur = super.undo();
        this.loadContext(ur.getContext());
        Object o = ur.getAffectedObject();
        if (o instanceof Variable && (v = (Variable)o).getParent() instanceof ModelVisualization) {
            int i = 0;
            while (i < 5) {
                super.undo();
                ++i;
            }
        }
        this.isListening = temp;
        this.fireChange();
        return ur;
    }

    @Override
    public synchronized UndoableRedoable redo() {
        this.stopCompound();
        boolean temp = this.isListening;
        this.isListening = false;
        int currentIndex = this.getCurrentUndoableRedoableIndex();
        if (currentIndex < this.size() - 1) {
            this.loadContext(((UndoableRedoable)this.get(currentIndex + 1)).getContext());
        }
        UndoableRedoable ur = super.redo();
        this.isListening = temp;
        this.fireChange();
        return ur;
    }

    protected synchronized void loadContext(Object context) {
        this.authoringTool.setContext(context);
    }

    @Override
    public synchronized void push(UndoableRedoable ur) {
        if (this.changeLogger != null && JAliceFrame.isLogging) {
            this.changeLogger.pushUndoableRedoable(ur);
        }
        if (ur instanceof ContextAssignableUndoableRedoable) {
            ((ContextAssignableUndoableRedoable)ur).setContext(this.authoringTool.getContext());
        }
        if (this.inCompound) {
            this.compoundItem.addItem(ur);
        } else {
            super.push(ur);
        }
        this.fireChange();
    }

    @Override
    public synchronized UndoableRedoable pop_() {
        this.stopCompound();
        UndoableRedoable ur = super.pop_();
        this.fireChange();
        return ur;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.setUnmodified();
        this.fireChange();
    }

    @Override
    public synchronized UndoableRedoable removeUndoable(int index) {
        UndoableRedoable ur = super.removeUndoable(index);
        this.fireChange();
        return ur;
    }

    @Override
    public synchronized void propertyChanging(PropertyEvent propertyEvent) {
        if (this.isListening) {
            propertyEvent.setOldValue(propertyEvent.getProperty().get());
        }
    }

    @Override
    public synchronized void propertyChanged(PropertyEvent propertyEvent) {
        if (this.isListening) {
            if (propertyEvent.getProperty() instanceof ObjectArrayProperty) {
                return;
            }
            if (this.authoringTool.getOneShotScheduler().isPropertyAffected(propertyEvent.getProperty())) {
                return;
            }
            if (propertyEvent.getProperty() instanceof ScriptProperty) {
                this.scriptHasChanged = true;
                this.fireChange();
                return;
            }
            this.push(new PropertyUndoableRedoable(propertyEvent.getProperty(), propertyEvent.getOldValue(), propertyEvent.getProperty().get()));
        }
    }

    @Override
    public synchronized void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
    }

    @Override
    public synchronized void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
        if (this.isListening) {
            if (this.authoringTool.getOneShotScheduler().isPropertyAffected(ev.getObjectArrayProperty())) {
                return;
            }
            this.push(new ObjectArrayPropertyUndoableRedoable(ev.getObjectArrayProperty(), ev.getChangeType(), ev.getOldIndex(), ev.getNewIndex(), ev.getItem()));
        }
    }

    @Override
    public synchronized void childrenChanging(ChildrenEvent childrenEvent) {
    }

    @Override
    public synchronized void childrenChanged(ChildrenEvent childrenEvent) {
        int changeType;
        if (this.isListening) {
            this.push(new ChildChangeUndoableRedoable(childrenEvent));
        }
        if ((changeType = childrenEvent.getChangeType()) == 1) {
            this.listenTo(childrenEvent.getChild());
        } else if (changeType == 3) {
            this.stopListeningTo(childrenEvent.getChild());
        }
    }

    public synchronized void listenTo(Element element) {
        if (element != null) {
            Element[] elements = element.getDescendants();
            int i = 0;
            while (i < elements.length) {
                Property[] properties = elements[i].getProperties();
                int j = 0;
                while (j < properties.length) {
                    properties[j].addPropertyListener(this);
                    if (properties[j] instanceof ObjectArrayProperty) {
                        ((ObjectArrayProperty)properties[j]).addObjectArrayPropertyListener(this);
                    }
                    ++j;
                }
                boolean alreadyChildrenListening = false;
                ChildrenListener[] childrenListeners = elements[i].getChildrenListeners();
                int j2 = 0;
                while (j2 < childrenListeners.length) {
                    if (childrenListeners[j2] == this) {
                        alreadyChildrenListening = true;
                    }
                    ++j2;
                }
                if (!alreadyChildrenListening) {
                    elements[i].addChildrenListener(this);
                }
                ++i;
            }
        }
    }

    public synchronized void stopListeningTo(Element element) {
        if (element != null) {
            Element[] elements = element.getDescendants();
            int i = 0;
            while (i < elements.length) {
                Property[] properties = elements[i].getProperties();
                int j = 0;
                while (j < properties.length) {
                    properties[j].removePropertyListener(this);
                    if (properties[j] instanceof ObjectArrayProperty) {
                        ((ObjectArrayProperty)properties[j]).removeObjectArrayPropertyListener(this);
                    }
                    ++j;
                }
                elements[i].removeChildrenListener(this);
                ++i;
            }
        }
    }

    @Override
    public void stateChanged(AuthoringToolStateChangedEvent ev) {
        if (ev.getCurrentState() == 3) {
            this.stopListeningTo(ev.getWorld());
        } else {
            this.listenTo(ev.getWorld());
        }
    }

    @Override
    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
        this.stopListeningTo(ev.getWorld());
    }

    @Override
    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
        this.listenTo(ev.getWorld());
    }

    @Override
    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }
}

