/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.util.IndexedTriangleArrayCounter;
import edu.cmu.cs.stage3.alice.core.util.TextureMapCounter;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.util.HowMuch;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.vecmath.Vector3d;

public class StatusBar
extends JPanel
implements AuthoringToolStateListener {
    Border border1;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel worldStatsPanel = new JPanel();
    JLabel worldStatsLabel = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel objectCountLabel = new JLabel();
    JLabel faceCountLabel = new JLabel();
    JLabel textureMemoryLabel = new JLabel();
    Component filler1;
    Border border2;

    public StatusBar(AuthoringTool authoringTool) {
        this.jbInit();
        authoringTool.addAuthoringToolStateListener(this);
    }

    @Override
    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
        this.updateWorldStats(ev.getWorld());
    }

    @Override
    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
        this.updateWorldStats(null);
    }

    @Override
    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void stateChanged(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }

    private void updateWorldStats(World world) {
        Vector3d goodHSB = new Vector3d(0.3333333333333333, 1.0, 0.85);
        Vector3d badHSB = new Vector3d(0.0, 1.0, 1.0);
        Color goodColor = new Color(Color.HSBtoRGB((float)goodHSB.x, (float)goodHSB.y, (float)goodHSB.z));
        Color badColor = new Color(Color.HSBtoRGB((float)badHSB.x, (float)badHSB.y, (float)badHSB.z));
        int minDangerObjectCount = 1000;
        int maxDangerObjectCount = 2000;
        int minDangerFaceCount = 10000;
        int maxDangerFaceCount = 50000;
        int minDangerTextureMemory = 0x2000000;
        int maxDangerTextureMemory = 0x4000000;
        if (world != null) {
            Vector3d hsb;
            float portion;
            IndexedTriangleArrayCounter itaCounter = new IndexedTriangleArrayCounter();
            TextureMapCounter textureMapCounter = new TextureMapCounter();
            world.visit(itaCounter, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
            world.visit(textureMapCounter, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
            int objectCount = itaCounter.getShownIndexedTriangleArrayCount();
            int faceCount = itaCounter.getShownIndexCount() / 3;
            double textureMemory = textureMapCounter.getTextureMapMemoryCount();
            if (objectCount <= minDangerObjectCount) {
                this.objectCountLabel.setBackground(goodColor);
            } else if (objectCount >= maxDangerObjectCount) {
                this.objectCountLabel.setBackground(badColor);
            } else {
                portion = (float)(objectCount - minDangerObjectCount) / (float)(maxDangerObjectCount - minDangerObjectCount);
                hsb = MathUtilities.interpolate(goodHSB, badHSB, portion);
                this.objectCountLabel.setBackground(new Color(Color.HSBtoRGB((float)hsb.x, (float)hsb.y, (float)hsb.z)));
            }
            if (faceCount <= minDangerFaceCount) {
                this.faceCountLabel.setBackground(goodColor);
            } else if (faceCount >= maxDangerFaceCount) {
                this.faceCountLabel.setBackground(badColor);
            } else {
                portion = (float)(faceCount - minDangerFaceCount) / (float)(maxDangerFaceCount - minDangerFaceCount);
                hsb = MathUtilities.interpolate(goodHSB, badHSB, portion);
                this.faceCountLabel.setBackground(new Color(Color.HSBtoRGB((float)hsb.x, (float)hsb.y, (float)hsb.z)));
            }
            if (textureMemory <= (double)minDangerTextureMemory) {
                this.textureMemoryLabel.setBackground(goodColor);
            } else if (textureMemory >= (double)maxDangerTextureMemory) {
                this.textureMemoryLabel.setBackground(badColor);
            } else {
                portion = (float)(textureMemory - (double)minDangerTextureMemory) / (float)(maxDangerTextureMemory - minDangerTextureMemory);
                hsb = MathUtilities.interpolate(goodHSB, badHSB, portion);
                this.textureMemoryLabel.setBackground(new Color(Color.HSBtoRGB((float)hsb.x, (float)hsb.y, (float)hsb.z)));
            }
            String textureSuffix = "";
            if (textureMemory > 524288.0) {
                textureMemory /= 1048576.0;
                textureSuffix = " MB";
            } else {
                textureMemory /= 1024.0;
                textureSuffix = " KB";
            }
            DecimalFormat memoryFormat = new DecimalFormat("#0.#");
            this.objectCountLabel.setText("object count: " + objectCount);
            this.faceCountLabel.setText("face count: " + faceCount);
            this.textureMemoryLabel.setText("texture memory: " + memoryFormat.format(textureMemory) + textureSuffix);
        } else {
            this.objectCountLabel.setText("object count: 0");
            this.faceCountLabel.setText("face count: 0");
            this.textureMemoryLabel.setText("texture memory: 0 bytes");
            this.objectCountLabel.setBackground(goodColor);
            this.faceCountLabel.setBackground(goodColor);
            this.textureMemoryLabel.setBackground(goodColor);
        }
    }

    private void jbInit() {
        this.border1 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.filler1 = Box.createGlue();
        this.border2 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(142, 142, 142), new Color(99, 99, 99));
        this.setBackground(new Color(204, 204, 204));
        this.setBorder(this.border1);
        this.setLayout(this.gridBagLayout1);
        this.worldStatsLabel.setText("World Statistics:");
        this.worldStatsPanel.setLayout(this.gridBagLayout2);
        this.objectCountLabel.setBackground(new Color(0, 204, 0));
        this.objectCountLabel.setForeground(Color.black);
        this.objectCountLabel.setOpaque(true);
        this.objectCountLabel.setHorizontalAlignment(0);
        this.objectCountLabel.setHorizontalTextPosition(0);
        this.objectCountLabel.setText("object count:");
        this.faceCountLabel.setBackground(new Color(0, 204, 0));
        this.faceCountLabel.setForeground(Color.black);
        this.faceCountLabel.setOpaque(true);
        this.faceCountLabel.setHorizontalAlignment(0);
        this.faceCountLabel.setHorizontalTextPosition(0);
        this.faceCountLabel.setText("face count:");
        this.textureMemoryLabel.setBackground(new Color(0, 204, 0));
        this.textureMemoryLabel.setForeground(Color.black);
        this.textureMemoryLabel.setOpaque(true);
        this.textureMemoryLabel.setHorizontalAlignment(0);
        this.textureMemoryLabel.setHorizontalTextPosition(0);
        this.textureMemoryLabel.setText("texture memory:");
        this.worldStatsPanel.setBorder(this.border2);
        this.add((Component)this.worldStatsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 4));
        this.worldStatsPanel.add((Component)this.worldStatsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 6), 0, 0));
        this.worldStatsPanel.add((Component)this.objectCountLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 6), 10, 0));
        this.worldStatsPanel.add((Component)this.faceCountLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 6), 10, 0));
        this.worldStatsPanel.add((Component)this.textureMemoryLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 6), 10, 0));
        this.worldStatsPanel.add(this.filler1, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }
}

