/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.WorldTree;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.TransferableFactory;
import edu.cmu.cs.stage3.alice.authoringtool.event.ElementSelectionListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementTreeCellEditor;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementTreeCellRenderer;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.WorldTreeModel;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Group;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class WorldTreeComponent
extends JPanel {
    protected World world;
    protected Element bogusRoot = new Transformable();
    protected WorldTreeModel worldTreeModel = new WorldTreeModel();
    protected ElementTreeCellRenderer cellRenderer = new ElementTreeCellRenderer();
    protected ElementTreeCellEditor cellEditor = new ElementTreeCellEditor();
    protected Element selectedElement;
    protected Configuration authoringtoolConfig;
    protected DragSource dragSource = new DragSource();
    protected HashSet elementSelectionListeners = new HashSet();
    protected WorldTreeDropTargetListener worldTreeDropTargetListener = new WorldTreeDropTargetListener();
    protected AuthoringTool authoringTool;
    private TreeSelectionListener worldSelectionListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent ev) {
            TreePath path = ev.getNewLeadSelectionPath();
            if (path != null) {
                Object o = path.getLastPathComponent();
                if (o instanceof Element) {
                    WorldTreeComponent.this.selectedElement = (Element)o;
                    if (WorldTreeComponent.this.selectedElement != WorldTreeComponent.this.worldTreeModel.HACK_getOriginalRoot()) {
                        WorldTreeComponent.this.authoringTool.setSelectedElement(WorldTreeComponent.this.selectedElement);
                    }
                }
            } else {
                WorldTreeComponent.this.setSelectedElement((Element)WorldTreeComponent.this.worldTreeModel.getRoot());
            }
        }
    };
    protected final MouseListener worldTreeMouseListener = new CustomMouseAdapter(){
        protected Vector defaultStructure;

        @Override
        protected void popupResponse(MouseEvent ev) {
            JTree tree = (JTree)ev.getSource();
            TreePath path = tree.getPathForLocation(ev.getX(), ev.getY());
            if (path != null) {
                JPopupMenu popup;
                Object node = path.getLastPathComponent();
                if (node instanceof Element && (popup = this.createPopup((Element)node, path)) != null) {
                    popup.show(ev.getComponent(), ev.getX(), ev.getY());
                }
            } else {
                PopupMenuUtilities.createAndShowPopupMenu(this.getDefaultStructure(), ev.getComponent(), ev.getX(), ev.getY());
            }
        }

        private JPopupMenu createPopup(Element element, TreePath path) {
            Vector structure = ElementPopupUtilities.getDefaultStructure(element, WorldTreeComponent.this.worldTreeModel.isElementInScope(element), WorldTreeComponent.this.authoringTool, WorldTreeComponent.this.worldTree, path);
            return ElementPopupUtilities.makeElementPopupMenu(element, structure);
        }

        protected Vector getDefaultStructure() {
            if (this.defaultStructure == null) {
                this.defaultStructure = new Vector();
                this.defaultStructure.add(new StringObjectPair("create new group", new Runnable(){

                    @Override
                    public void run() {
                        Group newGroup = new Group();
                        String name = AuthoringToolResources.getNameForNewChild("Group", (this).WorldTreeComponent.this.world);
                        newGroup.name.set(name);
                        newGroup.valueClass.set(Model.class);
                        (this).WorldTreeComponent.this.world.addChild(newGroup);
                        (this).WorldTreeComponent.this.world.groups.add(newGroup);
                    }
                }));
            }
            return this.defaultStructure;
        }
    };
    BorderLayout borderLayout2 = new BorderLayout();
    TitledBorder titledBorder1;
    JScrollPane treeScrollPane = new JScrollPane();
    JPanel treePanel = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    WorldTree worldTree = new WorldTree();

    public WorldTreeComponent(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.modelInit();
        this.jbInit();
        this.treeInit();
        this.dndInit();
        this.selectionInit();
    }

    private void modelInit() {
        this.worldTreeModel.setRoot(this.bogusRoot);
    }

    private void treeInit() {
        this.worldTree.setModel(this.worldTreeModel);
        this.worldTree.addTreeSelectionListener(this.worldSelectionListener);
        this.worldTree.putClientProperty("JTree.lineStyle", "Angled");
        this.worldTree.setCellEditor(this.cellEditor);
        this.worldTree.setCellRenderer(this.cellRenderer);
        CustomTreeUI treeUI = new CustomTreeUI();
        this.worldTree.setUI(treeUI);
        treeUI.setExpandedIcon(AuthoringToolResources.getIconForString("minus"));
        treeUI.setCollapsedIcon(AuthoringToolResources.getIconForString("plus"));
        this.worldTree.setEditable(true);
        this.worldTree.addMouseListener(this.worldTreeMouseListener);
        this.worldTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent ev) throws ExpandVetoException {
                if (ev.getPath().getLastPathComponent() == WorldTreeComponent.this.worldTreeModel.getRoot()) {
                    throw new ExpandVetoException(ev);
                }
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent ev) {
            }
        });
        this.treeScrollPane.setBorder(null);
    }

    private void dndInit() {
        this.dragSource.createDefaultDragGestureRecognizer(this.worldTree, 0x40000003, new ElementTreeDragGestureListener(this.worldTree));
        this.worldTree.setDropTarget(new DropTarget(this.worldTree, this.worldTreeDropTargetListener));
    }

    private void selectionInit() {
        this.authoringTool.addElementSelectionListener(new ElementSelectionListener(){

            @Override
            public void elementSelected(Element element) {
                WorldTreeComponent.this.setSelectedElement(element);
            }
        });
    }

    public void startListening(AuthoringTool authoringTool) {
        authoringTool.addAuthoringToolStateListener(this.worldTreeModel);
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
        if (world == null) {
            this.worldTreeModel.setRoot(this.bogusRoot);
            this.setCurrentScope(this.bogusRoot);
        } else {
            this.worldTreeModel.setRoot(world);
            this.setCurrentScope(world);
        }
        this.revalidate();
        this.repaint();
    }

    public void setCurrentScope(Element element) {
        this.worldTreeModel.setCurrentScope(element);
    }

    public void setSelectedElement(Element element) {
        block6: {
            if (element != this.selectedElement) {
                this.selectedElement = element;
                if (element == null) {
                    this.worldTree.clearSelection();
                } else {
                    Object[] path;
                    while ((path = this.worldTreeModel.getPath(element)) == null || path.length == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie) {
                            break block6;
                        }
                    }
                    TreePath selectedPath = new TreePath(path);
                    this.worldTree.setSelectionPath(selectedPath);
                    this.worldTree.scrollPathToVisible(selectedPath);
                }
            }
        }
    }

    public Element getSelectedElement() {
        return this.selectedElement;
    }

    public void jbInit() {
        this.titledBorder1 = new TitledBorder("");
        this.setLayout(this.borderLayout2);
        if (this.authoringtoolConfig != null) {
            int fontSize = Integer.parseInt(this.authoringtoolConfig.getValue("fontSize"));
            this.worldTree.setFont(new Font("Dialog", 0, (int)((double)(14 * fontSize) / 12.0)));
        } else {
            this.worldTree.setFont(new Font("Dialog", 0, 14));
        }
        this.setMinimumSize(new Dimension(5, 0));
        this.treePanel.setLayout(this.borderLayout4);
        this.worldTree.setBorder(new JScrollPane().getViewportBorder());
        this.add((Component)this.treeScrollPane, "Center");
        this.treeScrollPane.getViewport().add((Component)this.treePanel, null);
        this.treePanel.add((Component)this.worldTree, "Center");
    }

    public class CustomTreeUI
    extends MetalTreeUI {
        @Override
        protected MouseListener createMouseListener() {
            return new CustomMouseHandler();
        }

        @Override
        protected boolean startEditing(TreePath path, MouseEvent ev) {
            boolean result = super.startEditing(path, ev);
            if (result) {
                WorldTreeComponent.this.cellEditor.selectText();
            }
            return result;
        }

        public class CustomMouseHandler
        extends MouseAdapter {
            protected long pressTime;
            protected Point pressPoint;
            protected long clickDelay = 300L;
            protected double clickDistance = 8.0;

            @Override
            public void mousePressed(MouseEvent ev) {
                this.pressTime = ev.getWhen();
                this.pressPoint = ev.getPoint();
                if (CustomTreeUI.this.tree != null && CustomTreeUI.this.tree.isEnabled()) {
                    CustomTreeUI.this.tree.requestFocus();
                    TreePath path = CustomTreeUI.this.getClosestPathForLocation(CustomTreeUI.this.tree, ev.getX(), ev.getY());
                    if (path != null) {
                        Rectangle bounds = CustomTreeUI.this.getPathBounds(CustomTreeUI.this.tree, path);
                        if (ev.getY() > bounds.y + bounds.height) {
                            return;
                        }
                        if (SwingUtilities.isLeftMouseButton(ev)) {
                            CustomTreeUI.this.checkForClickInExpandControl(path, ev.getX(), ev.getY());
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (CustomTreeUI.this.tree != null && CustomTreeUI.this.tree.isEnabled()) {
                    CustomTreeUI.this.tree.requestFocus();
                    TreePath path = CustomTreeUI.this.getClosestPathForLocation(CustomTreeUI.this.tree, ev.getX(), ev.getY());
                    if (path != null) {
                        Element element = (Element)path.getLastPathComponent();
                        boolean elementInScope = ((WorldTreeModel)CustomTreeUI.this.tree.getModel()).isElementInScope(element);
                        if (elementInScope) {
                            Rectangle bounds = CustomTreeUI.this.getPathBounds(CustomTreeUI.this.tree, path);
                            if (ev.getY() > bounds.y + bounds.height) {
                                return;
                            }
                            int x = ev.getX();
                            if (x > bounds.x && x <= bounds.x + bounds.width) {
                                if (this.isClick(ev) && CustomTreeUI.this.startEditing(path, ev)) {
                                    return;
                                }
                                CustomTreeUI.this.selectPathForEvent(path, ev);
                            }
                        }
                    }
                }
            }

            protected boolean isClick(MouseEvent ev) {
                double dy;
                double dx;
                double dist;
                if (ev.getClickCount() > 1) {
                    return true;
                }
                long time = ev.getWhen();
                Point p = ev.getPoint();
                return time - this.pressTime <= this.clickDelay && (dist = Math.sqrt((dx = p.getX() - this.pressPoint.getX()) * dx + (dy = p.getY() - this.pressPoint.getY()) * dy)) <= this.clickDistance;
            }
        }
    }

    public class ElementTreeDragGestureListener
    implements DragGestureListener {
        protected JTree tree;
        protected WorldTreeModel treeModel;

        public ElementTreeDragGestureListener(JTree tree) {
            this.tree = tree;
            this.treeModel = (WorldTreeModel)tree.getModel();
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Object element;
            DnDManager.fireDragGestureRecognized(dge);
            if (this.tree.isEditing()) {
                return;
            }
            Point p = dge.getDragOrigin();
            TreePath path = this.tree.getPathForLocation((int)p.getX(), (int)p.getY());
            WorldTreeComponent.this.worldTree.setSelectionPath(path);
            if (path != null && (element = path.getLastPathComponent()) instanceof Element && this.treeModel.isElementInScope((Element)element)) {
                Transferable transferable = TransferableFactory.createTransferable(element);
                try {
                    WorldTreeComponent.this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, transferable, DnDManager.getInternalListener());
                    DnDManager.fireDragStarted(transferable, WorldTreeComponent.this);
                }
                catch (InvalidDnDOperationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class HackBorder
    extends AbstractBorder {
        private static final Insets insets = new Insets(1, 1, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(0, 0, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(w - 2, 2, w - 2, 2);
            g.drawLine(1, h - 2, 1, h - 2);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }
    }

    public class WorldTreeDropTargetListener
    implements DropTargetListener {
        protected boolean checkDrag(DropTargetDragEvent dtde) {
            if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, AuthoringToolResources.getReferenceFlavorForClass(Model.class))) {
                dtde.acceptDrag(2);
                return true;
            }
            dtde.rejectDrag();
            return false;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (this.checkDrag(dtde)) {
                WorldTreeComponent.this.worldTree.setDropLinesActive(true);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (this.checkDrag(dtde)) {
                WorldTreeComponent.this.worldTree.setCursorLocation(dtde.getLocation());
                TreePath parentPath = WorldTreeComponent.this.worldTree.getParentPath();
                Element parent = (Element)parentPath.getLastPathComponent();
                Transferable transferable = DnDManager.getCurrentTransferable();
                Element child = null;
                if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, AuthoringToolResources.getReferenceFlavorForClass(Model.class))) {
                    try {
                        child = (Element)transferable.getTransferData(AuthoringToolResources.getReferenceFlavorForClass(Model.class));
                    }
                    catch (Exception e) {
                        AuthoringTool.showErrorDialog("Error encountered extracting drop transferable.", e);
                    }
                }
                if (child != null) {
                    if (this.isAcceptableDrop(parent, child)) {
                        WorldTreeComponent.this.worldTree.setShowDropLines(true);
                    } else {
                        WorldTreeComponent.this.worldTree.setShowDropLines(false);
                    }
                } else {
                    WorldTreeComponent.this.worldTree.setShowDropLines(true);
                }
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.checkDrag(dtde);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            WorldTreeComponent.this.worldTree.setDropLinesActive(false);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            boolean succeeded = true;
            WorldTreeComponent.this.worldTree.setCursorLocation(dtde.getLocation());
            try {
                if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, AuthoringToolResources.getReferenceFlavorForClass(Model.class))) {
                    Transferable transferable = dtde.getTransferable();
                    final Model model = (Model)transferable.getTransferData(AuthoringToolResources.getReferenceFlavorForClass(Model.class));
                    TreePath parentPath = WorldTreeComponent.this.worldTree.getParentPath();
                    final Element parent = (Element)parentPath.getLastPathComponent();
                    if (this.isAcceptableDrop(parent, model)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    WorldTreeDropTargetListener.this.insertChild(parent, model, ((WorldTreeDropTargetListener)WorldTreeDropTargetListener.this).WorldTreeComponent.this.worldTree.getParentToPredecessorPaths());
                                }
                                catch (Throwable t) {
                                    AuthoringTool.showErrorDialog("Error moving child.", t);
                                }
                            }
                        });
                        dtde.acceptDrop(2);
                        succeeded = true;
                    } else {
                        dtde.rejectDrop();
                        succeeded = false;
                    }
                } else {
                    dtde.rejectDrop();
                    succeeded = false;
                }
            }
            catch (UnsupportedFlavorException e) {
                AuthoringTool.showErrorDialog("Drop didn't work: bad flavor", e);
                succeeded = false;
            }
            catch (IOException e) {
                AuthoringTool.showErrorDialog("Drop didn't work: IOException", e);
                succeeded = false;
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Drop didn't work.", t);
                succeeded = false;
            }
            WorldTreeComponent.this.worldTree.setDropLinesActive(false);
            dtde.dropComplete(succeeded);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isAcceptableDrop(Element parent, Element child) {
            if (parent instanceof Group) {
                Group group = (Group)parent;
                Class childValueClass = child.getClass();
                if (child instanceof Expression) {
                    childValueClass = ((Expression)child).getValueClass();
                }
                if (!group.valueClass.getClassValue().isAssignableFrom(childValueClass)) {
                    return false;
                }
            }
            if (!(parent instanceof Group) && !(parent instanceof World)) return false;
            if (parent instanceof World && child.getParent() instanceof World) {
                return true;
            }
            if (parent instanceof Group && child.getParent() instanceof Group) {
                if (parent.name.getValue().equals(child.getParent().name.getValue())) return true;
                int i = 0;
                while (i < parent.getChildCount()) {
                    if (parent.getChildAt((int)i).name.getValue().equals(child.name.getValue())) {
                        return false;
                    }
                    ++i;
                }
            } else if (child.getParent() == null) {
                return true;
            }
            int i = 0;
            while (i < parent.getChildCount()) {
                if (parent.getChildAt((int)i).name.getValue().equals(child.name.getValue())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void insertChild(Element parent, Element child, TreePath[] parentToPredecessor) {
            int index = 0;
            TreePath parentPath = parentToPredecessor[0];
            TreePath predecessorPath = parentToPredecessor[parentToPredecessor.length - 1];
            ObjectArrayProperty oap = null;
            if (parent instanceof World) {
                oap = ((World)parent).sandboxes;
            } else if (parent instanceof Group) {
                oap = ((Group)parent).values;
            }
            if (predecessorPath == parentPath) {
                index = 0;
            } else {
                int i = parentToPredecessor.length - 1;
                while (i >= 0 && parentToPredecessor[i] != null && !parentToPredecessor[i].getParentPath().equals(parentPath)) {
                    --i;
                }
                Element predecessor = (Element)parentToPredecessor[i].getLastPathComponent();
                if (oap != null) {
                    index = 1 + oap.indexOf(predecessor);
                }
            }
            if (oap != null && this.isAcceptableDrop(parent, child)) {
                int currentIndex = oap.indexOf(child);
                if (currentIndex > -1 && currentIndex < index) {
                    --index;
                }
                WorldTreeComponent.this.authoringTool.getUndoRedoStack().startCompound();
                child.removeFromParentsProperties();
                child.setParent(parent);
                oap.add(index, child);
                WorldTreeComponent.this.authoringTool.getUndoRedoStack().stopCompound();
            }
        }
    }
}

