/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.datatransfer;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.core.CopyFactory;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class CopyFactoryTransferable
implements Transferable {
    public static DataFlavor copyFactoryFlavor = AuthoringToolResources.getReferenceFlavorForClass(CopyFactory.class);
    protected CopyFactory copyFactory;
    protected DataFlavor myFlavor;
    protected DataFlavor[] flavors;

    public CopyFactoryTransferable(CopyFactory copyFactory) {
        this.copyFactory = copyFactory;
        try {
            this.myFlavor = AuthoringToolResources.getReferenceFlavorForClass(CopyFactory.class);
            this.myFlavor.setHumanPresentableName("copyFactoryTransferable(" + copyFactory.getValueClass().getName() + ")");
        }
        catch (Exception e) {
            AuthoringTool.showErrorDialog(e.getMessage(), e);
        }
        this.flavors = new DataFlavor[2];
        this.flavors[0] = this.myFlavor;
        this.flavors[1] = DataFlavor.stringFlavor;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int i = 0;
        while (i < this.flavors.length) {
            if (flavor.equals(this.flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.getRepresentationClass().equals(CopyFactory.class)) {
            return this.copyFactory;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.copyFactory.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

