/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.datatransfer;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.core.Property;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class PropertyReferenceTransferable
implements Transferable {
    public static final DataFlavor propertyReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(Property.class);
    protected DataFlavor[] flavors;
    protected Property property;

    public PropertyReferenceTransferable(Property property) {
        this.property = property;
        this.flavors = new DataFlavor[2];
        this.flavors[0] = propertyReferenceFlavor;
        this.flavors[1] = DataFlavor.stringFlavor;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int i = 0;
        while (i < this.flavors.length) {
            if (flavor.equals(this.flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(propertyReferenceFlavor)) {
            return this.property;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.property.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

