/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.OutputComponent;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyledStreamTextPane;
import edu.cmu.cs.stage3.alice.authoringtool.util.WatcherPanel;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.response.SoundResponse;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import movieMaker.FrameSequencer;
import movieMaker.Merge;
import movieMaker.MovieCapturer;
import movieMaker.MovieWriter;
import movieMaker.Picture;
import movieMaker.SoundHandler;
import movieMaker.SoundStorage;
import movieMaker.StartMovieCapture;

public class CaptureContentPane
extends ContentPane {
    protected JPanel renderPanel = new JPanel(new BorderLayout());
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JSplitPane stdOutSplitPane = new JSplitPane(0);
    protected Configuration config = Configuration.getLocalConfiguration(JAlice.class.getPackage());
    protected double aspectRatio;
    protected AuthoringTool authoringTool;
    protected boolean showStdOut = false;
    protected int stdOutHeight = 100;
    protected int watcherWidth = 200;
    protected OutputComponent stdOutOutputComponent;
    protected WatcherPanel watcherPanel;
    protected JScrollPane watcherScrollPane;
    protected JSplitPane watcherSplitPane = new JSplitPane(1);
    protected JButton pauseButton;
    protected JButton resumeButton;
    protected JButton restartButton;
    protected JButton stopButton;
    protected JButton takePictureButton;
    protected JSlider speedSlider;
    protected JLabel speedLabel;
    protected RenderCanvasFocusListener renderCanvasFocusListener = new RenderCanvasFocusListener();
    protected boolean shiftIsDown = false;
    protected JScrollPane textScrollPane;
    protected StyledStreamTextPane detailTextPane = new StyledStreamTextPane();
    protected boolean doNotListenToSpeedSlider = false;
    protected boolean doNotListenToResize = false;
    protected final int dividerSize = 8;
    protected String title;
    protected ActionListener okActionListener;
    protected JPanel captureBar = new JPanel(new GridBagLayout());
    protected JPanel exportBar = new JPanel(new GridBagLayout());
    protected JFrame statusFrame;
    protected JLabel recordLabel;
    protected JButton startCaptureButton;
    protected JButton stopCaptureButton;
    protected JButton clearButton;
    protected JLabel timeLabel;
    protected JButton encodeButton;
    protected JTextField fileName;
    protected JComboBox fileType;
    protected JLabel statusLabel;
    protected StartMovieCapture movieCapture = null;
    private Thread capturing;
    private Thread pulse;
    private Thread timerThread;
    private Thread writing;
    private Thread compressing;
    private boolean pulsing = false;
    private boolean running = false;
    private boolean endCapturing = false;
    private MovieCapturer videoHandler;
    private String exportDirectory;
    private FrameSequencer frameSequencer;
    protected TextOutputDocumentListener textListener = new TextOutputDocumentListener();
    protected RenderComponentListener renderResizeListener = new RenderComponentListener();

    public CaptureContentPane(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.stdOutOutputComponent = authoringTool.getStdOutOutputComponent();
        this.watcherPanel = authoringTool.getWatcherPanel();
        this.guiInit();
    }

    public void setAspectRatio(double aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    protected void setRenderWindowSizeBasedOnSavedBounds() {
        Rectangle bounds = this.getRenderBounds();
        this.renderPanel.setPreferredSize(new Dimension(bounds.width, bounds.height));
    }

    @Override
    public void preDialogShow(JDialog parentDialog) {
        super.preDialogShow(parentDialog);
        final Component renderCanvas = this.getRenderCanvas();
        if (renderCanvas != null) {
            renderCanvas.addFocusListener(this.renderCanvasFocusListener);
            Timer focusTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    renderCanvas.requestFocus();
                }
            });
            focusTimer.setRepeats(false);
            focusTimer.start();
        }
        this.stdOutOutputComponent.stdOutStream.println(Messages.getString("Running_World"));
        this.stdOutOutputComponent.stdOutStream.flush();
        this.stdOutOutputComponent.getTextPane().getDocument().addDocumentListener(this.textListener);
        Rectangle bounds = this.getRenderBounds();
        this.renderPanel.setPreferredSize(new Dimension(bounds.width, bounds.height));
        parentDialog.setLocation(bounds.getLocation());
        this.showStdOut = false;
        this.keyMapInit();
        this.updateGUI();
        if (this.config.getValue("rendering.ensureRenderDialogIsOnScreen").equalsIgnoreCase("true")) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = parentDialog.getSize();
            Point dialogLocation = parentDialog.getLocation();
            Rectangle screenRect = new Rectangle(0, 0, screenSize.width, screenSize.height);
            if (!SwingUtilities.isRectangleContainingRectangle(screenRect, parentDialog.getBounds())) {
                if (dialogLocation.x + dialogSize.width > screenSize.width) {
                    dialogLocation.x = screenSize.width - dialogSize.width;
                }
                if (dialogLocation.x < 0) {
                    dialogLocation.x = 0;
                }
                if (dialogLocation.y + dialogSize.height > screenSize.height) {
                    dialogLocation.y = screenSize.height - dialogSize.height;
                }
                if (dialogLocation.y < 0) {
                    dialogLocation.y = 0;
                }
                if (this.config.getValue("rendering.constrainRenderDialogAspectRatio").equalsIgnoreCase("false")) {
                    Dimension renderSize;
                    if (dialogSize.width > screenSize.width) {
                        renderSize = this.renderPanel.getPreferredSize();
                        renderSize.width = screenSize.width - 8;
                        this.renderPanel.setPreferredSize(renderSize);
                    }
                    if (dialogSize.height > screenSize.height) {
                        renderSize = this.renderPanel.getPreferredSize();
                        renderSize.height = screenSize.height - 27;
                        this.renderPanel.setPreferredSize(renderSize);
                    }
                } else if (dialogSize.height > screenSize.height || dialogSize.width > screenSize.width) {
                    double windowAspect = (double)screenSize.width / (double)screenSize.height;
                    if (this.aspectRatio > windowAspect) {
                        Dimension renderSize = this.renderPanel.getPreferredSize();
                        renderSize.width = screenSize.width - 8;
                        renderSize.height = (int)Math.round((double)renderSize.width / this.aspectRatio);
                        this.renderPanel.setPreferredSize(renderSize);
                    } else {
                        Dimension renderSize = this.renderPanel.getPreferredSize();
                        renderSize.height = screenSize.height - 27;
                        renderSize.width = (int)Math.round((double)renderSize.height * this.aspectRatio);
                        this.renderPanel.setPreferredSize(renderSize);
                    }
                }
                parentDialog.setLocation(dialogLocation);
                this.renderPanel.invalidate();
                parentDialog.pack();
            }
        }
    }

    @Override
    public void postDialogShow(JDialog parentDialog) {
        Component renderCanvas;
        super.postDialogShow(parentDialog);
        this.authoringTool.stopWorld();
        this.statusFrame.setVisible(false);
        this.timeLabel.setBackground(Color.GREEN);
        this.setClear(false);
        this.setButtonsCapturing(false);
        this.endCapturing = false;
        this.running = false;
        this.pulsing = false;
        try {
            if (this.timerThread != null) {
                this.timerThread.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.timeLabel.setText("0:00  ");
        try {
            if (this.capturing != null) {
                this.capturing.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.authoringTool.worldStopRunning();
        this.speedSlider.setValue(0);
        this.saveRenderBounds();
        this.showStdOut = false;
        if (this.config.getValue("clearStdOutOnRun").equalsIgnoreCase("true")) {
            this.detailTextPane.setText("");
        }
        if ((renderCanvas = this.getRenderCanvas()) != null) {
            renderCanvas.removeFocusListener(this.renderCanvasFocusListener);
        }
        this.stdOutOutputComponent.getTextPane().getDocument().removeDocumentListener(this.textListener);
        this.stdOutOutputComponent.stdOutStream.println(String.valueOf(Messages.getString("Stopping_World")) + "\n");
        this.stdOutOutputComponent.stdOutStream.flush();
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.okActionListener = l;
        this.stopButton.addActionListener(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.okActionListener = null;
        this.stopButton.removeActionListener(l);
    }

    protected void checkFileName() {
        String nameValue = this.fileName.getText();
        if (AikMin.isValidName(nameValue)) {
            this.fileName.setForeground(Color.black);
            this.startCaptureButton.setEnabled(true);
        } else {
            this.fileName.setForeground(Color.red);
            this.startCaptureButton.setEnabled(false);
        }
    }

    private void guiInit() {
        this.title = Messages.getString("Alice_World");
        this.setRenderWindowSizeBasedOnSavedBounds();
        this.watcherScrollPane = new JScrollPane(this.watcherPanel, 20, 30);
        this.textScrollPane = new JScrollPane(this.detailTextPane, 20, 30);
        this.detailTextPane.setEditable(false);
        this.pauseButton = new JButton(this.authoringTool.getActions().pauseWorldAction);
        this.resumeButton = new JButton(this.authoringTool.getActions().resumeWorldAction);
        this.restartButton = new JButton(this.authoringTool.getActions().restartStopWorldAction);
        this.stopButton = new JButton(this.authoringTool.getActions().stopWorldAction);
        this.takePictureButton = new JButton(this.authoringTool.getActions().takePictureAction);
        this.takePictureButton.setEnabled(true);
        this.speedLabel = new JLabel(Messages.getString("Speed__1x"));
        int fontSize = Integer.parseInt(this.config.getValue("fontSize"));
        this.speedLabel.setFont(new Font("SansSerif", 1, (int)((double)(12 * fontSize) / 12.0)));
        this.speedLabel.setPreferredSize(new Dimension(80, 12));
        this.speedLabel.setMinimumSize(new Dimension(20, 12));
        this.speedLabel.setMaximumSize(new Dimension(80, 12));
        this.pauseButton.setMargin(new Insets(3, 2, 3, 2));
        this.resumeButton.setMargin(new Insets(3, 2, 3, 2));
        this.restartButton.setMargin(new Insets(3, 2, 3, 2));
        this.stopButton.setMargin(new Insets(3, 2, 3, 2));
        this.takePictureButton.setMargin(new Insets(3, 2, 3, 2));
        this.stopCaptureButton = new JButton(Messages.getString("Stop_Recording"));
        this.stopCaptureButton.setToolTipText(Messages.getString("Click_here_to_stop_the_video_capture"));
        this.startCaptureButton = new JButton(Messages.getString("Record"));
        this.startCaptureButton.setToolTipText(Messages.getString("Click_here_to_start_the_video_capture"));
        this.encodeButton = new JButton(Messages.getString("Export_Video"));
        this.encodeButton.setToolTipText(Messages.getString("Click_here_to_stop_filming_and_encode_the_video"));
        this.clearButton = new JButton(Messages.getString("Clear"));
        this.clearButton.setToolTipText(Messages.getString("Click_here_to_clear_captured_video"));
        this.clearButton.setMargin(new Insets(3, 2, 3, 2));
        this.stopCaptureButton.setMargin(new Insets(3, 2, 3, 2));
        this.startCaptureButton.setMargin(new Insets(3, 2, 3, 2));
        this.encodeButton.setMargin(new Insets(3, 2, 3, 2));
        String[] types = new String[]{"MOV"};
        this.fileType = new JComboBox<String>(types);
        this.fileName = new JTextField(Messages.getString("MyVideo"));
        this.fileName.setFont(new Font("SansSerif", 1, (int)((double)(12 * fontSize) / 12.0)));
        this.fileName.setPreferredSize(new Dimension(124, 24));
        this.fileName.setMinimumSize(new Dimension(60, 24));
        this.fileName.setMaximumSize(new Dimension(124, 24));
        this.fileName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CaptureContentPane.this.checkFileName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CaptureContentPane.this.checkFileName();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CaptureContentPane.this.checkFileName();
            }
        });
        this.statusLabel = new JLabel(Messages.getString("Ready"));
        this.timeLabel = new JLabel("0:00  ");
        this.captureBar = new JPanel();
        this.statusLabel.setHorizontalAlignment(0);
        this.captureBar.setLayout(new GridBagLayout());
        this.exportBar = new JPanel();
        this.exportBar.setLayout(new GridBagLayout());
        this.recordLabel = new JLabel();
        this.captureBar.add((Component)this.startCaptureButton, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.captureBar.add((Component)this.stopCaptureButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.captureBar.add((Component)this.clearButton, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.captureBar.add((Component)new JLabel(), new GridBagConstraints(4, 0, 1, 2, 0.5, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.captureBar.add((Component)this.recordLabel, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.captureBar.add((Component)this.timeLabel, new GridBagConstraints(6, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.exportBar.add((Component)new JLabel("   " + Messages.getString("File_name_") + " "), new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.exportBar.add((Component)this.fileName, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.exportBar.add((Component)this.fileType, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.exportBar.add((Component)new JLabel(), new GridBagConstraints(4, 0, 1, 2, 0.5, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.exportBar.add((Component)this.encodeButton, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.timeLabel.setBackground(Color.GREEN);
        this.setButtonsCapturing(false);
        this.encodeButton.setEnabled(false);
        this.setClear(false);
        this.captureActionListeners();
        this.speedSlider = new JSlider(0, 9, 0);
        this.speedSlider.setPreferredSize(new Dimension(100, 16));
        this.speedSlider.setMinimumSize(new Dimension(40, 16));
        this.speedSlider.setMaximumSize(new Dimension(100, 16));
        this.speedSlider.setSnapToTicks(true);
        this.speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                Component renderCanvas;
                JSlider s = (JSlider)ce.getSource();
                if (!CaptureContentPane.this.doNotListenToSpeedSlider) {
                    int value = s.getValue();
                    if (value >= 0) {
                        CaptureContentPane.this.updateSpeed((double)value + 1.0);
                    } else if (value < 0) {
                        CaptureContentPane.this.updateSpeed(1.0 / (double)(1 + value * -1));
                    }
                }
                if ((renderCanvas = CaptureContentPane.this.getRenderCanvas()) != null && renderCanvas.isShowing()) {
                    renderCanvas.requestFocus();
                }
            }
        });
        this.buttonPanel.add((Component)this.speedSlider, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.pauseButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.speedLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.buttonPanel.add((Component)this.resumeButton, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.restartButton, new GridBagConstraints(6, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.stopButton, new GridBagConstraints(7, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.takePictureButton, new GridBagConstraints(8, 0, 1, 2, 1.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.watcherSplitPane = new JSplitPane(1);
        this.watcherSplitPane.setContinuousLayout(true);
        this.watcherSplitPane.setDividerSize(0);
        this.watcherSplitPane.setResizeWeight(1.0);
        this.watcherSplitPane.setLeftComponent(this.renderPanel);
        this.stdOutSplitPane = new JSplitPane(0);
        this.stdOutSplitPane.setContinuousLayout(true);
        this.stdOutSplitPane.setDividerSize(0);
        this.stdOutSplitPane.setResizeWeight(1.0);
        this.stdOutSplitPane.setTopComponent(this.watcherSplitPane);
        this.setLayout(new BorderLayout());
        JPanel menu = new JPanel();
        menu.setLayout(new GridLayout(3, 1));
        menu.add(this.captureBar);
        menu.add(this.exportBar);
        menu.add(this.buttonPanel);
        this.add((Component)menu, "North");
        this.add((Component)this.stdOutSplitPane, "Center");
        this.createStatusFrame();
        this.updateGUI();
    }

    private void keyMapInit() {
        for (Action action : this.authoringTool.getActions().renderActions) {
            Component root;
            String commandKey;
            KeyStroke keyStroke;
            try {
                keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                commandKey = (String)action.getValue("ActionCommandKey");
            }
            catch (ClassCastException e) {
                continue;
            }
            if (keyStroke == null || commandKey == null || !((root = SwingUtilities.getRoot(this)) instanceof JDialog)) continue;
            ((JDialog)root).getRootPane().registerKeyboardAction(action, commandKey, keyStroke, 2);
        }
    }

    public void saveRenderBounds() {
        Point pos = new Point(0, 0);
        Dimension size = this.renderPanel.getSize();
        Component root = SwingUtilities.getRoot(this);
        if (root instanceof JDialog) {
            SwingUtilities.convertPointToScreen(pos, root);
        } else {
            SwingUtilities.convertPointToScreen(pos, this.renderPanel);
        }
        this.config.setValue("rendering.renderWindowBounds", String.valueOf(pos.x) + ", " + pos.y + ", " + size.width + ", " + size.height);
    }

    public void saveRenderBounds(Rectangle newBounds) {
        this.config.setValue("rendering.renderWindowBounds", String.valueOf(newBounds.x) + ", " + newBounds.y + ", " + newBounds.width + ", " + newBounds.height);
    }

    protected boolean shouldConstrainAspectOnResize() {
        return !this.showStdOut && this.config.getValue("rendering.constrainRenderDialogAspectRatio").equalsIgnoreCase("true");
    }

    public JPanel getRenderPanel() {
        return this.renderPanel;
    }

    public Rectangle getRenderBounds() {
        String boundsString = this.config.getValue("rendering.renderWindowBounds");
        StringTokenizer st = new StringTokenizer(boundsString, " \t,");
        if (st.countTokens() == 4) {
            try {
                int x = Integer.parseInt(st.nextToken());
                int y = Integer.parseInt(st.nextToken());
                int width = Integer.parseInt(st.nextToken());
                int height = Integer.parseInt(st.nextToken());
                Rectangle bounds = new Rectangle(x, y, width, height);
                double currentAspectRatio = (double)width / (double)height;
                if (this.shouldConstrainAspectOnResize()) {
                    this.constrainToAspectRatio(bounds, currentAspectRatio > 1.0);
                }
                return bounds;
            }
            catch (NumberFormatException e) {
                AuthoringTool.showErrorDialog(Messages.getString("Parse_error_in_config_value__rendering_renderWindowBounds"), e);
            }
        } else {
            AuthoringTool.showErrorDialog(Messages.getString("Incorrect_number_of_tokens_in_config_value__rendering_renderWindowBounds"), null);
        }
        return null;
    }

    public void constrainToAspectRatio(Rectangle bounds, boolean stretchHorizontally) {
        if (this.aspectRatio > 0.0) {
            if (stretchHorizontally) {
                bounds.width = (int)Math.round((double)bounds.height * this.aspectRatio);
            } else {
                bounds.height = (int)Math.round((double)bounds.width / this.aspectRatio);
            }
        }
    }

    public void updateSpeed(double newSpeed) {
        this.authoringTool.setWorldSpeed(newSpeed);
        String speedText = NumberFormat.getInstance().format(newSpeed);
        if (newSpeed < 1.0) {
            if (newSpeed == 0.5) {
                speedText = "1/2";
            } else if (newSpeed == 0.25) {
                speedText = "1/4";
            } else if (newSpeed == 0.2) {
                speedText = "1/5";
            } else if (newSpeed > 0.3 && newSpeed < 0.34) {
                speedText = "1/3";
            } else if (newSpeed > 0.16 && newSpeed < 0.168) {
                speedText = "1/6";
            } else if (newSpeed > 0.14 && newSpeed < 0.143) {
                speedText = "1/7";
            }
        }
        this.speedLabel.setText(String.valueOf(Messages.getString("Speed__")) + speedText + "x");
        this.speedLabel.repaint();
    }

    public void setSpeedSliderValue(int value) {
        this.speedSlider.setValue(value);
    }

    public void stopWorld() {
        if (this.okActionListener != null) {
            this.okActionListener.actionPerformed(null);
        }
    }

    public void updateGUI() {
        int renderWidth = this.renderPanel.getWidth();
        if (this.showStdOut) {
            this.textScrollPane.setPreferredSize(new Dimension(renderWidth, this.stdOutHeight));
            this.stdOutSplitPane.setBottomComponent(this.textScrollPane);
            this.stdOutSplitPane.setDividerSize(8);
        } else {
            this.stdOutSplitPane.setBottomComponent(null);
            this.stdOutSplitPane.setDividerLocation(0);
            this.stdOutSplitPane.setDividerSize(0);
        }
        this.watcherSplitPane.setRightComponent(null);
        this.watcherSplitPane.setDividerLocation(0);
        this.watcherSplitPane.setDividerSize(0);
        this.packDialog();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.showStdOut = false;
        this.updateGUI();
    }

    public Component getRenderCanvas() {
        Component authoringToolRenderPanel = this.renderPanel.getComponent(0);
        if (authoringToolRenderPanel instanceof Container) {
            return ((Container)authoringToolRenderPanel).getComponent(0);
        }
        return null;
    }

    public void traverseTree() {
        World w = this.authoringTool.getWorld();
        this.findSounds(w);
    }

    public void setButtonsCapturing(boolean choice) {
        this.stopCaptureButton.setEnabled(choice);
        this.startCaptureButton.setEnabled(!choice);
        this.encodeButton.setEnabled(!choice);
        this.resumeButton.setEnabled(!choice);
        this.stopButton.setEnabled(!choice);
        this.restartButton.setEnabled(!choice);
    }

    public void setClear(boolean choice) {
        this.clearButton.setEnabled(choice);
        this.encodeButton.setEnabled(choice);
    }

    public void findSoundsfromResponse(Response s) {
        if (s instanceof SoundResponse) {
            ((SoundResponse)s).addSoundListener(new SoundHandler(this.authoringTool.getSoundStorage(), this.authoringTool));
        }
        if (s.getChildCount() > 0) {
            Element[] children = s.getChildren(Sandbox.class);
            int y = 0;
            while (y < children.length) {
                this.findSounds((Sandbox)children[y]);
                ++y;
            }
            children = s.getChildren(Response.class);
            y = 0;
            while (y < children.length) {
                this.findSoundsfromResponse((Response)children[y]);
                ++y;
            }
        }
    }

    public void findSoundsfromBehavior(Behavior s) {
        if (s.getChildCount() > 0) {
            Element[] children = s.getChildren(Response.class);
            int y = 0;
            while (y < children.length) {
                if (children[y] instanceof SoundResponse) {
                    ((SoundResponse)children[y]).addSoundListener(new SoundHandler(this.authoringTool.getSoundStorage(), this.authoringTool));
                }
                ++y;
            }
        }
    }

    public void findSounds(Sandbox sbox) {
        ElementArrayProperty p = sbox.responses;
        Object[] objs = p.getArrayValue();
        int x = 0;
        while (x < objs.length) {
            if (objs[x] != null) {
                this.findSoundsfromResponse((Response)objs[x]);
            }
            ++x;
        }
        p = sbox.behaviors;
        objs = p.getArrayValue();
        x = 0;
        while (x < objs.length) {
            if (objs[x] != null) {
                this.findSoundsfromBehavior((Behavior)objs[x]);
            }
            ++x;
        }
        Element[] t = sbox.getChildren(Sandbox.class);
        int x2 = 0;
        while (x2 < t.length) {
            this.findSounds((Sandbox)t[x2]);
            ++x2;
        }
    }

    public void setExportDirectory(String directory) {
        this.exportDirectory = directory;
    }

    public void captureInit() {
        this.videoHandler = new MovieCapturer(String.valueOf(this.exportDirectory) + "/frames/");
        this.frameSequencer = this.videoHandler.getFrameSequencer();
        this.authoringTool.pause();
        this.traverseTree();
        this.authoringTool.getSoundStorage().frameList = new ArrayList();
    }

    public void removeFiles(String dir) {
        File f = new File(dir);
        String[] files = f.list();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            String x = files[i];
            File empty = new File(String.valueOf(dir) + x);
            empty.delete();
            ++i;
        }
    }

    public boolean getRunning() {
        return this.running;
    }

    public boolean getEnd() {
        return this.endCapturing;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void createStatusFrame() {
        this.statusFrame = new JFrame();
        this.statusFrame.setSize(200, 100);
        this.statusFrame.setVisible(false);
        this.statusFrame.getContentPane().add(this.statusLabel);
        this.statusFrame.pack();
    }

    @Override
    public void disable() {
        this.startCaptureButton.setEnabled(false);
        this.stopCaptureButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.encodeButton.setEnabled(false);
        this.resumeButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.restartButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.speedSlider.setEnabled(false);
        this.fileName.setEnabled(false);
        this.fileType.setEnabled(false);
        this.takePictureButton.setEnabled(false);
    }

    @Override
    public void enable() {
        this.startCaptureButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.encodeButton.setEnabled(true);
        this.resumeButton.setEnabled(true);
        this.restartButton.setEnabled(true);
        this.stopButton.setEnabled(true);
        this.speedSlider.setEnabled(true);
        this.fileName.setEnabled(true);
        this.fileType.setEnabled(true);
        this.takePictureButton.setEnabled(true);
    }

    public void showStatus() {
        this.disable();
        this.statusFrame.setSize(200, 100);
        this.statusFrame.setVisible(true);
        try {
            if (AikMin.isWindows()) {
                this.statusFrame.setAlwaysOnTop(true);
                Point location = this.captureBar.getLocationOnScreen();
                this.statusFrame.setLocation(new Point(location.x, (int)((double)location.y + (double)this.renderPanel.getHeight() / 2.0)));
            } else {
                this.statusFrame.setLocation(0, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopCaptureAction() {
        this.running = false;
        if (this.authoringTool.getWorldClock().isPaused()) {
            this.authoringTool.pause();
        }
        this.authoringTool.getSoundStorage().setListening(false, (double)System.currentTimeMillis() / 1000.0);
        this.recordLabel.setIcon(null);
        this.setButtonsCapturing(false);
        this.setClear(true);
        try {
            this.writing.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void clearAction() {
        this.endCapturing = false;
        this.running = false;
        this.pulsing = false;
        this.setClear(false);
        this.removeFiles(String.valueOf(this.exportDirectory) + "/frames/");
        try {
            if (this.timerThread != null) {
                this.timerThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.timeLabel.setText("0:00  ");
        this.authoringTool.setSoundStorage(new SoundStorage());
        this.videoHandler = new MovieCapturer(String.valueOf(this.exportDirectory) + "/frames/");
        this.authoringTool.getSoundStorage().frameList = new ArrayList();
        this.frameSequencer = this.videoHandler.getFrameSequencer();
        this.traverseTree();
    }

    public void startCaptureAction() {
        this.setClear(false);
        this.timeLabel.setBackground(Color.RED);
        this.setButtonsCapturing(true);
        this.recordLabel.setIcon(new ImageIcon(JAlice.class.getResource("images/record.png")));
        this.recordLabel.setAlignmentX(1.0f);
        if (this.movieCapture == null || this.capturing == null || !this.capturing.isAlive()) {
            this.endCapturing = true;
            this.movieCapture = new StartMovieCapture(this.authoringTool, this, this.frameSequencer, this.videoHandler.getFramesPerSecond());
            this.running = true;
            this.capturing = new Thread(this.movieCapture);
            this.writing = new Thread(new WriteFrames(String.valueOf(this.exportDirectory) + "/frames", this.frameSequencer, this.frameSequencer.getFrameNumber()));
            this.timerThread = new Thread(new StartTimer(this.timeLabel));
            this.capturing.start();
            this.writing.start();
            this.timerThread.start();
        } else {
            this.running = true;
            this.writing = new Thread(new WriteFrames(String.valueOf(this.exportDirectory) + "/frames", this.frameSequencer, this.frameSequencer.getFrameNumber()));
            this.writing.start();
        }
        if (!this.authoringTool.getWorldClock().isPaused()) {
            this.authoringTool.resume();
        }
        this.authoringTool.getSoundStorage().setListening(true, (double)System.currentTimeMillis() / 1000.0);
    }

    public JPanel getCapturePanel() {
        return this.captureBar;
    }

    public JPanel getExportPanel() {
        return this.exportBar;
    }

    public void encodeAction() {
        this.setClear(false);
        this.setButtonsCapturing(false);
        this.encodeButton.setEnabled(false);
        this.endCapturing = false;
        this.pulsing = true;
        this.timeLabel.setText("0:00  ");
        try {
            this.capturing.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pulse = new Thread(new StartStatusPulsing(this.statusLabel, Messages.getString("Encoding_Video")));
        this.pulse.start();
        this.showStatus();
        this.compressing = new Thread(new StartMovieCompression());
        this.compressing.start();
    }

    public void captureActionListeners() {
        this.stopCaptureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptureContentPane.this.stopCaptureAction();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptureContentPane.this.clearAction();
            }
        });
        this.startCaptureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptureContentPane.this.startCaptureAction();
            }
        });
        this.encodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptureContentPane.this.encodeAction();
            }
        });
    }

    public Rectangle getRenderPanelLocation() {
        Rectangle area = new Rectangle(0, 0, 0, 0);
        if (this.stdOutSplitPane != null && this.stdOutSplitPane.getLocationOnScreen() != null) {
            area.x = this.stdOutSplitPane.getLocationOnScreen().x;
            area.y = this.stdOutSplitPane.getLocationOnScreen().y;
        }
        if (this.showStdOut) {
            area.height = this.stdOutHeight;
        }
        return area;
    }

    void afterEncoding(boolean error) {
        if (error) {
            System.err.print(Messages.getString("Error_in_making_video_"));
        }
        this.running = false;
        this.pulsing = false;
        this.statusFrame.setVisible(false);
        this.authoringTool.setSoundStorage(new SoundStorage());
        this.videoHandler = new MovieCapturer(String.valueOf(this.exportDirectory) + "/frames/");
        this.authoringTool.getSoundStorage().frameList = new ArrayList();
        this.frameSequencer = this.videoHandler.getFrameSequencer();
        this.traverseTree();
        ++this.authoringTool.numEncoded;
        this.enable();
        this.encodeButton.setEnabled(false);
    }

    public class RenderCanvasFocusListener
    extends FocusAdapter {
        public void focusLost() {
            Component renderCanvas = CaptureContentPane.this.getRenderCanvas();
            if (renderCanvas != null && renderCanvas.isShowing()) {
                renderCanvas.requestFocus();
            }
        }
    }

    protected class RenderComponentListener
    extends ComponentAdapter {
        protected RenderComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent ev) {
            if (CaptureContentPane.this.shouldConstrainAspectOnResize() && !CaptureContentPane.this.doNotListenToResize && !CaptureContentPane.this.endCapturing) {
                int deltaHeight;
                CaptureContentPane.this.doNotListenToResize = true;
                Rectangle oldBounds = CaptureContentPane.this.getRenderBounds();
                Dimension newSize = CaptureContentPane.this.renderPanel.getSize();
                Rectangle newBounds = new Rectangle(oldBounds.getLocation(), newSize);
                int deltaWidth = Math.abs(oldBounds.width - newSize.width);
                CaptureContentPane.this.constrainToAspectRatio(newBounds, deltaWidth < (deltaHeight = Math.abs(oldBounds.height - newSize.height)));
                CaptureContentPane.this.config.setValue("rendering.renderWindowBounds", String.valueOf(newBounds.x) + ", " + newBounds.y + ", " + newBounds.width + ", " + newBounds.height);
                CaptureContentPane.this.renderPanel.setPreferredSize(new Dimension(newBounds.width, newBounds.height));
                CaptureContentPane.this.buttonPanel.setPreferredSize(new Dimension(newBounds.width, CaptureContentPane.this.buttonPanel.getHeight()));
                CaptureContentPane.this.captureBar.setPreferredSize(new Dimension(newBounds.width, CaptureContentPane.this.captureBar.getHeight()));
                CaptureContentPane.this.exportBar.setPreferredSize(new Dimension(newBounds.width, CaptureContentPane.this.exportBar.getHeight()));
                CaptureContentPane.this.packDialog();
                CaptureContentPane.this.doNotListenToResize = false;
            }
        }
    }

    private class StartMovieCompression
    implements Runnable {
        private StartMovieCompression() {
        }

        @Override
        public void run() {
            MovieWriter writer = new MovieWriter(CaptureContentPane.this.videoHandler.getFramesPerSecond(), String.valueOf(CaptureContentPane.this.exportDirectory) + "/frames/", String.valueOf(CaptureContentPane.this.fileName.getText()) + "_NoSound", String.valueOf(CaptureContentPane.this.exportDirectory) + "/frames/");
            if (writer == null) {
                CaptureContentPane.this.afterEncoding(true);
                return;
            }
            boolean result = CaptureContentPane.this.fileType.getSelectedIndex() == 0 ? writer.writeQuicktime() : writer.writeAVI();
            CaptureContentPane.this.pulsing = false;
            try {
                CaptureContentPane.this.pulse.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            writer = null;
            if (!result) {
                CaptureContentPane.this.statusLabel.setText(Messages.getString("Video_failed_to_encrypt"));
                CaptureContentPane.this.afterEncoding(true);
                return;
            }
            if (CaptureContentPane.this.authoringTool.getSoundStorage() == null) {
                System.err.print(Messages.getString("No_Sound_Storage"));
                CaptureContentPane.this.afterEncoding(true);
                return;
            }
            Merge m = new Merge(CaptureContentPane.this.authoringTool.getSoundStorage().createURL(String.valueOf(CaptureContentPane.this.exportDirectory) + "/" + CaptureContentPane.this.fileName.getText() + ".mov"));
            if (m == null) {
                CaptureContentPane.this.afterEncoding(true);
                return;
            }
            Vector sources = new Vector();
            CaptureContentPane.this.pulsing = true;
            CaptureContentPane.this.pulse = new Thread(new StartStatusPulsing(CaptureContentPane.this.statusLabel, Messages.getString("Encoding_Sound")));
            CaptureContentPane.this.pulse.start();
            if (CaptureContentPane.this.frameSequencer == null) {
                System.err.print(Messages.getString("No_Sequencer"));
                CaptureContentPane.this.afterEncoding(true);
                return;
            }
            sources = CaptureContentPane.this.authoringTool.getSoundStorage().encodeFiles((double)(CaptureContentPane.this.frameSequencer.getFrameNumber() + 1) / 16.0, String.valueOf(CaptureContentPane.this.exportDirectory) + "/frames/" + CaptureContentPane.this.authoringTool.numEncoded);
            CaptureContentPane.this.pulsing = false;
            try {
                CaptureContentPane.this.pulse.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            CaptureContentPane.this.pulsing = true;
            CaptureContentPane.this.pulse = new Thread(new StartStatusPulsing(CaptureContentPane.this.statusLabel, Messages.getString("Merging_Sound_and_Audio")));
            CaptureContentPane.this.pulse.start();
            if (sources == null) {
                CaptureContentPane.this.afterEncoding(true);
                return;
            }
            sources.add(CaptureContentPane.this.authoringTool.getSoundStorage().createURL(String.valueOf(CaptureContentPane.this.exportDirectory) + "/frames/" + CaptureContentPane.this.fileName.getText() + "_NoSound.mov"));
            if (sources.size() > 0) {
                m.doMerge(sources);
            }
            m = null;
            sources.clear();
            sources = null;
            CaptureContentPane.this.pulsing = false;
            try {
                CaptureContentPane.this.pulse.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            CaptureContentPane.this.afterEncoding(false);
        }
    }

    private class StartStatusPulsing
    implements Runnable {
        private JLabel label;
        private String text;

        public StartStatusPulsing(JLabel l, String s) {
            this.label = l;
            this.text = s;
        }

        @Override
        public void run() {
            long time = 300L;
            while (CaptureContentPane.this.pulsing) {
                this.label.setText(String.valueOf(this.text) + ".");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.label.setText(String.valueOf(this.text) + "..");
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class StartTimer
    implements Runnable {
        private JLabel label;
        private int timer = 0;

        public StartTimer(JLabel l) {
            this.label = l;
        }

        @Override
        public void run() {
            DecimalFormat det = new DecimalFormat("00");
            while (CaptureContentPane.this.endCapturing) {
                if (!CaptureContentPane.this.getRunning()) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++this.timer;
                int seconds = this.timer % 60;
                int minutes = this.timer / 60;
                this.label.setText(String.valueOf(minutes) + ":" + det.format(seconds) + "  ");
            }
        }
    }

    protected class TextOutputDocumentListener
    implements DocumentListener {
        protected TextOutputDocumentListener() {
        }

        @Override
        public void insertUpdate(final DocumentEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String textUpdate = ev.getDocument().getText(ev.getOffset(), ev.getLength());
                        ((TextOutputDocumentListener)TextOutputDocumentListener.this).CaptureContentPane.this.detailTextPane.getDocument().insertString(((TextOutputDocumentListener)TextOutputDocumentListener.this).CaptureContentPane.this.detailTextPane.getDocument().getLength(), textUpdate, ((TextOutputDocumentListener)TextOutputDocumentListener.this).CaptureContentPane.this.detailTextPane.stdOutStyle);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    TextOutputDocumentListener.this.update();
                }
            });
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            this.update();
        }

        private void update() {
            if (!CaptureContentPane.this.showStdOut) {
                CaptureContentPane.this.saveRenderBounds();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CaptureContentPane.this.updateGUI();
                        ((TextOutputDocumentListener)TextOutputDocumentListener.this).CaptureContentPane.this.showStdOut = true;
                        Component renderCanvas = CaptureContentPane.this.getRenderCanvas();
                        if (renderCanvas != null) {
                            renderCanvas.requestFocus();
                        }
                    }
                });
            }
        }
    }

    private class WriteFrames
    implements Runnable {
        private int frameNumber;
        String fileLocation;
        private NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        private FrameSequencer myFrameSeq;

        public WriteFrames(String dirPath, FrameSequencer fs, int num) {
            this.fileLocation = fs.getDirectory();
            this.numberFormat.setMinimumIntegerDigits(6);
            this.numberFormat.setGroupingUsed(false);
            this.myFrameSeq = fs;
            this.frameNumber = num;
        }

        @Override
        public void run() {
            while (CaptureContentPane.this.running || this.myFrameSeq.getNumFrames() > 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Picture picture = this.myFrameSeq.removeFrame();
                if (picture == null) continue;
                String fileName = String.valueOf(this.fileLocation) + "frame" + this.numberFormat.format(this.frameNumber) + ".jpg";
                picture.setFileName(fileName);
                picture.write(fileName);
                ++this.frameNumber;
            }
        }
    }
}

