/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.ImagePanel;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class CapturedImageContentPane
extends ContentPane {
    private ImagePanel m_capturedImagePanel = new ImagePanel();
    private JCheckBox m_dontShowCheckBox = new JCheckBox(Messages.getString("don_t_show_this_anymore"));
    private JLabel m_storeLocationLabel = new JLabel(Messages.getString("storeLocation"));
    private JButton m_okButton = new JButton(Messages.getString("OK"));

    public CapturedImageContentPane() {
        this.setLayout(new GridBagLayout());
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CapturedImageContentPane.this.syncConfigWithCheckBox();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.gridheight = 3;
        gbc.gridwidth = -1;
        gbc.insets.left = 8;
        gbc.insets.top = 8;
        this.add((Component)this.m_capturedImagePanel, gbc);
        gbc.insets.right = 8;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        this.add((Component)new JLabel(Messages.getString("Image_captured_to_")), gbc);
        this.add((Component)this.m_storeLocationLabel, gbc);
        gbc.weighty = 1.0;
        this.add((Component)new JLabel(), gbc);
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        this.add((Component)this.m_okButton, gbc);
        gbc.anchor = 16;
        gbc.insets.bottom = 8;
        this.add((Component)this.m_dontShowCheckBox, gbc);
    }

    @Override
    public String getTitle() {
        return Messages.getString("Image_captured_and_stored");
    }

    @Override
    public void preDialogShow(JDialog dialog) {
        super.preDialogShow(dialog);
        this.syncCheckBoxWithConfig();
    }

    public void setStoreLocation(String storeLocation) {
        this.m_storeLocationLabel.setText(storeLocation);
    }

    public void setImage(Image image) {
        this.m_capturedImagePanel.setImage(image);
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.m_okButton.addActionListener(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.m_okButton.removeActionListener(l);
    }

    private void syncCheckBoxWithConfig() {
        Configuration authoringToolConfig = Configuration.getLocalConfiguration(JAlice.class.getPackage());
        this.m_dontShowCheckBox.setSelected(!authoringToolConfig.getValue("screenCapture.informUser").equalsIgnoreCase("true"));
    }

    private void syncConfigWithCheckBox() {
        Configuration authoringToolConfig = Configuration.getLocalConfiguration(JAlice.class.getPackage());
        String s = this.m_dontShowCheckBox.isSelected() ? "false" : "true";
        authoringToolConfig.setValue("screenCapture.informUser", s);
    }
}

