/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.HighlightingGlassPane;
import edu.cmu.cs.stage3.alice.authoringtool.util.ImagePanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.PropertyReferenceListCellRenderer;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.List;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.UserDefinedQuestionProperty;
import edu.cmu.cs.stage3.alice.core.property.UserDefinedResponseProperty;
import edu.cmu.cs.stage3.alice.core.question.PropertyValue;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.reference.ObjectArrayPropertyReference;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.swing.DialogManager;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.criterion.InstanceOfCriterion;
import edu.cmu.cs.stage3.util.criterion.MatchesAnyCriterion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeleteContentPane
extends ContentPane
implements PropertyListener,
ChildrenListener {
    public static final int LESS_DETAIL_MODE = 0;
    public static final int MORE_DETAIL_MODE = 1;
    protected int mode = -1;
    protected static AuthoringTool authoringTool;
    protected ImagePanel errorIconPanel = new ImagePanel();
    protected ElementPopupUtilities.DeleteRunnable deleteRunnable;
    protected HighlightingGlassPane glassPane;
    protected Element danglingElementToClear;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    JButton okayButton = new JButton();
    JButton removeReferenceButton = new JButton();
    JButton removeAllReferenceButton = new JButton();
    JPanel iconPanel = new JPanel();
    JPanel messagePanel = new JPanel();
    JPanel referencesPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    JScrollPane referencesScrollPane = new JScrollPane();
    JTextArea messageArea = new JTextArea();
    Border border1;
    Border border2;
    JButton cancelButton = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JList referencesList = new JList();

    public static void showDeleteDialog(ElementPopupUtilities.DeleteRunnable deleteRunnable, AuthoringTool authoringTool) {
        DeleteContentPane dcp = new DeleteContentPane(authoringTool);
        dcp.setDeleteRunnable(deleteRunnable);
        dcp.refresh();
        if (DialogManager.showDialog(dcp) == 0) {
            deleteRunnable.run();
        }
    }

    public DeleteContentPane(AuthoringTool authoringTool) {
        DeleteContentPane.authoringTool = authoringTool;
        this.jbInit();
        URL errorImageResources = JAlice.class.getResource("images/error.gif");
        this.errorIconPanel.setImage(Toolkit.getDefaultToolkit().createImage(errorImageResources));
        this.iconPanel.add((Component)this.errorIconPanel, "Center");
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setOpaque(false);
        this.referencesList.setCellRenderer(new PropertyReferenceListCellRenderer());
        this.referencesList.addListSelectionListener(new ReferencesSelectionListener());
        this.glassPane = new HighlightingGlassPane(authoringTool);
        this.setPreferredSize(new Dimension(600, 300));
    }

    @Override
    public String getTitle() {
        return Messages.getString("Alice___Can_t_Delete");
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.okayButton.addActionListener(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.okayButton.removeActionListener(l);
    }

    @Override
    public void addCancelActionListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    @Override
    public void removeCancelActionListener(ActionListener l) {
        this.cancelButton.removeActionListener(l);
    }

    @Override
    public void postDialogShow(JDialog dialog) {
        this.glassPane.setHighlightingEnabled(false);
        this.stopListening();
        this.TEMP_checkForListening();
        super.postDialogShow(dialog);
    }

    public void setDeleteRunnable(ElementPopupUtilities.DeleteRunnable deleteRunnable) {
        this.deleteRunnable = deleteRunnable;
    }

    public void TEMP_checkForListening() {
        Element[] elements = authoringTool.getWorld().getDescendants();
        int i = 0;
        while (i < elements.length) {
            ChildrenListener[] childrenListeners = elements[i].getChildrenListeners();
            int j = 0;
            while (j < childrenListeners.length) {
                if (childrenListeners[j] == this) {
                    System.out.println(String.valueOf(Messages.getString("child_listener__")) + elements[i]);
                }
                ++j;
            }
            Property[] properties = elements[i].getProperties();
            int j2 = 0;
            while (j2 < properties.length) {
                PropertyListener[] propertyListeners = properties[j2].getPropertyListeners();
                int k = 0;
                while (k < propertyListeners.length) {
                    if (propertyListeners[k] == this) {
                        System.out.println(String.valueOf(Messages.getString("property_listener__")) + properties[j2]);
                    }
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
    }

    public void startListening() {
        ListModel list = this.referencesList.getModel();
        int i = 0;
        while (i < list.getSize()) {
            if (list.getElementAt(i) instanceof PropertyReference) {
                PropertyReference reference = (PropertyReference)list.getElementAt(i);
                Element source = reference.getProperty().getOwner();
                this.listenUpToRootElement(source);
                if (source instanceof PropertyValue) {
                    Property[] properties = source.getParent().getProperties();
                    int p = 0;
                    while (p < properties.length) {
                        if (properties[p].get() == source) {
                            properties[p].addPropertyListener(this);
                        }
                        ++p;
                    }
                } else if (reference instanceof ObjectArrayPropertyReference) {
                    ObjectArrayPropertyReference oAPR = (ObjectArrayPropertyReference)reference;
                    PropertyReference[] references = oAPR.getReference().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                    if (references != null || references.length > 0) {
                        reference.getProperty().addPropertyListener(this);
                    }
                } else {
                    reference.getProperty().addPropertyListener(this);
                }
            }
            ++i;
        }
    }

    public void stopListening() {
        ListModel list = this.referencesList.getModel();
        int i = 0;
        while (i < list.getSize()) {
            if (list.getElementAt(i) instanceof PropertyReference) {
                PropertyReference reference = (PropertyReference)list.getElementAt(i);
                Element source = reference.getProperty().getOwner();
                this.stopListeningUpToRootElement(source);
                if (source instanceof PropertyValue) {
                    if (source.getParent() != null) {
                        Property[] properties = source.getParent().getProperties();
                        int p = 0;
                        while (p < properties.length) {
                            if (properties[p].get() == source) {
                                properties[p].removePropertyListener(this);
                            }
                            ++p;
                        }
                    }
                } else if (reference instanceof ObjectArrayPropertyReference) {
                    PropertyReference[] references = reference.getProperty().getOwner().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                    if (references != null || references.length > 0) {
                        reference.getProperty().removePropertyListener(this);
                    }
                } else {
                    reference.getProperty().removePropertyListener(this);
                }
            }
            ++i;
        }
    }

    @Override
    public void propertyChanging(PropertyEvent propertyEvent) {
    }

    @Override
    public void propertyChanged(PropertyEvent propertyEvent) {
        this.refresh();
    }

    @Override
    public void childrenChanging(ChildrenEvent childrenEvent) {
        this.danglingElementToClear = childrenEvent.getParent();
    }

    @Override
    public void childrenChanged(ChildrenEvent childrenEvent) {
        this.stopListeningUpToRootElement(this.danglingElementToClear);
        this.refresh();
    }

    protected void listenUpToRootElement(Element current) {
        if (current != null) {
            boolean alreadyChildrenListening = false;
            ChildrenListener[] childrenListeners = current.getChildrenListeners();
            int j = 0;
            while (j < childrenListeners.length) {
                if (childrenListeners[j] == this) {
                    alreadyChildrenListening = true;
                }
                ++j;
            }
            if (!alreadyChildrenListening) {
                current.addChildrenListener(this);
            }
            Property[] properties = current.getProperties();
            int i = 0;
            while (i < properties.length) {
                PropertyListener[] propListeners = properties[i].getPropertyListeners();
                boolean alreadyPropListening = false;
                int j2 = 0;
                while (j2 < propListeners.length) {
                    if (propListeners[j2] == this) {
                        alreadyPropListening = true;
                    }
                    ++j2;
                }
                if (!alreadyPropListening) {
                    properties[i].addPropertyListener(this);
                }
                ++i;
            }
            this.listenUpToRootElement(current.getParent());
        }
    }

    protected void stopListeningUpToRootElement(Element current) {
        if (current != null) {
            boolean alreadyChildrenListening = false;
            ChildrenListener[] childrenListeners = current.getChildrenListeners();
            int j = 0;
            while (j < childrenListeners.length) {
                if (childrenListeners[j] == this) {
                    alreadyChildrenListening = true;
                }
                ++j;
            }
            if (alreadyChildrenListening) {
                current.removeChildrenListener(this);
            }
            Property[] properties = current.getProperties();
            int i = 0;
            while (i < properties.length) {
                PropertyListener[] propListeners = properties[i].getPropertyListeners();
                boolean alreadyPropListening = false;
                int j2 = 0;
                while (j2 < propListeners.length) {
                    if (propListeners[j2] == this) {
                        alreadyPropListening = true;
                    }
                    ++j2;
                }
                if (alreadyPropListening) {
                    properties[i].removePropertyListener(this);
                }
                ++i;
            }
            this.stopListeningUpToRootElement(current.getParent());
        }
    }

    public void refresh() {
        if (this.deleteRunnable != null) {
            Element element = this.deleteRunnable.getElement();
            String elementRepr = AuthoringToolResources.getReprForValue(element);
            PropertyReference[] references = element.getRoot().getPropertyReferencesTo(element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            if (references.length > 0) {
                AuthoringToolResources.garbageCollectIfPossible(references);
                references = element.getRoot().getPropertyReferencesTo(element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            }
            this.stopListening();
            this.referencesList.setListData(references);
            this.startListening();
            if (references.length > 0) {
                this.okayButton.setEnabled(false);
                this.removeReferenceButton.setEnabled(true);
                this.removeAllReferenceButton.setEnabled(true);
                this.messageArea.setText(String.valueOf(elementRepr) + " " + Messages.getString("cannot_be_deleted_because_other_parts_of_the_World_contain_references_to_it__You_will_need_to_remove_these_references_in_order_to_delete_") + elementRepr + ".\n\n" + Messages.getString("Select_each_reference_below__and_either_remove_the_reference_manually__or_click_the_Remove_Reference_button_to_have_the_reference_removed_by_the_system_"));
                this.referencesList.setSelectedIndex(0);
            } else {
                this.okayButton.setEnabled(true);
                this.removeReferenceButton.setEnabled(false);
                this.removeAllReferenceButton.setEnabled(false);
                this.messageArea.setText(String.valueOf(Messages.getString("All_references_have_now_been_deleted___Click_Okay_to_delete_")) + elementRepr + ".");
                this.setDialogTitle(Messages.getString("Alice___Can_Delete"));
            }
        }
    }

    public static String getHighlightID(PropertyReference reference) {
        String highlightID = null;
        if (reference != null) {
            Element sourceParent;
            World world;
            Element source = reference.getProperty().getOwner();
            if (source == (world = authoringTool.getWorld())) {
                highlightID = "details<>:viewController<>:property<" + reference.getProperty().getName() + ">";
            }
            if (highlightID == null && source instanceof Model) {
                highlightID = "details<" + source.getKey(world) + ">:viewController<>:property<" + reference.getProperty().getName() + ">";
            }
            if (highlightID == null && source instanceof Variable) {
                sourceParent = source.getParent();
                if (sourceParent == world) {
                    highlightID = "details<>:viewController<>:variable<" + reference.getProperty().getOwner().getKey(world) + ">";
                } else if (sourceParent instanceof Model) {
                    highlightID = "details<" + sourceParent.getKey(world) + ">:viewController<>:variable<" + reference.getProperty().getOwner().getKey(sourceParent) + ">";
                } else if (sourceParent instanceof CallToUserDefinedResponse || sourceParent instanceof UserDefinedResponse) {
                    Element[] userDefinedResponses = world.getDescendants(UserDefinedResponse.class);
                    int i = 0;
                    while (i < userDefinedResponses.length) {
                        if (userDefinedResponses[i] == sourceParent || userDefinedResponses[i].isAncestorOf(sourceParent)) {
                            highlightID = "editors:element<" + userDefinedResponses[i].getKey(world) + ">:elementTile<" + source.getKey(world) + ">:property<" + reference.getProperty().getName() + ">";
                            break;
                        }
                        ++i;
                    }
                    if (highlightID == null) {
                        Element[] behaviors = world.getDescendants(Behavior.class);
                        int i2 = 0;
                        while (i2 < behaviors.length) {
                            if (behaviors[i2].isAncestorOf(sourceParent)) {
                                highlightID = "behaviors:elementTile<" + source.getKey(world) + ">:property<" + reference.getProperty().getName() + ">";
                                break;
                            }
                            ++i2;
                        }
                    }
                }
            }
            if (highlightID == null && source instanceof Collection && (sourceParent = source.getParent()) instanceof Variable) {
                Element variableParent = sourceParent.getParent();
                if (variableParent == world) {
                    highlightID = "details<>:viewController<>:variable<" + sourceParent.getKey(world) + ">";
                } else if (variableParent instanceof Model) {
                    highlightID = "details<" + variableParent.getKey(world) + ">:viewController<>:variable<" + sourceParent.getKey(variableParent) + ">";
                }
            }
            if (highlightID == null && source instanceof List) {
                sourceParent = source.getParent();
                if (sourceParent == world) {
                    highlightID = "details<>:viewController<>:variable<" + reference.getProperty().getOwner().getKey(world) + ">";
                } else if (sourceParent instanceof Model) {
                    highlightID = "details<" + sourceParent.getKey(world) + ">:viewController<>:variable<" + reference.getProperty().getOwner().getKey(sourceParent) + ">";
                }
            }
            if (highlightID == null) {
                InstanceOfCriterion userDefinedResponsesCriterion = new InstanceOfCriterion(UserDefinedResponse.class);
                InstanceOfCriterion userDefinedQuestionsCriterion = new InstanceOfCriterion(UserDefinedQuestion.class);
                Criterion[] searchCriterion = new Criterion[]{userDefinedResponsesCriterion, userDefinedQuestionsCriterion};
                Element[] userDefinedResponsesAndQuestions = world.search(new MatchesAnyCriterion(searchCriterion));
                Element sourceParent2 = source.getParent();
                int i = 0;
                while (i < userDefinedResponsesAndQuestions.length) {
                    if (userDefinedResponsesAndQuestions[i].isAncestorOf(source)) {
                        highlightID = "editors:element<" + userDefinedResponsesAndQuestions[i].getKey(world) + ">";
                        break;
                    }
                    ++i;
                }
                if (highlightID == null) {
                    Element[] behaviors = world.getDescendants(Behavior.class);
                    int i3 = 0;
                    while (i3 < behaviors.length) {
                        if (behaviors[i3].isAncestorOf(source)) {
                            highlightID = "behaviors";
                            break;
                        }
                        ++i3;
                    }
                }
                if (reference.getProperty() instanceof UserDefinedResponseProperty || reference.getProperty() instanceof UserDefinedQuestionProperty || source instanceof PropertyValue) {
                    Property[] properties = sourceParent2.getProperties();
                    boolean setIt = false;
                    int p = 0;
                    while (p < properties.length) {
                        if (properties[p].get() == source) {
                            highlightID = String.valueOf(highlightID) + ":elementTile<" + sourceParent2.getKey(world) + ">:property<" + properties[p].getName() + ">";
                            setIt = true;
                        }
                        ++p;
                    }
                    if (!setIt) {
                        highlightID = String.valueOf(highlightID) + ":elementTile<" + source.getKey(world) + ">";
                    }
                } else {
                    highlightID = String.valueOf(highlightID) + ":elementTile<" + source.getKey(world) + ">:property<" + reference.getProperty().getName() + ">";
                }
            }
        }
        return highlightID;
    }

    public static ImageIcon getDeleteIcon(PropertyReference reference) {
        String id;
        Image image;
        ImageIcon toReturn = new ImageIcon();
        if (reference != null && (image = authoringTool.getImageForID(id = DeleteContentPane.getHighlightID(reference))) != null) {
            toReturn.setImage(image);
        }
        return toReturn;
    }

    public static String getDeleteString(PropertyReference reference) {
        String highlightID = null;
        if (reference != null) {
            Element sourceParent;
            Element source = reference.getProperty().getOwner();
            World world = authoringTool.getWorld();
            String ourName = reference.getReference().name.getStringValue();
            if (source == world) {
                highlightID = String.valueOf(Messages.getString("The_World_s_")) + reference.getProperty().getName() + " " + Messages.getString("is_set_to_") + ourName;
            }
            if (highlightID == null && source instanceof Model) {
                highlightID = String.valueOf(Messages.getString("The_")) + source.name.getStringValue() + Messages.getString("_s_") + reference.getProperty().getName() + " " + Messages.getString("is_set_to_") + ourName;
            }
            if (highlightID == null && source instanceof Variable) {
                sourceParent = source.getParent();
                if (sourceParent == world) {
                    highlightID = String.valueOf(Messages.getString("The_World_s_variable__")) + reference.getProperty().getOwner().name.getStringValue() + " " + Messages.getString("is_set_to_") + ourName;
                } else if (sourceParent instanceof Model) {
                    highlightID = String.valueOf(Messages.getString("The_")) + sourceParent.name.getStringValue() + Messages.getString("_s_variable__") + reference.getProperty().getOwner().name.getStringValue() + " " + Messages.getString("is_set_to_") + ourName;
                } else if (sourceParent instanceof CallToUserDefinedResponse || sourceParent instanceof UserDefinedResponse) {
                    Element[] userDefinedResponses = world.getDescendants(UserDefinedResponse.class);
                    int i = 0;
                    while (i < userDefinedResponses.length) {
                        if (userDefinedResponses[i] == sourceParent || userDefinedResponses[i].isAncestorOf(sourceParent)) {
                            highlightID = String.valueOf(Messages.getString("The_method__")) + userDefinedResponses[i].getKey() + " " + Messages.getString("contains_") + source.getRepr() + " " + Messages.getString("which_is_set_to_") + ourName;
                            break;
                        }
                        ++i;
                    }
                    if (highlightID == null) {
                        Element[] behaviors = world.getDescendants(Behavior.class);
                        int i2 = 0;
                        while (i2 < behaviors.length) {
                            if (behaviors[i2].isAncestorOf(sourceParent)) {
                                highlightID = String.valueOf(Messages.getString("The_behavior_")) + source.getRepr() + Messages.getString("__property__") + reference.getProperty().getName();
                                break;
                            }
                            ++i2;
                        }
                    }
                }
            }
            if (highlightID == null && source instanceof Collection && (sourceParent = source.getParent()) instanceof Variable) {
                Element variableParent = sourceParent.getParent();
                if (variableParent == world) {
                    highlightID = String.valueOf(Messages.getString("The_World_s_variable__")) + sourceParent.name.getStringValue() + " " + Messages.getString("element_number_") + ((Collection)source).getIndexOfChild(reference.getReference()) + " " + Messages.getString("is_set_to_") + ourName;
                } else if (variableParent instanceof Model) {
                    highlightID = String.valueOf(Messages.getString("The_")) + variableParent.name.getStringValue() + Messages.getString("_s_variable__") + sourceParent.name.getStringValue() + " " + Messages.getString("element_number_") + ((Collection)source).getIndexOfChild(reference.getReference()) + " " + Messages.getString("is_set_to_") + ourName;
                }
            }
            if (highlightID == null) {
                InstanceOfCriterion userDefinedResponsesCriterion = new InstanceOfCriterion(UserDefinedResponse.class);
                InstanceOfCriterion userDefinedQuestionsCriterion = new InstanceOfCriterion(UserDefinedQuestion.class);
                Criterion[] searchCriterion = new Criterion[]{userDefinedResponsesCriterion, userDefinedQuestionsCriterion};
                Element[] userDefinedResponsesAndQuestions = world.search(new MatchesAnyCriterion(searchCriterion));
                Element sourceParent2 = source.getParent();
                int i = 0;
                while (i < userDefinedResponsesAndQuestions.length) {
                    if (userDefinedResponsesAndQuestions[i].isAncestorOf(source)) {
                        highlightID = String.valueOf(Messages.getString("The_method__")) + userDefinedResponsesAndQuestions[i].getKey() + "\"";
                        break;
                    }
                    ++i;
                }
                if (highlightID == null) {
                    Element[] behaviors = world.getDescendants(Behavior.class);
                    int i3 = 0;
                    while (i3 < behaviors.length) {
                        if (behaviors[i3].isAncestorOf(source)) {
                            highlightID = Messages.getString("The_behavior");
                            break;
                        }
                        ++i3;
                    }
                }
                if (reference.getProperty() instanceof UserDefinedResponseProperty || reference.getProperty() instanceof UserDefinedQuestionProperty || source instanceof PropertyValue) {
                    Property[] properties = sourceParent2.getProperties();
                    boolean setIt = false;
                    int p = 0;
                    while (p < properties.length) {
                        if (properties[p].get() == source) {
                            highlightID = String.valueOf(highlightID) + " " + Messages.getString("has_a_line_of_code_") + AuthoringToolResources.getReprForValue(source.getClass()) + " " + Messages.getString("who_s_") + properties[p].getName() + " " + Messages.getString("is_set_to_") + ourName;
                            setIt = true;
                        }
                        ++p;
                    }
                    if (!setIt) {
                        highlightID = String.valueOf(highlightID) + ":elementTile<" + source.getKey(world) + ">";
                    }
                } else {
                    highlightID = String.valueOf(highlightID) + ":elementTile<" + source.getKey(world) + ">:property<" + reference.getProperty().getName() + ">";
                }
            }
        }
        return highlightID;
    }

    void removeReferenceButton_actionPerformed(ActionEvent e) {
        PropertyReference reference = (PropertyReference)this.referencesList.getSelectedValue();
        Element source = reference.getProperty().getOwner();
        Element sourceParent = source.getParent();
        if (reference != null) {
            if (source instanceof CallToUserDefinedResponse || source instanceof CallToUserDefinedQuestion || source instanceof PropertyValue) {
                if (sourceParent instanceof CompositeResponse) {
                    source.removeFromParent();
                } else {
                    Property[] properties = sourceParent.getProperties();
                    int p = 0;
                    while (p < properties.length) {
                        if (properties[p].get() == source) {
                            properties[p].removePropertyListener(this);
                            properties[p].set(AuthoringToolResources.getDefaultValueForClass(properties[p].getValueClass()));
                        }
                        ++p;
                    }
                }
            } else if (reference instanceof ObjectArrayPropertyReference) {
                ObjectArrayPropertyReference oAPR = (ObjectArrayPropertyReference)reference;
                oAPR.getObjectArrayProperty().set(oAPR.getIndex(), (Object)null);
                PropertyReference[] references = oAPR.getProperty().getOwner().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                if (references == null || references.length < 1) {
                    reference.getProperty().removePropertyListener(this);
                }
            } else {
                reference.getProperty().removePropertyListener(this);
                reference.getProperty().set(AuthoringToolResources.getDefaultValueForClass(reference.getProperty().getValueClass()));
            }
            this.refresh();
        }
    }

    void removeAllReferenceButton_actionPerformed(ActionEvent e) {
        this.stopListening();
        int i = 0;
        while (i < this.referencesList.getModel().getSize()) {
            PropertyReference reference = (PropertyReference)this.referencesList.getModel().getElementAt(i);
            Element source = reference.getProperty().getOwner();
            Element sourceParent = source.getParent();
            if (reference != null) {
                if (source instanceof CallToUserDefinedResponse || source instanceof CallToUserDefinedQuestion || source instanceof PropertyValue) {
                    if (sourceParent instanceof CompositeResponse) {
                        source.removeFromParent();
                    } else {
                        Property[] properties = sourceParent.getProperties();
                        int p = 0;
                        while (p < properties.length) {
                            if (properties[p].get() == source) {
                                properties[p].removePropertyListener(this);
                                properties[p].set(AuthoringToolResources.getDefaultValueForClass(properties[p].getValueClass()));
                            }
                            ++p;
                        }
                    }
                } else if (reference instanceof ObjectArrayPropertyReference) {
                    ObjectArrayPropertyReference oAPR = (ObjectArrayPropertyReference)reference;
                    oAPR.getObjectArrayProperty().set(oAPR.getIndex(), (Object)null);
                    PropertyReference[] otherReferences = oAPR.getProperty().getOwner().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                    if (otherReferences == null || otherReferences.length < 1) {
                        reference.getProperty().removePropertyListener(this);
                    }
                } else {
                    reference.getProperty().removePropertyListener(this);
                    reference.getProperty().set(AuthoringToolResources.getDefaultValueForClass(reference.getProperty().getValueClass()));
                }
            }
            ++i;
        }
        this.refresh();
    }

    private void jbInit() {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border2 = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        this.setLayout(this.borderLayout1);
        this.okayButton.setText(Messages.getString("OK"));
        this.removeReferenceButton.setText(Messages.getString("Remove_Reference"));
        this.removeReferenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteContentPane.this.removeReferenceButton_actionPerformed(e);
            }
        });
        this.removeAllReferenceButton.setText(Messages.getString("Remove_All_References"));
        this.removeAllReferenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteContentPane.this.removeAllReferenceButton_actionPerformed(e);
            }
        });
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.iconPanel.setLayout(this.borderLayout2);
        this.messagePanel.setLayout(this.borderLayout3);
        this.referencesPanel.setLayout(this.borderLayout4);
        this.messageArea.setText(Messages.getString("Message_goes_here_"));
        this.mainPanel.setBorder(this.border1);
        this.buttonPanel.setBorder(this.border2);
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.cancelButton.setText(Messages.getString("Cancel"));
        this.referencesList.setSelectionMode(0);
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)this.mainPanel, "Center");
        this.buttonPanel.add((Component)this.okayButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 8, 8, 4), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 8, 0), 0, 0));
        this.buttonPanel.add((Component)this.removeReferenceButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 8, 8), 0, 0));
        this.buttonPanel.add((Component)this.removeAllReferenceButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 8, 8), 0, 0));
        this.mainPanel.add((Component)this.iconPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.mainPanel.add((Component)this.messagePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.messagePanel.add((Component)this.messageArea, "Center");
        this.mainPanel.add((Component)this.referencesPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.referencesPanel.add((Component)this.referencesScrollPane, "Center");
        this.referencesScrollPane.getViewport().add((Component)this.referencesList, null);
    }

    class ReferencesSelectionListener
    implements ListSelectionListener {
        ReferencesSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            String highlightID = null;
            PropertyReference reference = (PropertyReference)DeleteContentPane.this.referencesList.getSelectedValue();
            highlightID = DeleteContentPane.getHighlightID(reference);
            DeleteContentPane.this.glassPane.setHighlightID(highlightID);
            if (highlightID != null) {
                DeleteContentPane.this.glassPane.setHighlightingEnabled(true);
            }
        }
    }
}

