/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File file = null;
    int width = 0;
    int height = 0;
    boolean needUpdating = false;

    public ImagePreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(300, 300));
        this.setFont(new Font("SansSerif", 1, 12));
        fc.addPropertyChangeListener(this);
        this.needUpdating = true;
    }

    public ImagePreview(JFileChooser fc, Image Icon2) {
        this.setPreferredSize(new Dimension(300, 300));
        this.setFont(new Font("SansSerif", 1, 12));
        fc.addPropertyChangeListener(this);
        this.needUpdating = false;
        ImageIcon tmpIcon = new ImageIcon(Icon2);
        this.height = tmpIcon.getIconHeight();
        this.width = tmpIcon.getIconWidth();
        if (tmpIcon != null) {
            this.thumbnail = tmpIcon.getIconWidth() > 200 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(200, -1, 1)) : tmpIcon;
        }
        this.repaint();
    }

    public void loadImage() {
        if (this.file == null) {
            this.thumbnail = null;
            return;
        }
        ImageIcon tmpIcon = new ImageIcon(this.file.getPath());
        this.height = tmpIcon.getIconHeight();
        this.width = tmpIcon.getIconWidth();
        if (tmpIcon != null) {
            this.thumbnail = tmpIcon.getIconWidth() > 200 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(200, -1, 1)) : tmpIcon;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update && this.needUpdating) {
            this.thumbnail = null;
            this.loadImage();
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 60) {
                y = 60;
            }
            this.thumbnail.paintIcon(this, g, x, y);
            g.drawString(String.valueOf(Messages.getString("Dimensions___")) + this.width + " x " + this.height, 50, 30);
        }
    }
}

