/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.GalleryViewer;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.ConfigurationEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.ConfigurationListener;
import edu.cmu.cs.stage3.io.FileUtilities;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PreferencesContentPane
extends ContentPane {
    protected HashMap checkBoxToConfigKeyMap = new HashMap();
    protected AuthoringTool authoringTool;
    private Package authoringToolPackage = Package.getPackage("edu.cmu.cs.stage3.alice.authoringtool");
    protected JFileChooser browseFileChooser = new JFileChooser();
    protected HashMap rendererStringMap = new HashMap();
    protected boolean restartRequired = false;
    protected boolean reloadRequired = false;
    protected boolean shouldListenToRenderBoundsChanges = true;
    protected boolean changedCaptureDirectory = false;
    protected Frame owner;
    private Vector m_okActionListeners = new Vector();
    private final String FOREVER_INTERVAL_STRING = Messages.getString("Forever");
    private final String INFINITE_BACKUPS_STRING = Messages.getString("Infinite");
    private static Configuration authoringToolConfig = Configuration.getLocalConfiguration(JAlice.class.getPackage());
    public final AbstractAction okayAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (PreferencesContentPane.this.validateInput()) {
                PreferencesContentPane.this.fireOKActionListeners();
            }
        }
    };
    public final AbstractAction cancelAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
        }
    };
    public final DocumentListener captureDirectoryChangeListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            PreferencesContentPane.this.changedCaptureDirectory = true;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PreferencesContentPane.this.changedCaptureDirectory = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PreferencesContentPane.this.changedCaptureDirectory = true;
        }
    };
    public final DocumentListener renderDialogBoundsChecker = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (PreferencesContentPane.this.shouldListenToRenderBoundsChanges) {
                PreferencesContentPane.this.checkAndUpdateRenderBounds();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (PreferencesContentPane.this.shouldListenToRenderBoundsChanges) {
                PreferencesContentPane.this.checkAndUpdateRenderBounds();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (PreferencesContentPane.this.shouldListenToRenderBoundsChanges) {
                PreferencesContentPane.this.checkAndUpdateRenderBounds();
            }
        }
    };
    public final DocumentListener renderDialogWidthChecker = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (PreferencesContentPane.this.shouldListenToRenderBoundsChanges) {
                PreferencesContentPane.this.checkAndUpdateRenderWidth();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (PreferencesContentPane.this.shouldListenToRenderBoundsChanges) {
                PreferencesContentPane.this.checkAndUpdateRenderWidth();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (PreferencesContentPane.this.shouldListenToRenderBoundsChanges) {
                PreferencesContentPane.this.checkAndUpdateRenderWidth();
            }
        }
    };
    public final DocumentListener renderDialogHeightChecker = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (PreferencesContentPane.this.shouldListenToRenderBoundsChanges) {
                PreferencesContentPane.this.checkAndUpdateRenderHeight();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (PreferencesContentPane.this.shouldListenToRenderBoundsChanges) {
                PreferencesContentPane.this.checkAndUpdateRenderHeight();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (PreferencesContentPane.this.shouldListenToRenderBoundsChanges) {
                PreferencesContentPane.this.checkAndUpdateRenderHeight();
            }
        }
    };
    JPanel generalPanel = new JPanel();
    JPanel renderingPanel = new JPanel();
    JPanel screenGrabPanel = new JPanel();
    JPanel seldomUsedPanel = new JPanel();
    JPanel directoriesPanel = new JPanel();
    JPanel aseImporterPanel = new JPanel();
    JButton okayButton = new JButton();
    JButton cancelButton = new JButton();
    JCheckBox useBorderlessWindowCheckBox = new JCheckBox();
    JCheckBox infiniteBackupsCheckBox = new JCheckBox();
    JTextField importDirectoryTextField = new JTextField();
    Vector saveIntervalOptions = new Vector();
    Vector backupCountOptions = new Vector();
    Vector fontSizeOptions = new Vector();
    JLabel importDirectoryLabel = new JLabel();
    JButton importDirectoryBrowseButton = new JButton();
    JCheckBox enableScriptingCheckBox = new JCheckBox();
    JCheckBox doProfilingCheckBox = new JCheckBox();
    JCheckBox runtimeScratchPadEnabledCheckBox = new JCheckBox();
    JCheckBox saveAsSingleFileCheckBox = new JCheckBox();
    JCheckBox watcherPanelEnabledCheckBox = new JCheckBox();
    JComboBox saveIntervalComboBox = new JComboBox();
    JTabbedPane configTabbedPane = new JTabbedPane();
    private JTextField maxRecentWorldsTextField = new JTextField();
    private JLabel maxRecentWorldsLabel = new JLabel();
    private JComboBox resourceFileComboBox = new JComboBox();
    private JComboBox languageComboBox = new JComboBox();
    private JComboBox fontSizeComboBox = new JComboBox();
    private JTextField worldDirectoryTextField = new JTextField();
    private JCheckBox forceSoftwareRenderingCheckBox = new JCheckBox();
    private JCheckBox showFPSCheckBox = new JCheckBox();
    private JCheckBox deleteFiles = new JCheckBox();
    private JTextField boundsXTextField = new JTextField();
    private JTextField boundsYTextField = new JTextField();
    private JTextField boundsWidthTextField = new JTextField();
    private JTextField boundsHeightTextField = new JTextField();
    private JCheckBox constrainRenderDialogAspectCheckBox = new JCheckBox();
    private JCheckBox ensureRenderDialogIsOnScreenCheckBox = new JCheckBox();
    private JList rendererList = new JList();
    JTextField captureDirectoryTextField = new JTextField();
    private JTextField baseNameTextField = new JTextField();
    private JComboBox numDigitsComboBox = new JComboBox();
    private JComboBox codecComboBox = new JComboBox();
    private JCheckBox screenCaptureInformUserCheckBox = new JCheckBox();
    private JCheckBox showStartUpDialogCheckBox = new JCheckBox();
    private JCheckBox showWebWarningCheckBox = new JCheckBox();
    private JCheckBox loadSavedTabsCheckBox = new JCheckBox();
    private JCheckBox pickUpTilesCheckBox = new JCheckBox();
    private JCheckBox useAlphaTilesCheckBox = new JCheckBox();
    private JCheckBox saveThumbnailWithWorldCheckBox = new JCheckBox();
    private JCheckBox showWorldStatsCheckBox = new JCheckBox();
    private JCheckBox clearStdOutOnRunCheckBox = new JCheckBox();
    private JCheckBox enableHighContrastCheckBox = new JCheckBox();
    private JCheckBox enableLoggingCheckBox = new JCheckBox();
    private JCheckBox disableTooltipCheckBox = new JCheckBox();
    private JTextField numClipboardsTextField = new JTextField();
    private JComboBox backupCountComboBox = new JComboBox();
    private JCheckBox showBuilderCheckBox = new JCheckBox();
    JCheckBox createNormalsCheckBox = new JCheckBox();
    JCheckBox createUVsCheckBox = new JCheckBox();
    JCheckBox useSpecularCheckBox = new JCheckBox();
    JCheckBox groupMultipleRootObjectsCheckBox = new JCheckBox();
    JCheckBox colorToWhiteWhenTexturedCheckBox = new JCheckBox();

    public PreferencesContentPane() {
        this.setPreferredSize(new Dimension(600, 500));
        this.setMinimumSize(new Dimension(600, 500));
        this.jbInit();
        this.actionInit();
        this.checkBoxMapInit();
        this.miscInit();
        this.updateGUI();
        this.scaleFont(this);
    }

    private void actionInit() {
        this.okayAction.putValue("Name", Messages.getString("OK"));
        this.okayAction.putValue("ShortDescription", Messages.getString("Accept_preference_changes"));
        this.cancelAction.putValue("Name", Messages.getString("Cancel"));
        this.cancelAction.putValue("ShortDescription", Messages.getString("Close_dialog_without_accepting_changes"));
        this.okayButton.setAction(this.okayAction);
        this.cancelButton.setAction(this.cancelAction);
    }

    private void checkBoxMapInit() {
        this.useBorderlessWindowCheckBox.setText(Messages.getString("use_a_borderless_render_window"));
        this.watcherPanelEnabledCheckBox.setText(Messages.getString("show_variable_watcher_when_world_runs"));
        this.runtimeScratchPadEnabledCheckBox.setText(Messages.getString("show_scratch_pad_when_world_runs"));
        this.infiniteBackupsCheckBox.setText(Messages.getString("save_infinite_number_of_backup_scripts"));
        this.doProfilingCheckBox.setText(Messages.getString("profile_world"));
        this.enableScriptingCheckBox.setToolTipText("");
        this.enableScriptingCheckBox.setActionCommand("enable jython scripting");
        this.enableScriptingCheckBox.setText(" " + Messages.getString("enable_jython_scripting"));
        this.saveAsSingleFileCheckBox.setText(Messages.getString("always_save_worlds_as_single_files"));
        this.checkBoxToConfigKeyMap.put(this.showStartUpDialogCheckBox, "showStartUpDialog");
        this.checkBoxToConfigKeyMap.put(this.enableHighContrastCheckBox, "enableHighContrastMode");
        this.checkBoxToConfigKeyMap.put(this.enableLoggingCheckBox, "enableLoggingMode");
        this.checkBoxToConfigKeyMap.put(this.disableTooltipCheckBox, "disableTooltipMode");
        this.checkBoxToConfigKeyMap.put(this.showBuilderCheckBox, "showBuilderMode");
        this.checkBoxToConfigKeyMap.put(this.showWebWarningCheckBox, "showWebWarningDialog");
        this.checkBoxToConfigKeyMap.put(this.loadSavedTabsCheckBox, "loadSavedTabs");
        this.checkBoxToConfigKeyMap.put(this.saveThumbnailWithWorldCheckBox, "saveThumbnailWithWorld");
        this.checkBoxToConfigKeyMap.put(this.forceSoftwareRenderingCheckBox, "rendering.forceSoftwareRendering");
        this.checkBoxToConfigKeyMap.put(this.showFPSCheckBox, "rendering.showFPS");
        this.checkBoxToConfigKeyMap.put(this.deleteFiles, "rendering.deleteFiles");
        this.checkBoxToConfigKeyMap.put(this.useBorderlessWindowCheckBox, "rendering.useBorderlessWindow");
        this.checkBoxToConfigKeyMap.put(this.constrainRenderDialogAspectCheckBox, "rendering.constrainRenderDialogAspectRatio");
        this.checkBoxToConfigKeyMap.put(this.ensureRenderDialogIsOnScreenCheckBox, "rendering.ensureRenderDialogIsOnScreen");
        this.checkBoxToConfigKeyMap.put(this.createNormalsCheckBox, "importers.aseImporter.createNormalsIfNoneExist");
        this.checkBoxToConfigKeyMap.put(this.createUVsCheckBox, "importers.aseImporter.createUVsIfNoneExist");
        this.checkBoxToConfigKeyMap.put(this.useSpecularCheckBox, "importers.aseImporter.useSpecular");
        this.checkBoxToConfigKeyMap.put(this.groupMultipleRootObjectsCheckBox, "importers.aseImporter.groupMultipleRootObjects");
        this.checkBoxToConfigKeyMap.put(this.colorToWhiteWhenTexturedCheckBox, "importers.aseImporter.colorToWhiteWhenTextured");
        this.checkBoxToConfigKeyMap.put(this.watcherPanelEnabledCheckBox, "watcherPanelEnabled");
        this.checkBoxToConfigKeyMap.put(this.runtimeScratchPadEnabledCheckBox, "rendering.runtimeScratchPadEnabled");
        this.checkBoxToConfigKeyMap.put(this.infiniteBackupsCheckBox, "saveInfiniteBackups");
        this.checkBoxToConfigKeyMap.put(this.doProfilingCheckBox, "doProfiling");
        this.checkBoxToConfigKeyMap.put(this.showWorldStatsCheckBox, "showWorldStats");
        this.checkBoxToConfigKeyMap.put(this.enableScriptingCheckBox, "enableScripting");
        this.checkBoxToConfigKeyMap.put(this.pickUpTilesCheckBox, "gui.pickUpTiles");
        this.checkBoxToConfigKeyMap.put(this.useAlphaTilesCheckBox, "gui.useAlphaTiles");
        this.checkBoxToConfigKeyMap.put(this.saveAsSingleFileCheckBox, "useSingleFileLoadStore");
        this.checkBoxToConfigKeyMap.put(this.clearStdOutOnRunCheckBox, "clearStdOutOnRun");
        this.checkBoxToConfigKeyMap.put(this.screenCaptureInformUserCheckBox, "screenCapture.informUser");
    }

    private void miscInit() {
        this.browseFileChooser.setApproveButtonText(Messages.getString("Set_Directory"));
        this.browseFileChooser.setDialogTitle(Messages.getString("Choose_Directory___"));
        this.browseFileChooser.setDialogType(0);
        this.browseFileChooser.setFileSelectionMode(1);
        Configuration.addConfigurationListener(new ConfigurationListener(){

            @Override
            public void changing(ConfigurationEvent ev) {
            }

            @Override
            public void changed(ConfigurationEvent ev) {
                if (ev.getKeyName().endsWith("rendering.orderedRendererList") || ev.getKeyName().endsWith("rendering.forceSoftwareRendering") || ev.getKeyName().endsWith("resourceFile") || ev.getKeyName().endsWith("language") || ev.getKeyName().endsWith("enableScripting") || ev.getKeyName().endsWith("enableLoggingMode")) {
                    PreferencesContentPane.this.restartRequired = true;
                }
            }
        });
    }

    private void scaleFont(Component currentComponent) {
        currentComponent.setFont(new Font("SansSerif", 1, 12));
        if (currentComponent instanceof Container) {
            int i = 0;
            while (i < ((Container)currentComponent).getComponentCount()) {
                this.scaleFont(((Container)currentComponent).getComponent(i));
                ++i;
            }
        }
    }

    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    @Override
    public String getTitle() {
        return Messages.getString("Preferences");
    }

    @Override
    public void preDialogShow(JDialog dialog) {
        super.preDialogShow(dialog);
        this.updateGUI();
        this.changedCaptureDirectory = false;
    }

    @Override
    public void postDialogShow(JDialog dialog) {
        super.postDialogShow(dialog);
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.m_okActionListeners.addElement(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.m_okActionListeners.removeElement(l);
    }

    @Override
    public void addCancelActionListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    @Override
    public void removeCancelActionListener(ActionListener l) {
        this.cancelButton.removeActionListener(l);
    }

    private void fireOKActionListeners() {
        ActionEvent e = new ActionEvent(this, 1001, Messages.getString("OK"));
        int i = 0;
        while (i < this.m_okActionListeners.size()) {
            ActionListener l = (ActionListener)this.m_okActionListeners.elementAt(i);
            l.actionPerformed(e);
            ++i;
        }
    }

    public void finalizeSelections() {
        this.setInput();
        if (this.restartRequired) {
            Object[] options = new Object[]{Messages.getString("Restart"), Messages.getString("Cancel")};
            int result = DialogManager.showOptionDialog(Messages.getString("You_will_have_to_restart_Alice_in_order_for_these_settings_to_take_effect_"), Messages.getString("Restart_Required"), 2, 3, null, options, options[0]);
            this.restartRequired = false;
            if (result == 0) {
                this.authoringTool.quit(true);
            }
        } else if (this.reloadRequired) {
            DialogManager.showMessageDialog(Messages.getString("You_will_have_to_reload_the_current_world_in_order_for_these_settings_to_take_effect_"), Messages.getString("Reload_Required"), 1);
            this.reloadRequired = false;
        }
        if (this.configTabbedPane != null && this.generalPanel != null) {
            this.configTabbedPane.setSelectedComponent(this.generalPanel);
        }
    }

    protected boolean isValidRenderBounds(int x, int y, int w, int h) {
        return x >= 0 && y >= 0 && w > 0 && h > 0;
    }

    protected void checkAndUpdateRenderWidth() {
        int w = 0;
        int h = 0;
        boolean isOK = true;
        try {
            w = Integer.parseInt(this.boundsWidthTextField.getText());
            if (w > 0) {
                this.boundsWidthTextField.setForeground(Color.black);
            } else {
                this.boundsWidthTextField.setForeground(Color.red);
                isOK = false;
            }
        }
        catch (NumberFormatException e) {
            this.boundsWidthTextField.setForeground(Color.red);
            isOK = false;
        }
        try {
            h = Integer.parseInt(this.boundsHeightTextField.getText());
            if (h <= 0) {
                isOK = false;
            }
        }
        catch (NumberFormatException e) {
            isOK = false;
        }
        if (this.constrainRenderDialogAspectCheckBox.isSelected() && isOK && this.authoringTool != null) {
            double currentAspectRatio = this.authoringTool.getAspectRatio();
            h = (int)Math.round((double)w / currentAspectRatio);
            if (h <= 0) {
                h = 1;
            }
            this.shouldListenToRenderBoundsChanges = false;
            this.boundsHeightTextField.setText(Integer.toString(h));
            this.shouldListenToRenderBoundsChanges = true;
        }
        this.okayButton.setEnabled(isOK);
    }

    protected void checkAndUpdateRenderHeight() {
        int w = 0;
        int h = 0;
        boolean isOK = true;
        try {
            h = Integer.parseInt(this.boundsHeightTextField.getText());
            if (h > 0) {
                this.boundsHeightTextField.setForeground(Color.black);
            } else {
                this.boundsHeightTextField.setForeground(Color.red);
                isOK = false;
            }
        }
        catch (NumberFormatException e) {
            this.boundsHeightTextField.setForeground(Color.red);
            isOK = false;
        }
        try {
            w = Integer.parseInt(this.boundsWidthTextField.getText());
            if (w <= 0) {
                isOK = false;
            }
        }
        catch (NumberFormatException e) {
            isOK = false;
        }
        if (this.constrainRenderDialogAspectCheckBox.isSelected() && isOK && this.authoringTool != null) {
            double currentAspectRatio = this.authoringTool.getAspectRatio();
            w = (int)Math.round((double)h * currentAspectRatio);
            if (w <= 0) {
                w = 1;
            }
            this.shouldListenToRenderBoundsChanges = false;
            this.boundsWidthTextField.setText(Integer.toString(w));
            this.shouldListenToRenderBoundsChanges = true;
        }
        this.okayButton.setEnabled(isOK);
    }

    protected void checkAndUpdateRenderBounds() {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        boolean isOK = true;
        try {
            x = Integer.parseInt(this.boundsXTextField.getText());
            if (x >= 0) {
                this.boundsXTextField.setForeground(Color.black);
            } else {
                this.boundsXTextField.setForeground(Color.red);
                isOK = false;
            }
        }
        catch (NumberFormatException e) {
            this.boundsXTextField.setForeground(Color.red);
            isOK = false;
        }
        try {
            y = Integer.parseInt(this.boundsYTextField.getText());
            if (y >= 0) {
                this.boundsYTextField.setForeground(Color.black);
            } else {
                this.boundsYTextField.setForeground(Color.red);
                isOK = false;
            }
        }
        catch (NumberFormatException e) {
            this.boundsYTextField.setForeground(Color.red);
            isOK = false;
        }
        try {
            w = Integer.parseInt(this.boundsWidthTextField.getText());
            if (w > 0) {
                this.boundsWidthTextField.setForeground(Color.black);
            } else {
                this.boundsWidthTextField.setForeground(Color.red);
                isOK = false;
            }
        }
        catch (NumberFormatException e) {
            this.boundsWidthTextField.setForeground(Color.red);
            isOK = false;
        }
        try {
            h = Integer.parseInt(this.boundsHeightTextField.getText());
            if (h > 0) {
                this.boundsHeightTextField.setForeground(Color.black);
            } else {
                this.boundsHeightTextField.setForeground(Color.red);
                isOK = false;
            }
        }
        catch (NumberFormatException e) {
            this.boundsHeightTextField.setForeground(Color.red);
            isOK = false;
        }
        if (this.constrainRenderDialogAspectCheckBox.isSelected() && isOK && this.authoringTool != null) {
            double currentAspectRatio = this.authoringTool.getAspectRatio();
            if (currentAspectRatio > 1.0) {
                w = (int)Math.round((double)h * currentAspectRatio);
                if (w <= 0) {
                    w = 1;
                }
                this.shouldListenToRenderBoundsChanges = false;
                this.boundsWidthTextField.setText(Integer.toString(w));
                this.shouldListenToRenderBoundsChanges = true;
            } else {
                h = (int)Math.round((double)w / currentAspectRatio);
                if (h <= 0) {
                    h = 1;
                }
                this.shouldListenToRenderBoundsChanges = false;
                this.boundsHeightTextField.setText(Integer.toString(h));
                this.shouldListenToRenderBoundsChanges = true;
            }
        }
        this.okayButton.setEnabled(isOK);
    }

    protected boolean validateInput() {
        String backupCountString;
        int result;
        int result2;
        int i;
        try {
            i = Integer.parseInt(this.maxRecentWorldsTextField.getText());
            if (i < 0 || i > 30) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            DialogManager.showMessageDialog(Messages.getString("the_maximum_number_of_recent_worlds_must_be_between_0_and_30"), Messages.getString("Invalid_Clipboard_Number"), 1);
            return false;
        }
        try {
            i = Integer.parseInt(this.numClipboardsTextField.getText());
            if (i < 0 || i > 30) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            DialogManager.showMessageDialog(Messages.getString("the_number_of_clipboards_must_be_between_0_and_30"), Messages.getString("Invalid_Clipboard_Number"), 1);
            return false;
        }
        try {
            int x = Integer.parseInt(this.boundsXTextField.getText());
            int y = Integer.parseInt(this.boundsYTextField.getText());
            int w = Integer.parseInt(this.boundsWidthTextField.getText());
            int h = Integer.parseInt(this.boundsHeightTextField.getText());
            if (!this.isValidRenderBounds(x, y, w, h)) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            DialogManager.showMessageDialog(Messages.getString("all_of_the_render_window_bounds_values_must_be_integers_greater_than_0"), Messages.getString("Bad_Render_Bounds"), 1);
            return false;
        }
        File worldDirectoryFile = new File(this.worldDirectoryTextField.getText());
        if (!(worldDirectoryFile.exists() && worldDirectoryFile.isDirectory() && worldDirectoryFile.canRead() || (result2 = DialogManager.showConfirmDialog(String.valueOf(worldDirectoryFile.getAbsolutePath()) + " " + Messages.getString("is_not_valid___The_worlds_directory_must_be_a_directory_that_exists_and_can_be_read___Would_you_like_to_fix_this_now_"), Messages.getString("Bad_Directory"), 0, 2)) == 1)) {
            return false;
        }
        File importDirectoryFile = new File(this.importDirectoryTextField.getText());
        if (!(importDirectoryFile.exists() && importDirectoryFile.isDirectory() && importDirectoryFile.canRead() || (result = DialogManager.showConfirmDialog(String.valueOf(importDirectoryFile.getAbsolutePath()) + " " + Messages.getString("is_not_valid___The_import_directory_must_be_a_directory_that_exists_and_can_be_read___Would_you_like_to_fix_this_now_"), Messages.getString("Bad_Directory"), 0, 2)) == 1)) {
            return false;
        }
        if (this.changedCaptureDirectory) {
            File captureDirectoryFile = new File(this.captureDirectoryTextField.getText());
            int directoryCheck = FileUtilities.isWritableDirectory(captureDirectoryFile);
            if (directoryCheck == -2) {
                DialogManager.showMessageDialog(Messages.getString("The_capture_directory_specified_can_not_be_written_to__Please_choose_another_directory_"), Messages.getString("Bad_Directory"), 1);
                return false;
            }
            if (directoryCheck == -1 || directoryCheck == -3) {
                DialogManager.showMessageDialog(Messages.getString("The_capture_directory_must_be_a_directory_that_exists_"), Messages.getString("Bad_Directory"), 1);
                return false;
            }
        }
        if (this.baseNameTextField.getText().trim().equals("")) {
            DialogManager.showMessageDialog(Messages.getString("The_capture_base_name_must_not_be_empty_"), Messages.getString("Bad_Base_Name"), 1);
            return false;
        }
        char[] badChars = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
        String baseName = this.baseNameTextField.getText().trim();
        int i2 = 0;
        while (i2 < badChars.length) {
            if (baseName.indexOf(badChars[i2]) != -1) {
                StringBuffer message = new StringBuffer(Messages.getString("Filenames_may_not_contain_the_following_characters_"));
                int j = 0;
                while (j < badChars.length) {
                    message.append(" ");
                    message.append(badChars[j]);
                    ++j;
                }
                DialogManager.showMessageDialog(message.toString(), Messages.getString("Bad_Filename"), 1);
                return false;
            }
            ++i2;
        }
        String saveIntervalString = (String)this.saveIntervalComboBox.getSelectedItem();
        if (!saveIntervalString.equalsIgnoreCase(this.FOREVER_INTERVAL_STRING)) {
            try {
                Integer.parseInt(saveIntervalString);
            }
            catch (Throwable t) {
                DialogManager.showMessageDialog(Messages.getString("You_must_enter_a_valid_number_for_the_time_to_wait_before_prompting_to_save_"), Messages.getString("Bad_Prompt_To_Save_Interval"), 1);
                return false;
            }
        }
        if (!(backupCountString = (String)this.backupCountComboBox.getSelectedItem()).equalsIgnoreCase(this.INFINITE_BACKUPS_STRING)) {
            try {
                Integer.parseInt(backupCountString);
            }
            catch (Throwable t) {
                DialogManager.showMessageDialog(Messages.getString("You_must_enter_a_valid_number_for_the_number_of_backups_you_want_Alice_to_save_"), Messages.getString("Bad_Backup_Count_Value"), 1);
                return false;
            }
        }
        String fontSizeString = (String)this.fontSizeComboBox.getSelectedItem();
        try {
            Integer.parseInt(fontSizeString);
        }
        catch (Throwable t) {
            DialogManager.showMessageDialog(Messages.getString("You_must_enter_a_valid_number_for_the_font_size_"), Messages.getString("Bad_Backup_Font_Size"), 1);
            return false;
        }
        return true;
    }

    protected void setInput() {
        String saveIntervalString;
        boolean oldContrast = Configuration.getValue(this.authoringToolPackage, "enableHighContrastMode").equalsIgnoreCase("true");
        for (JCheckBox checkBox : this.checkBoxToConfigKeyMap.keySet()) {
            String currentValue = Configuration.getValue(this.authoringToolPackage, (String)this.checkBoxToConfigKeyMap.get(checkBox));
            if (currentValue == null) {
                AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Warning__no_value_found_for_preference__")) + this.checkBoxToConfigKeyMap.get(checkBox), null);
                currentValue = "false";
                Configuration.setValue(this.authoringToolPackage, (String)this.checkBoxToConfigKeyMap.get(checkBox), currentValue);
            }
            if (currentValue.equalsIgnoreCase("true") == checkBox.isSelected()) continue;
            Configuration.setValue(this.authoringToolPackage, (String)this.checkBoxToConfigKeyMap.get(checkBox), checkBox.isSelected() ? "true" : "false");
        }
        if (Configuration.getValue(this.authoringToolPackage, "disableTooltipMode").equalsIgnoreCase("true")) {
            ToolTipManager.sharedInstance().setEnabled(false);
        } else {
            ToolTipManager.sharedInstance().setEnabled(true);
        }
        GalleryViewer.showBuilder = Configuration.getValue(this.authoringToolPackage, "showBuilderMode").equalsIgnoreCase("true");
        if (!Configuration.getValue(this.authoringToolPackage, "recentWorlds.maxWorlds").equals(this.maxRecentWorldsTextField.getText())) {
            Configuration.setValue(this.authoringToolPackage, "recentWorlds.maxWorlds", this.maxRecentWorldsTextField.getText());
        }
        if (!Configuration.getValue(this.authoringToolPackage, "numberOfClipboards").equals(this.numClipboardsTextField.getText())) {
            Configuration.setValue(this.authoringToolPackage, "numberOfClipboards", this.numClipboardsTextField.getText());
        }
        String boundsString = String.valueOf(this.boundsXTextField.getText()) + ", " + this.boundsYTextField.getText() + ", " + this.boundsWidthTextField.getText() + ", " + this.boundsHeightTextField.getText();
        if (!Configuration.getValue(this.authoringToolPackage, "rendering.renderWindowBounds").equals(boundsString)) {
            Configuration.setValue(this.authoringToolPackage, "rendering.renderWindowBounds", boundsString);
        }
        if (!Configuration.getValue(this.authoringToolPackage, "directories.worldsDirectory").equals(this.worldDirectoryTextField.getText())) {
            Configuration.setValue(this.authoringToolPackage, "directories.worldsDirectory", this.worldDirectoryTextField.getText());
        }
        if (!Configuration.getValue(this.authoringToolPackage, "directories.importDirectory").equals(this.worldDirectoryTextField.getText())) {
            Configuration.setValue(this.authoringToolPackage, "directories.importDirectory", this.worldDirectoryTextField.getText());
        }
        if (!Configuration.getValue(this.authoringToolPackage, "directories.charactersDirectory").equals(String.valueOf(this.worldDirectoryTextField.getText()) + System.getProperty("file.separator") + "CustomGallery")) {
            Configuration.setValue(this.authoringToolPackage, "directories.charactersDirectory", String.valueOf(this.worldDirectoryTextField.getText()) + System.getProperty("file.separator") + "CustomGallery");
        }
        if (!Configuration.getValue(this.authoringToolPackage, "screenCapture.directory").equals(this.captureDirectoryTextField.getText())) {
            Configuration.setValue(this.authoringToolPackage, "screenCapture.directory", this.captureDirectoryTextField.getText());
        }
        if (!Configuration.getValue(this.authoringToolPackage, "screenCapture.baseName").equals(this.baseNameTextField.getText())) {
            Configuration.setValue(this.authoringToolPackage, "screenCapture.baseName", this.baseNameTextField.getText());
        }
        if (!Configuration.getValue(this.authoringToolPackage, "screenCapture.numDigits").equals((String)this.numDigitsComboBox.getSelectedItem())) {
            Configuration.setValue(this.authoringToolPackage, "screenCapture.numDigits", (String)this.numDigitsComboBox.getSelectedItem());
        }
        if (!Configuration.getValue(this.authoringToolPackage, "screenCapture.codec").equals((String)this.codecComboBox.getSelectedItem())) {
            Configuration.setValue(this.authoringToolPackage, "screenCapture.codec", (String)this.codecComboBox.getSelectedItem());
        }
        if (!Configuration.getValue(this.authoringToolPackage, "resourceFile").equals((String)this.resourceFileComboBox.getSelectedItem())) {
            Configuration.setValue(this.authoringToolPackage, "resourceFile", (String)this.resourceFileComboBox.getSelectedItem());
        }
        if (!Configuration.getValue(this.authoringToolPackage, "language").equals((String)this.languageComboBox.getSelectedItem())) {
            Configuration.setValue(this.authoringToolPackage, "language", (String)this.languageComboBox.getSelectedItem());
            Configuration.setValue(this.authoringToolPackage, "directories.templatesDirectory", "templateWorlds" + System.getProperty("file.separator") + (String)this.languageComboBox.getSelectedItem());
        }
        if ((saveIntervalString = (String)this.saveIntervalComboBox.getSelectedItem()).equalsIgnoreCase(this.FOREVER_INTERVAL_STRING)) {
            Configuration.setValue(this.authoringToolPackage, "promptToSaveInterval", Integer.toString(Integer.MAX_VALUE));
        } else {
            Configuration.setValue(this.authoringToolPackage, "promptToSaveInterval", saveIntervalString);
        }
        String backupCountString = (String)this.backupCountComboBox.getSelectedItem();
        if (saveIntervalString.equalsIgnoreCase(this.FOREVER_INTERVAL_STRING)) {
            Configuration.setValue(this.authoringToolPackage, "maximumWorldBackupCount", Integer.toString(Integer.MAX_VALUE));
        } else {
            Configuration.setValue(this.authoringToolPackage, "maximumWorldBackupCount", backupCountString);
        }
        int oldFontSize = ((Font)UIManager.get("Label.font")).getSize();
        String fontSizeString = (String)this.fontSizeComboBox.getSelectedItem();
        Configuration.setValue(this.authoringToolPackage, "fontSize", fontSizeString);
        int newFontSize = Integer.valueOf(fontSizeString);
        if (oldContrast != this.enableHighContrastCheckBox.isSelected() || oldFontSize != newFontSize) {
            this.restartRequired = true;
        }
        try {
            Configuration.storeConfig();
        }
        catch (IOException e) {
            AuthoringTool.showErrorDialog(Messages.getString("Error_storing_preferences_"), e);
        }
    }

    protected void updateGUI() {
        for (JCheckBox checkBox : this.checkBoxToConfigKeyMap.keySet()) {
            boolean value;
            try {
                value = Configuration.getValue(this.authoringToolPackage, (String)this.checkBoxToConfigKeyMap.get(checkBox)).equalsIgnoreCase("true");
            }
            catch (Exception e) {
                value = false;
            }
            checkBox.setSelected(value);
        }
        this.setSaveIntervalValues();
        this.initSaveIntervalComboBox();
        this.setBackupCountValues();
        this.initBackupCountComboBox();
        this.setFontSizeValues();
        this.initFontSizeComboBox();
        this.maxRecentWorldsTextField.setText(Configuration.getValue(this.authoringToolPackage, "recentWorlds.maxWorlds"));
        this.numClipboardsTextField.setText(Configuration.getValue(this.authoringToolPackage, "numberOfClipboards"));
        String boundsString = Configuration.getValue(this.authoringToolPackage, "rendering.renderWindowBounds");
        StringTokenizer st = new StringTokenizer(boundsString, " \t,");
        if (st.countTokens() == 4) {
            this.boundsXTextField.setText(st.nextToken());
            this.boundsYTextField.setText(st.nextToken());
            this.boundsWidthTextField.setText(st.nextToken());
            this.boundsHeightTextField.setText(st.nextToken());
        }
        String worldDirectory = Configuration.getValue(this.authoringToolPackage, "directories.worldsDirectory");
        this.worldDirectoryTextField.setText(worldDirectory);
        String importDirectory = Configuration.getValue(this.authoringToolPackage, "directories.importDirectory");
        this.importDirectoryTextField.setText(importDirectory);
        String captureDirectory = Configuration.getValue(this.authoringToolPackage, "screenCapture.directory");
        this.captureDirectoryTextField.setText(captureDirectory);
        this.baseNameTextField.setText(Configuration.getValue(this.authoringToolPackage, "screenCapture.baseName"));
        this.numDigitsComboBox.setSelectedItem(Configuration.getValue(this.authoringToolPackage, "screenCapture.numDigits"));
        this.codecComboBox.setSelectedItem(Configuration.getValue(this.authoringToolPackage, "screenCapture.codec"));
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.updateGUI();
        }
        super.setVisible(b);
    }

    private int getValueForString(String numString) {
        if (numString.equalsIgnoreCase(this.FOREVER_INTERVAL_STRING) || numString.equalsIgnoreCase(this.INFINITE_BACKUPS_STRING)) {
            return Integer.MAX_VALUE;
        }
        try {
            int toReturn = Integer.parseInt(numString);
            return toReturn;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private void setSaveIntervalValues() {
        this.saveIntervalOptions.removeAllElements();
        this.saveIntervalOptions.add("15");
        this.saveIntervalOptions.add("30");
        this.saveIntervalOptions.add("45");
        this.saveIntervalOptions.add("60");
        this.saveIntervalOptions.add(this.FOREVER_INTERVAL_STRING);
        String intervalString = Configuration.getValue(this.authoringToolPackage, "promptToSaveInterval");
        int interval = -1;
        try {
            interval = Integer.parseInt(intervalString);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.addComboBoxValueValue(interval, this.saveIntervalOptions);
    }

    private void addComboBoxValueValue(int toAdd, Vector toAddTo) {
        if (toAdd > 0) {
            boolean isThere = false;
            int location = toAddTo.size() - 1;
            int i = 0;
            while (i < toAddTo.size()) {
                int currentValue = this.getValueForString((String)toAddTo.get(i));
                if (toAdd == currentValue) {
                    isThere = true;
                } else if (toAdd < currentValue && location > i) {
                    location = i;
                }
                ++i;
            }
            if (!isThere) {
                Integer currentValue = new Integer(toAdd);
                toAddTo.insertElementAt(currentValue.toString(), location);
            }
        }
    }

    private void initSaveIntervalComboBox() {
        this.saveIntervalComboBox.removeAllItems();
        String intervalString = Configuration.getValue(this.authoringToolPackage, "promptToSaveInterval");
        int i = 0;
        while (i < this.saveIntervalOptions.size()) {
            this.saveIntervalComboBox.addItem(this.saveIntervalOptions.get(i));
            if (intervalString.equalsIgnoreCase(this.saveIntervalOptions.get(i).toString())) {
                this.saveIntervalComboBox.setSelectedIndex(i);
            } else if (intervalString.equalsIgnoreCase(Integer.toString(Integer.MAX_VALUE)) && ((String)this.saveIntervalOptions.get(i)).equalsIgnoreCase(this.FOREVER_INTERVAL_STRING)) {
                this.saveIntervalComboBox.setSelectedIndex(i);
            }
            ++i;
        }
    }

    private void setBackupCountValues() {
        this.backupCountOptions.removeAllElements();
        this.backupCountOptions.add("0");
        this.backupCountOptions.add("1");
        this.backupCountOptions.add("2");
        this.backupCountOptions.add("3");
        this.backupCountOptions.add("4");
        this.backupCountOptions.add("5");
        this.backupCountOptions.add("10");
        this.backupCountOptions.add(this.INFINITE_BACKUPS_STRING);
        String intervalString = Configuration.getValue(this.authoringToolPackage, "maximumWorldBackupCount");
        int interval = -1;
        try {
            interval = Integer.parseInt(intervalString);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.addComboBoxValueValue(interval, this.backupCountOptions);
    }

    private void initBackupCountComboBox() {
        this.backupCountComboBox.removeAllItems();
        String intervalString = Configuration.getValue(this.authoringToolPackage, "maximumWorldBackupCount");
        int i = 0;
        while (i < this.backupCountOptions.size()) {
            this.backupCountComboBox.addItem(this.backupCountOptions.get(i));
            if (intervalString.equalsIgnoreCase(this.backupCountOptions.get(i).toString())) {
                this.backupCountComboBox.setSelectedIndex(i);
            } else if (intervalString.equalsIgnoreCase(Integer.toString(Integer.MAX_VALUE)) && ((String)this.backupCountOptions.get(i)).equalsIgnoreCase(this.INFINITE_BACKUPS_STRING)) {
                this.backupCountComboBox.setSelectedIndex(i);
            }
            ++i;
        }
    }

    private void setFontSizeValues() {
        this.fontSizeOptions.removeAllElements();
        int fontSize = Integer.parseInt(authoringToolConfig.getValue("fontSize"));
        ArrayList<Integer> size = new ArrayList<Integer>();
        size.add(8);
        size.add(10);
        size.add(12);
        size.add(14);
        size.add(16);
        size.add(20);
        if (fontSize != 8 && fontSize != 10 && fontSize != 12 && fontSize != 14 && fontSize != 16 && fontSize != 20) {
            size.add(fontSize);
        }
        Collections.sort(size);
        int i = 0;
        while (i < size.size()) {
            this.fontSizeOptions.add(String.valueOf(size.get(i)));
            ++i;
        }
    }

    private void initFontSizeComboBox() {
        this.fontSizeComboBox.removeAllItems();
        String intervalString = Configuration.getValue(this.authoringToolPackage, "fontSize");
        int i = 0;
        while (i < this.fontSizeOptions.size()) {
            this.fontSizeComboBox.addItem(this.fontSizeOptions.get(i));
            if (intervalString.equalsIgnoreCase(this.fontSizeOptions.get(i).toString())) {
                this.fontSizeComboBox.setSelectedIndex(i);
            }
            ++i;
        }
    }

    void worldDirectoryBrowseButton_actionPerformed(ActionEvent ev) {
        File parent = new File(Configuration.getValue(this.authoringToolPackage, "directories.worldsDirectory"));
        this.browseFileChooser.setCurrentDirectory(parent);
        int returnVal = this.browseFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.browseFileChooser.getSelectedFile();
            this.worldDirectoryTextField.setText(file.getAbsolutePath());
        }
    }

    void importDirectoryBrowseButton_actionPerformed(ActionEvent ev) {
        File parent = new File(Configuration.getValue(this.authoringToolPackage, "directories.importDirectory")).getParentFile();
        this.browseFileChooser.setCurrentDirectory(parent);
        int returnVal = this.browseFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.browseFileChooser.getSelectedFile();
            this.importDirectoryTextField.setText(file.getAbsolutePath());
        }
    }

    void browseButton_actionPerformed(ActionEvent e) {
        boolean done = false;
        String finalFilePath = this.captureDirectoryTextField.getText();
        while (!done) {
            File parent = new File(finalFilePath);
            if (!parent.exists()) {
                parent = new File(Configuration.getValue(this.authoringToolPackage, "screenCapture.directory"));
            }
            this.browseFileChooser.setCurrentDirectory(parent);
            int returnVal = this.browseFileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File captureDirectoryFile = this.browseFileChooser.getSelectedFile();
                int directoryCheck = FileUtilities.isWritableDirectory(captureDirectoryFile);
                if (directoryCheck == -2) {
                    done = false;
                    DialogManager.showMessageDialog(Messages.getString("The_capture_directory_specified_can_not_be_written_to__Please_choose_another_directory_"), Messages.getString("Bad_Directory"), 1);
                    continue;
                }
                if (directoryCheck == -1 || directoryCheck == -3) {
                    done = false;
                    DialogManager.showMessageDialog(Messages.getString("The_capture_directory_must_be_a_directory_that_exists_"), Messages.getString("Bad_Directory"), 1);
                    continue;
                }
                finalFilePath = captureDirectoryFile.getAbsolutePath();
                done = true;
                continue;
            }
            finalFilePath = parent.getAbsolutePath();
            done = true;
        }
        this.captureDirectoryTextField.setText(finalFilePath);
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.okayButton.setText(Messages.getString("Okay"));
        this.cancelButton.setText(Messages.getString("Cancel"));
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.setBorder(emptyBorder);
        this.configTabbedPane.setBackground(new Color(204, 204, 204));
        this.add((Component)this.configTabbedPane, "Center");
        this.GeneralTabInit();
        this.RenderingTabInit();
        this.ScreenGrabTabInit();
        this.SeldomUsedTabInit();
        this.ASEImportTabInit();
        this.generalPanel.setBorder(emptyBorder);
        this.renderingPanel.setBorder(emptyBorder);
        this.screenGrabPanel.setBorder(emptyBorder);
        this.seldomUsedPanel.setBorder(emptyBorder);
        this.configTabbedPane.add((Component)this.generalPanel, Messages.getString("General"));
        this.configTabbedPane.add((Component)this.renderingPanel, Messages.getString("Rendering"));
        this.configTabbedPane.add((Component)this.screenGrabPanel, Messages.getString("Screen_Grab"));
        this.configTabbedPane.add((Component)this.seldomUsedPanel, Messages.getString("Seldom_Used"));
        Box buttonBox = Box.createHorizontalBox();
        Component component1 = Box.createGlue();
        Component component2 = Box.createHorizontalStrut(8);
        Component component3 = Box.createGlue();
        buttonBox.add(component1, null);
        buttonBox.add((Component)this.okayButton, null);
        buttonBox.add(component2, null);
        buttonBox.add((Component)this.cancelButton, null);
        buttonBox.add(component3, null);
        buttonPanel.add((Component)buttonBox, "Center");
        this.add((Component)buttonPanel, "South");
    }

    private void GeneralTabInit() {
        JPanel maxRecentWorldsPanel = new JPanel();
        JPanel resourcesPanel = new JPanel();
        JPanel languagePanel = new JPanel();
        JPanel inputDirectoriesPanel = new JPanel();
        JPanel fontSizePanel = new JPanel();
        this.maxRecentWorldsTextField.setColumns(3);
        this.maxRecentWorldsTextField.setMinimumSize(new Dimension(50, 22));
        this.maxRecentWorldsTextField.setMargin(new Insets(1, 1, 1, 1));
        this.maxRecentWorldsLabel.setText(Messages.getString("maximum_number_of_worlds_kept_in_the_recent_worlds_menu"));
        maxRecentWorldsPanel.setLayout(new GridBagLayout());
        maxRecentWorldsPanel.add((Component)this.maxRecentWorldsTextField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        maxRecentWorldsPanel.add((Component)this.maxRecentWorldsLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        JLabel resourcesLabel = new JLabel();
        resourcesPanel.setLayout(new GridBagLayout());
        resourcesPanel.add((Component)resourcesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        resourcesPanel.add((Component)this.resourceFileComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        resourcesLabel.setText(Messages.getString("display_my_program_"));
        File resourceDirectory = new File(JAlice.getAliceHomeDirectory(), "resources" + System.getProperty("file.separator") + AikMin.locale).getAbsoluteFile();
        File[] resourceFiles = resourceDirectory.listFiles(AuthoringToolResources.resourceFileFilter);
        int i = 0;
        while (i < resourceFiles.length) {
            this.resourceFileComboBox.addItem(resourceFiles[i].getName());
            ++i;
        }
        this.resourceFileComboBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel toReturn = new JLabel(Messages.getString("No_Name"));
                toReturn.setOpaque(true);
                String name = value.toString();
                if (name.equals("Alice Style.py")) {
                    name = Messages.getString("Alice_Style");
                } else if (name.equals("Java Style.py")) {
                    name = Messages.getString("Java_Style_in_Color");
                } else if (name.equals("Java Text Style.py")) {
                    name = Messages.getString("Java_Style_in_Black___White");
                } else {
                    int dotIndex = name.lastIndexOf(".");
                    if (dotIndex > -1) {
                        name = name.substring(0, dotIndex);
                    }
                }
                toReturn.setText(name);
                if (isSelected) {
                    toReturn.setBackground(list.getSelectionBackground());
                    toReturn.setForeground(list.getSelectionForeground());
                } else {
                    toReturn.setBackground(list.getBackground());
                    toReturn.setForeground(list.getForeground());
                }
                return toReturn;
            }
        });
        this.resourceFileComboBox.setSelectedItem(Configuration.getValue(this.authoringToolPackage, "resourceFile"));
        JLabel languageLabel = new JLabel();
        languagePanel.setLayout(new GridBagLayout());
        languagePanel.add((Component)languageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        languagePanel.add((Component)this.languageComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        languageLabel.setText(Messages.getString("display_language_"));
        int i2 = 0;
        while (i2 < AikMin.listOfLanguages.length) {
            this.languageComboBox.addItem(AikMin.listOfLanguages[i2]);
            ++i2;
        }
        this.languageComboBox.setSelectedItem(Configuration.getValue(this.authoringToolPackage, "language"));
        JLabel worldDirectoryLabel = new JLabel();
        JButton worldDirectoryBrowseButton = new JButton();
        this.worldDirectoryTextField.setColumns(15);
        inputDirectoriesPanel.setLayout(new GridBagLayout());
        inputDirectoriesPanel.add((Component)worldDirectoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        inputDirectoriesPanel.add((Component)this.worldDirectoryTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        inputDirectoriesPanel.add((Component)worldDirectoryBrowseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        worldDirectoryLabel.setText(Messages.getString("save_and_load_from_"));
        worldDirectoryBrowseButton.setText(Messages.getString("Browse___"));
        worldDirectoryBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesContentPane.this.worldDirectoryBrowseButton_actionPerformed(e);
            }
        });
        JLabel fontSizeLabel = new JLabel();
        fontSizePanel.setLayout(new GridBagLayout());
        fontSizePanel.add((Component)this.fontSizeComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        fontSizePanel.add((Component)fontSizeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.fontSizeComboBox.setEditable(true);
        this.fontSizeComboBox.setPreferredSize(new Dimension(55, 25));
        this.fontSizeComboBox.setMaximumRowCount(9);
        fontSizeLabel.setText(" " + Messages.getString("general_font_size__default_value_is_12_"));
        Component component = Box.createGlue();
        this.generalPanel.setLayout(new GridBagLayout());
        this.generalPanel.add((Component)maxRecentWorldsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add((Component)resourcesPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add((Component)languagePanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add((Component)inputDirectoriesPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add((Component)fontSizePanel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add(component, new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void RenderingTabInit() {
        JPanel renderWindowBoundsPanel = new JPanel();
        JLabel rendererListLabel = new JLabel();
        JButton rendererMoveUpButton = new JButton();
        JButton rendererMoveDownButton = new JButton();
        this.forceSoftwareRenderingCheckBox.setText(" " + Messages.getString("force_software_rendering__slower_and_safer_"));
        this.showFPSCheckBox.setText(" " + Messages.getString("show_frames_per_second"));
        this.deleteFiles.setText(" " + Messages.getString("delete_frames_folder_after_exporting_video"));
        JLabel renderWindowBoundsLabel = new JLabel();
        JLabel boundsWidthLabel = new JLabel();
        JLabel boundsHeightLabel = new JLabel();
        JLabel boundsXLabel = new JLabel();
        JLabel boundsYLabel = new JLabel();
        renderWindowBoundsLabel.setText(Messages.getString("render_window_position_and_size_"));
        boundsXLabel.setHorizontalAlignment(0);
        boundsXLabel.setText(Messages.getString("horizontal_position_"));
        this.boundsXTextField.setColumns(5);
        this.boundsXTextField.setMinimumSize(new Dimension(61, 22));
        this.boundsXTextField.setMargin(new Insets(1, 1, 1, 1));
        this.boundsXTextField.getDocument().addDocumentListener(this.renderDialogBoundsChecker);
        boundsYLabel.setHorizontalAlignment(0);
        boundsYLabel.setText(" " + Messages.getString("vertical_position_"));
        this.boundsYTextField.setColumns(5);
        this.boundsYTextField.setMinimumSize(new Dimension(61, 22));
        this.boundsYTextField.setMargin(new Insets(1, 1, 1, 1));
        this.boundsYTextField.getDocument().addDocumentListener(this.renderDialogBoundsChecker);
        boundsWidthLabel.setHorizontalAlignment(0);
        boundsWidthLabel.setText(" " + Messages.getString("width_"));
        this.boundsWidthTextField.setColumns(5);
        this.boundsWidthTextField.setMinimumSize(new Dimension(61, 22));
        this.boundsWidthTextField.setMargin(new Insets(1, 1, 1, 1));
        this.boundsWidthTextField.getDocument().addDocumentListener(this.renderDialogWidthChecker);
        boundsHeightLabel.setText(" " + Messages.getString("height_"));
        this.boundsHeightTextField.setColumns(5);
        this.boundsHeightTextField.setMinimumSize(new Dimension(61, 22));
        this.boundsHeightTextField.setMargin(new Insets(1, 1, 1, 1));
        this.boundsHeightTextField.getDocument().addDocumentListener(this.renderDialogHeightChecker);
        renderWindowBoundsPanel.setLayout(new GridBagLayout());
        renderWindowBoundsPanel.add((Component)renderWindowBoundsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 0), 0, 0));
        renderWindowBoundsPanel.add((Component)boundsXLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 5, 3, 0), 0, 0));
        renderWindowBoundsPanel.add((Component)this.boundsXTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 5, 3, 0), 0, 0));
        renderWindowBoundsPanel.add((Component)boundsYLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 5, 3, 0), 0, 0));
        renderWindowBoundsPanel.add((Component)this.boundsYTextField, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 0, new Insets(3, 5, 3, 0), 0, 0));
        renderWindowBoundsPanel.add((Component)boundsWidthLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 5, 3, 0), 0, 0));
        renderWindowBoundsPanel.add((Component)this.boundsWidthTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 5, 3, 0), 0, 0));
        renderWindowBoundsPanel.add((Component)boundsHeightLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 5, 3, 0), 0, 0));
        renderWindowBoundsPanel.add((Component)this.boundsHeightTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 5, 3, 0), 0, 0));
        this.constrainRenderDialogAspectCheckBox.setText(" " + Messages.getString("constrain_render_window_s_aspect_ratio"));
        this.constrainRenderDialogAspectCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PreferencesContentPane.this.checkAndUpdateRenderBounds();
            }
        });
        this.ensureRenderDialogIsOnScreenCheckBox.setText(" " + Messages.getString("make_sure_the_render_window_is_always_on_the_screen"));
        rendererListLabel.setText(Messages.getString("renderer_order__top_item_will_be_tried_first__bottom_item_will_be_tried_last__"));
        this.rendererList.setModel(new ConfigListModel(this.authoringToolPackage, "rendering.orderedRendererList"));
        this.rendererList.setSelectedIndex(0);
        this.rendererList.setBorder(BorderFactory.createLineBorder(Color.black));
        this.rendererList.setSelectionMode(0);
        rendererMoveUpButton.setText(Messages.getString("move_up"));
        rendererMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = PreferencesContentPane.this.rendererList.getSelectedValue();
                ((ConfigListModel)PreferencesContentPane.this.rendererList.getModel()).moveIndexHigher(PreferencesContentPane.this.rendererList.getSelectedIndex());
                PreferencesContentPane.this.rendererList.setSelectedValue(selectedItem, false);
            }
        });
        rendererMoveDownButton.setText(Messages.getString("move_down"));
        rendererMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = PreferencesContentPane.this.rendererList.getSelectedValue();
                ((ConfigListModel)PreferencesContentPane.this.rendererList.getModel()).moveIndexLower(PreferencesContentPane.this.rendererList.getSelectedIndex());
                PreferencesContentPane.this.rendererList.setSelectedValue(selectedItem, false);
            }
        });
        Component component = Box.createGlue();
        this.renderingPanel.setLayout(new GridBagLayout());
        this.renderingPanel.add((Component)this.forceSoftwareRenderingCheckBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.renderingPanel.add((Component)this.showFPSCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.renderingPanel.add((Component)this.deleteFiles, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.renderingPanel.add((Component)renderWindowBoundsPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.renderingPanel.add((Component)this.constrainRenderDialogAspectCheckBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.renderingPanel.add((Component)this.ensureRenderDialogIsOnScreenCheckBox, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.renderingPanel.add((Component)rendererListLabel, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.renderingPanel.add((Component)this.rendererList, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.renderingPanel.add((Component)rendererMoveUpButton, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.renderingPanel.add((Component)rendererMoveDownButton, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.renderingPanel.add(component, new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void ScreenGrabTabInit() {
        JLabel captureDirectory = new JLabel();
        captureDirectory.setText(Messages.getString("directory_to_capture_to_"));
        this.captureDirectoryTextField.getDocument().addDocumentListener(this.captureDirectoryChangeListener);
        this.captureDirectoryTextField.setColumns(15);
        JButton browseButton = new JButton();
        browseButton.setText(Messages.getString("Browse___"));
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesContentPane.this.browseButton_actionPerformed(e);
            }
        });
        JLabel baseNameLabel = new JLabel();
        baseNameLabel.setText(Messages.getString("base_filename_"));
        this.baseNameTextField.setMinimumSize(new Dimension(100, 28));
        this.baseNameTextField.setPreferredSize(new Dimension(100, 28));
        JLabel numDigitsLabel = new JLabel();
        numDigitsLabel.setText(Messages.getString("number_of_digits_to_append_"));
        this.numDigitsComboBox.addItem("1");
        this.numDigitsComboBox.addItem("2");
        this.numDigitsComboBox.addItem("3");
        this.numDigitsComboBox.addItem("4");
        this.numDigitsComboBox.addItem("5");
        this.numDigitsComboBox.addItem("6");
        JLabel codecLabel = new JLabel();
        codecLabel.setText(Messages.getString("image_format_"));
        this.codecComboBox.setPreferredSize(new Dimension(60, 25));
        this.codecComboBox.addItem("jpeg");
        this.codecComboBox.addItem("png");
        this.screenCaptureInformUserCheckBox.setText(" " + Messages.getString("show_information_dialog_when_capture_is_made"));
        JLabel usageLabel = new JLabel();
        usageLabel.setText(Messages.getString("Note__use_Ctrl_G_to_grab_a_frame_while_the_world_is_running_"));
        this.screenGrabPanel.setLayout(new GridBagLayout());
        Component component = Box.createGlue();
        this.screenGrabPanel.add((Component)captureDirectory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.screenGrabPanel.add((Component)this.captureDirectoryTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.screenGrabPanel.add((Component)browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.screenGrabPanel.add((Component)baseNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.screenGrabPanel.add((Component)this.baseNameTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.screenGrabPanel.add((Component)numDigitsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.screenGrabPanel.add((Component)this.numDigitsComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.screenGrabPanel.add((Component)codecLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.screenGrabPanel.add((Component)this.codecComboBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.screenGrabPanel.add((Component)this.screenCaptureInformUserCheckBox, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.screenGrabPanel.add(component, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.screenGrabPanel.add((Component)usageLabel, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 16, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void SeldomUsedTabInit() {
        JPanel saveIntervalPanel = new JPanel();
        JPanel backupCountPanel = new JPanel();
        this.showStartUpDialogCheckBox.setText(" " + Messages.getString("show_startup_dialog_when_Alice_launches"));
        this.showWebWarningCheckBox.setText(" " + Messages.getString("show_warning_when_browsing_the_web_gallery"));
        this.loadSavedTabsCheckBox.setText(" " + Messages.getString("open_tabs_that_were_previously_open_on_world_load"));
        this.pickUpTilesCheckBox.setText(" " + Messages.getString("pick_up_tiles_while_dragging_and_dropping__reduces_performance_"));
        this.useAlphaTilesCheckBox.setText(" " + Messages.getString("use_alpha_blending_in_picked_up_tiles__really_reduces_performance_"));
        this.saveThumbnailWithWorldCheckBox.setText(" " + Messages.getString("save_thumbnail_with_world"));
        this.showWorldStatsCheckBox.setText(" " + Messages.getString("show_world_statistics"));
        this.clearStdOutOnRunCheckBox.setText(" " + Messages.getString("clear_text_output_on_play"));
        this.enableHighContrastCheckBox.setText(" " + Messages.getString("enable_high_contrast_mode_for_projectors"));
        this.enableLoggingCheckBox.setText(" " + Messages.getString("enable_logging"));
        this.disableTooltipCheckBox.setText(" " + Messages.getString("disable_tooltip"));
        this.showBuilderCheckBox.setText(" " + Messages.getString("show_he_she_builder_in_gallery"));
        JLabel numClipboardsLabel = new JLabel();
        this.numClipboardsTextField.setColumns(3);
        this.numClipboardsTextField.setMargin(new Insets(1, 1, 1, 1));
        numClipboardsLabel.setText(Messages.getString("number_of_clipboards"));
        JPanel numClipboardsPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(8);
        numClipboardsPanel.setLayout(borderLayout);
        numClipboardsPanel.add((Component)this.numClipboardsTextField, "West");
        numClipboardsPanel.add((Component)numClipboardsLabel, "Center");
        JLabel saveIntervalLabelEnd = new JLabel();
        this.saveIntervalComboBox.setEditable(true);
        this.saveIntervalComboBox.setPreferredSize(new Dimension(60, 25));
        saveIntervalLabelEnd.setText(" " + Messages.getString("number_of_minutes_to_wait_before_displaying_save_reminder"));
        saveIntervalPanel.setOpaque(false);
        saveIntervalPanel.setBorder(null);
        saveIntervalPanel.add(this.saveIntervalComboBox);
        saveIntervalPanel.add(saveIntervalLabelEnd);
        JLabel backupCountLabel = new JLabel();
        backupCountLabel.setText(" " + Messages.getString("number_of_backups_of_each_world_to_save"));
        this.backupCountComboBox.setEditable(true);
        this.backupCountComboBox.setPreferredSize(new Dimension(60, 25));
        this.backupCountComboBox.setMaximumRowCount(9);
        backupCountPanel.setOpaque(false);
        backupCountPanel.setBorder(null);
        backupCountPanel.add(this.backupCountComboBox);
        backupCountPanel.add(backupCountLabel);
        this.seldomUsedPanel.setLayout(new GridBagLayout());
        this.seldomUsedPanel.add((Component)this.showStartUpDialogCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.showWebWarningCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.loadSavedTabsCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.pickUpTilesCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.useAlphaTilesCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.saveThumbnailWithWorldCheckBox, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.showWorldStatsCheckBox, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.clearStdOutOnRunCheckBox, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.enableHighContrastCheckBox, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.enableLoggingCheckBox, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.enableScriptingCheckBox, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.disableTooltipCheckBox, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)this.showBuilderCheckBox, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)numClipboardsPanel, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.seldomUsedPanel.add((Component)saveIntervalPanel, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add((Component)backupCountPanel, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.seldomUsedPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 16, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (Configuration.getValue(this.authoringToolPackage, "disableTooltipMode").equalsIgnoreCase("true")) {
            ToolTipManager.sharedInstance().setEnabled(false);
        } else {
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    }

    private void ASEImportTabInit() {
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.createNormalsCheckBox.setText(Messages.getString("create_normals_if_none_exist"));
        this.createUVsCheckBox.setText(Messages.getString("create_uv_coordinates_if_none_exist"));
        this.useSpecularCheckBox.setText(Messages.getString("use_specular_information_if_given_in_ASE_file"));
        this.groupMultipleRootObjectsCheckBox.setText(Messages.getString("group_multiple_root_objects"));
        this.colorToWhiteWhenTexturedCheckBox.setText(Messages.getString("set_ambient_and_diffuse_color_to_white_if_object_is_textured"));
        Box aseImporterBox = Box.createVerticalBox();
        aseImporterBox.add((Component)this.createNormalsCheckBox, null);
        aseImporterBox.add((Component)this.createUVsCheckBox, null);
        aseImporterBox.add((Component)this.useSpecularCheckBox, null);
        aseImporterBox.add((Component)this.groupMultipleRootObjectsCheckBox, null);
        aseImporterBox.add((Component)this.colorToWhiteWhenTexturedCheckBox, null);
        this.aseImporterPanel.setLayout(new BorderLayout());
        this.aseImporterPanel.setBorder(emptyBorder);
        this.aseImporterPanel.add((Component)aseImporterBox, "Center");
    }

    protected class ConfigListModel
    implements ListModel,
    ConfigurationListener {
        protected Package configPackage;
        protected String configKey;
        protected Set listenerSet = new HashSet();

        public ConfigListModel(Package configPackage, String configKey) {
            this.configPackage = configPackage;
            this.configKey = configKey;
            Configuration.addConfigurationListener(this);
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
            this.listenerSet.add(listener);
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            this.listenerSet.remove(listener);
        }

        @Override
        public int getSize() {
            return Configuration.getValueList(this.configPackage, this.configKey).length;
        }

        public Object getElementAt(int index) {
            String item = Configuration.getValueList(this.configPackage, this.configKey)[index];
            return AuthoringToolResources.getReprForValue(item);
        }

        public void moveIndexHigher(int index) {
            String[] valueList = Configuration.getValueList(this.configPackage, this.configKey);
            if (index > 0 && index < valueList.length) {
                String[] newValueList = new String[valueList.length];
                System.arraycopy(valueList, 0, newValueList, 0, valueList.length);
                String temp = newValueList[index];
                newValueList[index] = newValueList[index - 1];
                newValueList[index - 1] = temp;
                Configuration.setValueList(this.configPackage, this.configKey, newValueList);
            }
        }

        public void moveIndexLower(int index) {
            String[] valueList = Configuration.getValueList(this.configPackage, this.configKey);
            if (index >= 0 && index < valueList.length - 1) {
                String[] newValueList = new String[valueList.length];
                System.arraycopy(valueList, 0, newValueList, 0, valueList.length);
                String temp = newValueList[index];
                newValueList[index] = newValueList[index + 1];
                newValueList[index + 1] = temp;
                Configuration.setValueList(this.configPackage, this.configKey, newValueList);
            }
        }

        @Override
        public void changing(ConfigurationEvent ev) {
        }

        @Override
        public void changed(ConfigurationEvent ev) {
            if (ev.getKeyName().endsWith("rendering.orderedRendererList")) {
                int upperRange = 0;
                if (ev.getOldValueList() != null) {
                    upperRange = Math.max(upperRange, ev.getOldValueList().length);
                }
                if (ev.getNewValueList() != null) {
                    upperRange = Math.max(upperRange, ev.getNewValueList().length);
                }
                ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, upperRange);
                Iterator iter = this.listenerSet.iterator();
                while (iter.hasNext()) {
                    ((ListDataListener)iter.next()).contentsChanged(listDataEvent);
                }
            }
        }
    }
}

