/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.HighlightingGlassPane;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.SimulationException;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimulationExceptionPanel
extends JPanel {
    private AuthoringTool m_authoringTool;
    private SimulationException m_simulationException;
    private HighlightingGlassPane m_glassPane;
    private JLabel m_descriptionLabel = new JLabel();

    public SimulationExceptionPanel(AuthoringTool authoringTool) {
        this.m_authoringTool = authoringTool;
        this.m_glassPane = new HighlightingGlassPane(authoringTool);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        this.add((Component)new JLabel(Messages.getString("Alice_has_detected_a_problem_with_your_world_")), gbc);
        gbc.insets.left = 8;
        this.add((Component)this.m_descriptionLabel, gbc);
    }

    public void setSimulationException(SimulationException simulationException) {
        this.m_simulationException = simulationException;
        this.m_descriptionLabel.setText(simulationException.getMessage());
        Element element = simulationException.getElement();
        World world = this.m_authoringTool.getWorld();
        Element ancestor = null;
        Element[] userDefinedResponses = world.getDescendants(UserDefinedResponse.class);
        int i = 0;
        while (i < userDefinedResponses.length) {
            if (userDefinedResponses[i].isAncestorOf(element)) {
                ancestor = userDefinedResponses[i];
                break;
            }
            ++i;
        }
        if (ancestor == null) {
            Element[] userDefinedQuestions = world.getDescendants(edu.cmu.cs.stage3.alice.core.question.userdefined.Component.class);
            int i2 = 0;
            while (i2 < userDefinedQuestions.length) {
                if (userDefinedQuestions[i2].isAncestorOf(element)) {
                    ancestor = userDefinedQuestions[i2];
                    break;
                }
                ++i2;
            }
        }
        String highlightID = null;
        if (this.m_simulationException instanceof SimulationPropertyException) {
            SimulationPropertyException spe = (SimulationPropertyException)this.m_simulationException;
            highlightID = "editors:element<" + ancestor.getKey(world) + ">:elementTile<" + element.getKey(world) + ">:property<" + spe.getProperty().getName() + ">";
        }
        if (highlightID == null && element != null && ancestor != null) {
            highlightID = "editors:element<" + ancestor.getKey(world) + ">:elementTile<" + element.getKey(world) + ">";
        }
        this.m_glassPane.setHighlightID(highlightID);
    }

    public void setErrorHighlightingEnabled(boolean enabled) {
        this.m_glassPane.setHighlightingEnabled(enabled);
    }

    public Rectangle getErrorRect() {
        return this.m_glassPane.getHighlightRect();
    }
}

