/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Sound;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.media.DataSource;
import edu.cmu.cs.stage3.media.Manager;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SoundRecorder
extends ContentPane {
    private static byte[] s_wavHeader = new byte[44];
    Capture capture = new Capture();
    Playback playback = new Playback();
    AudioInputStream audioInputStream;
    final int bufSize = 16384;
    private static final int IDLE = 0;
    private static final int RECORDING = 1;
    private static final int PAUSE = 2;
    private static final int RESUME = 3;
    private static final int PLAYING = 4;
    private int m_state = 0;
    private Element m_parentToCheckForNameValidity;
    private Sound m_sound;
    private DataSource m_dataSource;
    private JTextField m_nameTextField;
    private JLabel m_durationLabel;
    private JButton m_recordButton;
    private JButton m_pauseButton;
    private JButton m_playButton;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private Timer m_durationUpdateTimer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SoundRecorder.this.onDurationUpdate();
        }
    });
    private long m_durationT0;
    private File soundDirectory;
    double pauseTime = 0.0;
    long dt = 0L;
    double t = 0.0;
    double totalPauseTime = 0.0;

    static {
        System.arraycopy("RIFF????WAVEfmt ".getBytes(), 0, s_wavHeader, 0, 16);
        SoundRecorder.s_wavHeader[16] = 16;
        SoundRecorder.s_wavHeader[17] = 0;
        SoundRecorder.s_wavHeader[18] = 0;
        SoundRecorder.s_wavHeader[19] = 0;
        SoundRecorder.s_wavHeader[20] = 1;
        SoundRecorder.s_wavHeader[21] = 0;
        SoundRecorder.s_wavHeader[22] = 2;
        SoundRecorder.s_wavHeader[23] = 0;
        SoundRecorder.s_wavHeader[24] = 68;
        SoundRecorder.s_wavHeader[25] = -84;
        SoundRecorder.s_wavHeader[26] = 0;
        SoundRecorder.s_wavHeader[27] = 0;
        SoundRecorder.s_wavHeader[28] = 16;
        SoundRecorder.s_wavHeader[29] = -79;
        SoundRecorder.s_wavHeader[30] = 2;
        SoundRecorder.s_wavHeader[31] = 0;
        SoundRecorder.s_wavHeader[32] = 4;
        SoundRecorder.s_wavHeader[33] = 0;
        SoundRecorder.s_wavHeader[34] = 16;
        SoundRecorder.s_wavHeader[35] = 0;
        System.arraycopy("data????".getBytes(), 0, s_wavHeader, 36, 8);
    }

    public SoundRecorder(File currentWorldLocation) {
        this.soundDirectory = currentWorldLocation;
        this.m_durationLabel = new JLabel();
        this.onDurationUpdate();
        this.m_recordButton = new JButton(Messages.getString("Record"));
        this.m_recordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundRecorder.this.onRecord();
            }
        });
        this.m_pauseButton = new JButton(Messages.getString("Pause"));
        this.m_pauseButton.setEnabled(false);
        this.m_pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundRecorder.this.onPause();
            }
        });
        this.m_playButton = new JButton(Messages.getString("Play"));
        this.m_playButton.setEnabled(false);
        this.m_playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundRecorder.this.onPlay();
            }
        });
        this.m_nameTextField = new JTextField();
        this.m_nameTextField.setText(Messages.getString("unnamedSound"));
        this.m_nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SoundRecorder.this.checkNameForValidity();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SoundRecorder.this.checkNameForValidity();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SoundRecorder.this.checkNameForValidity();
            }
        });
        this.m_okButton = new JButton(Messages.getString("OK"));
        this.m_okButton.setPreferredSize(new Dimension(80, 26));
        this.m_okButton.setEnabled(false);
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundRecorder.this.onOK();
            }
        });
        this.m_cancelButton = new JButton(Messages.getString("Cancel"));
        this.m_cancelButton.setPreferredSize(new Dimension(80, 26));
        this.m_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundRecorder.this.onCancel();
            }
        });
        this.checkNameForValidity();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = -1;
        namePanel.add((Component)new JLabel(Messages.getString("Name__")), gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        namePanel.add((Component)this.m_nameTextField, gbc);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        controlPanel.add((Component)this.m_recordButton, gbc);
        controlPanel.add((Component)this.m_pauseButton, gbc);
        controlPanel.add((Component)this.m_playButton, gbc);
        JPanel okCancelPanel = new JPanel();
        okCancelPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        okCancelPanel.add((Component)new JLabel(), gbc);
        gbc.weightx = 0.0;
        okCancelPanel.add((Component)this.m_okButton, gbc);
        okCancelPanel.add((Component)this.m_cancelButton, gbc);
        int opad = 16;
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets.top = 16;
        gbc.insets.left = 16;
        gbc.insets.right = 16;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)namePanel, gbc);
        gbc.insets.top = 0;
        JLabel spacer1 = new JLabel();
        spacer1.setPreferredSize(new Dimension(480, 16));
        gbc.weighty = 1.0;
        this.add((Component)spacer1, gbc);
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        this.add((Component)this.m_durationLabel, gbc);
        this.add((Component)controlPanel, gbc);
        JLabel spacer2 = new JLabel();
        spacer2.setPreferredSize(new Dimension(480, 16));
        gbc.weighty = 1.0;
        this.add((Component)spacer2, gbc);
        gbc.weighty = 0.0;
        gbc.insets.bottom = 16;
        gbc.anchor = 14;
        this.add((Component)okCancelPanel, gbc);
    }

    @Override
    public void handleDispose() {
        this.onCancel();
        super.handleDispose();
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.m_okButton.addActionListener(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.m_okButton.removeActionListener(l);
    }

    @Override
    public void addCancelActionListener(ActionListener l) {
        this.m_cancelButton.addActionListener(l);
    }

    @Override
    public void removeCancelActionListener(ActionListener l) {
        this.m_cancelButton.removeActionListener(l);
    }

    public Sound getSound() {
        return this.m_sound;
    }

    public void setSound(Sound sound) {
        this.m_sound = sound;
    }

    public Element getParentToCheckForNameValidity() {
        return this.m_parentToCheckForNameValidity;
    }

    public void setParentToCheckForNameValidity(Element parentToCheckForNameValidity) {
        this.m_parentToCheckForNameValidity = parentToCheckForNameValidity;
        this.m_nameTextField.setText(AuthoringToolResources.getNameForNewChild(Messages.getString("unnamedSound"), this.m_parentToCheckForNameValidity));
    }

    private void checkNameForValidity() {
        Color color = Color.black;
        color = Element.isPotentialNameValid(this.m_nameTextField.getText()) ? Color.black : Color.red;
        if (this.m_parentToCheckForNameValidity != null && this.m_parentToCheckForNameValidity.getChildNamedIgnoreCase(this.m_nameTextField.getText()) != null) {
            color = Color.red;
        }
        this.m_nameTextField.setForeground(color);
        this.updateOKButtonEnabled();
    }

    private void updateOKButtonEnabled() {
        this.m_okButton.setEnabled(this.audioInputStream != null && this.m_nameTextField.getForeground().equals(Color.black));
    }

    private String formatTime(double seconds) {
        if (Double.isNaN(seconds)) {
            return "?:??";
        }
        DecimalFormat decFormatter = new DecimalFormat(".000");
        DecimalFormat secMinFormatter1 = new DecimalFormat("00");
        DecimalFormat secMinFormatter2 = new DecimalFormat("#0");
        double secondsFloored = (int)Math.floor(seconds);
        double decimal = seconds - secondsFloored;
        double secs = secondsFloored % 60.0;
        double minutes = (secondsFloored - secs) / 60.0 % 60.0;
        double hours = (secondsFloored - 60.0 * minutes - secs) / 3600.0;
        String timeString = String.valueOf(secMinFormatter1.format(secs)) + decFormatter.format(decimal);
        if (hours > 0.0) {
            timeString = String.valueOf(secMinFormatter1.format(minutes)) + ":" + timeString;
            timeString = String.valueOf(secMinFormatter2.format(hours)) + ":" + timeString;
        } else {
            timeString = String.valueOf(secMinFormatter2.format(minutes)) + ":" + timeString;
        }
        return timeString;
    }

    private void onDurationUpdate() {
        switch (this.m_state) {
            case 1: 
            case 4: {
                this.dt = System.currentTimeMillis() - this.m_durationT0;
                this.t = (double)this.dt * 0.001 - this.totalPauseTime;
                break;
            }
            case 2: {
                this.pauseTime = System.currentTimeMillis() - this.m_durationT0 - this.dt;
                break;
            }
            case 3: {
                this.totalPauseTime += this.pauseTime * 0.001;
                if (this.capture.thread != null) {
                    this.m_state = 1;
                    break;
                }
                if (this.playback.thread == null) break;
                this.m_state = 4;
            }
        }
        this.m_durationLabel.setText(String.valueOf(Messages.getString("Duration__")) + this.formatTime(this.t));
    }

    private void onStop() {
        this.pauseTime = 0.0;
        this.totalPauseTime = 0.0;
        this.m_state = 0;
        this.m_playButton.setText(Messages.getString("Play"));
        this.m_playButton.setEnabled(true);
        this.m_recordButton.setText(Messages.getString("Record"));
        this.m_recordButton.setEnabled(true);
        this.m_pauseButton.setEnabled(false);
        this.m_durationUpdateTimer.stop();
        this.checkNameForValidity();
    }

    private void onRecord() {
        if (this.m_recordButton.getText().startsWith(Messages.getString("Record"))) {
            this.capture.start();
            this.m_playButton.setEnabled(false);
            this.m_pauseButton.setEnabled(true);
            this.m_recordButton.setText(Messages.getString("Stop"));
            this.m_state = 1;
            this.m_durationT0 = System.currentTimeMillis();
            this.m_durationUpdateTimer.start();
        } else {
            this.capture.stop();
        }
    }

    private void onPause() {
        if (this.m_pauseButton.getText().startsWith(Messages.getString("Pause"))) {
            if (this.capture.thread != null) {
                this.capture.line.stop();
                this.m_state = 2;
            } else if (this.playback.thread != null) {
                this.playback.line.stop();
                this.m_state = 2;
            }
            this.m_pauseButton.setText(Messages.getString("Resume"));
        } else {
            if (this.capture.thread != null) {
                this.capture.line.start();
                this.m_state = 3;
            } else if (this.playback.thread != null) {
                this.playback.line.start();
                this.m_state = 3;
            }
            this.m_pauseButton.setText(Messages.getString("Pause"));
        }
    }

    private void onPlay() {
        if (this.m_playButton.getText().startsWith(Messages.getString("Play"))) {
            this.playback.start();
            this.m_recordButton.setEnabled(false);
            this.m_pauseButton.setEnabled(true);
            this.m_playButton.setText(Messages.getString("Stop"));
            this.m_state = 4;
            this.m_durationT0 = System.currentTimeMillis();
            this.m_durationUpdateTimer.start();
        } else {
            this.playback.stop();
        }
    }

    private void onCancel() {
        this.onStop();
        this.setSound(null);
    }

    private void onOK() {
        this.onStop();
        Sound sound = new Sound();
        sound.name.set(this.m_nameTextField.getText());
        sound.dataSource.set(this.m_dataSource);
        this.setSound(sound);
    }

    class Capture
    implements Runnable {
        TargetDataLine line;
        Thread thread;

        Capture() {
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName(Messages.getString("Capture"));
            this.thread.start();
        }

        public void stop() {
            this.thread = null;
        }

        private void shutDown(String message) {
            if (message != null) {
                AuthoringTool.showErrorDialog(message, null);
            }
            if (this.thread != null) {
                this.thread = null;
            }
            SoundRecorder.this.onStop();
        }

        @Override
        public void run() {
            SoundRecorder.this.audioInputStream = null;
            AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, true);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                this.shutDown(String.valueOf(Messages.getString("Line_matching_")) + info + " " + Messages.getString("not_supported_"));
                return;
            }
            try {
                this.line = (TargetDataLine)AudioSystem.getLine(info);
                this.line.open(format, this.line.getBufferSize());
            }
            catch (LineUnavailableException ex) {
                this.shutDown(String.valueOf(Messages.getString("Unable_to_open_the_line__")) + ex);
                return;
            }
            catch (SecurityException ex) {
                this.shutDown(ex.toString());
                return;
            }
            catch (Exception ex) {
                this.shutDown(ex.toString());
                return;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int frameSizeInBytes = format.getFrameSize();
            int bufferLengthInFrames = this.line.getBufferSize() / 8;
            int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
            byte[] data = new byte[bufferLengthInBytes];
            this.line.start();
            while (this.thread != null) {
                int numBytesRead = this.line.read(data, 0, bufferLengthInBytes);
                if (numBytesRead == -1) break;
                out.write(data, 0, numBytesRead);
            }
            this.line.stop();
            this.line.close();
            this.line = null;
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            byte[] audioBytes = out.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(audioBytes);
            SoundRecorder.this.audioInputStream = new AudioInputStream(bais, format, audioBytes.length / frameSizeInBytes);
            try {
                SoundRecorder.this.audioInputStream.reset();
            }
            catch (Exception e) {
                return;
            }
            File file = new File(SoundRecorder.this.soundDirectory + "/" + SoundRecorder.this.m_nameTextField.getText() + ".wav");
            try {
                if (AudioSystem.write(SoundRecorder.this.audioInputStream, AudioFileFormat.Type.WAVE, file) == -1) {
                    throw new IOException(Messages.getString("Problems_writing_to_file"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                SoundRecorder.this.m_dataSource = Manager.createDataSource(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SoundRecorder.this.m_dataSource.waitForRealizedPlayerCount(1, 0L);
            this.shutDown(null);
        }
    }

    public class Playback
    implements Runnable {
        SourceDataLine line;
        Thread thread;

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName(Messages.getString("Playback"));
            this.thread.start();
        }

        public void stop() {
            this.thread = null;
        }

        private void shutDown(String message) {
            if (message != null) {
                AuthoringTool.showErrorDialog(message, null);
            }
            if (this.thread != null) {
                this.thread = null;
            }
            SoundRecorder.this.onStop();
        }

        @Override
        public void run() {
            if (SoundRecorder.this.audioInputStream == null) {
                this.shutDown(Messages.getString("No_loaded_audio_to_play_back"));
                return;
            }
            try {
                SoundRecorder.this.audioInputStream.reset();
            }
            catch (Exception e) {
                this.shutDown(String.valueOf(Messages.getString("Unable_to_reset_the_stream_n")) + e);
                return;
            }
            AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, true);
            AudioInputStream playbackInputStream = AudioSystem.getAudioInputStream(format, SoundRecorder.this.audioInputStream);
            if (playbackInputStream == null) {
                this.shutDown(String.valueOf(Messages.getString("Unable_to_convert_stream_of_format_")) + SoundRecorder.this.audioInputStream + " " + Messages.getString("to_format_") + format);
                return;
            }
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                this.shutDown(String.valueOf(Messages.getString("Line_matching_")) + info + " " + Messages.getString("not_supported_"));
                return;
            }
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(format, 16384);
            }
            catch (LineUnavailableException ex) {
                this.shutDown(String.valueOf(Messages.getString("Unable_to_open_the_line__")) + ex);
                return;
            }
            int frameSizeInBytes = format.getFrameSize();
            int bufferLengthInFrames = this.line.getBufferSize() / 8;
            int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
            byte[] data = new byte[bufferLengthInBytes];
            int numBytesRead = 0;
            this.line.start();
            while (this.thread != null) {
                try {
                    numBytesRead = playbackInputStream.read(data);
                    if (numBytesRead == -1) break;
                    int numBytesRemaining = numBytesRead;
                    while (numBytesRemaining > 0) {
                        numBytesRemaining -= this.line.write(data, 0, numBytesRemaining);
                    }
                }
                catch (Exception e) {
                    this.shutDown(String.valueOf(Messages.getString("Error_during_playback__")) + e);
                    break;
                }
            }
            if (this.thread != null) {
                this.line.drain();
            }
            this.line.stop();
            this.line.close();
            this.line = null;
            this.shutDown(null);
        }
    }
}

