/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.AliceWorldFilter;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.TutorialWorldFilter;
import edu.cmu.cs.stage3.alice.authoringtool.util.AliceTabbedPaneUI;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.awt.DynamicFlowLayout;
import edu.cmu.cs.stage3.image.ImageIO;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StartUpContentPane
extends ContentPane {
    public static final int DO_NOT_CHANGE_TAB_ID = -1;
    public static final int OPEN_TAB_ID = 1;
    public static final int TUTORIAL_TAB_ID = 2;
    public static final int RECENT_TAB_ID = 3;
    public static final int TEMPLATE_TAB_ID = 4;
    public static final int EXAMPLE_TAB_ID = 5;
    public static final int TEXTBOOK_EXAMPLE_TAB_ID = 6;
    private static final String TUTORIAL_STRING = Messages.getString("Tutorial");
    private static final String EXAMPLES_STRING = Messages.getString("Examples");
    private static final String RECENT_STRING = Messages.getString("Recent_Worlds");
    private static final String TEXTBOOK_EXAMPLES_STRING = Messages.getString("Textbook_");
    private static final String OPEN_STRING = Messages.getString("Open_a_world");
    private static final String TEMPLATES_STRING = Messages.getString("Templates");
    private final int WIDTH = 550;
    private final int HEIGHT = 500;
    private static final Color SELECTED_COLOR = new Color(10, 10, 100);
    private static final Color SELECTED_TEXT_COLOR = new Color(255, 255, 255);
    private static final Color BACKGROUND_COLOR = new Color(0, 0, 0);
    private static Configuration authoringToolConfig = Configuration.getLocalConfiguration(JAlice.class.getPackage());
    private AliceWorldFilter aliceFilter;
    private javax.swing.filechooser.FileFilter worldFilter;
    private TutorialWorldFilter tutorialFilter = new TutorialWorldFilter();
    private StartUpIcon currentlySelected;
    private ImageIcon headerImage;
    private ImageIcon basicIcon;
    private ImageIcon directoryIcon;
    private ImageIcon upDirectoryIcon;
    private ImageIcon tutorialButtonIcon;
    private File exampleWorlds = null;
    private File templateWorlds = null;
    private File tutorialWorlds = null;
    private File textbookExampleWorlds = null;
    private JTabbedPane mainTabPane = new JTabbedPane();
    private JScrollPane exampleScrollPane = new JScrollPane(22, 31);
    private JScrollPane textbookExampleScrollPane = new JScrollPane(22, 31);
    private JScrollPane recentScrollPane = new JScrollPane(22, 31);
    private JScrollPane templateScrollPane = new JScrollPane(22, 31);
    private JScrollPane tutorialScrollPane = new JScrollPane(22, 31);
    private JPanel exampleWorldsContainer = new JPanel();
    private JPanel recentWorldsContainer = new JPanel();
    private JPanel textbookExampleWorldsContainer = new JPanel();
    private JPanel templateWorldsContainer = new JPanel();
    private JPanel tutorialWorldsContainer = new JPanel();
    private DynamicFlowLayout examplePanelLayout = new DynamicFlowLayout(0, null, JPanel.class, 20);
    private DynamicFlowLayout recentPanelLayout = new DynamicFlowLayout(0, null, JPanel.class, 20);
    private DynamicFlowLayout templatePanelLayout = new DynamicFlowLayout(0, null, JPanel.class, 20);
    private DynamicFlowLayout tutorialPanelLayout = new DynamicFlowLayout(0, null, JPanel.class, 20);
    private DynamicFlowLayout textbookPanelLayout = new DynamicFlowLayout(0, null, JPanel.class, 20);
    private JPanel exampleWorldsDirectoryContainer = new JPanel();
    private JPanel textbookExampleWorldsDirectoryContainer = new JPanel();
    private JPanel templateWorldsDirectoryContainer = new JPanel();
    private JPanel tutorialWorldsDirectoryContainer = new JPanel();
    private JPanel recentWorldsDirectoryContainer = new JPanel();
    private JLabel exampleWorldsDirLabel = new JLabel();
    private JLabel textbookExampleWorldsDirLabel = new JLabel();
    private JLabel templateWorldsDirLabel = new JLabel();
    private JLabel tutorialWorldsDirLabel = new JLabel();
    private JLabel recentWorldsDirLabel = new JLabel();
    private JButton openButton = new JButton();
    private JButton cancelButton = new JButton();
    private JCheckBox stopShowingCheckBox = new JCheckBox();
    private JLabel headerLabel = new JLabel();
    private JPanel tutorialButtonPanel = new JPanel();
    private JButton startTutorialButton = new JButton();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JFileChooser fileChooser = new JFileChooser(){

        @Override
        public void setSelectedFile(File file) {
            super.setSelectedFile(file);
            StartUpContentPane.this.handleFileSelectionChange(file);
        }
    };
    private JPanel buttonPanel = new JPanel();
    private JLabel jLabel1 = new JLabel();
    protected int currentTab = 2;

    public StartUpContentPane(AuthoringTool authoringTool) {
        JLabel noRecentWorldsLabel;
        String filename;
        this.headerImage = new ImageIcon(JAlice.class.getResource("images/startUpDialog/StartupScreen.png"));
        this.basicIcon = new ImageIcon(JAlice.class.getResource("images/startUpDialog/aliceIcon.png"));
        this.directoryIcon = new ImageIcon(JAlice.class.getResource("images/startUpDialog/directoryIcon.png"));
        this.upDirectoryIcon = new ImageIcon(JAlice.class.getResource("images/startUpDialog/upDirectoryIcon.png"));
        this.tutorialButtonIcon = new ImageIcon(JAlice.class.getResource("images/startUpDialog/tutorialButton.png"));
        String[] recentWorldsStrings = authoringToolConfig.getValueList("recentWorlds.worlds");
        String max = authoringToolConfig.getValue("recentWorlds.maxWorlds");
        int maxRecentWorlds = Integer.parseInt(max);
        if (maxRecentWorlds > 0 && maxRecentWorlds <= recentWorldsStrings.length) {
            String[] cappedRecentWorlds = new String[maxRecentWorlds];
            System.arraycopy(recentWorldsStrings, 0, cappedRecentWorlds, 0, maxRecentWorlds);
            recentWorldsStrings = cappedRecentWorlds;
        }
        if ((filename = authoringToolConfig.getValue("directories.examplesDirectory")) != null) {
            this.exampleWorlds = new File(filename).getAbsoluteFile();
        }
        if ((filename = authoringToolConfig.getValue("directories.templatesDirectory")) != null) {
            this.templateWorlds = new File(filename).getAbsoluteFile();
        }
        if ((filename = authoringToolConfig.getValue("directories.textbookExamplesDirectory")) != null) {
            this.textbookExampleWorlds = new File(filename).getAbsoluteFile();
        }
        this.worldFilter = authoringTool.getWorldFileFilter();
        this.aliceFilter = new AliceWorldFilter(this.worldFilter);
        this.jbInit();
        this.guiInit();
        int count = 0;
        int fontSize = Integer.parseInt(authoringToolConfig.getValue("fontSize"));
        String font = "SansSerif";
        this.tutorialWorlds = authoringTool.getTutorialDirectory();
        count = this.buildPanel(this.tutorialWorldsContainer, this.buildVectorFromDirectory(this.tutorialWorlds, this.tutorialFilter), false, null, 2);
        if (count <= 0) {
            this.tutorialWorldsDirectoryContainer.removeAll();
            JLabel noTutorialWorldsLabel = new JLabel();
            noTutorialWorldsLabel.setText(Messages.getString("No_tutorial_found_"));
            noTutorialWorldsLabel.setFont(new Font(font, 1, (int)((double)(18 * fontSize) / 12.0)));
            this.tutorialWorldsDirectoryContainer.add(noTutorialWorldsLabel);
        }
        if ((count = this.buildPanel(this.exampleWorldsContainer, this.buildVectorFromDirectory(this.exampleWorlds, this.aliceFilter), false, null, 1)) <= 0) {
            this.exampleWorldsDirectoryContainer.removeAll();
            JLabel noExampleWorldsLabel = new JLabel();
            noExampleWorldsLabel.setText(Messages.getString("No_example_worlds_"));
            noExampleWorldsLabel.setFont(new Font(font, 1, (int)((double)(18 * fontSize) / 12.0)));
            this.exampleWorldsDirectoryContainer.add(noExampleWorldsLabel);
        }
        if ((count = this.buildPanel(this.templateWorldsContainer, this.buildVectorFromDirectory(this.templateWorlds, this.aliceFilter), false, null, 1)) <= 0) {
            this.templateWorldsDirectoryContainer.removeAll();
            JLabel noTemplateWorldsLabel = new JLabel();
            noTemplateWorldsLabel.setText(Messages.getString("No_templates_"));
            noTemplateWorldsLabel.setFont(new Font(font, 1, (int)((double)(18 * fontSize) / 12.0)));
            this.templateWorldsDirectoryContainer.add(noTemplateWorldsLabel);
        }
        if ((count = this.buildPanel(this.recentWorldsContainer, this.buildVectorFromString(recentWorldsStrings), true, null, 1)) <= 0) {
            this.recentWorldsDirectoryContainer.removeAll();
            noRecentWorldsLabel = new JLabel();
            noRecentWorldsLabel.setText(Messages.getString("No_recent_worlds_"));
            noRecentWorldsLabel.setFont(new Font(font, 1, (int)((double)(18 * fontSize) / 12.0)));
            this.recentWorldsDirectoryContainer.add(noRecentWorldsLabel);
        }
        if ((count = this.buildPanel(this.textbookExampleWorldsContainer, this.buildVectorFromDirectory(this.textbookExampleWorlds, this.aliceFilter), false, null, 1)) <= 0) {
            this.textbookExampleWorldsDirectoryContainer.removeAll();
            noRecentWorldsLabel = new JLabel();
            noRecentWorldsLabel.setText(Messages.getString("No_textbook_worlds_"));
            noRecentWorldsLabel.setFont(new Font(font, 1, (int)((double)(18 * fontSize) / 12.0)));
            this.textbookExampleWorldsDirectoryContainer.add(noRecentWorldsLabel);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StartUpContentPane.this.matchSizes();
            }
        });
        this.tutorialPanelLayout.setHgap(35);
        this.tutorialPanelLayout.setVgap(10);
        this.examplePanelLayout.setHgap(35);
        this.examplePanelLayout.setVgap(10);
        this.recentPanelLayout.setHgap(35);
        this.recentPanelLayout.setVgap(10);
        this.templatePanelLayout.setHgap(35);
        this.templatePanelLayout.setVgap(10);
        this.textbookPanelLayout.setHgap(35);
        this.textbookPanelLayout.setVgap(10);
    }

    @Override
    public void preDialogShow(JDialog dialog) {
        super.preDialogShow(dialog);
        this.mainTabPane.setSelectedComponent(this.getTabForID(this.currentTab));
    }

    private void handleFileSelectionChange(File file) {
        this.openButton.setEnabled(file != null && file.exists() && !file.isDirectory());
    }

    @Override
    public String getTitle() {
        return Messages.getString("Welcome_to_Alice__");
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.openButton.addActionListener(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.openButton.removeActionListener(l);
    }

    @Override
    public void addCancelActionListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    @Override
    public void removeCancelActionListener(ActionListener l) {
        this.cancelButton.removeActionListener(l);
    }

    public boolean isTutorial() {
        if (this.currentlySelected != null) {
            return this.currentlySelected.type == 2;
        }
        return this.getTabID() == 2;
    }

    public boolean isSaveNeeded() {
        if (this.currentlySelected != null) {
            return this.currentlySelected.needToSave;
        }
        return true;
    }

    public File getFile() {
        if (this.getTabID() == 1) {
            return this.fileChooser.getSelectedFile();
        }
        if (this.currentlySelected != null) {
            return new File(this.currentlySelected.file);
        }
        return null;
    }

    private int getIDForTab(Component tab) {
        if (tab == this.fileChooser) {
            return 1;
        }
        if (tab == this.tutorialWorldsDirectoryContainer) {
            return 2;
        }
        if (tab == this.recentWorldsDirectoryContainer) {
            return 3;
        }
        if (tab == this.exampleWorldsDirectoryContainer) {
            return 5;
        }
        if (tab == this.textbookExampleWorldsDirectoryContainer) {
            return 6;
        }
        if (tab == this.templateWorldsDirectoryContainer) {
            return 4;
        }
        return 0;
    }

    private Component getTabForID(int tabID) {
        switch (tabID) {
            case 1: {
                return this.fileChooser;
            }
            case 2: {
                return this.tutorialWorldsDirectoryContainer;
            }
            case 3: {
                return this.recentWorldsDirectoryContainer;
            }
            case 5: {
                return this.exampleWorldsDirectoryContainer;
            }
            case 4: {
                return this.templateWorldsDirectoryContainer;
            }
            case 6: {
                return this.textbookExampleWorldsDirectoryContainer;
            }
        }
        return this.tutorialWorldsDirectoryContainer;
    }

    private int getTabID() {
        return this.getIDForTab(this.mainTabPane.getSelectedComponent());
    }

    public void setTabID(int tabID) {
        File currentDir;
        if (tabID == 1 && (currentDir = new File(authoringToolConfig.getValue("directories.worldsDirectory"))).exists()) {
            this.fileChooser.setCurrentDirectory(currentDir);
        }
        if (tabID != -1) {
            this.currentTab = tabID;
            this.mainTabPane.setSelectedComponent(this.getTabForID(this.currentTab));
        }
    }

    private String makeNameFromFilename(String filename) {
        String name = filename.substring(0, filename.length() - 4);
        int last = name.lastIndexOf(File.separator);
        if (last >= 0 && last < name.length()) {
            name = name.substring(last + 1);
        }
        return name;
    }

    private String makeDirectoryNameFromFilename(String filename) {
        int last;
        String name = new String(filename);
        if (filename.endsWith(File.separator)) {
            filename = filename.substring(filename.length());
        }
        if ((last = filename.lastIndexOf(File.separator)) >= 0 && last < filename.length()) {
            name = filename.substring(last + 1);
        }
        return name;
    }

    private Vector buildVectorFromString(String[] files) {
        Vector<StringObjectPair> toReturn = new Vector<StringObjectPair>();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                String name = this.makeNameFromFilename(files[i]);
                StringObjectPair sop = new StringObjectPair(name, files[i]);
                toReturn.add(sop);
                ++i;
            }
        }
        return toReturn;
    }

    private Vector buildVectorFromDirectory(File dir, FileFilter f) {
        Vector<StringObjectPair> toReturn = null;
        if (dir != null && dir.isDirectory()) {
            toReturn = new Vector<StringObjectPair>();
            File[] files = dir.listFiles(f);
            int i = 0;
            while (i < files.length) {
                String name = "";
                name = files[i].isDirectory() ? this.makeDirectoryNameFromFilename(files[i].getName()) : this.makeNameFromFilename(files[i].getName());
                StringObjectPair sop = new StringObjectPair(Messages.getString(name), files[i].getAbsolutePath());
                toReturn.add(sop);
                ++i;
            }
        }
        return toReturn;
    }

    private ImageIcon getIconFromFile(File file) {
        String filename = file.getAbsolutePath();
        ImageIcon icon = null;
        try {
            InputStream stream;
            Image image;
            ZipFile zip;
            ZipEntry entry;
            Node n;
            DocumentBuilderFactory factory;
            DocumentBuilder builder;
            Document document;
            NodeList nl;
            if (filename.endsWith(".stl") && (nl = (document = (builder = (factory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(file)).getElementsByTagName("stencilStack")) != null && nl.getLength() > 0 && (n = nl.item(0)) instanceof Element) {
                String worldFileName = ((Element)n).getAttribute("world");
                file = new File(worldFileName);
            }
            if ((entry = (zip = new ZipFile(file)).getEntry("thumbnail.png")) != null && (image = ImageIO.load("png", stream = zip.getInputStream(entry))) != null) {
                icon = new ImageIcon(image);
            }
            zip.close();
        }
        catch (Exception e) {
            return null;
        }
        return icon;
    }

    protected Component getTopContainer(Component innerContainer) {
        if (innerContainer == this.tutorialWorldsContainer) {
            return this.tutorialWorldsDirectoryContainer;
        }
        if (innerContainer == this.exampleWorldsContainer) {
            return this.exampleScrollPane;
        }
        if (innerContainer == this.templateWorldsContainer) {
            return this.templateScrollPane;
        }
        if (innerContainer == this.textbookExampleWorldsContainer) {
            return this.textbookExampleScrollPane;
        }
        return null;
    }

    protected String getBaseDirString(Component topLevelOwner) {
        if (topLevelOwner == this.tutorialWorldsDirectoryContainer) {
            return TUTORIAL_STRING;
        }
        if (topLevelOwner == this.exampleScrollPane) {
            return EXAMPLES_STRING;
        }
        if (topLevelOwner == this.templateScrollPane) {
            return TEMPLATES_STRING;
        }
        if (topLevelOwner == this.textbookExampleScrollPane) {
            return TEXTBOOK_EXAMPLES_STRING;
        }
        return "";
    }

    private int buildPanel(JPanel toBuild, Vector toAdd, boolean needToSave, File parentDir, int type) {
        int count = 0;
        if (parentDir != null || toAdd != null) {
            toBuild.removeAll();
        }
        if (parentDir != null && parentDir.getName().compareToIgnoreCase("Required") != 0) {
            String parentDirName = Messages.getString("Back");
            StartUpIcon parentDirIcon = new StartUpIcon(parentDirName, this.upDirectoryIcon, parentDir.getAbsolutePath(), false, 3, this.getTopContainer(toBuild));
            toBuild.add(parentDirIcon);
            ++count;
        }
        if (toAdd != null) {
            int i = 0;
            while (i < toAdd.size()) {
                StringObjectPair sop = (StringObjectPair)toAdd.get(i);
                String name = sop.getString();
                String filename = (String)sop.getObject();
                File file = new File(filename);
                ImageIcon icon = this.basicIcon;
                if (file.exists() && file.canRead()) {
                    filename = file.getAbsolutePath();
                    if (file.isDirectory()) {
                        StartUpIcon dirIcon = new StartUpIcon(name, this.directoryIcon, filename, false, 3, this.getTopContainer(toBuild));
                        toBuild.add(dirIcon);
                        ++count;
                    } else {
                        boolean worldIsThere = true;
                        if (file.exists() && file.canRead()) {
                            icon = this.getIconFromFile(file);
                            if (icon == null) {
                                icon = this.basicIcon;
                            }
                        } else {
                            worldIsThere = false;
                        }
                        if (worldIsThere) {
                            StartUpIcon sui = new StartUpIcon(name, icon, filename, needToSave, type, this.getTopContainer(toBuild));
                            toBuild.add(sui);
                            ++count;
                        }
                    }
                }
                ++i;
            }
        }
        toBuild.revalidate();
        return count;
    }

    private void initializeFileChooser() {
        AikMin.setFontSize(12);
        this.fileChooser = new JFileChooser(){

            @Override
            public void setSelectedFile(File file) {
                super.setSelectedFile(file);
                StartUpContentPane.this.handleFileSelectionChange(file);
            }
        };
        int i = 0;
        while (i < this.fileChooser.getComponentCount()) {
            this.setButtonBackgroundColors(this.fileChooser.getComponent(i), this.fileChooser.getBackground());
            ++i;
        }
        File currentDir = new File(authoringToolConfig.getValue("directories.worldsDirectory"));
        if (currentDir.exists()) {
            this.fileChooser.setCurrentDirectory(currentDir);
        }
        this.fileChooser.setFileFilter(this.worldFilter);
        this.fileChooser.setBackground(Color.white);
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpContentPane.this.fileChooser_actionPerformed(e);
            }
        });
        this.fileChooser.setFileSelectionMode(0);
        this.mainTabPane.add((Component)this.fileChooser, "<html><body leftmargin=5 marginwidth=5>" + OPEN_STRING + "</body></html>");
        try {
            AikMin.setFontSize(Integer.parseInt(authoringToolConfig.getValue("fontSize")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void guiInit() {
        int fontSize = Integer.parseInt(authoringToolConfig.getValue("fontSize"));
        if (fontSize > 12) {
            this.setPreferredSize(new Dimension(550, 500 + fontSize * 3));
        } else {
            this.setPreferredSize(new Dimension(550, 500));
        }
        this.headerLabel.setIcon(this.headerImage);
        this.startTutorialButton.setIcon(this.tutorialButtonIcon);
        this.startTutorialButton.setCursor(new Cursor(12));
        this.exampleWorldsContainer.setBorder(null);
        this.tutorialWorldsContainer.setBorder(null);
        this.recentWorldsContainer.setBorder(null);
        this.templateWorldsContainer.setBorder(null);
        this.textbookExampleWorldsContainer.setBorder(null);
        authoringToolConfig.getValue("showStartUpDialog");
        this.stopShowingCheckBox.setSelected(authoringToolConfig.getValue("showStartUpDialog").equalsIgnoreCase("true"));
        this.mainTabPane.setUI(new AliceTabbedPaneUI());
        this.mainTabPane.setOpaque(false);
        this.initializeFileChooser();
        int selectedTab = Integer.parseInt(authoringToolConfig.getValue("showStartUpDialog_OpenTab"));
        this.setTabID(selectedTab);
    }

    private void setButtonBackgroundColors(Component c, Color color) {
        if (!(c instanceof Button)) {
            c.setBackground(color);
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int i = 0;
            while (i < cont.getComponentCount()) {
                this.setButtonBackgroundColors(cont.getComponent(i), color);
                ++i;
            }
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        Component component2 = Box.createGlue();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.mainTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StartUpContentPane.this.mainTabPane_stateChanged(e);
            }
        });
        this.buttonPanel.setOpaque(false);
        int fontSize = Integer.parseInt(authoringToolConfig.getValue("fontSize"));
        this.openButton.setMinimumSize(new Dimension(fontSize * 8, fontSize * 2 + 5));
        this.openButton.setPreferredSize(new Dimension(fontSize * 8, fontSize * 2 + 5));
        this.openButton.setText(Messages.getString("Open"));
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                authoringToolConfig.setValue("showStartUpDialog_OpenTab", Integer.toString(StartUpContentPane.this.getIDForTab(StartUpContentPane.this.mainTabPane.getSelectedComponent())));
            }
        });
        this.cancelButton.setMinimumSize(new Dimension(fontSize * 8, fontSize * 2 + 5));
        this.cancelButton.setPreferredSize(new Dimension(fontSize * 8, fontSize * 2 + 5));
        this.cancelButton.setText(Messages.getString("Cancel"));
        this.stopShowingCheckBox.setOpaque(false);
        this.stopShowingCheckBox.setText(Messages.getString("Show_this_dialog_at_start"));
        this.stopShowingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpContentPane.this.stopShowingCheckBox_actionPerformed(e);
            }
        });
        this.exampleWorldsContainer.setLayout(this.examplePanelLayout);
        this.exampleScrollPane.setBackground(Color.white);
        this.exampleScrollPane.setBorder(null);
        this.exampleScrollPane.setOpaque(false);
        this.exampleScrollPane.getViewport().setBackground(Color.white);
        this.exampleWorldsContainer.setBackground(Color.white);
        this.exampleWorldsContainer.setAlignmentX(0.0f);
        this.exampleWorldsContainer.setAlignmentY(0.0f);
        this.exampleWorldsDirLabel.setText(" ");
        this.exampleWorldsDirectoryContainer.setLayout(new GridBagLayout());
        this.exampleWorldsDirectoryContainer.setOpaque(true);
        this.exampleWorldsDirectoryContainer.setBackground(Color.white);
        this.exampleWorldsDirectoryContainer.add((Component)this.exampleWorldsDirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.exampleWorldsDirectoryContainer.add((Component)this.exampleScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.recentWorldsContainer.setLayout(this.recentPanelLayout);
        this.recentScrollPane.setBackground(Color.white);
        this.recentScrollPane.setBorder(null);
        this.recentScrollPane.getViewport().setBackground(Color.white);
        this.recentScrollPane.setOpaque(false);
        this.recentWorldsContainer.setBackground(Color.white);
        this.recentWorldsContainer.setAlignmentX(0.0f);
        this.recentWorldsContainer.setAlignmentY(0.0f);
        this.recentWorldsDirLabel.setText(" ");
        this.recentWorldsDirectoryContainer.setLayout(new GridBagLayout());
        this.recentWorldsDirectoryContainer.setOpaque(true);
        this.recentWorldsDirectoryContainer.setBackground(Color.white);
        this.recentWorldsDirectoryContainer.add((Component)this.recentWorldsDirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.recentWorldsDirectoryContainer.add((Component)this.recentScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.templateWorldsContainer.setLayout(this.templatePanelLayout);
        this.templateScrollPane.getViewport().setBackground(Color.white);
        this.templateScrollPane.setOpaque(false);
        this.templateScrollPane.setBorder(null);
        this.templateScrollPane.setBackground(Color.white);
        this.templateWorldsContainer.setBackground(Color.white);
        this.templateWorldsContainer.setAlignmentX(0.0f);
        this.templateWorldsContainer.setAlignmentY(0.0f);
        this.templateWorldsDirLabel.setText(" ");
        this.templateWorldsDirectoryContainer.setLayout(new GridBagLayout());
        this.templateWorldsDirectoryContainer.setOpaque(true);
        this.templateWorldsDirectoryContainer.setBackground(Color.white);
        this.templateWorldsDirectoryContainer.add((Component)this.templateWorldsDirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.templateWorldsDirectoryContainer.add((Component)this.templateScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.textbookExampleWorldsContainer.setLayout(this.textbookPanelLayout);
        this.textbookExampleScrollPane.getViewport().setBackground(Color.white);
        this.textbookExampleScrollPane.setOpaque(false);
        this.textbookExampleScrollPane.setBorder(null);
        this.textbookExampleScrollPane.setBackground(Color.white);
        this.textbookExampleWorldsContainer.setBackground(Color.white);
        this.textbookExampleWorldsContainer.setAlignmentX(0.0f);
        this.textbookExampleWorldsContainer.setAlignmentY(0.0f);
        this.textbookExampleWorldsDirLabel.setText(" ");
        this.textbookExampleWorldsDirectoryContainer.setLayout(new GridBagLayout());
        this.textbookExampleWorldsDirectoryContainer.setOpaque(true);
        this.textbookExampleWorldsDirectoryContainer.setBackground(Color.white);
        this.textbookExampleWorldsDirectoryContainer.add((Component)this.textbookExampleWorldsDirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.textbookExampleWorldsDirectoryContainer.add((Component)this.textbookExampleScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tutorialButtonPanel.setBackground(Color.white);
        this.tutorialButtonPanel.setLayout(new GridBagLayout());
        this.startTutorialButton.setBackground(Color.white);
        this.startTutorialButton.setBorder(null);
        this.startTutorialButton.setMaximumSize(new Dimension(120, 90));
        this.startTutorialButton.setMinimumSize(new Dimension(120, 90));
        this.startTutorialButton.setPreferredSize(new Dimension(120, 90));
        this.startTutorialButton.setToolTipText(Messages.getString("Start_the_Alice_tutorial"));
        this.startTutorialButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpContentPane.this.startTutorialButton_actionPerformed(e);
            }
        });
        this.jLabel1.setText(Messages.getString("or_continue_a_tutorial_"));
        this.tutorialButtonPanel.add((Component)this.startTutorialButton, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.tutorialButtonPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(2, 3, 2, 0), 0, 0));
        this.tutorialButtonPanel.add(component2, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tutorialWorldsContainer.setLayout(this.tutorialPanelLayout);
        this.tutorialScrollPane.getViewport().setBackground(Color.white);
        this.tutorialScrollPane.setOpaque(false);
        this.tutorialScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.tutorialScrollPane.setBackground(Color.white);
        this.tutorialWorldsContainer.setBackground(Color.white);
        this.tutorialWorldsContainer.setAlignmentX(0.0f);
        this.tutorialWorldsContainer.setAlignmentY(0.0f);
        this.tutorialWorldsDirectoryContainer.setLayout(new GridBagLayout());
        this.tutorialWorldsDirectoryContainer.setOpaque(true);
        this.tutorialWorldsDirectoryContainer.setBackground(Color.white);
        this.tutorialWorldsDirectoryContainer.add((Component)this.tutorialButtonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 0), 0, 0));
        this.tutorialWorldsDirectoryContainer.add((Component)this.tutorialScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.openButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 0, 0, 4), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 0, 0, 4), 0, 0));
        this.buttonPanel.add(Box.createGlue(), new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.mainTabPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainTabPane.add((Component)this.tutorialWorldsDirectoryContainer, "<html><body leftmargin=5 marginwidth=5>" + TUTORIAL_STRING + "</body></html>");
        this.mainTabPane.add((Component)this.recentWorldsDirectoryContainer, "<html><body leftmargin=5 marginwidth=5>" + RECENT_STRING + "</body></html>");
        this.mainTabPane.add((Component)this.templateWorldsDirectoryContainer, "<html><body leftmargin=5 marginwidth=5>" + TEMPLATES_STRING + "</body></html>");
        this.mainTabPane.add((Component)this.exampleWorldsDirectoryContainer, "<html><body leftmargin=5 marginwidth=5>" + EXAMPLES_STRING + "</body></html>");
        this.mainTabPane.add((Component)this.textbookExampleWorldsDirectoryContainer, "<html><body leftmargin=5 marginwidth=5>" + TEXTBOOK_EXAMPLES_STRING + "</body></html>");
        this.add((Component)this.stopShowingCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 16, 2, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.headerLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tutorialScrollPane.getViewport().add((Component)this.tutorialWorldsContainer, null);
        this.templateScrollPane.getViewport().add((Component)this.templateWorldsContainer, null);
        this.exampleScrollPane.getViewport().add((Component)this.exampleWorldsContainer, null);
        this.recentScrollPane.getViewport().add((Component)this.recentWorldsContainer, null);
        this.textbookExampleScrollPane.getViewport().add((Component)this.textbookExampleWorldsContainer, null);
        this.templateScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        this.exampleScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        this.recentScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        this.textbookExampleScrollPane.getVerticalScrollBar().setUnitIncrement(50);
    }

    private void matchSizes() {
        this.tutorialWorldsContainer.setSize(this.recentScrollPane.getVisibleRect().width, this.tutorialWorldsContainer.getHeight());
        this.recentWorldsContainer.setSize(this.recentScrollPane.getVisibleRect().width, this.recentWorldsContainer.getHeight());
        this.templateWorldsContainer.setSize(this.templateScrollPane.getVisibleRect().width, this.templateWorldsContainer.getHeight());
        this.exampleWorldsContainer.setSize(this.exampleScrollPane.getVisibleRect().width, this.exampleWorldsContainer.getHeight());
        this.textbookExampleWorldsContainer.setSize(this.textbookExampleScrollPane.getVisibleRect().width, this.textbookExampleWorldsContainer.getHeight());
    }

    private void setFileChooserButtons() {
        this.remove(this.buttonPanel);
    }

    private void setRegularButtons() {
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void mainTabPane_stateChanged(ChangeEvent e) {
        if (this.currentlySelected != null) {
            this.currentlySelected.deSelect();
            this.currentlySelected = null;
        }
        if (this.mainTabPane.getSelectedComponent() == this.fileChooser) {
            this.setFileChooserButtons();
            this.handleFileSelectionChange(this.fileChooser.getSelectedFile());
        } else {
            this.setRegularButtons();
            this.openButton.setEnabled(false);
        }
    }

    private void stopShowingCheckBox_actionPerformed(ActionEvent e) {
        if (this.stopShowingCheckBox.isSelected()) {
            authoringToolConfig.setValue("showStartUpDialog", "true");
        } else {
            authoringToolConfig.setValue("showStartUpDialog", "false");
        }
    }

    private void fileChooser_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("ApproveSelection")) {
            this.openButton.setEnabled(true);
            this.openButton.doClick();
        } else if (actionCommand.equals("CancelSelection")) {
            this.cancelButton.doClick();
        }
    }

    private void startTutorialButton_actionPerformed(ActionEvent e) {
        this.openButton.setEnabled(true);
        this.openButton.doClick();
    }

    protected class StartUpIcon
    extends JLabel
    implements MouseListener {
        protected static final int STANDARD = 1;
        protected static final int TUTORIAL = 2;
        protected static final int DIRECTORY = 3;
        protected boolean isSelected;
        protected String file;
        protected boolean needToSave;
        protected int type;
        protected Component owner;

        public StartUpIcon(String name, ImageIcon icon, String file, boolean needToSave, int type, Component owner) {
            super(name, icon, 0);
            this.isSelected = false;
            this.needToSave = false;
            this.file = file;
            this.needToSave = needToSave;
            this.type = type;
            this.owner = owner;
            this.setBackground(BACKGROUND_COLOR);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            Dimension size = new Dimension(icon.getIconWidth() + 4, icon.getIconHeight() + 24);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            if (type == 3) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
            this.setOpaque(false);
            this.addMouseListener(this);
        }

        protected JPanel getContainer(Component topLevelOwner) {
            if (topLevelOwner == StartUpContentPane.this.tutorialWorldsDirectoryContainer) {
                return StartUpContentPane.this.tutorialWorldsContainer;
            }
            if (topLevelOwner == StartUpContentPane.this.exampleScrollPane) {
                return StartUpContentPane.this.exampleWorldsContainer;
            }
            if (topLevelOwner == StartUpContentPane.this.templateScrollPane) {
                return StartUpContentPane.this.templateWorldsContainer;
            }
            if (topLevelOwner == StartUpContentPane.this.textbookExampleScrollPane) {
                return StartUpContentPane.this.textbookExampleWorldsContainer;
            }
            return null;
        }

        protected void changeDirectory(String newDirectory) {
            File newDir = new File(newDirectory);
            File parentDir = newDir.getParentFile();
            String baseDir = StartUpContentPane.this.getBaseDirString(this.owner);
            if (this.owner instanceof JScrollPane) {
                ((JScrollPane)this.owner).getVerticalScrollBar().setValue(0);
            }
            if (newDir.compareTo(StartUpContentPane.this.exampleWorlds) == 0 || newDir.compareTo(StartUpContentPane.this.templateWorlds) == 0 || newDir.compareTo(StartUpContentPane.this.tutorialWorlds) == 0) {
                StartUpContentPane.this.buildPanel(this.getContainer(this.owner), StartUpContentPane.this.buildVectorFromDirectory(newDir, StartUpContentPane.this.aliceFilter), this.needToSave, null, 1);
            } else {
                StartUpContentPane.this.buildPanel(this.getContainer(this.owner), StartUpContentPane.this.buildVectorFromDirectory(newDir, StartUpContentPane.this.aliceFilter), this.needToSave, parentDir, 1);
            }
        }

        public void deSelect() {
            if (this.isSelected) {
                StartUpContentPane.this.currentlySelected = null;
                this.isSelected = false;
                this.setBackground(BACKGROUND_COLOR);
                this.setOpaque(false);
                this.repaint();
                this.setForeground((Color)UIManager.get("Label.foreground"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.type == 3) {
                this.changeDirectory(this.file);
            } else {
                if (!this.isSelected) {
                    this.isSelected = true;
                    if (StartUpContentPane.this.currentlySelected != null) {
                        StartUpContentPane.this.currentlySelected.deSelect();
                    }
                    if (!StartUpContentPane.this.openButton.isEnabled()) {
                        StartUpContentPane.this.openButton.setEnabled(true);
                    }
                    this.setBackground(SELECTED_COLOR);
                    this.setOpaque(true);
                    this.setForeground(SELECTED_TEXT_COLOR);
                    StartUpContentPane.this.currentlySelected = this;
                    StartUpContentPane.this.currentlySelected.repaint();
                }
                if (e.getClickCount() == 2) {
                    StartUpContentPane.this.openButton.doClick();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    }
}

