/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIEffects;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public abstract class BasicBehaviorPanel
extends DnDGroupingPanel
implements GUIElement,
PropertyListener {
    public static final Color COLOR = AuthoringToolResources.getColor("behavior");
    protected JPopupMenu popUpMenu;
    protected Behavior m_behavior = null;
    protected GroupingPanel m_containingPanel;
    protected GroupingPanel labelPanel;
    protected AuthoringTool authoringTool;
    protected String typeString;
    protected final MouseListener behaviorMouseListener = new CustomMouseAdapter(){

        @Override
        protected void popupResponse(MouseEvent e) {
            BasicBehaviorPanel.this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
            PopupMenuUtilities.ensurePopupIsOnScreen(BasicBehaviorPanel.this.popUpMenu);
        }
    };

    public BasicBehaviorPanel() {
        this.addMouseListener(this.behaviorMouseListener);
        this.grip.addMouseListener(this.behaviorMouseListener);
    }

    public void set(Behavior behavior, String type, AuthoringTool authoringTool) {
        this.clean();
        super.reset();
        this.authoringTool = authoringTool;
        this.m_behavior = behavior;
        this.setTransferable(new ElementReferenceTransferable(behavior));
        this.typeString = AuthoringToolResources.getReprForValue(this.m_behavior.getClass());
        this.m_behavior.isEnabled.addPropertyListener(this);
        this.popUpMenu = this.createPopup();
        this.guiInit();
    }

    public void set(Behavior behavior, AuthoringTool authoringTool) {
        this.clean();
        super.reset();
        this.authoringTool = authoringTool;
        this.m_behavior = behavior;
        this.setTransferable(new ElementReferenceTransferable(behavior));
        this.typeString = AuthoringToolResources.getReprForValue(this.m_behavior.getClass());
        this.m_behavior.isEnabled.addPropertyListener(this);
        this.popUpMenu = this.createPopup();
        this.guiInit();
    }

    protected String getHTMLColorString(Color color) {
        String r = Integer.toHexString(color.getRed());
        String g = Integer.toHexString(color.getGreen());
        String b = Integer.toHexString(color.getBlue());
        if (r.length() == 1) {
            r = "0" + r;
        }
        if (g.length() == 1) {
            g = "0" + g;
        }
        if (b.length() == 1) {
            b = "0" + b;
        }
        return new String("#" + r + g + b);
    }

    public void getHTML(StringBuffer toWriteTo, boolean useColor) {
        Color bgColor = COLOR;
        String strikeStart = "";
        String strikeEnd = "";
        if (!this.m_behavior.isEnabled.booleanValue()) {
            bgColor = AuthoringToolResources.getColor("disabledHTML");
            strikeStart = "<strike><font color=\"" + this.getHTMLColorString(AuthoringToolResources.getColor("disabledHTMLText")) + "\">";
            strikeEnd = "</font></strike>";
        }
        toWriteTo.append("<tr>\n<td bgcolor=" + this.getHTMLColorString(bgColor) + "><b>" + strikeStart + GUIFactory.getHTMLStringForComponent(this) + "</b>" + strikeEnd + "</td>\n</tr>\n");
    }

    public Behavior getBehavior() {
        return this.m_behavior;
    }

    protected JPopupMenu createPopup() {
        Vector<Object> popupStructure = new Vector<Object>();
        popupStructure.add(ElementPopupUtilities.DeleteRunnable.class);
        Vector coerceStructure = ElementPopupUtilities.makeCoerceToStructure(this.m_behavior);
        if (coerceStructure != null && coerceStructure.size() > 0) {
            popupStructure.add(coerceStructure.elementAt(0));
        }
        StringObjectPair commentOut = null;
        if (this.m_behavior.isEnabled.booleanValue()) {
            Runnable setEnabled = new Runnable(){

                @Override
                public void run() {
                    BasicBehaviorPanel.this.m_behavior.isEnabled.set(false);
                    BasicBehaviorPanel.this.repaint();
                }
            };
            commentOut = new StringObjectPair(Messages.getString("disable"), setEnabled);
        } else {
            Runnable setEnabled = new Runnable(){

                @Override
                public void run() {
                    BasicBehaviorPanel.this.m_behavior.isEnabled.set(true);
                    BasicBehaviorPanel.this.repaint();
                }
            };
            commentOut = new StringObjectPair(Messages.getString("enable"), setEnabled);
        }
        popupStructure.add(commentOut);
        return ElementPopupUtilities.makeElementPopupMenu(this.m_behavior, popupStructure);
    }

    @Override
    public void goToSleep() {
        if (this.m_behavior != null) {
            this.m_behavior.isEnabled.removePropertyListener(this);
        }
    }

    @Override
    public void wakeUp() {
        if (this.m_behavior != null) {
            this.m_behavior.isEnabled.addPropertyListener(this);
        }
    }

    @Override
    public void release() {
        super.release();
        this.releasePanel(this.m_containingPanel);
        GUIFactory.releaseGUI(this);
    }

    @Override
    public void clean() {
        this.goToSleep();
        this.popUpMenu = null;
        if (this.m_containingPanel != null) {
            this.releasePanel(this.m_containingPanel);
            this.m_containingPanel.removeAll();
        }
    }

    protected void removeAllListening() {
        this.setTransferable(null);
        this.removeMouseListener(this.behaviorMouseListener);
        this.grip.removeMouseListener(this.behaviorMouseListener);
    }

    @Override
    public void die() {
        this.clean();
        this.removeAllListening();
        this.removeAll();
        this.m_behavior = null;
        this.m_containingPanel = null;
        this.authoringTool = null;
    }

    protected void releasePanel(Container toRelease) {
        if (toRelease != null) {
            int i = 0;
            while (i < toRelease.getComponentCount()) {
                if (toRelease.getComponent(i) instanceof Releasable) {
                    ((Releasable)((Object)toRelease.getComponent(i))).release();
                }
                ++i;
            }
        }
    }

    public static void buildLabel(JPanel container, String typeString) {
        String currentSubstring;
        int oldLocation = 0;
        int insertX = 0;
        int locationLeft = typeString.indexOf(60, 0);
        int locationRight = typeString.indexOf(62, locationLeft);
        while (locationLeft > -1 && locationRight > -1 && oldLocation < typeString.length()) {
            JComponent toAdd;
            currentSubstring = typeString.substring(oldLocation, locationLeft);
            String key = typeString.substring(locationLeft + 1, locationRight);
            ImageIcon icon = AuthoringToolResources.getIconForValue(key);
            if (icon == null) {
                toAdd = new GroupingPanel();
                toAdd.setLayout(new BorderLayout(0, 0));
                toAdd.setBackground(COLOR);
                ((GroupingPanel)toAdd).setBorder(BorderFactory.createCompoundBorder(((GroupingPanel)toAdd).getBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 0)));
                JLabel expressionLabel = new JLabel(key);
                ((GroupingPanel)toAdd).add((Component)expressionLabel, "Center");
            } else {
                toAdd = new JLabel(icon);
            }
            container.add((Component)new JLabel(currentSubstring), new GridBagConstraints(insertX, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            container.add((Component)toAdd, new GridBagConstraints(++insertX, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            ++insertX;
            oldLocation = locationRight + 1;
            locationLeft = typeString.indexOf(60, oldLocation);
            locationRight = typeString.indexOf(62, locationLeft);
        }
        if (oldLocation < typeString.length()) {
            currentSubstring = typeString.substring(oldLocation, typeString.length());
            container.add((Component)new JLabel(currentSubstring), new GridBagConstraints(insertX, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            ++insertX;
        }
    }

    protected void buildLabel(JPanel container) {
        String currentSubstring;
        int oldLocation = 0;
        int insertX = 0;
        int locationLeft = this.typeString.indexOf(60, 0);
        int locationRight = this.typeString.indexOf(62, locationLeft);
        while (locationLeft > -1 && locationRight > -1 && oldLocation < this.typeString.length()) {
            JComponent toAdd;
            currentSubstring = this.typeString.substring(oldLocation, locationLeft);
            String key = this.typeString.substring(locationLeft + 1, locationRight);
            Property prop = this.m_behavior.getPropertyNamed(key);
            if (prop != null) {
                SetPropertyImmediatelyFactory propPIF = new SetPropertyImmediatelyFactory(prop);
                boolean shouldAllowExpressions = true;
                Class desiredValueClass = PopupMenuUtilities.getDesiredValueClass(prop);
                if (Response.class.isAssignableFrom(desiredValueClass) || prop.getName().equalsIgnoreCase("keyCode") || prop.getName().equalsIgnoreCase("onWhat")) {
                    shouldAllowExpressions = false;
                }
                toAdd = GUIFactory.getPropertyViewController(prop, true, shouldAllowExpressions, AuthoringToolResources.shouldGUIOmitPropertyName(prop), propPIF);
            } else {
                toAdd = new JLabel(AuthoringToolResources.getIconForValue(key));
                if (toAdd == null) {
                    toAdd = new JLabel(Messages.getString("_no_image_"));
                }
            }
            container.add((Component)new JLabel(currentSubstring), new GridBagConstraints(insertX, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            container.add((Component)toAdd, new GridBagConstraints(++insertX, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            ++insertX;
            oldLocation = locationRight + 1;
            locationLeft = this.typeString.indexOf(60, oldLocation);
            locationRight = this.typeString.indexOf(62, locationLeft);
        }
        if (oldLocation < this.typeString.length()) {
            currentSubstring = this.typeString.substring(oldLocation, this.typeString.length());
            container.add((Component)new JLabel(currentSubstring), new GridBagConstraints(insertX, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            ++insertX;
        }
    }

    public void prePropertyChange(PropertyEvent propertyEvent) {
    }

    @Override
    public void propertyChanging(PropertyEvent propertyEvent) {
    }

    @Override
    public void paintForeground(Graphics g) {
        super.paintForeground(g);
        if (!this.m_behavior.isEnabled.booleanValue()) {
            Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            GUIEffects.paintDisabledEffect(g, bounds);
        }
    }

    @Override
    public void propertyChanged(PropertyEvent propertyEvent) {
        this.popUpMenu = this.createPopup();
        this.guiInit();
    }

    protected void guiInit() {
    }
}

