/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CopyFactoryTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor.BasicBehaviorPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor.BehaviorGroupEditor;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.DnDManagerListener;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.CopyFactory;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Group;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.KeyboardNavigationBehavior;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class BehaviorGroupsEditor
extends GroupingPanel
implements Editor,
ObjectArrayPropertyListener {
    protected GroupingPanel m_containingPanel;
    protected BehaviorGroupEditor worldEditor;
    protected GridBagLayout containingPanelLayout;
    protected JPanel m_header;
    protected JScrollPane scrollPane;
    protected Component glue;
    protected final String BEHAVIOR_NAME = Messages.getString("Events");
    protected static final String DEFAULT_NAME = Messages.getString("event");
    protected static final int SPACE = 8;
    protected static final int OBJECT = 1;
    protected static final int BEHAVIOR = 2;
    protected static final int BAD = -1;
    protected int editorCount = 0;
    protected int counter = 0;
    protected final Color BACKGROUND_COLOR = AuthoringToolResources.getColor("behaviorBackground");
    protected World world;
    protected AuthoringTool authoringTool;
    protected JButton newBehaviorButton;
    protected JPopupMenu behaviorMenu;
    protected Vector behaviorRunnables = new Vector();
    protected JLabel menuLabel = new JLabel();
    protected Vector allSandboxes = new Vector();
    protected boolean paintDropPotential = false;
    protected boolean beingDroppedOn = false;
    protected Color dndHighlightColor = AuthoringToolResources.getColor("dndHighlight");
    protected Color dndHighlightColor2 = AuthoringToolResources.getColor("dndHighlight2");
    protected DropPotentialFeedbackListener dropPotentialFeedbackListener = new DropPotentialFeedbackListener();
    public final AbstractAction newBehaviorAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BehaviorGroupsEditor.this.setRunnables(BehaviorGroupsEditor.this.world, "");
            BehaviorGroupsEditor.this.createNewBehavior(e);
        }
    };

    public Rectangle getScrollPaneVisibleRect() {
        return this.scrollPane.getVisibleRect();
    }

    public JComponent getScrollPane() {
        return this.scrollPane;
    }

    public JComponent getContainingPanel() {
        return this.m_containingPanel;
    }

    public static void setName(Behavior toSet, Element parent) {
        String newName = AuthoringToolResources.getNameForNewChild(DEFAULT_NAME, parent);
        toSet.name.set(newName);
    }

    public BehaviorGroupsEditor() {
        this.authoringTool = AuthoringTool.getHack();
        this.behaviorMenu = new JPopupMenu();
        Class[] behaviors = AuthoringToolResources.getBehaviorClasses();
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        DnDManager.addListener(this.dropPotentialFeedbackListener);
        int i = 0;
        while (i < behaviors.length) {
            Class currentBehavior = behaviors[i];
            String behaviorName = AuthoringToolResources.getReprForValue(currentBehavior);
            if (behaviorName == null) {
                behaviorName = Messages.getString("No_Name");
            }
            CreateNewBehaviorRunnable runnable = new CreateNewBehaviorRunnable(currentBehavior, this.world);
            this.behaviorRunnables.add(runnable);
            structure.add(new StringObjectPair(behaviorName, runnable));
            ++i;
        }
        this.behaviorMenu = structure.size() > 0 ? PopupMenuUtilities.makePopupMenu(structure) : PopupMenuUtilities.makeDisabledPopup(Messages.getString("None_Available"));
        this.behaviorMenu.add((Component)this.menuLabel, 0);
        this.initGUI();
        this.refreshGUI();
    }

    public BehaviorGroupsEditor(World theWorld) {
        this();
        this.setObject(theWorld);
    }

    protected BehaviorGroupEditor getEditor(Sandbox toCheck) {
        int i = 0;
        while (i < this.m_containingPanel.getComponentCount()) {
            BehaviorGroupEditor bge;
            if (this.m_containingPanel.getComponent(i) instanceof BehaviorGroupEditor && (bge = (BehaviorGroupEditor)this.m_containingPanel.getComponent(i)).getElement() == toCheck) {
                return bge;
            }
            ++i;
        }
        return null;
    }

    public Vector getEditors() {
        Vector toReturn = new Vector();
        int i = 0;
        while (i < this.m_containingPanel.getComponentCount()) {
            if (this.m_containingPanel.getComponent(i) instanceof BehaviorGroupEditor) {
                BehaviorGroupEditor bge = (BehaviorGroupEditor)this.m_containingPanel.getComponent(i);
                Vector behaviorsComponents = bge.getBehaviorComponents();
                int j = 0;
                while (j < behaviorsComponents.size()) {
                    toReturn.add(behaviorsComponents.get(j));
                    ++j;
                }
            }
            ++i;
        }
        return toReturn;
    }

    protected boolean checkGUI() {
        int total = 1;
        int i = 0;
        while (i < this.world.sandboxes.size()) {
            if (((Sandbox)this.world.sandboxes.get((int)i)).behaviors.size() > 0) {
                ++total;
            }
            ++i;
        }
        i = 0;
        while (i < this.world.groups.size()) {
            Group currentGroup = (Group)this.world.groups.get(i);
            int j = 0;
            while (j < currentGroup.size()) {
                if ((Sandbox)currentGroup.getChildAt(j) instanceof Sandbox && ((Sandbox)currentGroup.getChildAt((int)j)).behaviors.size() > 0) {
                    ++total;
                }
                ++j;
            }
            ++i;
        }
        int count = 0;
        int i2 = 0;
        while (i2 < this.m_containingPanel.getComponentCount()) {
            if (this.m_containingPanel.getComponent(i2) instanceof BehaviorGroupEditor) {
                BehaviorGroupEditor bge = (BehaviorGroupEditor)this.m_containingPanel.getComponent(i2);
                if (bge.getElement() == this.world) {
                    ++count;
                } else if (this.world.sandboxes.contains(bge.getElement())) {
                    if (((Sandbox)bge.getElement()).behaviors.size() <= 0) {
                        return false;
                    }
                    ++count;
                } else {
                    boolean found = false;
                    int j = 0;
                    while (j < this.world.groups.size()) {
                        Group currentGroup = (Group)this.world.groups.get(j);
                        if (currentGroup.contains(bge.getElement())) {
                            if (((Sandbox)bge.getElement()).behaviors.size() <= 0) {
                                return false;
                            }
                            ++count;
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        return false;
                    }
                }
            }
            ++i2;
        }
        return count == total;
    }

    protected void resetConstraints() {
        int i = 0;
        while (i < this.m_containingPanel.getComponentCount()) {
            Component c = this.m_containingPanel.getComponent(i);
            GridBagConstraints constraints = this.containingPanelLayout.getConstraints(c);
            if (c != null) {
                constraints.gridy = i;
                this.containingPanelLayout.setConstraints(c, constraints);
            }
            ++i;
        }
        this.m_containingPanel.revalidate();
        this.m_containingPanel.repaint();
    }

    public void editorRemoved(BehaviorGroupEditor toRemove) {
        if (this.getEditor((Sandbox)toRemove.getElement()) != null) {
            --this.editorCount;
            if (this.editorCount == 1) {
                this.worldEditor.removeLabel();
            }
            this.m_containingPanel.remove(toRemove);
            if (!this.checkGUI()) {
                this.refreshGUI();
            } else {
                this.resetConstraints();
            }
        }
    }

    @Override
    public void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
    }

    @Override
    public void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
        block12: {
            block13: {
                Sandbox child;
                block14: {
                    block10: {
                        Sandbox behaviorOwner;
                        block11: {
                            if (!(ev.getItem() instanceof Behavior)) break block10;
                            behaviorOwner = (Sandbox)ev.getObjectArrayProperty().getOwner();
                            if (behaviorOwner.behaviors.size() != 0) break block11;
                            BehaviorGroupEditor toRemove = this.getEditor(behaviorOwner);
                            if (toRemove == null) break block12;
                            this.editorRemoved(toRemove);
                            break block12;
                        }
                        if (ev.getChangeType() != 1 || behaviorOwner.behaviors.size() != 1) break block12;
                        this.addEditor(behaviorOwner);
                        break block12;
                    }
                    if (!(ev.getItem() instanceof Sandbox)) break block13;
                    child = (Sandbox)ev.getItem();
                    if (ev.getChangeType() != 1) break block14;
                    this.addEditor(child);
                    break block12;
                }
                if (ev.getChangeType() != 3) break block12;
                BehaviorGroupEditor toRemove = this.getEditor(child);
                if (toRemove != null) {
                    this.editorRemoved(toRemove);
                }
                child.behaviors.removeObjectArrayPropertyListener(this);
                break block12;
            }
            if (ev.getItem() instanceof Group) {
                Group child = (Group)ev.getItem();
                if (ev.getChangeType() == 1) {
                    child.values.addObjectArrayPropertyListener(this);
                    int j = 0;
                    while (j < child.size()) {
                        if (child.getChildAt(j) instanceof Sandbox) {
                            Sandbox current = (Sandbox)child.getChildAt(j);
                            this.addEditor(current);
                        }
                        ++j;
                    }
                } else if (ev.getChangeType() == 3) {
                    child.values.removeObjectArrayPropertyListener(this);
                    int j = 0;
                    while (j < child.size()) {
                        if ((Sandbox)child.getChildAt(j) instanceof Sandbox) {
                            Sandbox current = (Sandbox)child.getChildAt(j);
                            current.behaviors.removeObjectArrayPropertyListener(this);
                            BehaviorGroupEditor toRemove = this.getEditor(current);
                            if (toRemove != null) {
                                this.editorRemoved(toRemove);
                            }
                        }
                        ++j;
                    }
                }
            }
        }
    }

    protected void createNewBehavior(ActionEvent e) {
        this.behaviorMenu.show(this.newBehaviorButton, 0, this.newBehaviorButton.getHeight());
        PopupMenuUtilities.ensurePopupIsOnScreen(this.behaviorMenu);
    }

    protected void addEditor(Sandbox toAdd) {
        ElementArrayProperty currentGroup = toAdd.behaviors;
        if (this.getEditor(toAdd) == null && currentGroup != null) {
            toAdd.behaviors.addObjectArrayPropertyListener(this);
            if (currentGroup.size() > 0) {
                ++this.editorCount;
                if (this.editorCount > 1) {
                    this.worldEditor.addLabel();
                }
                BehaviorGroupEditor editor = new BehaviorGroupEditor();
                editor.set(currentGroup.getOwner(), this.authoringTool);
                editor.setDropTarget(new DropTarget(editor, editor));
                this.m_containingPanel.remove(this.glue);
                this.m_containingPanel.add((Component)editor, new GridBagConstraints(0, this.m_containingPanel.getComponentCount(), 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 4, 3, 2), 0, 0));
                this.m_containingPanel.add(this.glue, new GridBagConstraints(0, this.m_containingPanel.getComponentCount(), 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                if (!this.checkGUI()) {
                    this.refreshGUI();
                } else {
                    this.resetConstraints();
                    this.revalidate();
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void release() {
        super.release();
        if (this.world != null) {
            this.world.sandboxes.removeObjectArrayPropertyListener(this);
            this.world.groups.removeObjectArrayPropertyListener(this);
            int i = 0;
            while (i < this.world.sandboxes.size()) {
                Sandbox current = (Sandbox)this.world.sandboxes.get(i);
                current.behaviors.removeObjectArrayPropertyListener(this);
                ++i;
            }
            i = 0;
            while (i < this.world.groups.size()) {
                Group currentGroup = (Group)this.world.groups.get(i);
                currentGroup.values.removeObjectArrayPropertyListener(this);
                int j = 0;
                while (j < currentGroup.size()) {
                    if ((Sandbox)currentGroup.getChildAt(j) instanceof Sandbox) {
                        Sandbox current = (Sandbox)currentGroup.getChildAt(j);
                        current.behaviors.removeObjectArrayPropertyListener(this);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        int i = 0;
        while (i < this.m_containingPanel.getComponentCount()) {
            if (this.m_containingPanel.getComponent(i) instanceof BehaviorGroupEditor) {
                ((BehaviorGroupEditor)this.m_containingPanel.getComponent(i)).setAuthoringTool(authoringTool);
            }
            ++i;
        }
    }

    protected void setRunnables(Sandbox s, String label) {
        int i = 0;
        while (i < this.behaviorRunnables.size()) {
            ((CreateNewBehaviorRunnable)this.behaviorRunnables.get(i)).setOwner(s);
            ++i;
        }
        this.menuLabel.setText(label);
    }

    public void setObject(World theWorld) {
        this.release();
        this.world = theWorld;
        if (this.world != null) {
            this.setRunnables(this.world, "");
            this.world.sandboxes.addObjectArrayPropertyListener(this);
            this.world.groups.addObjectArrayPropertyListener(this);
            int i = 0;
            while (i < this.world.sandboxes.size()) {
                Sandbox current = (Sandbox)this.world.sandboxes.get(i);
                current.behaviors.addObjectArrayPropertyListener(this);
                ++i;
            }
            i = 0;
            while (i < this.world.groups.size()) {
                Group currentGroup = (Group)this.world.groups.get(i);
                currentGroup.values.addObjectArrayPropertyListener(this);
                int j = 0;
                while (j < currentGroup.size()) {
                    if ((Sandbox)currentGroup.getChildAt(j) instanceof Sandbox) {
                        Sandbox current = (Sandbox)currentGroup.getChildAt(j);
                        if (current.behaviors != null) {
                            current.behaviors.addObjectArrayPropertyListener(this);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.refreshGUI();
    }

    @Override
    public Object getObject() {
        return this.world;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    private void removeAllElements(JPanel container) {
        int i = 0;
        while (i < container.getComponentCount()) {
            if (container.getComponent(i) instanceof BehaviorGroupEditor) {
                ((BehaviorGroupEditor)container.getComponent(i)).release();
            }
            ++i;
        }
        container.removeAll();
    }

    protected void initGUI() {
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        this.setBackground(this.BACKGROUND_COLOR);
        this.setBorder(null);
        this.scrollPane = new JScrollPane(20, 30);
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, "Center");
        this.m_containingPanel = new GroupingPanel(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                BehaviorGroupsEditor.this.dragEnter(dtde);
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                BehaviorGroupsEditor.this.dragExit(dte);
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                BehaviorGroupsEditor.this.dragOver(dtde);
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                BehaviorGroupsEditor.this.drop(dtde);
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
                BehaviorGroupsEditor.this.dropActionChanged(dtde);
            }
        };
        String toolTipText = "<html><body>" + Messages.getString("_p_Events__p_") + Messages.getString("_p_Events_run_Methods_when_certain_things_happen__p_") + Messages.getString("_p__like_when_the_mouse_is_clicked_on_an_Object_or__p_") + Messages.getString("_p_when_a_certain_key_is_pressed___p_") + "</body></html>";
        this.containingPanelLayout = new GridBagLayout();
        this.m_containingPanel.setLayout(this.containingPanelLayout);
        this.m_containingPanel.setBorder(null);
        this.m_containingPanel.setBackground(this.BACKGROUND_COLOR);
        this.m_containingPanel.setToolTipText(toolTipText);
        this.scrollPane.setViewportView(this.m_containingPanel);
        this.newBehaviorButton = new JButton(Messages.getString("create_new_event"));
        this.newBehaviorButton.setToolTipText(Messages.getString("Display_Menu_of_New_Event_Types"));
        this.newBehaviorButton.setMargin(new Insets(2, 2, 2, 2));
        this.newBehaviorButton.addActionListener(this.newBehaviorAction);
        this.newBehaviorButton.setBackground(new Color(240, 240, 255));
        this.newBehaviorButton.setDropTarget(new DropTarget(this.newBehaviorButton, this));
        this.m_header = new JPanel();
        this.m_header.setLayout(new FlowLayout(0, 2, 2));
        this.m_header.setBackground(this.BACKGROUND_COLOR);
        this.m_header.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        this.m_header.setToolTipText(toolTipText);
        JLabel behaviorLabel = new JLabel(this.BEHAVIOR_NAME);
        int fontSize = Integer.parseInt(this.authoringToolConfig.getValue("fontSize"));
        Font behaviorFont = new Font("Helvetica", 1, (int)((double)(16 * fontSize) / 12.0));
        behaviorLabel.setFont(behaviorFont);
        behaviorLabel.setDropTarget(new DropTarget(behaviorLabel, this));
        this.m_header.add(behaviorLabel);
        this.m_header.add(Box.createHorizontalStrut(4));
        this.m_header.add(this.newBehaviorButton);
        this.m_header.setDropTarget(new DropTarget(this.m_header, this));
        this.add((Component)this.m_header, "North");
        this.glue = Box.createVerticalGlue();
        this.setToolTipText(toolTipText);
    }

    protected synchronized void refreshGUI() {
        if (this.world != null) {
            this.removeAll();
            this.add((Component)this.m_header, "North");
            this.add((Component)this.scrollPane, "Center");
            this.removeAllElements(this.m_containingPanel);
            int count = 0;
            this.worldEditor = new BehaviorGroupEditor();
            this.worldEditor.set(this.world, this.authoringTool);
            this.worldEditor.setEmptyString(" " + Messages.getString("No_events"));
            this.m_containingPanel.add((Component)this.worldEditor, new GridBagConstraints(0, count, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 4, 3, 2), 0, 0));
            BehaviorGroupEditor editor = null;
            int i = 0;
            while (i < this.world.sandboxes.size()) {
                ElementArrayProperty currentGroup = ((Sandbox)this.world.sandboxes.get((int)i)).behaviors;
                if (currentGroup != null && currentGroup.size() > 0) {
                    editor = new BehaviorGroupEditor();
                    editor.set(currentGroup.getOwner(), this.authoringTool);
                    this.m_containingPanel.add((Component)editor, new GridBagConstraints(0, ++count, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 4, 3, 2), 0, 0));
                }
                ++i;
            }
            if (count == 0) {
                this.worldEditor.removeLabel();
            }
            this.m_containingPanel.add(this.glue, new GridBagConstraints(0, count + 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.editorCount = count + 1;
        }
        this.revalidate();
        this.repaint();
    }

    protected void printComponents(Container c) {
        System.out.println(c + "n\n");
        int i = 0;
        while (i < c.getComponentCount()) {
            if (c.getComponent(i) instanceof Container) {
                this.printComponents((Container)c.getComponent(i));
            } else {
                System.out.println(c.getComponent(i));
            }
            ++i;
        }
    }

    protected static int checkDragEvent(DropTargetDragEvent dtde) throws IOException, UnsupportedFlavorException {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, CopyFactoryTransferable.copyFactoryFlavor)) {
            Transferable transferable = DnDManager.getCurrentTransferable();
            CopyFactory copyFactory = (CopyFactory)transferable.getTransferData(CopyFactoryTransferable.copyFactoryFlavor);
            Class valueClass = copyFactory.getValueClass();
            if (Behavior.class.isAssignableFrom(valueClass)) {
                return 2;
            }
            return -1;
        }
        if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.transformableReferenceFlavor)) {
            return 1;
        }
        if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.behaviorReferenceFlavor)) {
            return 2;
        }
        return -1;
    }

    protected static int checkTransferable(Transferable transferable) throws IOException, UnsupportedFlavorException {
        if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, CopyFactoryTransferable.copyFactoryFlavor)) {
            CopyFactory copyFactory = (CopyFactory)transferable.getTransferData(CopyFactoryTransferable.copyFactoryFlavor);
            Class valueClass = copyFactory.getValueClass();
            if (Behavior.class.isAssignableFrom(valueClass)) {
                return 2;
            }
            return -1;
        }
        if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.transformableReferenceFlavor)) {
            return 1;
        }
        if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.behaviorReferenceFlavor)) {
            return 2;
        }
        return -1;
    }

    protected Component getTopComponent(Component c) {
        if (c instanceof BehaviorGroupEditor || c == this || c == this.m_containingPanel || c == null) {
            return c;
        }
        return this.getTopComponent(c.getParent());
    }

    private Component getPrimaryComponent(Component c) {
        if (c == null) {
            return c;
        }
        if (c.getParent() == this.m_containingPanel) {
            return c;
        }
        return this.getPrimaryComponent(c.getParent());
    }

    protected BehaviorGroupEditor getEditor(Point p) {
        int numSpots = this.editorCount * 2;
        int[] spots = new int[numSpots];
        int i = 0;
        while (i < this.editorCount) {
            Component c = this.m_containingPanel.getComponent(i);
            spots[i * 2] = c.getBounds().y;
            spots[i * 2 + 1] = c.getBounds().y + c.getBounds().height;
            ++i;
        }
        int closestSpot = -1;
        int minDist = Integer.MAX_VALUE;
        int i2 = 0;
        while (i2 < numSpots) {
            int d = Math.abs(p.y - spots[i2]);
            if (d < minDist) {
                minDist = d;
                closestSpot = i2;
            }
            ++i2;
        }
        return (BehaviorGroupEditor)this.m_containingPanel.getComponent(closestSpot / 2);
    }

    protected void paintLineInEditor(DropTargetDragEvent dtde) {
        BehaviorGroupEditor currentEditor = this.getEditor(SwingUtilities.convertPoint(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), this.m_containingPanel));
        currentEditor.dragOver(dtde);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        try {
            int type = BehaviorGroupsEditor.checkDragEvent(dtde);
            if (type != -1 && type != 2) {
                dtde.acceptDrag(2);
                ++this.counter;
                this.beingDroppedOn = true;
                this.repaint();
            } else {
                this.beingDroppedOn = false;
                this.repaint();
                dtde.rejectDrag();
            }
        }
        catch (Exception e) {
            dtde.rejectDrag();
            this.beingDroppedOn = false;
            this.repaint();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.beingDroppedOn) {
            this.beingDroppedOn = false;
            this.repaint();
        } else {
            super.dragExit(dte);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        try {
            BehaviorGroupEditor currentEditor;
            Component primary;
            int type = BehaviorGroupsEditor.checkDragEvent(dtde);
            if (type == -1) {
                dtde.rejectDrag();
                if (this.beingDroppedOn) {
                    this.beingDroppedOn = false;
                    this.repaint();
                }
            } else if (type == 1) {
                dtde.acceptDrag(2);
                if (!this.beingDroppedOn) {
                    this.beingDroppedOn = true;
                    this.repaint();
                }
            } else if (type == 2 && !((primary = this.getPrimaryComponent(dtde.getDropTargetContext().getComponent())) instanceof BehaviorGroupEditor) && (currentEditor = this.getEditor(SwingUtilities.convertPoint(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), this.m_containingPanel))) != null) {
                currentEditor.componentElementPanel.dragOver(dtde);
            }
        }
        catch (Exception e) {
            dtde.rejectDrag();
            this.beingDroppedOn = false;
            this.repaint();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        boolean dropSuccess = true;
        try {
            BehaviorGroupEditor currentEditor;
            Component primary;
            int type = BehaviorGroupsEditor.checkTransferable(transferable);
            if (type == -1) {
                dtde.rejectDrop();
                dropSuccess = false;
            } else if (type == 1) {
                dtde.acceptDrop(2);
                Transformable droppedElement = (Transformable)dtde.getTransferable().getTransferData(ElementReferenceTransferable.transformableReferenceFlavor);
                this.setRunnables(droppedElement, String.valueOf(Messages.getString("New_")) + droppedElement.name.get() + " " + Messages.getString("event"));
                this.behaviorMenu.show(dtde.getDropTargetContext().getComponent(), (int)dtde.getLocation().getX(), (int)dtde.getLocation().getY());
                PopupMenuUtilities.ensurePopupIsOnScreen(this.behaviorMenu);
            } else if (type == 2 && !((primary = this.getPrimaryComponent(dtde.getDropTargetContext().getComponent())) instanceof BehaviorGroupEditor) && (currentEditor = this.getEditor(SwingUtilities.convertPoint(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), this.m_containingPanel))) != null) {
                currentEditor.componentElementPanel.drop(dtde);
            }
        }
        catch (Exception e) {
            AuthoringTool.showErrorDialog(Messages.getString("The_drop_failed_"), e);
            dropSuccess = false;
        }
        this.beingDroppedOn = false;
        this.paintDropPotential = false;
        this.repaint();
        dtde.dropComplete(dropSuccess);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void paintForeground(Graphics g) {
        super.paintForeground(g);
        Point p = SwingUtilities.convertPoint(this.m_containingPanel, this.m_containingPanel.getLocation(), this);
        if (this.beingDroppedOn) {
            Dimension size = this.m_containingPanel.getSize();
            g.setColor(this.dndHighlightColor2);
            g.drawRect(p.x, p.y, size.width - 1, size.height - 1);
            g.drawRect(p.x + 1, p.y + 1, size.width - 3, size.height - 3);
        } else if (this.paintDropPotential) {
            Dimension size = this.m_containingPanel.getSize();
            g.setColor(this.dndHighlightColor);
            g.drawRect(p.x, p.y, size.width - 1, size.height - 1);
            g.drawRect(p.x + 1, p.y + 1, size.width - 3, size.height - 3);
        }
    }

    @Override
    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void stateChanged(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
        this.refreshGUI();
    }

    @Override
    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaved(AuthoringToolStateChangedEvent ev) {
        this.refreshGUI();
    }

    protected class BehaviorMenuItem
    extends JMenuItem {
        private DnDGroupingPanel visibleComponent = new DnDGroupingPanel();
        private JPanel internalComponent = new JPanel();

        public BehaviorMenuItem(String s) {
            this.visibleComponent.setLayout(new GridBagLayout());
            BasicBehaviorPanel.buildLabel(this.internalComponent, s);
            this.internalComponent.setOpaque(false);
            this.visibleComponent.setOpaque(true);
            this.visibleComponent.add((Component)this.internalComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.visibleComponent.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.visibleComponent.setSize(this.visibleComponent.getPreferredSize());
            Dimension dim = this.visibleComponent.getPreferredSize();
            this.internalComponent.doLayout();
            BufferedImage image = new BufferedImage(dim.width, dim.height, 2);
            JLabel l = new JLabel(Messages.getString("TEST"));
            l.print(image.createGraphics());
            this.setIcon(new ImageIcon(image));
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
            super.menuSelectionChanged(isIncluded);
            if (isIncluded) {
                this.internalComponent.setBackground(Color.white);
            } else {
                this.internalComponent.setBackground(Color.black);
            }
        }
    }

    class CreateNewBehaviorRunnable
    implements Runnable {
        Class behaviorClass;
        Sandbox owner;

        public CreateNewBehaviorRunnable(Class behaviorClass, Sandbox owner) {
            this.behaviorClass = behaviorClass;
            this.owner = owner;
        }

        public void setOwner(Sandbox owner) {
            this.owner = owner;
        }

        @Override
        public void run() {
            try {
                Object instance;
                if (BehaviorGroupsEditor.this.authoringTool != null) {
                    BehaviorGroupsEditor.this.authoringTool.getUndoRedoStack().startCompound();
                }
                if ((instance = this.behaviorClass.newInstance()) instanceof Behavior) {
                    Behavior behavior = (Behavior)instance;
                    BehaviorGroupsEditor.setName(behavior, this.owner);
                    behavior.setParent(this.owner);
                    this.owner.behaviors.add(0, behavior);
                    behavior.manufactureDetails();
                    if (behavior instanceof KeyboardNavigationBehavior) {
                        ((KeyboardNavigationBehavior)behavior).subject.set(BehaviorGroupsEditor.this.authoringTool.getCurrentCamera());
                    }
                }
                if (BehaviorGroupsEditor.this.authoringTool != null) {
                    BehaviorGroupsEditor.this.authoringTool.getUndoRedoStack().stopCompound();
                }
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog(Messages.getString("Failed_to_create_new_event"), t);
            }
        }
    }

    protected class DropPotentialFeedbackListener
    implements DnDManagerListener {
        protected DropPotentialFeedbackListener() {
        }

        private void doCheck() {
            Transferable transferable = DnDManager.getCurrentTransferable();
            try {
                boolean transferableHasPotential;
                int type = BehaviorGroupsEditor.checkTransferable(transferable);
                boolean bl = transferableHasPotential = type != -1;
                if (BehaviorGroupsEditor.this.paintDropPotential != transferableHasPotential) {
                    BehaviorGroupsEditor.this.paintDropPotential = transferableHasPotential;
                    BehaviorGroupsEditor.this.repaint();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
        }

        @Override
        public void dragStarted() {
            this.doCheck();
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            this.doCheck();
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
            this.doCheck();
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            this.doCheck();
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            BehaviorGroupsEditor.this.paintDropPotential = false;
            BehaviorGroupsEditor.this.beingDroppedOn = false;
            BehaviorGroupsEditor.this.repaint();
        }
    }
}

