/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CopyFactoryTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor.BehaviorGroupEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor.BehaviorGroupsEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeComponentElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.CopyFactory;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;

public class CompositeComponentBehaviorPanel
extends CompositeComponentElementPanel {
    public void set(ObjectArrayProperty elements, BehaviorGroupEditor owner, AuthoringTool authoringToolIn) {
        super.set(elements, owner, authoringToolIn);
    }

    @Override
    protected boolean isInverted() {
        return true;
    }

    @Override
    protected Component makeGUI(Element currentElement) {
        JComponent toAdd = null;
        if (currentElement instanceof Behavior) {
            toAdd = GUIFactory.getGUI(currentElement);
            return toAdd;
        }
        return null;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        boolean dropSuccess = true;
        try {
            int type = BehaviorGroupsEditor.checkTransferable(transferable);
            if (type == -1 || type == 1) {
                if (this.m_owner.getParent() instanceof DropTargetListener) {
                    ((DropTargetListener)((Object)this.m_owner.getParent())).drop(dtde);
                }
            } else if (type == 2) {
                Behavior b;
                dtde.acceptDrop(2);
                if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, CopyFactoryTransferable.copyFactoryFlavor)) {
                    CopyFactory copyFactory = (CopyFactory)transferable.getTransferData(CopyFactoryTransferable.copyFactoryFlavor);
                    b = (Behavior)copyFactory.manufactureCopy(this.componentElements.getOwner().getWorld());
                } else {
                    b = (Behavior)transferable.getTransferData(ElementReferenceTransferable.behaviorReferenceFlavor);
                }
                this.performDrop(b, dtde);
            }
        }
        catch (Exception e) {
            AuthoringTool.showErrorDialog(Messages.getString("The_drop_failed_"), e);
            dropSuccess = false;
        }
        dtde.dropComplete(dropSuccess);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (!this.m_owner.isExpanded() && this.m_owner.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.m_owner.getParent())).dragOver(dtde);
        }
        try {
            if (BehaviorGroupsEditor.checkDragEvent(dtde) != 2) {
                if (this.m_owner.getParent() instanceof DropTargetListener) {
                    ((DropTargetListener)((Object)this.m_owner.getParent())).dragOver(dtde);
                }
            } else {
                this.insertDropPanel(dtde);
                dtde.acceptDrag(dtde.getDropAction());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrag();
            return;
        }
    }
}

