/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.ComponentElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeComponentElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeComponentOwner;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.ForEachElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.IfElseElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.LoopNElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.questioneditor.CompositeComponentQuestionPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.questioneditor.MainCompositeQuestionPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor.CompositeComponentResponsePanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor.ResponseEditor;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIEffects;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Composite;
import edu.cmu.cs.stage3.alice.core.question.userdefined.IfElse;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.core.response.IfElseInOrder;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class CompositeElementPanel
extends DnDGroupingPanel
implements CompositeComponentOwner,
GUIElement,
PropertyListener {
    protected CompositeComponentElementPanel componentElementPanel;
    protected Element m_element;
    protected ObjectArrayProperty m_components;
    protected BooleanProperty m_isCommentedOut;
    protected String headerText = Messages.getString("Composite_Element");
    protected JPanel headerPanel;
    protected JLabel closeBrace = new JLabel("}");
    protected JPanel containingPanel;
    protected JButton expandButton;
    protected JComponent nameInputField;
    protected Action expandAction;
    protected JLabel headerLabel;
    protected boolean isExpanded = true;
    protected Color backgroundColor = new Color(255, 255, 255);
    protected int m_depth = 0;
    protected ImageIcon plus;
    protected ImageIcon minus;
    protected Component glue;
    protected AuthoringTool authoringTool;
    protected ActionListener actionListener;
    protected MouseListener elementMouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent ev) {
            if ((ev.isPopupTrigger() || ev.getButton() == 3 || System.getProperty("os.name") != null && !System.getProperty("os.name").startsWith("Windows") && ev.isControlDown()) && CompositeElementPanel.this.getParent() != null) {
                Vector structure = ElementPopupUtilities.getDefaultStructure(CompositeElementPanel.this.m_element);
                if (!ForEachElementPanel.class.isAssignableFrom(CompositeElementPanel.this.getClass()) && !LoopNElementPanel.class.isAssignableFrom(CompositeElementPanel.this.getClass())) {
                    Runnable dissolveRunnable = new Runnable(){

                        @Override
                        public void run() {
                            CompositeElementPanel.this.dissolve();
                        }
                    };
                    StringObjectPair dissolveEntry = new StringObjectPair(Messages.getString("dissolve"), dissolveRunnable);
                    if (structure != null) {
                        structure.add(dissolveEntry);
                    }
                }
                if (structure != null) {
                    ElementPopupUtilities.createAndShowElementPopupMenu(CompositeElementPanel.this.m_element, structure, CompositeElementPanel.this, ev.getX(), ev.getY());
                }
            }
        }
    };
    protected static String IS_EXPANDED_KEY = "edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor IS_EXPANDED_KEY";

    public CompositeElementPanel() {
        this.headerText = Messages.getString("Element_Response");
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CompositeElementPanel.this.isExpanded) {
                    CompositeElementPanel.this.reduceComponentElementPanel();
                } else {
                    CompositeElementPanel.this.expandComponentElementPanel();
                }
            }
        };
        this.backgroundColor = this.getCustomBackgroundColor();
        this.generateGUI();
    }

    public void set(Element element, AuthoringTool authoringToolIn) {
        this.clean();
        super.reset();
        this.authoringTool = authoringToolIn;
        this.m_element = element;
        this.variableInit();
        this.startListening();
        this.setHeaderLabel();
        this.updateGUI();
        this.setDropTargets();
    }

    protected Color getCustomBackgroundColor() {
        return this.backgroundColor;
    }

    protected void setDropTargets() {
        this.headerLabel.setDropTarget(new DropTarget(this.headerLabel, this.componentElementPanel));
        this.setDropTarget(new DropTarget(this, this.componentElementPanel));
        this.containingPanel.setDropTarget(new DropTarget(this.containingPanel, this.componentElementPanel));
        this.headerPanel.setDropTarget(new DropTarget(this.headerPanel, this.componentElementPanel));
        this.grip.setDropTarget(new DropTarget(this.grip, this.componentElementPanel));
        this.glue.setDropTarget(new DropTarget(this.glue, this.componentElementPanel));
        this.expandButton.setDropTarget(new DropTarget(this.expandButton, this.componentElementPanel));
    }

    protected void variableInit() {
        Object isExpandedValue = this.m_element.data.get(IS_EXPANDED_KEY);
        this.backgroundColor = this.getCustomBackgroundColor();
        if (isExpandedValue instanceof Boolean) {
            this.isExpanded = (Boolean)isExpandedValue;
        }
        this.setTransferable(new ElementReferenceTransferable(this.m_element));
        if (this.m_element instanceof CompositeResponse) {
            CompositeResponse proxy = (CompositeResponse)this.m_element;
            this.m_components = proxy.componentResponses;
            this.m_isCommentedOut = proxy.isCommentedOut;
            this.componentElementPanel = new CompositeComponentResponsePanel();
            this.componentElementPanel.set(this.m_components, this, this.authoringTool);
            this.componentElementPanel.setBackground(this.backgroundColor);
            this.addDragSourceComponent(this.componentElementPanel);
            this.componentElementPanel.addMouseListener(this.elementMouseListener);
        } else if (this.m_element instanceof Composite) {
            Composite proxy = (Composite)this.m_element;
            this.m_components = proxy.components;
            this.m_isCommentedOut = proxy.isCommentedOut;
            this.componentElementPanel = new CompositeComponentQuestionPanel();
            this.componentElementPanel.set(this.m_components, this, this.authoringTool);
            this.componentElementPanel.setBackground(this.backgroundColor);
            this.addDragSourceComponent(this.componentElementPanel);
            this.componentElementPanel.addMouseListener(this.elementMouseListener);
        }
    }

    @Override
    public Component getGrip() {
        return this.grip;
    }

    @Override
    public Container getParent() {
        return super.getParent();
    }

    protected void startListening() {
        if (this.m_element != null) {
            this.m_element.name.addPropertyListener(this);
        }
        if (this.m_isCommentedOut != null) {
            this.m_isCommentedOut.addPropertyListener(this);
        }
    }

    protected void stopListening() {
        if (this.m_element != null) {
            this.m_element.name.removePropertyListener(this);
        }
        if (this.m_isCommentedOut != null) {
            this.m_isCommentedOut.removePropertyListener(this);
        }
    }

    @Override
    public void goToSleep() {
        this.stopListening();
        if (this.componentElementPanel != null) {
            this.componentElementPanel.goToSleep();
        }
    }

    @Override
    public void wakeUp() {
        this.startListening();
        if (this.componentElementPanel != null) {
            this.componentElementPanel.wakeUp();
        }
    }

    @Override
    public void release() {
        super.release();
        if (this.componentElementPanel != null) {
            this.componentElementPanel.release();
        }
        GUIFactory.releaseGUI(this);
    }

    @Override
    public void clean() {
        this.goToSleep();
        if (this.componentElementPanel != null) {
            if (this.containingPanel != null) {
                this.containingPanel.remove(this.componentElementPanel);
            }
            this.componentElementPanel.release();
            this.componentElementPanel = null;
        }
    }

    protected void removeAllListening() {
        this.removeDragSourceComponent(this.componentElementPanel);
        this.componentElementPanel.removeMouseListener(this.elementMouseListener);
        this.grip.setDropTarget(null);
        this.removeDragSourceComponent(this.glue);
        this.glue.removeMouseListener(this.elementMouseListener);
        this.removeMouseListener(this.elementMouseListener);
        this.grip.removeMouseListener(this.elementMouseListener);
        this.expandButton.removeActionListener(this.actionListener);
        this.setTransferable(null);
        if (this.headerLabel != null) {
            this.headerLabel.removeMouseListener(this.elementMouseListener);
            this.removeDragSourceComponent(this.headerLabel);
        }
        if (this.containingPanel != null) {
            this.containingPanel.removeMouseListener(this.elementMouseListener);
            this.removeDragSourceComponent(this.containingPanel);
        }
        if (this.headerPanel != null) {
            this.headerPanel.removeMouseListener(this.elementMouseListener);
            this.removeDragSourceComponent(this.headerPanel);
        }
    }

    @Override
    public void die() {
        this.clean();
        this.removeAllListening();
    }

    public void dissolve() {
        if (this.m_element.getParent() instanceof CompositeResponse) {
            this.authoringTool.getUndoRedoStack().startCompound();
            CompositeResponse parent = (CompositeResponse)this.m_element.getParent();
            int index = parent.componentResponses.indexOf(this.m_element);
            if (parent instanceof IfElseInOrder && !parent.componentResponses.contains(this.m_element)) {
                index = ((IfElseInOrder)parent).elseComponentResponses.indexOf(this.m_element);
            }
            Object[] responses = this.m_components.getArrayValue();
            int i = 0;
            while (i < responses.length) {
                if (responses[i] instanceof Response) {
                    Response currentResponse = (Response)responses[i];
                    currentResponse.removeFromParent();
                    currentResponse.setParent(parent);
                    parent.componentResponses.add(index + i, currentResponse);
                }
                ++i;
            }
            this.m_element.removeFromParent();
            this.authoringTool.getUndoRedoStack().stopCompound();
        } else if (this.m_element.getParent() instanceof Composite) {
            this.authoringTool.getUndoRedoStack().startCompound();
            Composite parent = (Composite)this.m_element.getParent();
            int index = parent.getIndexOfChild(this.m_element);
            if (parent instanceof IfElse && !parent.components.contains(this.m_element)) {
                index = ((IfElse)parent).elseComponents.indexOf(this.m_element);
            }
            Object[] questions = this.m_components.getArrayValue();
            int i = 0;
            while (i < questions.length) {
                if (questions[i] instanceof edu.cmu.cs.stage3.alice.core.question.userdefined.Component) {
                    edu.cmu.cs.stage3.alice.core.question.userdefined.Component currentQuestion = (edu.cmu.cs.stage3.alice.core.question.userdefined.Component)questions[i];
                    currentQuestion.removeFromParent();
                    currentQuestion.setParent(parent);
                    parent.components.add(index + i, currentQuestion);
                }
                ++i;
            }
            this.m_element.removeFromParent();
            this.authoringTool.getUndoRedoStack().stopCompound();
        } else if (this.m_element.getParent() instanceof UserDefinedQuestion) {
            this.authoringTool.getUndoRedoStack().startCompound();
            UserDefinedQuestion parent = (UserDefinedQuestion)this.m_element.getParent();
            int index = parent.getIndexOfChild(this.m_element);
            Object[] questions = this.m_components.getArrayValue();
            int i = 0;
            while (i < questions.length) {
                if (questions[i] instanceof edu.cmu.cs.stage3.alice.core.question.userdefined.Component) {
                    edu.cmu.cs.stage3.alice.core.question.userdefined.Component currentQuestion = (edu.cmu.cs.stage3.alice.core.question.userdefined.Component)questions[i];
                    currentQuestion.removeFromParent();
                    currentQuestion.setParent(parent);
                    parent.components.add(index + i, currentQuestion);
                }
                ++i;
            }
            this.m_element.removeFromParent();
            this.authoringTool.getUndoRedoStack().stopCompound();
        }
    }

    public void prePropertyChange(PropertyEvent propertyEvent) {
    }

    @Override
    public void propertyChanging(PropertyEvent propertyEvent) {
    }

    @Override
    public void propertyChanged(PropertyEvent propertyEvent) {
        if (propertyEvent.getProperty() == this.m_isCommentedOut) {
            this.revalidate();
            this.repaint();
        } else {
            this.updateGUI();
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.backgroundColor = color;
        if (this.containingPanel != null) {
            this.containingPanel.setBackground(this.backgroundColor);
        }
        if (this.headerLabel != null) {
            this.headerLabel.setBackground(this.backgroundColor);
        }
        if (this.headerPanel != null) {
            this.headerPanel.setBackground(this.backgroundColor);
        }
        if (this.componentElementPanel != null) {
            this.componentElementPanel.setBackground(this.backgroundColor);
        }
    }

    protected void generateGUI() {
        this.setOpaque(false);
        this.plus = new ImageIcon(CompositeElementPanel.class.getResource("images/plus.gif"));
        this.minus = new ImageIcon(CompositeElementPanel.class.getResource("images/minus.gif"));
        this.expandButton = new JButton();
        this.expandButton.setContentAreaFilled(false);
        this.expandButton.setMargin(new Insets(0, 0, 0, 0));
        this.expandButton.setFocusPainted(false);
        this.expandButton.setBorderPainted(false);
        this.expandButton.setBorder(null);
        this.expandButton.addActionListener(this.actionListener);
        this.glue = Box.createHorizontalGlue();
        this.addDragSourceComponent(this.glue);
        this.glue.addMouseListener(this.elementMouseListener);
        this.addMouseListener(this.elementMouseListener);
        this.grip.addMouseListener(this.elementMouseListener);
        if (this.headerLabel == null) {
            this.headerLabel = new JLabel();
            this.setHeaderLabel();
            this.headerLabel.setOpaque(false);
            this.headerLabel.addMouseListener(this.elementMouseListener);
            this.addDragSourceComponent(this.headerLabel);
        }
        if (this.containingPanel == null) {
            this.containingPanel = new JPanel();
            this.containingPanel.setLayout(new BorderLayout());
            this.containingPanel.addMouseListener(this.elementMouseListener);
            this.containingPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.containingPanel.setOpaque(false);
            this.addDragSourceComponent(this.containingPanel);
        }
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setLayout(new GridBagLayout());
            this.headerPanel.addMouseListener(this.elementMouseListener);
            this.headerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.headerPanel.setOpaque(false);
            this.addDragSourceComponent(this.headerPanel);
        }
    }

    protected void restoreDrag() {
        this.addDragSourceComponent(this.glue);
        this.addDragSourceComponent(this.headerPanel);
        this.addDragSourceComponent(this.containingPanel);
        this.addDragSourceComponent(this.headerLabel);
    }

    protected void updateGUI() {
        this.containingPanel.removeAll();
        this.headerPanel.removeAll();
        this.restoreDrag();
        if (this.isExpanded) {
            this.expandButton.setIcon(this.minus);
        } else {
            this.expandButton.setIcon(this.plus);
        }
        this.headerPanel.add((Component)this.expandButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.headerPanel.add((Component)this.headerLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add(this.glue, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.containingPanel.add((Component)this.headerPanel, "North");
        if (this.isExpanded) {
            this.containingPanel.add((Component)this.componentElementPanel, "Center");
            if (ResponseEditor.IS_JAVA) {
                this.containingPanel.add((Component)this.closeBrace, "South");
            }
        }
        this.add((Component)this.containingPanel, "Center");
        this.setBackground(this.getCustomBackgroundColor());
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void expandComponentElementPanel() {
        if (!this.isExpanded) {
            this.m_element.data.put(IS_EXPANDED_KEY, Boolean.TRUE);
            this.isExpanded = true;
            this.setHeaderLabel();
            this.expandButton.setIcon(this.minus);
            this.containingPanel.add((Component)this.componentElementPanel, "Center");
            if (ResponseEditor.IS_JAVA) {
                this.containingPanel.add((Component)this.closeBrace, "South");
            }
            this.revalidate();
        }
    }

    public void setHeaderLabel() {
        if (this.headerLabel != null) {
            this.headerLabel.setText(this.headerText);
            if (ResponseEditor.IS_JAVA) {
                if (!this.isExpanded) {
                    this.headerLabel.setText(String.valueOf(this.headerText) + " { " + this.getDots() + " }");
                } else {
                    this.headerLabel.setText(String.valueOf(this.headerText) + " {");
                }
            }
        }
    }

    protected static int getEmptyRows(Object[] elements) {
        int count = 0;
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof CompositeResponse) {
                if (((CompositeResponse)elements[i]).componentResponses.size() == 0) {
                    ++count;
                }
                if (elements[i] instanceof IfElseInOrder && ((IfElseInOrder)elements[i]).elseComponentResponses.size() == 0) {
                    ++count;
                }
            } else if (elements[i] instanceof Composite) {
                if (((Composite)elements[i]).components.size() == 0) {
                    ++count;
                }
                if (elements[i] instanceof IfElse && ((IfElse)elements[i]).elseComponents.size() == 0) {
                    ++count;
                }
            }
            ++i;
        }
        return count;
    }

    protected static int getTotalRowsToRenderForIfElse(Element ifElse, ObjectArrayProperty components) {
        int total = 0;
        Vector<Object> potentiallyEmpty = new Vector<Object>();
        if (ifElse instanceof IfElseInOrder) {
            IfElseInOrder ifElseResponse = (IfElseInOrder)ifElse;
            int i = 0;
            while (i < components.size()) {
                if (components.get(i) instanceof CompositeResponse) {
                    Element[] ds = ((Element)components.get(i)).getDescendants(Response.class);
                    total += ds.length;
                    total += ((Element)components.get(i)).getDescendants(IfElseInOrder.class).length;
                    potentiallyEmpty.addAll(Arrays.asList(((Element)components.get(i)).getDescendants(CompositeResponse.class)));
                    if (CompositeElementEditor.IS_JAVA) {
                        total += ((Element)components.get(i)).getDescendants(CompositeResponse.class).length;
                    }
                } else {
                    ++total;
                }
                ++i;
            }
        } else if (ifElse instanceof IfElse) {
            IfElse ifElseQuestion = (IfElse)ifElse;
            int i = 0;
            while (i < components.size()) {
                ++total;
                if (components.get(i) instanceof IfElse) {
                    ++total;
                }
                if (components.get(i) instanceof Composite) {
                    potentiallyEmpty.add(components.get(i));
                }
                total += ((Element)components.get(i)).getDescendants(edu.cmu.cs.stage3.alice.core.question.userdefined.Component.class).length;
                total += ((Element)components.get(i)).getDescendants(IfElse.class).length;
                potentiallyEmpty.addAll(Arrays.asList(((Element)components.get(i)).getDescendants(Composite.class)));
                if (CompositeElementEditor.IS_JAVA) {
                    total += ((Element)components.get(i)).getDescendants(Composite.class).length;
                }
                ++i;
            }
        }
        int emptyRows = CompositeElementPanel.getEmptyRows(potentiallyEmpty.toArray());
        return total += emptyRows;
    }

    protected String getHTMLColorString(Color color) {
        String r = Integer.toHexString(color.getRed());
        String g = Integer.toHexString(color.getGreen());
        String b = Integer.toHexString(color.getBlue());
        if (r.length() == 1) {
            r = "0" + r;
        }
        if (g.length() == 1) {
            g = "0" + g;
        }
        if (b.length() == 1) {
            b = "0" + b;
        }
        return new String("#" + r + g + b);
    }

    protected String getHeaderHTML() {
        return GUIFactory.getHTMLStringForComponent(this.headerPanel);
    }

    public static int getTotalHTMLRows(Element element) {
        int totalRows = 0;
        if (element instanceof Response) {
            if (element instanceof IfElseInOrder) {
                totalRows = CompositeElementPanel.getTotalRowsToRenderForIfElse(element, ((IfElseInOrder)element).componentResponses);
            } else {
                totalRows = element.getDescendants(Response.class).length - 1;
                totalRows += element.getDescendants(IfElseInOrder.class).length;
                totalRows += CompositeElementPanel.getEmptyRows(element.getDescendants(CompositeResponse.class));
                if (CompositeElementEditor.IS_JAVA) {
                    totalRows += element.getDescendants(CompositeResponse.class).length - 1;
                }
            }
        } else if (element instanceof Composite || element instanceof UserDefinedQuestion) {
            if (element instanceof IfElse) {
                totalRows = CompositeElementPanel.getTotalRowsToRenderForIfElse(element, ((IfElse)element).components);
            } else {
                totalRows = element.getDescendants(edu.cmu.cs.stage3.alice.core.question.userdefined.Component.class).length - 1;
                totalRows += element.getDescendants(IfElse.class).length;
                totalRows += CompositeElementPanel.getEmptyRows(element.getDescendants(Composite.class));
                if (CompositeElementEditor.IS_JAVA) {
                    totalRows += element.getDescendants(Composite.class).length - 1;
                }
            }
        }
        return totalRows;
    }

    public void getHTML(StringBuffer toWriteTo, int colSpan, boolean useColor, boolean isDisabled) {
        int totalRows = 0;
        String colorString = "";
        String borderColorString = this.getHTMLColorString(Color.lightGray);
        String styleString = "";
        String strikeStart = "";
        String strikeEnd = "";
        if (!isDisabled) {
            isDisabled = this.isDisabled();
        }
        if (useColor) {
            colorString = isDisabled ? " bgcolor=\"" + this.getHTMLColorString(AuthoringToolResources.getColor("disabledHTML")) + "\"" : " bgcolor=\"" + this.getHTMLColorString(this.getCustomBackgroundColor()) + "\"";
        }
        if (isDisabled) {
            strikeStart = "<strike><font color=\"" + this.getHTMLColorString(AuthoringToolResources.getColor("disabledHTMLText")) + "\">";
            strikeEnd = "</font></strike>";
        }
        totalRows = CompositeElementPanel.getTotalHTMLRows(this.m_element);
        if (this instanceof MainCompositeQuestionPanel) {
            ++totalRows;
        }
        styleString = " style=\"border-left: 1px solid " + borderColorString + "; border-top: 1px solid " + borderColorString + "; border-right: 1px solid " + borderColorString + "\"";
        toWriteTo.append("<td colspan=\"" + colSpan + "\"" + colorString + styleString + ">&nbsp;&nbsp;");
        toWriteTo.append(String.valueOf(strikeStart) + this.getHeaderHTML() + strikeEnd);
        styleString = this instanceof IfElseElementPanel || CompositeElementEditor.IS_JAVA ? " style=\"border-left: 1px solid " + borderColorString + "\"" : " style=\"border-left: 1px solid " + borderColorString + "; border-bottom: 1px solid " + borderColorString + "\"";
        toWriteTo.append("</td>\n</tr>\n<tr>\n<td width=\"20\" rowspan=\"" + totalRows + "\"" + colorString + styleString + ">&nbsp;&nbsp;&nbsp;&nbsp;</td>\n");
        int i = 0;
        while (i < this.componentElementPanel.getElementComponentCount()) {
            Component currentComponent;
            if (i > 0) {
                toWriteTo.append("<tr>\n");
            }
            if ((currentComponent = this.componentElementPanel.getComponent(i)) instanceof CompositeElementPanel) {
                ((CompositeElementPanel)currentComponent).getHTML(toWriteTo, colSpan - 1, useColor, isDisabled);
            } else {
                boolean isComponentDisabled;
                String componentColorString = "";
                String componentStrikeStart = "";
                String componentStrikeEnd = "";
                boolean bl = isComponentDisabled = isDisabled || ((ComponentElementPanel)currentComponent).isDisabled();
                if (currentComponent instanceof ComponentElementPanel) {
                    if (isComponentDisabled) {
                        componentColorString = " bgcolor=\"" + this.getHTMLColorString(AuthoringToolResources.getColor("disabledHTML")) + "\"";
                        componentStrikeStart = "<strike><font color=\"" + this.getHTMLColorString(AuthoringToolResources.getColor("disabledHTMLText")) + "\">";
                        componentStrikeEnd = "</font></strike>";
                    } else {
                        componentColorString = " bgcolor=\"" + this.getHTMLColorString(((ComponentElementPanel)currentComponent).getCustomBackgroundColor()) + "\"";
                    }
                }
                styleString = " style=\"border-bottom: 1px solid " + borderColorString + "; border-right: 1px solid " + borderColorString + "; border-left: 1px solid " + borderColorString + "; border-top: 1px solid " + borderColorString + "\"";
                toWriteTo.append("<td width=\"100%\" colspan=\"" + (colSpan - 1) + "\"" + componentColorString + styleString + ">&nbsp;&nbsp;" + componentStrikeStart + GUIFactory.getHTMLStringForComponent(currentComponent) + componentStrikeEnd + "</td>\n");
            }
            ++i;
        }
        if (this.componentElementPanel.getElementComponentCount() == 0) {
            styleString = this instanceof IfElseElementPanel || CompositeElementEditor.IS_JAVA ? " style=\"border-right: 1 solid " + borderColorString + "\"" : " style=\"border-right: 1 solid " + borderColorString + "; border-bottom: 1 solid " + borderColorString + "\"";
            toWriteTo.append("<td width=\"100%\" colspan=\"" + (colSpan - 1) + "\"" + colorString + styleString + ">" + strikeStart + Messages.getString("_i__Do_Nothing___i_") + strikeEnd + "</td>\n</tr>\n");
        }
        if (this instanceof MainCompositeQuestionPanel) {
            MainCompositeQuestionPanel mainQuestion = (MainCompositeQuestionPanel)this;
            styleString = " style=\"border-bottom: 1 solid " + borderColorString + "; border-right: 1 solid " + borderColorString + "; border-left: 1 solid " + borderColorString + ";\"";
            colorString = " bgcolor=\"" + this.getHTMLColorString(AuthoringToolResources.getColor("Return")) + "\"";
            toWriteTo.append("<tr>\n<td width=\"100%\" colspan=\"" + colSpan + "\"" + colorString + styleString + ">" + GUIFactory.getHTMLStringForComponent(mainQuestion.returnPanel) + "</td>\n</tr>\n");
        }
        if (this instanceof IfElseElementPanel) {
            IfElseElementPanel ifElse = (IfElseElementPanel)this;
            if (this.m_element instanceof IfElse) {
                totalRows = CompositeElementPanel.getTotalRowsToRenderForIfElse(this.m_element, ((IfElse)this.m_element).elseComponents);
            } else if (this.m_element instanceof IfElseInOrder) {
                totalRows = CompositeElementPanel.getTotalRowsToRenderForIfElse(this.m_element, ((IfElseInOrder)this.m_element).elseComponentResponses);
            }
            styleString = " style=\"border-left: 1 solid " + borderColorString + "; border-right: 1 solid " + borderColorString + "\"";
            toWriteTo.append("<tr>\n<td colspan=\"" + colSpan + "\"" + colorString + styleString + ">&nbsp;&nbsp;" + strikeStart + GUIFactory.getHTMLStringForComponent(((IfElseElementPanel)this).elsePanel) + strikeEnd + "</td>\n");
            styleString = CompositeElementEditor.IS_JAVA ? " style=\"border-left: 1 solid " + borderColorString + "\"" : " style=\"border-left: 1 solid " + borderColorString + "; border-bottom: 1 solid " + borderColorString + "\"";
            toWriteTo.append("</tr>\n<tr>\n<td width=\"20\" rowspan=\"" + totalRows + "\"" + colorString + styleString + ">&nbsp;</td>\n");
            int i2 = 0;
            while (i2 < ifElse.elseComponentPanel.getElementComponentCount()) {
                Component currentComponent;
                if (i2 > 0) {
                    toWriteTo.append("<tr>\n");
                }
                if ((currentComponent = ifElse.elseComponentPanel.getComponent(i2)) instanceof CompositeElementPanel) {
                    ((CompositeElementPanel)currentComponent).getHTML(toWriteTo, colSpan - 1, useColor, isDisabled);
                } else {
                    boolean isComponentDisabled;
                    String componentColorString = "";
                    String componentStrikeStart = "";
                    String componentStrikeEnd = "";
                    boolean bl = isComponentDisabled = isDisabled || ((ComponentElementPanel)currentComponent).isDisabled();
                    if (currentComponent instanceof ComponentElementPanel) {
                        if (isComponentDisabled) {
                            componentColorString = " bgcolor=\"" + this.getHTMLColorString(AuthoringToolResources.getColor("disabledHTML")) + "\"";
                            componentStrikeStart = "<strike><font color=\"" + this.getHTMLColorString(AuthoringToolResources.getColor("disabledHTMLText")) + "\">";
                            componentStrikeEnd = "</font></strike>";
                        } else {
                            componentColorString = " bgcolor=\"" + this.getHTMLColorString(((ComponentElementPanel)currentComponent).getCustomBackgroundColor()) + "\"";
                        }
                    }
                    styleString = " style=\"border-bottom: 1 solid " + borderColorString + "; border-right: 1 solid " + borderColorString + "; border-left: 1 solid " + borderColorString + "; border-top: 1 solid " + borderColorString + "\"";
                    toWriteTo.append("<td colspan=\"" + (colSpan - 1) + "\"" + componentColorString + styleString + ">&nbsp;&nbsp;" + componentStrikeStart + GUIFactory.getHTMLStringForComponent(currentComponent) + componentStrikeEnd + "</td>\n");
                }
                toWriteTo.append("</tr>\n");
                ++i2;
            }
            if (ifElse.elseComponentPanel.getElementComponentCount() == 0) {
                styleString = !CompositeElementEditor.IS_JAVA ? " style=\"border-right: 1 solid " + borderColorString + "; border-bottom: 1 solid " + borderColorString + "\"" : " style=\"border-right: 1 solid " + borderColorString + "\"";
                toWriteTo.append("<td colspan=\"" + (colSpan - 1) + "\"" + colorString + styleString + ">" + strikeStart + Messages.getString("_i__Do_Nothing___i_") + strikeEnd + "</td>\n</tr>\n");
            }
        }
        if (CompositeElementEditor.IS_JAVA) {
            styleString = " style=\"border-left: 1 solid " + borderColorString + "; border-bottom: 1 solid " + borderColorString + "; border-right: 1 solid " + borderColorString + "\"";
            toWriteTo.append("<tr><td colspan=\"" + colSpan + "\"" + colorString + styleString + ">" + strikeStart + "<b>&nbsp;&nbsp;}</b>" + strikeEnd + "</td></tr>");
        }
    }

    public String getDots() {
        String dots = "";
        int i = 0;
        while (i < this.m_components.size()) {
            dots = i == 0 ? String.valueOf(dots) + "." : String.valueOf(dots) + " .";
            ++i;
        }
        return dots;
    }

    public void reduceComponentElementPanel() {
        if (this.isExpanded) {
            this.m_element.data.put(IS_EXPANDED_KEY, Boolean.FALSE);
            this.isExpanded = false;
            this.setHeaderLabel();
            this.expandButton.setIcon(this.plus);
            this.containingPanel.remove(this.componentElementPanel);
            if (ResponseEditor.IS_JAVA) {
                this.containingPanel.remove(this.closeBrace);
            }
            this.revalidate();
        }
    }

    public CompositeComponentElementPanel getComponentPanel() {
        return this.componentElementPanel;
    }

    protected void dndInit() {
    }

    public void addResponsePanel(JComponent toAdd, int position) {
        this.componentElementPanel.addElementPanel(toAdd, position);
    }

    @Override
    public Element getElement() {
        return this.m_element;
    }

    public boolean isDisabled() {
        boolean isEnabledValue = true;
        if (this.m_element instanceof Response) {
            if (((Response)this.m_element).isCommentedOut.get() != null) {
                isEnabledValue = ((Response)this.m_element).isCommentedOut.getBooleanValue() == false;
            }
        } else if (this.m_element instanceof edu.cmu.cs.stage3.alice.core.question.userdefined.Component && ((edu.cmu.cs.stage3.alice.core.question.userdefined.Component)this.m_element).isCommentedOut.get() != null) {
            isEnabledValue = ((edu.cmu.cs.stage3.alice.core.question.userdefined.Component)this.m_element).isCommentedOut.getBooleanValue() == false;
        }
        return !isEnabledValue;
    }

    @Override
    public void paintForeground(Graphics g) {
        super.paintForeground(g);
        if (this.m_element != null && this.isDisabled()) {
            Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            GUIEffects.paintDisabledEffect(g, bounds);
        }
    }
}

