/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.While;
import edu.cmu.cs.stage3.alice.core.response.WhileLoopInOrder;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class WhileElementPanel
extends CompositeElementPanel {
    protected JComponent conditionalInput;
    protected JLabel endHeader;
    protected BooleanProperty m_condition;
    protected static BufferedImage whileLoopBackgroundImage;
    protected static Dimension whileLoopBackgroundImageSize;

    static {
        whileLoopBackgroundImageSize = new Dimension(-1, -1);
    }

    public WhileElementPanel() {
        this.headerText = Messages.getString("While");
        this.backgroundColor = AuthoringToolResources.getColor("WhileLoopInOrder");
    }

    @Override
    protected void variableInit() {
        super.variableInit();
        if (this.m_element instanceof WhileLoopInOrder) {
            WhileLoopInOrder proxy = (WhileLoopInOrder)this.m_element;
            this.m_condition = proxy.condition;
        } else if (this.m_element instanceof While) {
            While proxy = (While)this.m_element;
            this.m_condition = proxy.condition;
        }
    }

    @Override
    protected void startListening() {
        super.startListening();
        if (this.m_condition != null) {
            this.m_condition.addPropertyListener(this);
        }
    }

    @Override
    protected void stopListening() {
        super.stopListening();
        if (this.m_condition != null) {
            this.m_condition.removePropertyListener(this);
        }
    }

    @Override
    public void setHeaderLabel() {
        if (this.headerLabel != null) {
            this.headerLabel.setText(this.headerText);
            if (CompositeElementEditor.IS_JAVA) {
                this.headerLabel.setText("while (");
            }
        }
        if (this.endHeader != null) {
            this.endHeader.setText("");
            if (CompositeElementEditor.IS_JAVA) {
                if (!this.isExpanded) {
                    this.endHeader.setText(") { " + this.getDots() + " }");
                } else {
                    this.endHeader.setText(") {");
                }
            }
        }
    }

    @Override
    protected void generateGUI() {
        super.generateGUI();
        if (this.endHeader == null) {
            this.endHeader = new JLabel();
        }
    }

    @Override
    protected void restoreDrag() {
        super.restoreDrag();
        this.addDragSourceComponent(this.endHeader);
    }

    @Override
    protected void updateGUI() {
        super.updateGUI();
        SetPropertyImmediatelyFactory pif = new SetPropertyImmediatelyFactory(this.m_condition);
        this.conditionalInput = GUIFactory.getPropertyViewController(this.m_condition, true, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_condition), pif);
        this.headerPanel.remove(this.glue);
        this.headerPanel.add((Component)this.conditionalInput, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add((Component)this.endHeader, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add(this.glue, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createBackgroundImage(int width, int height) {
        whileLoopBackgroundImageSize.setSize(width, height);
        whileLoopBackgroundImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)whileLoopBackgroundImage.getGraphics();
        g.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, width, height);
    }

    protected void paintTextureEffect(Graphics g, Rectangle bounds) {
        if (bounds.width > WhileElementPanel.whileLoopBackgroundImageSize.width || bounds.height > WhileElementPanel.whileLoopBackgroundImageSize.height) {
            this.createBackgroundImage(bounds.width, bounds.height);
        }
        g.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
        g.drawImage(whileLoopBackgroundImage, bounds.x, bounds.y, this);
    }
}

