/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor.CompositeResponsePanel;
import edu.cmu.cs.stage3.alice.core.response.DoInOrder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class SequentialResponsePanel
extends CompositeResponsePanel {
    protected static BufferedImage sequentialBackgroundImage;
    protected static Dimension sequentialBackgroundImageSize;

    static {
        sequentialBackgroundImageSize = new Dimension(-1, -1);
    }

    public SequentialResponsePanel() {
        this.headerText = AuthoringToolResources.getReprForValue(DoInOrder.class);
    }

    public void set(DoInOrder r, AuthoringTool authoringToolIn) {
        super.set(r, authoringToolIn);
    }

    @Override
    protected Color getCustomBackgroundColor() {
        return AuthoringToolResources.getColor("DoInOrder");
    }

    @Override
    protected void updateGUI() {
        super.updateGUI();
    }

    protected void createBackgroundImage(int width, int height) {
        sequentialBackgroundImageSize.setSize(width, height);
        sequentialBackgroundImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)sequentialBackgroundImage.getGraphics();
        g.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, width, height);
    }

    protected void paintTextureEffect(Graphics g, Rectangle bounds) {
        if (bounds.width > SequentialResponsePanel.sequentialBackgroundImageSize.width || bounds.height > SequentialResponsePanel.sequentialBackgroundImageSize.height) {
            this.createBackgroundImage(bounds.width, bounds.height);
        }
        g.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
        g.drawImage(sequentialBackgroundImage, bounds.x, bounds.y, this);
    }
}

