/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.sceneeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.JAliceFrame;
import edu.cmu.cs.stage3.alice.authoringtool.editors.sceneeditor.CameraViewPanel;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.GalleryViewer;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.ScriptComboWidget;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.ConfigurationEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.ConfigurationListener;
import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class SceneEditor
extends JPanel
implements Editor {
    private Package authoringToolPackage = Package.getPackage("edu.cmu.cs.stage3.alice.authoringtool");
    public String editorName = Messages.getString("Scene_Editor");
    public static int LARGE_MODE = 1;
    public static int SMALL_MODE = 2;
    protected int guiMode = LARGE_MODE;
    protected World world;
    protected Camera renderCamera = null;
    protected ScriptComboWidget scriptComboWidget = new ScriptComboWidget();
    protected AuthoringTool authoringTool;
    protected Image makeSceneEditorBigImage = AuthoringToolResources.getImageForString("makeSceneEditorBig");
    protected Image makeSceneEditorSmallImage = AuthoringToolResources.getImageForString("makeSceneEditorSmall");
    protected JButton makeSceneEditorBigButton;
    protected JButton makeSceneEditorSmallButton;
    protected HashMap idsToComponents = new HashMap();
    protected HashMap componentsToIds = new HashMap();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel mainPanel = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BevelBorder bevelBorder1 = new BevelBorder(1);
    FlowLayout flowLayout4 = new FlowLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    FlowLayout flowLayout6 = new FlowLayout();
    FlowLayout flowLayout7 = new FlowLayout();
    FlowLayout flowLayout8 = new FlowLayout();
    FlowLayout flowLayout9 = new FlowLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    BorderLayout borderLayout8 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    Border border1;
    Border border2;
    Border border3;
    FlowLayout flowLayout3 = new FlowLayout();
    JPanel topPanel = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout9 = new BorderLayout();
    CameraViewPanel cameraViewPanel = new CameraViewPanel(this);

    public SceneEditor() {
        this.configInit();
        this.jbInit();
        this.guiInit();
    }

    private void configInit() {
        Configuration.addConfigurationListener(new ConfigurationListener(){

            @Override
            public void changing(ConfigurationEvent ev) {
            }

            @Override
            public void changed(ConfigurationEvent ev) {
                if (ev.getKeyName().equals("edu.cmu.cs.stage3.alice.authoringtool.enableScripting")) {
                    if (Configuration.getValue(SceneEditor.this.authoringToolPackage, "enableScripting").equalsIgnoreCase("true")) {
                        SceneEditor.this.topPanel.add((Component)SceneEditor.this.scriptComboWidget, "Center");
                    } else {
                        SceneEditor.this.topPanel.remove(SceneEditor.this.scriptComboWidget);
                    }
                    SceneEditor.this.revalidate();
                    SceneEditor.this.repaint();
                }
            }
        });
    }

    private void guiInit() {
        this.mainPanel.setMinimumSize(new Dimension(0, 0));
        if (Configuration.getValue(this.authoringToolPackage, "enableScripting").equalsIgnoreCase("true")) {
            this.topPanel.add((Component)this.scriptComboWidget, "Center");
        }
        if (AikMin.locale.equalsIgnoreCase("english")) {
            this.makeSceneEditorBigButton = new JButton(new ImageIcon(this.makeSceneEditorBigImage));
            this.makeSceneEditorSmallButton = new JButton(new ImageIcon(this.makeSceneEditorSmallImage));
            this.makeSceneEditorBigButton.setMargin(new Insets(2, 2, 2, 2));
            this.makeSceneEditorSmallButton.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.makeSceneEditorBigButton = new JButton(Messages.getString("Add_Object"));
            this.makeSceneEditorBigButton.setMargin(new Insets(4, 5, 4, 5));
            this.makeSceneEditorBigButton.setForeground(Color.white);
            this.makeSceneEditorSmallButton = new JButton(Messages.getString("Done"));
            this.makeSceneEditorSmallButton.setMargin(new Insets(5, 10, 5, 10));
            this.makeSceneEditorSmallButton.setForeground(Color.white);
        }
        this.makeSceneEditorBigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SceneEditor.this.authoringTool.getJAliceFrame().setGuiMode(JAliceFrame.SCENE_EDITOR_LARGE_MODE);
            }
        });
        this.makeSceneEditorSmallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SceneEditor.this.authoringTool.getJAliceFrame().setGuiMode(JAliceFrame.SCENE_EDITOR_SMALL_MODE);
            }
        });
        this.makeSceneEditorBigButton.setBackground(AuthoringToolResources.getColor("makeSceneEditorBigBackground"));
        this.makeSceneEditorSmallButton.setBackground(AuthoringToolResources.getColor("makeSceneEditorSmallBackground"));
        this.cameraViewPanel.navPanel.add((Component)this.makeSceneEditorBigButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 2, 2), 0, 0));
        this.cameraViewPanel.controlPanel.add((Component)this.makeSceneEditorSmallButton, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 8, 8), 0, 0));
        this.makeSceneEditorBigButton.setToolTipText("<html><font face=arial size=-1>" + Messages.getString("Open_the_Object_Gallery_and_Layout_Tool__p__p_Objects_are_added_to_the_world_from_the_Gallery__p_The_Layout_Tool_has_tools_that_will_help_you_position_objects_in_the_world__p_You_will_not_be_able_to_edit_Methods_or_Events_while_the_Gallery_is_open_") + "</font></html>");
        this.makeSceneEditorSmallButton.setToolTipText("<html><font face=arial size=-1>" + Messages.getString("Close_the_Gallery_and_Layout_Tool__p__p_Closes_the_gallery_and_returns_p_to_the_Method_and_Event_editors_") + "</font></html>");
    }

    public void setGuiMode(int guiMode) {
        if (this.guiMode != guiMode) {
            this.guiMode = guiMode;
            this.cameraViewPanel.setTargetsDirty();
            this.cameraViewPanel.updateMoveCameraCombo();
            this.mainPanel.removeAll();
            if (guiMode == SMALL_MODE) {
                this.cameraViewPanel.setViewMode(0);
                this.cameraViewPanel.navPanel.add((Component)this.makeSceneEditorBigButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 2, 2), 0, 0));
                this.cameraViewPanel.guiNavigator.setImageSize(1);
                this.cameraViewPanel.defaultMoveModeButton.doClick();
                if (this.cameraViewPanel.affectSubpartsCheckBox.isSelected()) {
                    this.cameraViewPanel.affectSubpartsCheckBox.doClick();
                }
                this.mainPanel.add((Component)this.cameraViewPanel.superRenderPanel, "Center");
            } else if (guiMode == LARGE_MODE) {
                this.cameraViewPanel.navPanel.remove(this.makeSceneEditorBigButton);
                this.cameraViewPanel.singleViewButton.doClick();
                this.cameraViewPanel.guiNavigator.setImageSize(2);
                this.cameraViewPanel.add((Component)this.cameraViewPanel.superRenderPanel, "Center");
                this.cameraViewPanel.defaultMoveModeButton.doClick();
                this.mainPanel.add((Component)this.cameraViewPanel, "Center");
            }
        }
    }

    public int getGuiMode() {
        return this.guiMode;
    }

    public void setViewMode(int mode) {
        this.cameraViewPanel.setViewMode(mode);
    }

    public int getViewMode() {
        return this.cameraViewPanel.getViewMode();
    }

    public Dimension getRenderSize() {
        return this.cameraViewPanel.getRenderSize();
    }

    public JPanel getSuperRenderPanel() {
        return this.cameraViewPanel.superRenderPanel;
    }

    public JPanel getRenderPanel() {
        return this.cameraViewPanel.renderPanel;
    }

    public void makeDirty() {
        this.cameraViewPanel.setTargetsDirty();
    }

    public GalleryViewer getGalleryViewer() {
        return this.cameraViewPanel.galleryViewer;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public Object getObject() {
        return this.world;
    }

    public void setObject(World world) {
        this.world = world;
        this.scriptComboWidget.setSandbox(world);
        this.cameraViewPanel.setWorld(world);
        if (world != null) {
            Camera[] cameras = (Camera[])world.getDescendants(Camera.class);
            if (cameras.length > 0) {
                this.renderCamera = cameras[0];
            }
        } else {
            this.renderCamera = null;
        }
    }

    @Override
    public void setAuthoringTool(AuthoringTool authoringTool) {
        if (this.authoringTool != null) {
            this.authoringTool.removeAuthoringToolStateListener(this);
        }
        this.authoringTool = authoringTool;
        this.cameraViewPanel.setAuthoringTool(authoringTool);
        this.cameraViewPanel.renderInit(authoringTool);
        this.stencilInit();
        if (authoringTool != null) {
            authoringTool.addAuthoringToolStateListener(this);
        }
    }

    protected void stencilInit() {
        this.idsToComponents.put("makeSceneEditorBigButton", this.makeSceneEditorBigButton);
        this.idsToComponents.put("makeSceneEditorSmallButton", this.makeSceneEditorSmallButton);
        this.idsToComponents.put("guiNavigatorSlidePanel", this.cameraViewPanel.guiNavigator.getSlidePanel());
        this.idsToComponents.put("guiNavigatorDrivePanel", this.cameraViewPanel.guiNavigator.getDrivePanel());
        this.idsToComponents.put("guiNavigatorTiltPanel", this.cameraViewPanel.guiNavigator.getTiltPanel());
        this.idsToComponents.put("affectSubpartsCheckBox", this.cameraViewPanel.affectSubpartsCheckBox);
        this.idsToComponents.put("aspectRatioComboBox", this.cameraViewPanel.aspectRatioComboBox);
        this.idsToComponents.put("lensAngleSlider", this.cameraViewPanel.lensAngleSlider);
        this.idsToComponents.put("singleViewButton", this.cameraViewPanel.singleViewButton);
        this.idsToComponents.put("quadViewButton", this.cameraViewPanel.quadViewButton);
        this.idsToComponents.put("cameraDummyButton", this.cameraViewPanel.cameraDummyButton);
        this.idsToComponents.put("objectDummyButton", this.cameraViewPanel.objectDummyButton);
        this.idsToComponents.put("moveCameraCombo", this.cameraViewPanel.moveCameraCombo);
        this.idsToComponents.put("defaultMoveModeButton", this.cameraViewPanel.defaultMoveModeButton);
        this.idsToComponents.put("moveUpDownModeButton", this.cameraViewPanel.moveUpDownModeButton);
        this.idsToComponents.put("turnLeftRightModeButton", this.cameraViewPanel.turnLeftRightModeButton);
        this.idsToComponents.put("turnForwardBackwardModeButton", this.cameraViewPanel.turnForwardBackwardModeButton);
        this.idsToComponents.put("tumbleModeButton", this.cameraViewPanel.tumbleModeButton);
        this.idsToComponents.put("copyModeButton", this.cameraViewPanel.copyModeButton);
        this.idsToComponents.put("orthoScrollModeButton", this.cameraViewPanel.orthoScrollModeButton);
        this.idsToComponents.put("orthoZoomInModeButton", this.cameraViewPanel.orthoZoomInModeButton);
        this.idsToComponents.put("superRenderPanel", this.cameraViewPanel.superRenderPanel);
        this.idsToComponents.put("renderPanel", this.cameraViewPanel.renderPanel);
        for (Object key : this.idsToComponents.keySet()) {
            this.componentsToIds.put(this.idsToComponents.get(key), key);
        }
    }

    public String getIdForComponent(Component c) {
        return (String)this.componentsToIds.get(c);
    }

    public Component getComponentForId(String id) {
        return (Component)this.idsToComponents.get(id);
    }

    @Override
    public void stateChanged(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
        if (ev.getCurrentState() == 3) {
            this.cameraViewPanel.deactivate();
        } else if (this.isShowing()) {
            this.cameraViewPanel.activate();
        }
    }

    @Override
    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.activate();
    }

    @Override
    public void stateChanging(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldLoading(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldStarting(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldStopping(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldPausing(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldSaving(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldStarted(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldStopped(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldPaused(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    @Override
    public void worldSaved(AuthoringToolStateChangedEvent ev) {
        this.cameraViewPanel.setTargetsDirty();
    }

    void this_componentShown(ComponentEvent e) {
        this.cameraViewPanel.setTargetsDirty();
        this.cameraViewPanel.activate();
    }

    private void jbInit() {
        this.border1 = BorderFactory.createEmptyBorder(0, 10, 0, 10);
        this.border2 = BorderFactory.createMatteBorder(0, 10, 0, 10, new Color(236, 235, 235));
        this.border3 = BorderFactory.createEmptyBorder(0, 10, 0, 10);
        this.setBackground(new Color(126, 159, 197));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SceneEditor.this.this_componentShown(e);
            }
        });
        this.setLayout(this.borderLayout1);
        this.mainPanel.setBackground(new Color(126, 159, 197));
        this.mainPanel.setMinimumSize(new Dimension(10, 100));
        this.mainPanel.setLayout(this.borderLayout9);
        this.flowLayout4.setHgap(0);
        this.flowLayout4.setVgap(0);
        this.flowLayout3.setAlignment(0);
        this.flowLayout3.setHgap(0);
        this.flowLayout3.setVgap(0);
        this.topPanel.setLayout(this.borderLayout5);
        this.mainPanel.add(this.cameraViewPanel);
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)this.topPanel, "North");
    }
}

