/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.texturemapviewer;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TextureMapViewer
extends JPanel
implements Editor {
    public String editorName = Messages.getString("TextureMap_Viewer");
    protected TextureMap textureMap;
    protected ImagePanel texturePanel = new ImagePanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane textureScrollPane = new JScrollPane();

    public TextureMapViewer() {
        this.jbInit();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public Object getObject() {
        return this.textureMap;
    }

    @Override
    public void setAuthoringTool(AuthoringTool authoringTool) {
    }

    public void setObject(TextureMap textureMap) {
        this.textureMap = textureMap;
        if (textureMap != null) {
            this.texturePanel.setImage(textureMap.image.getImageValue());
        } else {
            this.texturePanel.setImage(null);
        }
        this.texturePanel.revalidate();
        this.texturePanel.repaint();
    }

    @Override
    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void stateChanged(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }

    private void jbInit() {
        this.setLayout(this.borderLayout1);
        this.setBackground(Color.black);
        this.textureScrollPane.getViewport().setBackground(Color.black);
        this.textureScrollPane.setBorder(null);
        this.add((Component)this.textureScrollPane, "Center");
        this.textureScrollPane.getViewport().add((Component)this.texturePanel, null);
    }

    protected class ImagePanel
    extends JPanel {
        Image image;
        int buffer = 5;
        int imageWidth = 0;
        int imageHeight = 0;

        public ImagePanel() {
            this.setBackground(Color.black);
        }

        public void setImage(Image image) {
            this.image = image;
            if (image != null) {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(image, 0);
                try {
                    tracker.waitForAll(1000L);
                    this.imageWidth = image.getWidth(this);
                    this.imageHeight = image.getHeight(this);
                    Dimension size = new Dimension(this.imageWidth + this.buffer * 2, this.imageHeight + this.buffer * 2);
                    this.setMinimumSize(size);
                    this.setPreferredSize(size);
                }
                catch (InterruptedException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Interrupted_while_loading_image_"), e);
                }
            } else {
                Dimension size = new Dimension(this.buffer * 2, this.buffer * 2);
                this.setMinimumSize(size);
                this.setPreferredSize(size);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                g.setColor(Color.white);
                g.drawRect(this.buffer, this.buffer, this.imageWidth + 1, this.imageHeight + 1);
                g.drawImage(this.image, this.buffer + 1, this.buffer + 1, this);
            }
        }
    }
}

