/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.galleryviewer;

import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.GalleryObject;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.GalleryViewer;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ModelInfoContentPane
extends ContentPane {
    GalleryViewer.ObjectXmlData data;
    ImageIcon image;
    JLabel imageLabel;
    JLabel nameLabel;
    JButton addObjectButton;
    JButton cancelButton;
    JPanel detailsPanel;
    String filename;

    public ModelInfoContentPane() {
        this.guiInit();
    }

    @Override
    public String getTitle() {
        return GalleryObject.getDisplayName(this.data.name);
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.addObjectButton.addActionListener(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.addObjectButton.removeActionListener(l);
    }

    @Override
    public void addCancelActionListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    @Override
    public void removeCancelActionListener(ActionListener l) {
        this.cancelButton.removeActionListener(l);
    }

    public void set(GalleryViewer.ObjectXmlData data, ImageIcon image) {
        this.data = data;
        this.image = image;
        if (data.directoryData != null) {
            this.filename = String.valueOf(String.valueOf(data.directoryData.rootNode.rootPath)) + String.valueOf(data.objectFilename);
        } else if (data.parentDirectory != null) {
            this.filename = String.valueOf(String.valueOf(data.parentDirectory.rootNode.rootPath)) + String.valueOf(data.objectFilename);
        }
        this.imageLabel.setIcon(image);
        this.setName(GalleryObject.getDisplayName(data.name));
        this.nameLabel.setText(GalleryObject.getDisplayName(data.name));
        this.buildDetails();
    }

    private void buildDetails() {
        int count = 0;
        this.detailsPanel.removeAll();
        JLabel size = new JLabel(Messages.getString("size_"));
        size.setForeground(GalleryViewer.textColor);
        JLabel sizeDetail = new JLabel(String.valueOf(String.valueOf(String.valueOf(this.data.size))).concat(" kb"));
        sizeDetail.setForeground(GalleryViewer.textColor);
        this.detailsPanel.add((Component)size, new GridBagConstraints(0, count, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.detailsPanel.add((Component)sizeDetail, new GridBagConstraints(1, count, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 4, 0, 0), 0, 0));
        ++count;
        int i = 0;
        while (i < this.data.details.size()) {
            StringObjectPair current = (StringObjectPair)this.data.details.get(i);
            String currentString = current.getString();
            if (currentString.equalsIgnoreCase(Messages.getString("modeledby"))) {
                currentString = Messages.getString("modeled_by");
            } else if (currentString.equalsIgnoreCase(Messages.getString("paintedby"))) {
                currentString = Messages.getString("painted_by");
            } else if (currentString.equalsIgnoreCase(Messages.getString("physicalsize"))) {
                currentString = Messages.getString("physical_size");
            }
            JLabel title = new JLabel(String.valueOf(String.valueOf(currentString)).concat(":"));
            JLabel detail = new JLabel();
            title.setForeground(GalleryViewer.textColor);
            detail.setForeground(GalleryViewer.textColor);
            if (current.getObject() != null && !current.getObject().equals("")) {
                if (current.getObject() instanceof String) {
                    detail.setText(current.getObject().toString());
                    this.detailsPanel.add((Component)title, new GridBagConstraints(0, count, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 0, 0), 0, 0));
                    this.detailsPanel.add((Component)detail, new GridBagConstraints(1, count, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 4, 0, 0), 0, 0));
                    ++count;
                } else if (current.getObject() instanceof Vector) {
                    Vector detailVector = (Vector)current.getObject();
                    JPanel detailContainer = new JPanel();
                    detailContainer.setOpaque(false);
                    detailContainer.setBorder(null);
                    detailContainer.setLayout(new BoxLayout(detailContainer, 1));
                    int index = 0;
                    while (index < detailVector.size()) {
                        String currentDetail;
                        if (detailVector.get(index) != null && detailVector.get(index) instanceof String && !(currentDetail = (String)detailVector.get(index)).equalsIgnoreCase("")) {
                            JLabel detailLabel = new JLabel(currentDetail);
                            detailLabel.setForeground(GalleryViewer.textColor);
                            detailContainer.add(detailLabel);
                        }
                        ++index;
                    }
                    this.detailsPanel.add((Component)title, new GridBagConstraints(0, count, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 0, 0), 0, 0));
                    this.detailsPanel.add((Component)detailContainer, new GridBagConstraints(1, count, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 4, 0, 0), 0, 0));
                    ++count;
                }
            }
            ++i;
        }
        this.detailsPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, count, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void guiInit() {
        this.setBackground(GalleryObject.BACKGROUND);
        this.imageLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.nameLabel.setForeground(GalleryViewer.textColor);
        this.detailsPanel = new JPanel();
        this.detailsPanel.setOpaque(false);
        this.detailsPanel.setLayout(new GridBagLayout());
        this.addObjectButton = new JButton(Messages.getString("Add_instance_to_world"));
        this.cancelButton = new JButton(Messages.getString("Cancel"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this.imageLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 20, 20), 0, 0));
        this.add((Component)this.addObjectButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 6, 6, 2), 0, 0));
        this.add((Component)this.cancelButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 2, 6, 6), 0, 0));
        this.add((Component)this.detailsPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 2, 2, 6), 0, 0));
    }

    public String getFilename() {
        return this.filename;
    }
}

