/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.galleryviewer;

import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.GalleryObject;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.GalleryViewer;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Image;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;

public class WebGalleryObject
extends GalleryObject {
    protected boolean needToWriteThumbnail = false;

    @Override
    protected String getToolTipString() {
        return "<html><body><p>" + Messages.getString("Object") + "</p><p>" + Messages.getString("Click_to_add_this_object_to_the_world") + "</p></body></html>";
    }

    @Override
    protected void guiInit() {
        super.guiInit();
        this.location = Messages.getString("the_Web");
    }

    public static Image retrieveImage(String root, String filename, long timestamp) {
        String imageFilename = String.valueOf(root) + filename;
        boolean needToLoad = false;
        ImageIcon toReturn = null;
        if (imageFilename != null) {
            String cacheFilename = String.valueOf(GalleryViewer.cacheDir) + GalleryViewer.reverseWebReady(filename);
            File cachedImageFile = new File(cacheFilename);
            if (cachedImageFile.exists() && cachedImageFile.canRead()) {
                if (cachedImageFile.lastModified() == timestamp) {
                    toReturn = new ImageIcon(cacheFilename);
                } else {
                    needToLoad = true;
                }
            } else {
                needToLoad = true;
            }
            if (needToLoad) {
                try {
                    URL imageURL = new URL(imageFilename);
                    toReturn = new ImageIcon(imageURL);
                }
                catch (Exception e) {
                    toReturn = null;
                }
            }
            if (toReturn.getIconHeight() < 10 || toReturn.getIconWidth() < 10) {
                toReturn = null;
            }
        }
        return toReturn.getImage();
    }

    @Override
    public void loadImage() {
        String tempFilename = null;
        if (this.data != null && this.data.imageFilename != null) {
            tempFilename = String.valueOf(this.rootPath) + this.data.imageFilename;
        }
        final String imageFilename = tempFilename;
        Runnable doLoad = new Runnable(){

            @Override
            public void run() {
                String cacheFilename = null;
                if (imageFilename != null) {
                    cacheFilename = String.valueOf(GalleryViewer.cacheDir) + GalleryViewer.reverseWebReady(WebGalleryObject.this.data.imageFilename);
                    File cachedImageFile = new File(cacheFilename);
                    if (cachedImageFile.exists() && cachedImageFile.canRead()) {
                        if (cachedImageFile.lastModified() == WebGalleryObject.this.data.timeStamp) {
                            WebGalleryObject.this.image = new ImageIcon(cacheFilename);
                        } else {
                            WebGalleryObject.this.needToWriteThumbnail = true;
                        }
                    } else {
                        WebGalleryObject.this.needToWriteThumbnail = true;
                    }
                    if (WebGalleryObject.this.needToWriteThumbnail) {
                        try {
                            URL imageURL = new URL(imageFilename);
                            WebGalleryObject.this.image = new ImageIcon(imageURL);
                        }
                        catch (Exception e) {
                            WebGalleryObject.this.image = GalleryViewer.noImageIcon;
                        }
                    }
                } else {
                    WebGalleryObject.this.image = GalleryViewer.noImageIcon;
                    WebGalleryObject.this.needToWriteThumbnail = false;
                }
                if (WebGalleryObject.this.image.getIconHeight() < 10 || WebGalleryObject.this.image.getIconWidth() < 10) {
                    WebGalleryObject.this.image = GalleryViewer.noImageIcon;
                    WebGalleryObject.this.needToWriteThumbnail = false;
                }
                WebGalleryObject.this.setImage(WebGalleryObject.this.image);
                if (WebGalleryObject.this.needToWriteThumbnail && cacheFilename != null) {
                    WebGalleryObject.storeThumbnail(cacheFilename, WebGalleryObject.this.image.getImage(), WebGalleryObject.this.data.timeStamp);
                }
            }
        };
        Thread t = new Thread(doLoad);
        t.start();
    }
}

