/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.importers;

import edu.cmu.cs.stage3.alice.authoringtool.AbstractImporter;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.BackslashConverterFilterInputStream;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Module;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.geometry.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.core.response.DoTogether;
import edu.cmu.cs.stage3.alice.gallery.ModelFixer;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.image.ImageIO;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.AxisAngle;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector4;
import edu.cmu.cs.stage3.pratt.maxkeyframing.BezierSpline;
import edu.cmu.cs.stage3.pratt.maxkeyframing.CatmullRomSpline;
import edu.cmu.cs.stage3.pratt.maxkeyframing.KeyframeResponse;
import edu.cmu.cs.stage3.pratt.maxkeyframing.LinearSpline;
import edu.cmu.cs.stage3.pratt.maxkeyframing.PositionKeyframeResponse;
import edu.cmu.cs.stage3.pratt.maxkeyframing.QuaternionKey;
import edu.cmu.cs.stage3.pratt.maxkeyframing.QuaternionKeyframeResponse;
import edu.cmu.cs.stage3.pratt.maxkeyframing.QuaternionSlerpSpline;
import edu.cmu.cs.stage3.pratt.maxkeyframing.QuaternionTCBKey;
import edu.cmu.cs.stage3.pratt.maxkeyframing.ScaleKeyframeResponse;
import edu.cmu.cs.stage3.pratt.maxkeyframing.TCBSpline;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Vector3BezierKey;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Vector3SimpleKey;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Vector3TCBKey;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.vecmath.Vector3d;

public class ASEImporter
extends AbstractImporter {
    protected StreamTokenizer tokenizer;
    protected HashMap modelsToParentStrings;
    protected HashMap namesToModels;
    protected HashMap namesToMaterials;
    protected HashMap modelsToMaterialIndices;
    protected HashMap modelsToKeyframeAnims;
    protected ArrayList models;
    protected Material[] materials = null;
    protected int firstFrame;
    protected int lastFrame;
    protected int frameSpeed;
    protected int ticksPerFrame;
    protected double timeScaleFactor;
    protected String currentObject = Messages.getString("_none_");
    protected String currentlyLoading = Messages.getString("_none_");
    protected int currentProgress = 0;
    protected ProgressDialog progressDialog;
    protected static Configuration importersConfig = Configuration.getLocalConfiguration(ASEImporter.class.getPackage());

    static {
        if (importersConfig.getValue("aseImporter.useSpecular") == null) {
            importersConfig.setValue("aseImporter.useSpecular", "false");
        }
        if (importersConfig.getValue("aseImporter.colorToWhiteWhenTextured") == null) {
            importersConfig.setValue("aseImporter.colorToWhiteWhenTextured", "true");
        }
        if (importersConfig.getValue("aseImporter.groupMultipleRootObjects") == null) {
            importersConfig.setValue("aseImporter.groupMultipleRootObjects", "true");
        }
        if (importersConfig.getValue("aseImporter.createNormalsIfNoneExist") == null) {
            importersConfig.setValue("aseImporter.createNormalsIfNoneExist", "true");
        }
        if (importersConfig.getValue("aseImporter.createUVsIfNoneExist") == null) {
            importersConfig.setValue("aseImporter.createUVsIfNoneExist", "true");
        }
    }

    @Override
    public Map getExtensionMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ASE", Messages.getString("3D_Studio_ascii_export"));
        return map;
    }

    @Override
    protected Element load(InputStream is, String ext) throws IOException {
        ArrayList<Transformable> rootModels;
        Sandbox element;
        block49: {
            BackslashConverterFilterInputStream bcfis = new BackslashConverterFilterInputStream(is);
            BufferedReader br = new BufferedReader(new InputStreamReader(bcfis));
            this.tokenizer = new StreamTokenizer(br);
            this.tokenizer.eolIsSignificant(false);
            this.tokenizer.lowerCaseMode(false);
            this.tokenizer.parseNumbers();
            this.tokenizer.wordChars(42, 42);
            this.tokenizer.wordChars(95, 95);
            this.tokenizer.wordChars(58, 58);
            this.modelsToParentStrings = new HashMap();
            this.namesToModels = new HashMap();
            this.namesToMaterials = new HashMap();
            this.modelsToMaterialIndices = new HashMap();
            this.modelsToKeyframeAnims = new HashMap();
            this.models = new ArrayList();
            this.progressDialog = new ProgressDialog();
            this.progressDialog.start();
            try {
                while (true) {
                    this.tokenizer.nextToken();
                    if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*SCENE")) {
                        this.currentObject = Messages.getString("scene_info");
                        this.parseSceneInfo();
                        this.currentObject = Messages.getString("_none_");
                        continue;
                    }
                    if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*GEOMOBJECT")) {
                        this.currentObject = Messages.getString("unnamed_object");
                        this.parseGeomObject();
                        this.currentObject = Messages.getString("_none_");
                        continue;
                    }
                    if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*HELPEROBJECT")) {
                        this.currentObject = Messages.getString("unnamed_helper_object");
                        this.parseHelperObject();
                        this.currentObject = Messages.getString("_none_");
                        continue;
                    }
                    if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL_LIST")) {
                        this.currentObject = Messages.getString("material_list");
                        this.parseMaterialList();
                        this.currentObject = Messages.getString("_none_");
                        continue;
                    }
                    if (this.tokenizer.ttype == -1) break;
                }
            }
            catch (IOException e) {
                AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Error_parsing_ASE__IOException_caught_at_line_")) + this.tokenizer.lineno(), e);
                return null;
            }
            catch (InvalidFormatError e) {
                AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Error_parsing_ASE__Invalid_Format__")) + e.getMessage() + Messages.getString("__at_line_") + this.tokenizer.lineno(), e, false);
                return null;
            }
            element = null;
            rootModels = new ArrayList<Transformable>();
            for (Transformable model : this.models) {
                String parentString = (String)this.modelsToParentStrings.get(model);
                if (parentString == null) {
                    rootModels.add(model);
                    model.isFirstClass.set(Boolean.TRUE);
                    continue;
                }
                Transformable parent = (Transformable)this.namesToModels.get(parentString);
                if (parent == null) {
                    AuthoringTool.showErrorDialog(model.name.getValue() + Messages.getString("_s_parent__") + parentString + Messages.getString("__does_not_exist___putting_it_at_the_top_level___"), null);
                    rootModels.add(model);
                    model.isFirstClass.set(Boolean.TRUE);
                    continue;
                }
                parent.addChild(model);
                parent.parts.add(model);
                model.vehicle.set(parent);
                model.isFirstClass.set(Boolean.FALSE);
            }
            if (rootModels.size() == 1) {
                element = (Transformable)rootModels.get(0);
                break block49;
            }
            if (rootModels.size() > 1) {
                if (importersConfig.getValue("aseImporter.groupMultipleRootObjects").equalsIgnoreCase("true")) {
                    element = new Model();
                    element.name.set(null);
                    element.isFirstClass.set(Boolean.TRUE);
                    for (Transformable model : rootModels) {
                        element.addChild(model);
                        ((Model)element).parts.add(model);
                        model.vehicle.set((Model)element);
                        model.isFirstClass.set(Boolean.FALSE);
                    }
                } else {
                    element = new Module();
                    element.name.set(null);
                    for (Transformable model : rootModels) {
                        element.addChild(model);
                        model.isFirstClass.set(Boolean.TRUE);
                    }
                }
                break block49;
            }
            if (rootModels.size() >= 1) break block49;
            return null;
        }
        try {
            String currentName = (String)element.name.getValue();
            if (currentName == null) {
                element.name.set(this.plainName);
            } else if (!currentName.equalsIgnoreCase(this.plainName)) {
                element.name.set(String.valueOf(this.plainName) + "_" + currentName);
            }
            Transformable dummyScene = new Transformable();
            if (element instanceof Model) {
                Sandbox trans = element;
                ((Transformable)trans).vehicle.set(dummyScene);
                this.currentObject = (String)((Transformable)trans).name.getValue();
                this.currentlyLoading = Messages.getString("fixing_transformations");
                this.fixTransformations((Transformable)trans, dummyScene);
                this.currentObject = (String)((Transformable)trans).name.getValue();
                this.currentlyLoading = Messages.getString("fixing_vertices");
                this.fixVertices((Transformable)trans);
                this.currentlyLoading = Messages.getString("_none_");
                ((Transformable)trans).vehicle.set(null);
                ((Transformable)trans).localTransformation.set(MathUtilities.createIdentityMatrix4d());
            } else {
                Element[] children = element.getChildren();
                int i = 0;
                while (i < children.length) {
                    Transformable trans = (Transformable)children[i];
                    trans.vehicle.set(dummyScene);
                    this.currentObject = (String)trans.name.getValue();
                    this.currentlyLoading = Messages.getString("fixing_transformations");
                    this.fixTransformations(trans, dummyScene);
                    this.currentObject = (String)trans.name.getValue();
                    this.currentlyLoading = Messages.getString("fixing_vertices");
                    this.fixVertices(trans);
                    this.currentlyLoading = Messages.getString("_none_");
                    trans.vehicle.set(null);
                    ++i;
                }
            }
            for (Transformable trans : this.models) {
                int materialIndex;
                if (!(trans instanceof Model)) continue;
                Model model = (Model)trans;
                try {
                    materialIndex = (Integer)this.modelsToMaterialIndices.get(model);
                }
                catch (NullPointerException e) {
                    materialIndex = -1;
                }
                if (materialIndex >= 0 && materialIndex < this.materials.length) {
                    Material material = this.materials[materialIndex];
                    if (material == null) continue;
                    if (material.diffuseTexture != null && importersConfig.getValue("aseImporter.colorToWhiteWhenTextured").equalsIgnoreCase("true")) {
                        model.ambientColor.set(Color.WHITE);
                        model.color.set(Color.WHITE);
                    } else {
                        model.ambientColor.set(material.ambient);
                        model.color.set(material.diffuse);
                    }
                    if (importersConfig.getValue("aseImporter.useSpecular").equalsIgnoreCase("true")) {
                        model.specularHighlightColor.set(material.specular);
                        model.specularHighlightExponent.set(new Double(material.shine + 1.0));
                    }
                    model.opacity.set(new Double(1.0 - material.transparency));
                    model.diffuseColorMap.set(material.diffuseTexture);
                    model.opacityMap.set(material.opacityTexture);
                    model.specularHighlightColorMap.set(material.shineTexture);
                    model.bumpMap.set(material.bumpTexture);
                    continue;
                }
                if (materialIndex == -1) continue;
                AuthoringTool.showErrorDialog(model.name.getValue() + " " + Messages.getString("referenced_a_material_index_out_of_range___no_material_properties_assigned_"), null);
            }
            int i = 0;
            while (i < this.materials.length) {
                if (this.materials[i] != null) {
                    Transformable materialOwner = null;
                    if (element instanceof Transformable) {
                        materialOwner = (Transformable)element;
                    } else {
                        for (Transformable trans : this.models) {
                            try {
                                int materialIndex = (Integer)this.modelsToMaterialIndices.get(trans);
                                if (materialIndex != i) continue;
                                materialOwner = this.getRootModel(trans);
                                break;
                            }
                            catch (NullPointerException materialIndex) {
                                // empty catch block
                            }
                        }
                    }
                    if (materialOwner != null) {
                        if (this.materials[i].diffuseTexture != null) {
                            materialOwner.addChild(this.materials[i].diffuseTexture);
                            materialOwner.textureMaps.add(this.materials[i].diffuseTexture);
                        }
                        if (this.materials[i].opacityTexture != null) {
                            materialOwner.addChild(this.materials[i].opacityTexture);
                            materialOwner.textureMaps.add(this.materials[i].diffuseTexture);
                        }
                        if (this.materials[i].shineTexture != null) {
                            materialOwner.addChild(this.materials[i].shineTexture);
                            materialOwner.textureMaps.add(this.materials[i].shineTexture);
                        }
                        if (this.materials[i].bumpTexture != null) {
                            materialOwner.addChild(this.materials[i].bumpTexture);
                            materialOwner.textureMaps.add(this.materials[i].bumpTexture);
                        }
                    } else {
                        AuthoringTool.showErrorDialog(Messages.getString("ASEImporter_Error__no_materialOwner_to_attach_textures_to_"), null);
                    }
                }
                ++i;
            }
            for (Transformable root : rootModels) {
                DoTogether rootAnim = new DoTogether();
                rootAnim.name.set("keyframeAnimation");
                for (Transformable trans : this.models) {
                    ArrayList anims;
                    if (!trans.isDescendantOf(root) && !trans.equals(root) || (anims = (ArrayList)this.modelsToKeyframeAnims.get(trans)) == null) continue;
                    String prefix = AuthoringToolResources.getReprForValue(trans);
                    prefix = prefix.replace('.', '_');
                    for (KeyframeResponse anim : anims) {
                        anim.duration.set(null);
                        String baseName = anim.name.getStringValue();
                        anim.name.set(String.valueOf(prefix) + "_" + baseName);
                        anim.subject.set(trans);
                        rootAnim.addChild(anim);
                        rootAnim.componentResponses.add(anim);
                    }
                }
                if (rootAnim.componentResponses.isEmpty()) continue;
                root.addChild(rootAnim);
                root.responses.add(rootAnim);
            }
        }
        catch (Throwable t) {
            AuthoringTool.showErrorDialog(Messages.getString("An_unexpected_error_occured_while_loading_an_ASE_"), t);
        }
        this.progressDialog.stop();
        this.progressDialog.setVisible(false);
        this.progressDialog.dispose();
        this.tokenizer = null;
        this.modelsToParentStrings = null;
        this.namesToModels = null;
        this.namesToMaterials = null;
        this.modelsToMaterialIndices = null;
        this.modelsToKeyframeAnims = null;
        this.models = null;
        this.materials = null;
        return element;
    }

    protected Transformable getRootModel(Transformable trans) {
        Element parent = trans.getParent();
        if (!(parent instanceof Transformable)) {
            return trans;
        }
        return this.getRootModel((Transformable)parent);
    }

    protected void fixTransformations(Transformable root, Transformable scene) {
        root.setTransformationRightNow(root.getLocalTransformation(), scene);
        Element[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Transformable) {
                this.fixTransformations((Transformable)children[i], scene);
            }
            ++i;
        }
    }

    protected void fixVertices(Transformable root) {
        this.currentObject = (String)root.name.getValue();
        if (root instanceof Model && ((Model)root).geometry.getValue() instanceof IndexedTriangleArray) {
            IndexedTriangleArray geom = (IndexedTriangleArray)((Model)root).geometry.getValue();
            Vertex3d[] vertices = (Vertex3d[])geom.vertices.getValue();
            if (vertices != null) {
                this.progressDialog.setMax(vertices.length - 1);
                this.currentProgress = 0;
                int i = 0;
                while (i < vertices.length) {
                    this.currentProgress = i;
                    Vector4 v = new Vector4(vertices[i].position.x, vertices[i].position.y, vertices[i].position.z, 1.0);
                    Vector4 vprime = Vector4.multiply(v, root.getSceneGraphReferenceFrame().getInverseAbsoluteTransformation());
                    vertices[i].position.set(vprime.x, vprime.y, vprime.z);
                    ++i;
                }
                geom.vertices.set(vertices);
            }
        }
        Element[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Transformable) {
                this.fixVertices((Transformable)children[i]);
            }
            ++i;
        }
    }

    protected String parseString() throws InvalidFormatError, IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype == 34) {
            return this.tokenizer.sval;
        }
        throw new InvalidFormatError(Messages.getString("String_value_expected"));
    }

    protected int parseInt() throws InvalidFormatError, IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype == -2) {
            return (int)this.tokenizer.nval;
        }
        throw new InvalidFormatError(Messages.getString("int_value_expected"));
    }

    protected double parseDouble() throws InvalidFormatError, IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype == -2) {
            return this.tokenizer.nval;
        }
        throw new InvalidFormatError(Messages.getString("double_value_expected"));
    }

    protected float parseFloat() throws InvalidFormatError, IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype == -2) {
            return (float)this.tokenizer.nval;
        }
        throw new InvalidFormatError(Messages.getString("double_value_expected"));
    }

    protected void parseUnknownBlock() throws InvalidFormatError, IOException {
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.ttype == 123) {
                this.parseUnknownBlock();
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished_block"));
    }

    protected void parseSceneInfo() throws IOException {
        this.firstFrame = 0;
        this.lastFrame = 0;
        this.frameSpeed = 0;
        this.ticksPerFrame = 0;
        this.timeScaleFactor = 1.0;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__SCENE"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*SCENE_FIRSTFRAME")) {
                this.firstFrame = this.parseInt();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*SCENE_LASTFRAME")) {
                this.lastFrame = this.parseInt();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*SCENE_FRAMESPEED")) {
                this.frameSpeed = this.parseInt();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*SCENE_TICKSPERFRAME")) {
                this.ticksPerFrame = this.parseInt();
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                try {
                    this.timeScaleFactor = 1.0 / (double)this.ticksPerFrame * (1.0 / (double)this.frameSpeed);
                }
                catch (Exception e) {
                    this.timeScaleFactor = 1.0;
                }
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__SCENE"));
    }

    protected void parseMaterialList() throws InvalidFormatError, IOException {
        int count = 0;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__MATERIAL_LIST"));
        }
        this.currentProgress = 0;
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL_COUNT")) {
                count = this.parseInt();
                this.materials = new Material[count];
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL")) {
                if (count < 1) {
                    throw new InvalidFormatError(Messages.getString("material_declared_before_number_of_materials_defined"));
                }
                this.parseMaterial();
                this.currentObject = Messages.getString("_none_");
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__MESH_VERTEX_LIST"));
    }

    protected void parseMaterial() throws InvalidFormatError, IOException {
        Material material = new Material();
        int index = this.parseInt();
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__MATERIAL__n_"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL_NAME")) {
                material.name = this.tokenizer.sval;
                this.namesToMaterials.put(material.name, material);
                this.currentObject = material.name;
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL_AMBIENT")) {
                material.ambient = new Color(this.parseDouble(), this.parseDouble(), this.parseDouble());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL_DIFFUSE")) {
                material.diffuse = new Color(this.parseDouble(), this.parseDouble(), this.parseDouble());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL_SPECULAR")) {
                material.specular = new Color(this.parseDouble(), this.parseDouble(), this.parseDouble());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL_SHINE")) {
                material.shine = this.parseDouble();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL_SHINESTRENGTH")) {
                material.shinestrength = this.parseDouble();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL_TRANSPARENCY")) {
                material.transparency = this.parseDouble();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MAP_AMBIENT")) {
                material.ambientTexture = this.parseMap();
                this.currentObject = material.name;
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MAP_DIFFUSE")) {
                material.diffuseTexture = this.parseMap();
                this.currentObject = material.name;
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MAP_SHINE")) {
                material.shineTexture = this.parseMap();
                this.currentObject = material.name;
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MAP_SHINESTRENGTH")) {
                material.shineStrengthTexture = this.parseMap();
                this.currentObject = material.name;
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MAP_SELFILLUM")) {
                material.selfIllumTexture = this.parseMap();
                this.currentObject = material.name;
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MAP_OPACITY")) {
                material.opacityTexture = this.parseMap();
                this.currentObject = material.name;
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MAP_BUMP")) {
                material.bumpTexture = this.parseMap();
                this.currentObject = material.name;
                continue;
            }
            if (this.tokenizer.ttype == 123) {
                this.parseUnknownBlock();
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                this.materials[index] = material;
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__MATERIAL"));
    }

    /*
     * Unable to fully structure code
     */
    protected TextureMap parseMap() throws InvalidFormatError, IOException {
        texture = null;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__MAP__map_type_"));
        }
        while (true) {
            block47: {
                block50: {
                    block48: {
                        block49: {
                            this.tokenizer.nextToken();
                            if (this.tokenizer.sval == null || !this.tokenizer.sval.equalsIgnoreCase("*BITMAP")) break block47;
                            this.currentObject = filename = this.parseString();
                            imageFile = new File(filename);
                            justName = imageFile.getName();
                            extension = justName.substring(justName.lastIndexOf(46) + 1);
                            bis = null;
                            if (!imageFile.exists()) break block48;
                            if (!imageFile.canRead()) break block49;
                            bis = new BufferedInputStream(new FileInputStream(imageFile));
                            break block50;
                        }
                        AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Cannot_read_from_file__")) + filename + " " + Messages.getString("specified_on_line_") + this.tokenizer.lineno(), null, false);
                        continue;
                    }
                    location = this.getLocation();
                    if (!(location instanceof File)) ** GOTO lbl36
                    imageFile = new File((File)location, filename);
                    if (!imageFile.exists()) {
                        imageFile = new File((File)location, justName);
                    }
                    if (!imageFile.exists()) ** GOTO lbl34
                    if (imageFile.canRead()) {
                        bis = new BufferedInputStream(new FileInputStream(imageFile));
                    } else {
                        AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Cannot_read_from_file__")) + filename + " " + Messages.getString("specified_on_line_") + this.tokenizer.lineno(), null, false);
                        continue;
lbl34:
                        // 1 sources

                        AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Unable_to_find_file__")) + filename + " " + Messages.getString("specified_on_line_") + this.tokenizer.lineno(), null, false);
                        continue;
lbl36:
                        // 1 sources

                        if (location instanceof URL) {
                            name = new StringBuffer();
                            chars = new char[justName.length()];
                            justName.getChars(0, justName.length(), chars, 0);
                            i = 0;
                            while (i < chars.length) {
                                c = chars[i];
                                if (c == ' ') {
                                    name.append("%20");
                                } else if (c == '#') {
                                    name.append("%23");
                                } else if (c == ';') {
                                    name.append("%3B");
                                } else if (c == '@') {
                                    name.append("%40");
                                } else if (c == '&') {
                                    name.append("%26");
                                } else if (c == '=') {
                                    name.append("%3D");
                                } else if (c == '+') {
                                    name.append("%2B");
                                } else if (c == '$') {
                                    name.append("%24");
                                } else if (c == ',') {
                                    name.append("%2C");
                                } else if (c == '%') {
                                    name.append("%25");
                                } else if (c == '\"') {
                                    name.append("%22");
                                } else if (c == '{') {
                                    name.append("%7B");
                                } else if (c == '}') {
                                    name.append("%7D");
                                } else if (c == '^') {
                                    name.append("%5E");
                                } else if (c == '[') {
                                    name.append("%5B");
                                } else if (c == ']') {
                                    name.append("%5D");
                                } else if (c == '`') {
                                    name.append("%60");
                                } else {
                                    name.append(c);
                                }
                                ++i;
                            }
                            url = (URL)location;
                            url = new URL(String.valueOf(url.toExternalForm()) + name.toString());
                            bis = new BufferedInputStream(url.openStream());
                        } else {
                            AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("location_is_not_a_File_or_URL__")) + location, null, false);
                        }
                    }
                }
                if (bis == null) {
                    AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("BufferedInputStream_is_null_for_")) + filename, null);
                    continue;
                }
                codec = ImageIO.mapExtensionToCodecName(extension);
                if (codec == null) {
                    AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Can_t_find_appropriate_codec_for_")) + filename, null);
                    continue;
                }
                image = ImageIO.load(codec, bis);
                if (image == null) {
                    AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Image_loaded_is_null_for_")) + filename, null);
                    continue;
                }
                textureName = justName.substring(0, justName.indexOf(46));
                texture = new TextureMap();
                if (image instanceof BufferedImage && (bi = (BufferedImage)image).getColorModel().hasAlpha()) {
                    texture.format.set(new Integer(3));
                }
                texture.name.set(textureName);
                texture.image.set(image);
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return texture;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__MAP_DIFFUSE"));
    }

    protected void parseHelperObject() throws IOException {
        Model helper = new Model();
        helper.isFirstClass.set(Boolean.FALSE);
        this.models.add(helper);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__HELPEROBJECT"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*NODE_NAME")) {
                helper.name.set(this.parseString());
                this.namesToModels.put(helper.name.getValue(), helper);
                this.currentObject = (String)helper.name.getValue();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*NODE_PARENT")) {
                this.modelsToParentStrings.put(helper, this.parseString());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*NODE_TM")) {
                this.currentlyLoading = Messages.getString("transformation");
                this.currentProgress = 0;
                helper.localTransformation.set(this.parseTransformation());
                this.currentProgress = 0;
                this.currentlyLoading = Messages.getString("_none_");
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*TM_ANIMATION")) {
                ArrayList anims = this.parseAnimationNode();
                this.modelsToKeyframeAnims.put(helper, anims);
                continue;
            }
            if (this.tokenizer.ttype == 123) {
                this.parseUnknownBlock();
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__HELPEROBJECT"));
    }

    protected void parseGeomObject() throws IOException {
        Model model = new Model();
        model.isFirstClass.set(Boolean.FALSE);
        this.models.add(model);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__GEOMOBJECT"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*NODE_NAME")) {
                model.name.set(this.parseString());
                this.namesToModels.put(model.name.getValue(), model);
                this.currentObject = (String)model.name.getValue();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*NODE_PARENT")) {
                this.modelsToParentStrings.put(model, this.parseString());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*NODE_TM")) {
                this.currentlyLoading = Messages.getString("transformation");
                this.currentProgress = 0;
                model.localTransformation.set(this.parseTransformation());
                this.currentProgress = 0;
                this.currentlyLoading = Messages.getString("_none_");
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH")) {
                this.currentlyLoading = Messages.getString("mesh");
                this.currentProgress = 0;
                model.geometry.set(this.parseMesh());
                model.geometry.getElementValue().setParent(model);
                model.geometry.getElementValue().name.set(AuthoringToolResources.getNameForNewChild("__ita__", model));
                this.currentProgress = 0;
                this.currentlyLoading = Messages.getString("_none_");
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*PROP_CASTSHADOW") || this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*PROP_RECVSHADOW")) continue;
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MATERIAL_REF")) {
                this.modelsToMaterialIndices.put(model, new Integer(this.parseInt()));
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*TM_ANIMATION")) {
                ArrayList anims = this.parseAnimationNode();
                this.modelsToKeyframeAnims.put(model, anims);
                continue;
            }
            if (this.tokenizer.ttype == 123) {
                this.parseUnknownBlock();
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__GEOMOBJECT"));
    }

    protected Matrix44 parseTransformation() throws InvalidFormatError, IOException {
        Matrix44 m = new Matrix44();
        Matrix33 rot = new Matrix33();
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__NODE_TM"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*TM_ROW0")) {
                rot.m00 = this.parseDouble();
                rot.m01 = this.parseDouble();
                rot.m02 = this.parseDouble();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*TM_ROW1")) {
                rot.m10 = this.parseDouble();
                rot.m11 = this.parseDouble();
                rot.m12 = this.parseDouble();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*TM_ROW2")) {
                rot.m20 = this.parseDouble();
                rot.m21 = this.parseDouble();
                rot.m22 = this.parseDouble();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*TM_ROW3")) {
                m.m30 = -this.parseDouble();
                m.m32 = -this.parseDouble();
                m.m31 = this.parseDouble();
                continue;
            }
            if (this.tokenizer.ttype == 123) {
                this.parseUnknownBlock();
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                m.m00 = rot.m00;
                m.m01 = -rot.m02;
                m.m02 = rot.m01;
                m.m10 = -rot.m20;
                m.m11 = rot.m22;
                m.m12 = -rot.m21;
                m.m20 = rot.m10;
                m.m21 = -rot.m12;
                m.m22 = rot.m11;
                return m;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__NODE_TM"));
    }

    protected IndexedTriangleArray parseMesh() throws InvalidFormatError, IOException {
        IndexedTriangleArray geometry = new IndexedTriangleArray();
        Vertex3d[] verts = null;
        int[] coordIndices = null;
        int[] uvIndices = null;
        double[] coordinates = null;
        double[] normals = null;
        float[] uvs = null;
        Object colors = null;
        int numVerts = -1;
        int numUVs = -1;
        int numFaces = -1;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__MESH"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_NUMVERTEX")) {
                numVerts = this.parseInt();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_NUMFACES")) {
                numFaces = this.parseInt();
                coordIndices = new int[numFaces * 3];
                uvIndices = new int[numFaces * 3];
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_NUMTVERTEX")) {
                numUVs = this.parseInt();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_VERTEX_LIST")) {
                if (numVerts < 0) {
                    throw new InvalidFormatError(Messages.getString("illegal_number_of_vertices_defined_or_coordinates_declared_before_number_of_vertices_defined"));
                }
                coordinates = new double[numVerts * 3];
                this.currentlyLoading = Messages.getString("coordinates");
                this.progressDialog.setMax(numVerts);
                this.parseVertexList(coordinates);
                this.currentlyLoading = Messages.getString("mesh");
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_TVERTLIST")) {
                if (numUVs < 0) {
                    throw new InvalidFormatError(Messages.getString("uvs_declared_before_number_of_texture_vertices_defined"));
                }
                uvs = new float[numUVs * 2];
                this.currentlyLoading = "uvs";
                this.progressDialog.setMax(numUVs);
                this.parseUVList(uvs);
                this.currentlyLoading = Messages.getString("mesh");
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_NORMALS")) {
                if (numVerts < 0) {
                    throw new InvalidFormatError(Messages.getString("normals_declared_before_number_of_vertices_defined"));
                }
                normals = new double[numFaces * 3 * 3];
                this.currentlyLoading = Messages.getString("normals");
                this.progressDialog.setMax(numFaces);
                this.parseNormals(normals);
                this.currentlyLoading = Messages.getString("mesh");
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_FACE_LIST")) {
                if (coordIndices == null) {
                    throw new InvalidFormatError(Messages.getString("faces_declared_before_number_of_faces_defined"));
                }
                this.currentlyLoading = Messages.getString("coordinate_indices");
                this.progressDialog.setMax(coordIndices.length / 3);
                this.parseFaceList(coordIndices);
                this.currentlyLoading = Messages.getString("mesh");
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_TFACELIST")) {
                if (uvIndices == null) {
                    throw new InvalidFormatError(Messages.getString("texture_faces_declared_before_number_of_faces_defined"));
                }
                this.currentlyLoading = Messages.getString("texture_indices");
                this.progressDialog.setMax(uvIndices.length / 3);
                this.parseUVFaceList(uvIndices);
                this.currentlyLoading = Messages.getString("mesh");
                continue;
            }
            if (this.tokenizer.ttype == 123) {
                this.parseUnknownBlock();
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                if (numVerts > 0 && coordIndices != null) {
                    int vertexFormat = 0;
                    if (coordinates != null) {
                        vertexFormat |= 1;
                    }
                    if (normals != null || importersConfig.getValue("aseImporter.createNormalsIfNoneExist").equalsIgnoreCase("true")) {
                        vertexFormat |= 2;
                    }
                    if (uvs != null || importersConfig.getValue("aseImporter.createUVsIfNoneExist").equalsIgnoreCase("true")) {
                        vertexFormat |= 0x10;
                    }
                    if (colors != null) {
                        vertexFormat |= 4;
                    }
                    verts = new Vertex3d[numFaces * 3];
                    int i = 0;
                    while (i < numFaces * 3) {
                        verts[i] = new Vertex3d(vertexFormat);
                        ++i;
                    }
                    int[] indices = new int[numFaces * 3];
                    int i2 = 0;
                    while (i2 < numFaces * 3) {
                        indices[i2] = i2;
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < numFaces) {
                        int j = 0;
                        while (j < 3) {
                            if (coordinates != null) {
                                verts[i2 * 3 + j].position.x = coordinates[coordIndices[i2 * 3 + j] * 3 + 0];
                                verts[i2 * 3 + j].position.y = coordinates[coordIndices[i2 * 3 + j] * 3 + 1];
                                verts[i2 * 3 + j].position.z = coordinates[coordIndices[i2 * 3 + j] * 3 + 2];
                            }
                            if (normals != null) {
                                verts[i2 * 3 + j].normal.x = normals[i2 * 9 + j * 3 + 0];
                                verts[i2 * 3 + j].normal.y = normals[i2 * 9 + j * 3 + 1];
                                verts[i2 * 3 + j].normal.z = normals[i2 * 9 + j * 3 + 2];
                            }
                            if (uvs != null) {
                                verts[i2 * 3 + j].textureCoordinate0.x = uvs[uvIndices[i2 * 3 + j] * 2 + 0];
                                verts[i2 * 3 + j].textureCoordinate0.y = uvs[uvIndices[i2 * 3 + j] * 2 + 1];
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    geometry.vertices.set(verts);
                    geometry.indices.set(indices);
                    if (normals == null && importersConfig.getValue("aseImporter.createNormalsIfNoneExist").equalsIgnoreCase("true")) {
                        ModelFixer.calculateNormals(geometry);
                    }
                }
                return geometry;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__MESH"));
    }

    protected void parseVertexList(double[] coordinates) throws InvalidFormatError, IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__MESH_VERTEX_LIST"));
        }
        this.currentProgress = 0;
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_VERTEX")) {
                int index = this.parseInt();
                coordinates[index * 3 + 0] = -this.parseDouble();
                coordinates[index * 3 + 2] = -this.parseDouble();
                coordinates[index * 3 + 1] = this.parseDouble();
                ++this.currentProgress;
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__MESH_VERTEX_LIST"));
    }

    protected void parseUVList(float[] uvs) throws InvalidFormatError, IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__MESH_TVERTLIST"));
        }
        this.currentProgress = 0;
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_TVERT")) {
                int index = this.parseInt();
                uvs[index * 2 + 0] = this.parseFloat();
                uvs[index * 2 + 1] = this.parseFloat();
                ++this.currentProgress;
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__MESH_TVERTLIST"));
    }

    protected void parseNormals(double[] normals) throws InvalidFormatError, IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__MESH_NORMALS"));
        }
        int face = 0;
        int v = 0;
        this.currentProgress = 0;
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_VERTEXNORMAL")) {
                int index = this.parseInt();
                int realv = v;
                if (v == 1) {
                    realv = 2;
                }
                if (v == 2) {
                    realv = 1;
                }
                normals[face * 9 + realv * 3 + 0] = -this.parseDouble();
                normals[face * 9 + realv * 3 + 2] = -this.parseDouble();
                normals[face * 9 + realv * 3 + 1] = this.parseDouble();
                if (++v == 3) {
                    v = 0;
                    ++face;
                }
                ++this.currentProgress;
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__MESH_NORMALS"));
    }

    protected void parseVertexColors(double[] colors) {
    }

    protected void parseFaceList(int[] indices) throws InvalidFormatError, IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__MESH_FACE_LIST"));
        }
        this.currentProgress = 0;
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_FACE")) {
                this.parseMeshFace(indices);
                ++this.currentProgress;
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__MESH_FACE_LIST"));
    }

    protected void parseMeshFace(int[] indices) throws InvalidFormatError, IOException {
        int index = this.parseInt();
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("A:")) {
                indices[index * 3 + 0] = this.parseInt();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("B:")) {
                indices[index * 3 + 2] = this.parseInt();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("C:")) {
                indices[index * 3 + 1] = this.parseInt();
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_FACE")) {
                this.tokenizer.pushBack();
                return;
            }
            if (this.tokenizer.ttype == 125) {
                this.tokenizer.pushBack();
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__MESH_FACE"));
    }

    protected void parseUVFaceList(int[] indices) throws InvalidFormatError, IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__MESH_TFACELIST"));
        }
        this.currentProgress = 0;
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*MESH_TFACE")) {
                int index = this.parseInt();
                indices[index * 3 + 0] = this.parseInt();
                indices[index * 3 + 2] = this.parseInt();
                indices[index * 3 + 1] = this.parseInt();
                ++this.currentProgress;
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__MESH_TFACELIST"));
    }

    protected ArrayList parseAnimationNode() throws InvalidFormatError, IOException {
        ArrayList<KeyframeResponse> anims = new ArrayList<KeyframeResponse>();
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__TM_ANIMATION"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_POS_LINEAR")) {
                anims.add(this.parseLinearPositionAnimation());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_POS_BEZIER")) {
                anims.add(this.parseBezierPositionAnimation());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_POS_TCB")) {
                anims.add(this.parseTCBPositionAnimation());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_ROT_LINEAR")) {
                anims.add(this.parseLinearQuaternionAnimation());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_ROT_BEZIER")) {
                anims.add(this.parseBezierQuaternionAnimation());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_ROT_TCB")) {
                anims.add(this.parseTCBQuaternionAnimation());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_SCALE_LINEAR") || this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_SCALE_BEZIER") || this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_SCALE_TCB")) continue;
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_POS_TRACK")) {
                anims.add(this.parseSampledPositionAnimation());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_ROT_TRACK")) {
                anims.add(this.parseSampledQuaternionAnimation());
                continue;
            }
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_SCALE_TRACK")) continue;
            if (this.tokenizer.ttype == 123) {
                this.parseUnknownBlock();
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return anims;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__TM_ANIMATION"));
    }

    protected KeyframeResponse parseLinearPositionAnimation() throws InvalidFormatError, IOException {
        PositionKeyframeResponse keyframeResponse = new PositionKeyframeResponse();
        keyframeResponse.name.set("linearPositionKeyframeAnim");
        LinearSpline spline = new LinearSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_POS_LINEAR"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_POS_KEY")) {
                double time = this.parseDouble() * this.timeScaleFactor;
                double x = -this.parseDouble();
                double z = -this.parseDouble();
                double y = this.parseDouble();
                spline.addKey(new Vector3SimpleKey(time, new Vector3d(x, y, z)));
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_POS_LINEAR"));
    }

    protected KeyframeResponse parseBezierPositionAnimation() throws InvalidFormatError, IOException {
        PositionKeyframeResponse keyframeResponse = new PositionKeyframeResponse();
        keyframeResponse.name.set("bezierPositionKeyframeAnim");
        BezierSpline spline = new BezierSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_POS_BEZIER"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_BEZIER_POS_KEY")) {
                double time = this.parseDouble() * this.timeScaleFactor;
                double x = -this.parseDouble();
                double z = -this.parseDouble();
                double y = this.parseDouble();
                double intan_x = -this.parseDouble();
                double intan_z = -this.parseDouble();
                double intan_y = this.parseDouble();
                double outtan_x = -this.parseDouble();
                double outtan_z = -this.parseDouble();
                double outtan_y = this.parseDouble();
                spline.addKey(new Vector3BezierKey(time, new Vector3d(x, y, z), new Vector3d(intan_x, intan_y, intan_z), new Vector3d(outtan_x, outtan_y, outtan_z)));
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                spline.convertMAXTangentsToBezierTangents(this.timeScaleFactor);
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_POS_BEZIER"));
    }

    protected KeyframeResponse parseTCBPositionAnimation() throws InvalidFormatError, IOException {
        PositionKeyframeResponse keyframeResponse = new PositionKeyframeResponse();
        keyframeResponse.name.set("tcbPositionKeyframeAnim");
        TCBSpline spline = new TCBSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_POS_TCB"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_TCB_POS_KEY")) {
                double time = this.parseDouble() * this.timeScaleFactor;
                double x = -this.parseDouble();
                double z = -this.parseDouble();
                double y = this.parseDouble();
                double tension = this.parseDouble();
                double continuity = this.parseDouble();
                double bias = this.parseDouble();
                double easeIn = this.parseDouble();
                double easeOut = this.parseDouble();
                spline.addKey(new Vector3TCBKey(time, new Vector3d(x, y, z), tension, continuity, bias));
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_POS_TCB"));
    }

    protected KeyframeResponse parseLinearQuaternionAnimation() throws InvalidFormatError, IOException {
        QuaternionKeyframeResponse keyframeResponse = new QuaternionKeyframeResponse();
        keyframeResponse.name.set("quaternionKeyframeAnim");
        QuaternionSlerpSpline spline = new QuaternionSlerpSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_ROT_LINEAR"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_ROT_KEY")) {
                double time = this.parseDouble() * this.timeScaleFactor;
                double axis_x = -this.parseDouble();
                double axis_z = -this.parseDouble();
                double axis_y = this.parseDouble();
                double angle = -this.parseDouble();
                spline.addKey(new QuaternionKey(time, new Quaternion(new AxisAngle(axis_x, axis_y, axis_z, angle))));
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_ROT_LINEAR"));
    }

    protected KeyframeResponse parseBezierQuaternionAnimation() throws InvalidFormatError, IOException {
        QuaternionKeyframeResponse keyframeResponse = new QuaternionKeyframeResponse();
        keyframeResponse.name.set("quaternionKeyframeAnim");
        QuaternionSlerpSpline spline = new QuaternionSlerpSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_ROT_BEZIER"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_ROT_KEY")) {
                double time = this.parseDouble() * this.timeScaleFactor;
                double axis_x = -this.parseDouble();
                double axis_z = -this.parseDouble();
                double axis_y = this.parseDouble();
                double angle = -this.parseDouble();
                spline.addKey(new QuaternionKey(time, new Quaternion(new AxisAngle(axis_x, axis_y, axis_z, angle))));
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_ROT_BEZIER"));
    }

    protected KeyframeResponse parseTCBQuaternionAnimation() throws InvalidFormatError, IOException {
        QuaternionKeyframeResponse keyframeResponse = new QuaternionKeyframeResponse();
        keyframeResponse.name.set("tcbQuaternionKeyframeAnim");
        TCBSpline spline = new TCBSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_ROT_TCB"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_TCB_ROT_KEY")) {
                double time = this.parseDouble() * this.timeScaleFactor;
                double axis_x = -this.parseDouble();
                double axis_z = -this.parseDouble();
                double axis_y = this.parseDouble();
                double angle = -this.parseDouble();
                double tension = this.parseDouble();
                double continuity = this.parseDouble();
                double bias = this.parseDouble();
                double easeIn = this.parseDouble();
                double easeOut = this.parseDouble();
                spline.addKey(new QuaternionTCBKey(time, new Quaternion(new AxisAngle(axis_x, axis_y, axis_z, angle)), tension, continuity, bias));
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                spline.correctForMAXRelativeKeys();
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_ROT_TCB"));
    }

    protected KeyframeResponse parseLinearScaleAnimation() throws InvalidFormatError, IOException {
        ScaleKeyframeResponse keyframeResponse = new ScaleKeyframeResponse();
        keyframeResponse.name.set("linearScaleKeyframeAnim");
        LinearSpline spline = new LinearSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_SCALE_LINEAR"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_SCALE_KEY")) continue;
            if (this.tokenizer.ttype == 125) {
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_SCALE_LINEAR"));
    }

    protected KeyframeResponse parseBezierScaleAnimation() throws InvalidFormatError, IOException {
        ScaleKeyframeResponse keyframeResponse = new ScaleKeyframeResponse();
        keyframeResponse.name.set("bezierScaleKeyframeAnim");
        BezierSpline spline = new BezierSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_SCALE_BEZIER"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_BEZIER_SCALE_KEY")) continue;
            if (this.tokenizer.ttype == 125) {
                spline.convertMAXTangentsToBezierTangents(this.timeScaleFactor);
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_SCALE_BEZIER"));
    }

    protected KeyframeResponse parseTCBScaleAnimation() throws InvalidFormatError, IOException {
        ScaleKeyframeResponse keyframeResponse = new ScaleKeyframeResponse();
        keyframeResponse.name.set("tcbScaleKeyframeAnim");
        TCBSpline spline = new TCBSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_SCALE_TCB"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_TCB_SCALE_KEY")) continue;
            if (this.tokenizer.ttype == 125) {
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_SCALE_TCB"));
    }

    protected KeyframeResponse parseSampledPositionAnimation() throws InvalidFormatError, IOException {
        PositionKeyframeResponse keyframeResponse = new PositionKeyframeResponse();
        keyframeResponse.name.set("sampledPositionAnim");
        CatmullRomSpline spline = new CatmullRomSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_POS_TRACK"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_POS_SAMPLE")) {
                double time = this.parseDouble() * this.timeScaleFactor;
                double x = -this.parseDouble();
                double z = -this.parseDouble();
                double y = this.parseDouble();
                spline.addKey(new Vector3SimpleKey(time, new Vector3d(x, y, z)));
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_POS_TRACK"));
    }

    protected KeyframeResponse parseSampledQuaternionAnimation() throws InvalidFormatError, IOException {
        QuaternionKeyframeResponse keyframeResponse = new QuaternionKeyframeResponse();
        keyframeResponse.name.set("sampledQuaternionAnim");
        QuaternionSlerpSpline spline = new QuaternionSlerpSpline();
        keyframeResponse.spline.set(spline);
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != 123) {
            throw new InvalidFormatError(Messages.getString("Block_expected_after__CONTROL_ROT_TRACK"));
        }
        while (true) {
            this.tokenizer.nextToken();
            if (this.tokenizer.sval != null && this.tokenizer.sval.equalsIgnoreCase("*CONTROL_ROT_SAMPLE")) {
                double time = this.parseDouble() * this.timeScaleFactor;
                double axis_x = -this.parseDouble();
                double axis_z = -this.parseDouble();
                double axis_y = this.parseDouble();
                double angle = -this.parseDouble();
                spline.addKey(new QuaternionKey(time, new Quaternion(new AxisAngle(axis_x, axis_y, axis_z, angle))));
                continue;
            }
            if (this.tokenizer.ttype == 125) {
                spline.correctForMAXRelativeKeys();
                return keyframeResponse;
            }
            if (this.tokenizer.ttype == -1) break;
        }
        throw new InvalidFormatError(Messages.getString("unfinished__CONTROL_ROT_TRACK"));
    }

    class InvalidFormatError
    extends Error {
        public InvalidFormatError(String s) {
            super(s);
        }
    }

    private class Material {
        public String name;
        public Color ambient;
        public Color diffuse;
        public Color specular;
        public double shine;
        public double shinestrength;
        public double transparency;
        public TextureMap ambientTexture = null;
        public TextureMap diffuseTexture = null;
        public TextureMap shineTexture = null;
        public TextureMap shineStrengthTexture = null;
        public TextureMap selfIllumTexture = null;
        public TextureMap opacityTexture = null;
        public TextureMap bumpTexture = null;

        private Material() {
        }
    }

    class ProgressDialog
    extends JDialog {
        protected JLabel linesLabel;
        protected JLabel objectLabel;
        protected JLabel progressLabel;
        protected JProgressBar progressBar;
        protected JPanel progressPanel;
        protected Timer timer;

        public ProgressDialog() {
            super((Frame)null, Messages.getString("Importing___"), false);
            this.linesLabel = new JLabel(Messages.getString("Lines_read__0"));
            this.objectLabel = new JLabel(Messages.getString("Object___none_"));
            this.progressLabel = new JLabel(Messages.getString("Loading__none___"));
            this.progressBar = new JProgressBar();
            this.progressPanel = new JPanel();
            this.timer = null;
            this.progressBar.setMinimum(0);
            this.linesLabel.setAlignmentX(0.0f);
            this.objectLabel.setAlignmentX(0.0f);
            this.progressPanel.setAlignmentX(0.0f);
            this.progressPanel.setLayout(new BorderLayout());
            this.progressPanel.add("West", this.progressLabel);
            this.progressPanel.add("Center", this.progressBar);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(this.linesLabel);
            this.getContentPane().add(this.objectLabel);
            this.getContentPane().add(this.progressPanel);
            this.setDefaultCloseOperation(0);
            this.timer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ProgressDialog.this.linesLabel.setText(String.valueOf(Messages.getString("Lines_read__")) + ((ProgressDialog)ProgressDialog.this).ASEImporter.this.tokenizer.lineno());
                    ProgressDialog.this.objectLabel.setText(String.valueOf(Messages.getString("Object__")) + ((ProgressDialog)ProgressDialog.this).ASEImporter.this.currentObject);
                    ProgressDialog.this.progressLabel.setText(String.valueOf(Messages.getString("Loading_")) + ((ProgressDialog)ProgressDialog.this).ASEImporter.this.currentlyLoading + ": ");
                    ProgressDialog.this.progressBar.setValue(((ProgressDialog)ProgressDialog.this).ASEImporter.this.currentProgress);
                }
            });
            this.pack();
            this.setVisible(true);
        }

        public void start() {
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }

        public void setMax(int max) {
            this.progressBar.setMaximum(max);
        }
    }
}

