/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.importers;

import edu.cmu.cs.stage3.alice.authoringtool.AbstractImporter;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.image.ImageIO;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ImageImporter
extends AbstractImporter {
    @Override
    public Map getExtensionMap() {
        HashMap<String, String> knownCodecPrettyNames = new HashMap<String, String>();
        knownCodecPrettyNames.put("BMP", Messages.getString("Windows_Bitmap"));
        knownCodecPrettyNames.put("GIF", Messages.getString("Graphic_Interchange_Format"));
        knownCodecPrettyNames.put("JPEG", Messages.getString("Joint_Photographic_Experts_Group_format"));
        knownCodecPrettyNames.put("PNG", Messages.getString("Portable_Network_Graphics_format"));
        knownCodecPrettyNames.put("TIFF", Messages.getString("Tagged_Image_File_Format"));
        HashMap<String, String> map = new HashMap<String, String>();
        String[] codecNames = ImageIO.getCodecNames();
        int i = 0;
        while (i < codecNames.length) {
            String prettyName = (String)knownCodecPrettyNames.get(codecNames[i].toUpperCase());
            if (prettyName == null) {
                prettyName = codecNames[i];
            }
            String[] extensions = ImageIO.getExtensionsForCodec(codecNames[i]);
            int j = 0;
            while (j < extensions.length) {
                map.put(extensions[j].toUpperCase(), prettyName);
                ++j;
            }
            ++i;
        }
        return map;
    }

    @Override
    protected Element load(InputStream istream, String ext) throws IOException {
        BufferedImage bi;
        String codecName = ImageIO.mapExtensionToCodecName(ext);
        if (codecName == null) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Unsupported_Extension__")) + ext);
        }
        BufferedInputStream bis = istream instanceof BufferedInputStream ? (BufferedInputStream)istream : new BufferedInputStream(istream);
        Image image = ImageIO.load(codecName, bis);
        TextureMap texture = new TextureMap();
        if (image instanceof BufferedImage && (bi = (BufferedImage)image).getColorModel().hasAlpha()) {
            texture.format.set(new Integer(3));
        }
        texture.name.set(this.plainName);
        texture.image.set(image);
        return texture;
    }
}

