/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.importers.mocap;

import edu.cmu.cs.stage3.alice.authoringtool.AbstractImporter;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.importers.mocap.ASFBone;
import edu.cmu.cs.stage3.alice.authoringtool.importers.mocap.ASFImporter;
import edu.cmu.cs.stage3.alice.authoringtool.importers.mocap.ASFSkeleton;
import edu.cmu.cs.stage3.alice.authoringtool.importers.mocap.MocapImporterOptionsDialog;
import edu.cmu.cs.stage3.alice.authoringtool.util.BackslashConverterFilterInputStream;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Pose;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.io.EStreamTokenizer;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

public class AMCImporter
extends AbstractImporter {
    protected ASFSkeleton skel = null;
    private static final World scene = new World();
    protected Model applyTo = null;
    protected double fps = 30.0;
    protected int nativeFPS = 60;
    protected String animationName = "motionCaptureAnimation";
    protected String AMCPath = "";

    @Override
    public Map getExtensionMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("AMC", "Acclaim Motion Capture");
        return map;
    }

    @Override
    public Element load(String filename) throws IOException {
        this.animationName = new File(filename).getName();
        this.animationName = this.animationName.substring(0, this.animationName.lastIndexOf(46));
        if (this.animationName.lastIndexOf(46) != -1) {
            this.animationName = this.animationName.substring(this.animationName.lastIndexOf(46) + 1);
        }
        this.AMCPath = new File(filename).getAbsolutePath();
        this.AMCPath = this.AMCPath.substring(0, this.AMCPath.indexOf(new File(filename).getName()));
        return super.load(filename);
    }

    @Override
    public Element load(File file) throws IOException {
        this.animationName = file.getName();
        this.animationName = this.animationName.substring(0, this.animationName.lastIndexOf(46));
        if (this.animationName.lastIndexOf(46) != -1) {
            this.animationName = this.animationName.substring(this.animationName.lastIndexOf(46) + 1);
        }
        this.AMCPath = file.getAbsolutePath();
        this.AMCPath = this.AMCPath.substring(0, this.AMCPath.indexOf(file.getName()));
        return super.load(file);
    }

    @Override
    public Element load(URL url) throws IOException {
        String externalForm = url.toExternalForm();
        String fullName = externalForm.substring(externalForm.lastIndexOf(47) + 1);
        this.animationName = fullName.substring(0, fullName.lastIndexOf(46));
        if (this.animationName.lastIndexOf(46) != -1) {
            this.animationName = this.animationName.substring(this.animationName.lastIndexOf(46) + 1);
        }
        return super.load(url);
    }

    @Override
    protected Element load(InputStream is, String ext) throws IOException {
        BackslashConverterFilterInputStream bcfis = new BackslashConverterFilterInputStream(is);
        BufferedReader br = new BufferedReader(new InputStreamReader(bcfis));
        EStreamTokenizer tokenizer = new EStreamTokenizer(br);
        tokenizer.commentChar(35);
        tokenizer.eolIsSignificant(false);
        tokenizer.lowerCaseMode(true);
        tokenizer.parseNumbers();
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(58, 58);
        String ASFfilename = "";
        String ASFpath = "";
        double dt = 1.0 / (double)this.nativeFPS;
        while (tokenizer.ttype != -3 || !tokenizer.sval.equals(":degrees")) {
            if (tokenizer.ttype != -3) {
                tokenizer.nextToken();
                continue;
            }
            if (tokenizer.sval.equals(":asf-file")) {
                tokenizer.nextToken();
                ASFfilename = tokenizer.sval;
            } else if (tokenizer.sval.equals(":asf-path")) {
                tokenizer.nextToken();
                ASFpath = tokenizer.sval;
            } else if (tokenizer.sval.equals(":samples-per-second")) {
                tokenizer.nextToken();
                this.nativeFPS = (int)tokenizer.nval;
                dt = 1.0 / (double)this.nativeFPS;
            }
            tokenizer.nextToken();
        }
        File ASFfile = new File("");
        if (!ASFfilename.equals("") && !(ASFfile = new File(ASFfilename)).isFile()) {
            String temp;
            int previ = 0;
            int i = ASFpath.indexOf(";");
            while (i != -1) {
                temp = ASFpath.substring(previ, i - 1);
                if (!temp.endsWith(File.separator) && !temp.equals("")) {
                    temp = temp.concat(File.separator);
                }
                if ((ASFfile = new File(temp.concat(ASFfilename))).isFile()) break;
                previ = i + 1;
                i = ASFpath.indexOf(";", i + 1);
            }
            if (!ASFfile.isFile()) {
                temp = ASFpath.substring(previ);
                if (!temp.endsWith(File.separator) && !temp.equals("")) {
                    temp = temp.concat(File.separator);
                }
                ASFfile = new File(temp.concat(ASFfilename));
            }
            if (!ASFfile.isFile()) {
                temp = this.AMCPath;
                if (!temp.endsWith(File.separator) && !temp.equals("")) {
                    temp = temp.concat(File.separator);
                }
                ASFfile = new File(temp.concat(ASFfilename));
            }
        }
        MocapImporterOptionsDialog optionsDialog = new MocapImporterOptionsDialog();
        if (ASFfile.isFile()) {
            optionsDialog.setASFFile(ASFfile.getPath());
            optionsDialog.setASFPath(ASFfile.getParentFile());
        } else {
            optionsDialog.setASFPath(new File(this.AMCPath));
        }
        optionsDialog.setNativeFPS(this.nativeFPS);
        optionsDialog.pack();
        optionsDialog.setVisible(true);
        if (!optionsDialog.ok) {
            return null;
        }
        this.applyTo = (Model)optionsDialog.getSelectedPart();
        ASFfile = new File(optionsDialog.getASFFile());
        this.fps = optionsDialog.getFPS();
        this.nativeFPS = optionsDialog.getNativeFPS();
        dt = 1.0 / (double)this.nativeFPS;
        if (!ASFfile.isFile()) {
            return null;
        }
        FileInputStream ASFis = new FileInputStream(ASFfile);
        this.skel = new ASFImporter().loadSkeleton(ASFis);
        ((InputStream)ASFis).close();
        int samplenumber = 0;
        if (this.applyTo == null) {
            this.applyTo = this.skel.getRoot().model;
        }
        this.skel.setBasePose(this.applyTo);
        tokenizer.nextToken();
        while (tokenizer.ttype != -1) {
            samplenumber = (int)tokenizer.nval;
            tokenizer.nextToken();
            while (tokenizer.ttype == -3) {
                ASFBone bone = (ASFBone)this.skel.bones_dict.get(tokenizer.sval);
                tokenizer.nextToken();
                bone.position = (Vector3)bone.base_position.clone();
                bone.axis = new Matrix33();
                ListIterator li2 = bone.dof.listIterator();
                while (li2.hasNext()) {
                    Integer d = (Integer)li2.next();
                    if (!d.equals(ASFBone.DOF_L)) {
                        if (d.equals(ASFBone.DOF_TX)) {
                            bone.position.x = tokenizer.nval * this.skel.lengthscale;
                        } else if (d.equals(ASFBone.DOF_TY)) {
                            bone.position.y = tokenizer.nval * this.skel.lengthscale;
                        } else if (d.equals(ASFBone.DOF_TZ)) {
                            bone.position.z = -tokenizer.nval * this.skel.lengthscale;
                        } else if (d.equals(ASFBone.DOF_RX)) {
                            bone.axis.rotateX(-tokenizer.nval * this.skel.anglescale);
                        } else if (d.equals(ASFBone.DOF_RY)) {
                            bone.axis.rotateY(-tokenizer.nval * this.skel.anglescale);
                        } else if (d.equals(ASFBone.DOF_RZ)) {
                            bone.axis.rotateZ(tokenizer.nval * this.skel.anglescale);
                        }
                    }
                    tokenizer.nextToken();
                }
                if (!(bone.lastTime + 1.0 / this.fps <= (double)(samplenumber - 1) * dt)) continue;
                bone.lastTime = (double)(samplenumber - 1) * dt;
                bone.hasFrame = true;
            }
            this.skel.addFrames();
        }
        UserDefinedResponse anim = this.skel.buildAnim();
        Pose[] poses = this.skel.buildPoses();
        anim.name.set(AuthoringToolResources.getNameForNewChild(this.animationName, this.applyTo));
        poses[0].name.set(AuthoringToolResources.getNameForNewChild(String.valueOf(this.animationName) + "_startPose", this.applyTo));
        poses[1].name.set(AuthoringToolResources.getNameForNewChild(String.valueOf(this.animationName) + "_endPose", this.applyTo));
        this.applyTo.responses.add(anim);
        this.applyTo.misc.add(poses[0]);
        this.applyTo.misc.add(poses[1]);
        this.applyTo.addChild(anim);
        this.applyTo.addChild(poses[0]);
        this.applyTo.addChild(poses[1]);
        if (this.applyTo == this.skel.getRoot().model) {
            this.applyTo.name.set("MocapSkeleton");
        }
        return this.applyTo;
    }
}

