/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.importers.mocap;

import edu.cmu.cs.stage3.alice.authoringtool.importers.mocap.BoneSelectDialog;
import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Pose;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.geometry.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.pratt.maxkeyframing.CatmullRomSpline;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Key;
import edu.cmu.cs.stage3.pratt.maxkeyframing.PositionKeyframeResponse;
import edu.cmu.cs.stage3.pratt.maxkeyframing.QuaternionKey;
import edu.cmu.cs.stage3.pratt.maxkeyframing.QuaternionKeyframeResponse;
import edu.cmu.cs.stage3.pratt.maxkeyframing.QuaternionSlerpSpline;
import edu.cmu.cs.stage3.pratt.maxkeyframing.ScaleKeyframeResponse;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Vector3SimpleKey;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class ASFBone {
    public static final Integer DOF_TX = new Integer(0);
    public static final Integer DOF_TY = new Integer(1);
    public static final Integer DOF_TZ = new Integer(2);
    public static final Integer DOF_RX = new Integer(3);
    public static final Integer DOF_RY = new Integer(4);
    public static final Integer DOF_RZ = new Integer(5);
    public static final Integer DOF_L = new Integer(6);
    private static final World scene = new World();
    public String name = "";
    public Vector3d direction;
    public double length = 0.04;
    public Matrix33 model_transform;
    public Matrix33 base_axis;
    public Matrix33 axis;
    public Vector3d base_position;
    public Vector3d position;
    public Vector dof = new Vector();
    public Vector children = new Vector();
    public Vector3d endPoint;
    public Model model;
    public Model realMod = null;
    public ASFBone parent = null;
    public double width = 0.04;
    public PositionKeyframeResponse positionKeyframeAnim;
    public QuaternionKeyframeResponse quaternionKeyframeAnim;
    public ScaleKeyframeResponse lengthKeyframeAnim;
    public CatmullRomSpline positionSpline;
    public QuaternionSlerpSpline quaternionSpline;
    public CatmullRomSpline lengthSpline;
    public double lastTime;
    public boolean hasFrame = false;
    public boolean accumulated = false;

    public ASFBone() {
        this.base_position = new Vector3d(0.0, 0.0, 0.0);
        this.position = new Vector3d(0.0, 0.0, 0.0);
        this.direction = new Vector3d(0.0, 0.0, 1.0);
        this.base_axis = new Matrix33();
        this.axis = new Matrix33();
        this.lastTime = Double.NEGATIVE_INFINITY;
        this.positionKeyframeAnim = new PositionKeyframeResponse();
        this.positionKeyframeAnim.name.set("bonePositionKeyframeAnim");
        this.positionSpline = new CatmullRomSpline();
        this.positionKeyframeAnim.spline.set(this.positionSpline);
        this.positionKeyframeAnim.duration.set(null);
        this.quaternionKeyframeAnim = new QuaternionKeyframeResponse();
        this.quaternionKeyframeAnim.name.set("jointAngleKeyframeAnim");
        this.quaternionSpline = new QuaternionSlerpSpline();
        this.quaternionKeyframeAnim.spline.set(this.quaternionSpline);
        this.quaternionKeyframeAnim.duration.set(null);
        this.lengthKeyframeAnim = new ScaleKeyframeResponse();
        this.lengthKeyframeAnim.name.set("boneLengthKeyframeAnim");
        this.lengthSpline = new CatmullRomSpline();
        this.lengthKeyframeAnim.spline.set(this.lengthSpline);
        this.lengthKeyframeAnim.duration.set(null);
    }

    public ASFBone(String n) {
        this();
        this.name = n;
    }

    private IndexedTriangleArray buildUnitCube() {
        Vertex3d[] vertices = new Vertex3d[24];
        int[] indices = new int[]{0, 1, 2, 0, 2, 3, 4, 5, 6, 4, 6, 7, 8, 9, 10, 8, 10, 11, 12, 13, 14, 12, 14, 15, 16, 17, 18, 16, 18, 19, 20, 21, 22, 20, 22, 23};
        vertices[0] = Vertex3d.createXYZIJKUV(-0.5, 0.5, 0.0, 0.0, 0.0, -1.0, 0.0f, 0.0f);
        vertices[1] = Vertex3d.createXYZIJKUV(0.5, 0.5, 0.0, 0.0, 0.0, -1.0, 0.0f, 0.0f);
        vertices[2] = Vertex3d.createXYZIJKUV(0.5, -0.5, 0.0, 0.0, 0.0, -1.0, 0.0f, 0.0f);
        vertices[3] = Vertex3d.createXYZIJKUV(-0.5, -0.5, 0.0, 0.0, 0.0, -1.0, 0.0f, 0.0f);
        vertices[4] = Vertex3d.createXYZIJKUV(0.5, 0.5, 0.0, 1.0, 0.0, 0.0, 0.0f, 0.0f);
        vertices[5] = Vertex3d.createXYZIJKUV(0.5, 0.5, 1.0, 1.0, 0.0, 0.0, 0.0f, 0.0f);
        vertices[6] = Vertex3d.createXYZIJKUV(0.5, -0.5, 1.0, 1.0, 0.0, 0.0, 0.0f, 0.0f);
        vertices[7] = Vertex3d.createXYZIJKUV(0.5, -0.5, 0.0, 1.0, 0.0, 0.0, 0.0f, 0.0f);
        vertices[8] = Vertex3d.createXYZIJKUV(0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 0.0f, 0.0f);
        vertices[9] = Vertex3d.createXYZIJKUV(-0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 0.0f, 0.0f);
        vertices[10] = Vertex3d.createXYZIJKUV(-0.5, -0.5, 1.0, 0.0, 0.0, 1.0, 0.0f, 0.0f);
        vertices[11] = Vertex3d.createXYZIJKUV(0.5, -0.5, 1.0, 0.0, 0.0, 1.0, 0.0f, 0.0f);
        vertices[12] = Vertex3d.createXYZIJKUV(-0.5, 0.5, 1.0, -1.0, 0.0, 0.0, 0.0f, 0.0f);
        vertices[13] = Vertex3d.createXYZIJKUV(-0.5, 0.5, 0.0, -1.0, 0.0, 0.0, 0.0f, 0.0f);
        vertices[14] = Vertex3d.createXYZIJKUV(-0.5, -0.5, 0.0, -1.0, 0.0, 0.0, 0.0f, 0.0f);
        vertices[15] = Vertex3d.createXYZIJKUV(-0.5, -0.5, 1.0, -1.0, 0.0, 0.0, 0.0f, 0.0f);
        vertices[16] = Vertex3d.createXYZIJKUV(-0.5, 0.5, 1.0, 0.0, 1.0, 0.0, 0.0f, 0.0f);
        vertices[17] = Vertex3d.createXYZIJKUV(0.5, 0.5, 1.0, 0.0, 1.0, 0.0, 0.0f, 0.0f);
        vertices[18] = Vertex3d.createXYZIJKUV(0.5, 0.5, 0.0, 0.0, 1.0, 0.0, 0.0f, 0.0f);
        vertices[19] = Vertex3d.createXYZIJKUV(-0.5, 0.5, 0.0, 0.0, 1.0, 0.0, 0.0f, 0.0f);
        vertices[20] = Vertex3d.createXYZIJKUV(-0.5, -0.5, 0.0, 0.0, -1.0, 0.0, 0.0f, 0.0f);
        vertices[21] = Vertex3d.createXYZIJKUV(0.5, -0.5, 0.0, 0.0, -1.0, 0.0, 0.0f, 0.0f);
        vertices[22] = Vertex3d.createXYZIJKUV(0.5, -0.5, 1.0, 0.0, -1.0, 0.0, 0.0f, 0.0f);
        vertices[23] = Vertex3d.createXYZIJKUV(-0.5, -0.5, 1.0, 0.0, -1.0, 0.0, 0.0f, 0.0f);
        IndexedTriangleArray ita = new IndexedTriangleArray();
        ita.indices.set(indices);
        ita.vertices.set(vertices);
        return ita;
    }

    private IndexedTriangleArray buildBoneGeometry(double width, double length) {
        Matrix44 coordSys = Matrix44.IDENTITY;
        Vertex3d[] vertices = new Vertex3d[24];
        int[] indices = new int[]{0, 1, 2, 0, 2, 3, 4, 5, 6, 4, 6, 7, 8, 9, 10, 8, 10, 11, 12, 13, 14, 12, 14, 15, 16, 17, 18, 16, 18, 19, 20, 21, 22, 20, 22, 23};
        Vector4d normal = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(0.0, 0.0, -1.0, 0.0));
        Vector4d point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, width / 2.0, 0.0, 1.0));
        vertices[0] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, width / 2.0, 0.0, 1.0));
        vertices[1] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, -width / 2.0, 0.0, 1.0));
        vertices[2] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, -width / 2.0, 0.0, 1.0));
        vertices[3] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        normal = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(1.0, 0.0, 0.0, 0.0));
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, width / 2.0, 0.0, 1.0));
        vertices[4] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, width / 2.0, length, 1.0));
        vertices[5] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, -width / 2.0, length, 1.0));
        vertices[6] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, -width / 2.0, 0.0, 1.0));
        vertices[7] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, width / 2.0, length, 1.0));
        normal = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(0.0, 0.0, 1.0, 0.0));
        vertices[8] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, width / 2.0, length, 1.0));
        vertices[9] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, -width / 2.0, length, 1.0));
        vertices[10] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, -width / 2.0, length, 1.0));
        vertices[11] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, width / 2.0, length, 1.0));
        normal = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-1.0, 0.0, 0.0, 0.0));
        vertices[12] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, width / 2.0, 0.0, 1.0));
        vertices[13] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, -width / 2.0, 0.0, 1.0));
        vertices[14] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, -width / 2.0, length, 1.0));
        vertices[15] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, width / 2.0, length, 1.0));
        normal = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(0.0, 1.0, 0.0, 0.0));
        vertices[16] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, width / 2.0, length, 1.0));
        vertices[17] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, width / 2.0, 0.0, 1.0));
        vertices[18] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, width / 2.0, 0.0, 1.0));
        vertices[19] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        normal = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(0.0, -1.0, 0.0, 0.0));
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, -width / 2.0, 0.0, 1.0));
        vertices[20] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, -width / 2.0, 0.0, 1.0));
        vertices[21] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(width / 2.0, -width / 2.0, length, 1.0));
        vertices[22] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        point = MathUtilities.multiply((Matrix4d)coordSys, new Vector4d(-width / 2.0, -width / 2.0, length, 1.0));
        vertices[23] = Vertex3d.createXYZIJKUV(point.x, point.y, point.z, normal.x, normal.y, normal.z, 0.0f, 0.0f);
        IndexedTriangleArray ita = new IndexedTriangleArray();
        ita.indices.set(indices);
        ita.vertices.set(vertices);
        return ita;
    }

    public Model buildBone(ASFBone parent) {
        return this.buildBone(parent, false);
    }

    public Model buildBone(ASFBone parent, boolean length_geometry) {
        if (parent != null) {
            this.base_position = parent.endPoint;
            this.model = new Model();
            this.model.isFirstClass.set(false);
            parent.model.addChild(this.model);
            parent.model.parts.add(this.model);
            this.model.vehicle.set(parent.model);
        } else {
            this.model = new Model();
            this.model.isFirstClass.set(true);
            this.model.vehicle.set(scene);
        }
        this.parent = parent;
        this.model.setOrientationRightNow(this.base_axis, (ReferenceFrame)scene);
        this.model.setPositionRightNow(this.base_position, scene);
        this.base_axis = this.model.getOrientationAsAxes();
        this.base_position = this.model.getPosition();
        IndexedTriangleArray geom = this.buildBoneGeometry(0.04, 0.04);
        this.model.addChild(geom);
        this.model.geometry.set(geom);
        this.model.name.set(this.name);
        if (parent != null) {
            this.endPoint = MathUtilities.multiply(this.direction, this.length / this.direction.length());
            this.endPoint.add((Tuple3d)parent.endPoint);
        } else {
            this.endPoint = new Vector3d(0.0, 0.0, 0.0);
        }
        if (length_geometry && this.length != 0.0 && parent != null) {
            Model unit_cube = new Model();
            geom = this.buildBoneGeometry(0.04, this.length);
            unit_cube.addChild(geom);
            unit_cube.geometry.set(geom);
            unit_cube.isFirstClass.set(false);
            unit_cube.name.set(this.model.name.getStringValue().concat("_bone"));
            this.model.addChild(unit_cube);
            this.model.parts.add(unit_cube);
            unit_cube.vehicle.set(this.model);
            if (this.direction.x == 0.0 && this.direction.z == 0.0) {
                unit_cube.setOrientationRightNow(this.direction, new Vector3d(0.0, 0.0, -1.0), (ReferenceFrame)scene);
            } else {
                unit_cube.setOrientationRightNow(this.direction, new Vector3d(0.0, 1.0, 0.0), (ReferenceFrame)scene);
            }
        }
        ListIterator li = this.children.listIterator();
        while (li.hasNext()) {
            ASFBone child = (ASFBone)li.next();
            Model model = child.buildBone(this);
        }
        return this.model;
    }

    public void setBasePose(Model mod) {
        this.setBasePose(mod, true);
    }

    public void setBasePose(Model mod, boolean use) {
        if (mod == null) {
            mod = this.model;
        }
        if (use) {
            this.realMod = mod;
            if (this.name.compareTo("root") == 0) {
                mod.setPointOfViewRightNow(this.model.getPointOfView());
                if (this.model != mod) {
                    mod.turnRightNow(Direction.LEFT, 0.5);
                }
            }
            this.base_axis = this.model.getOrientationAsAxes(mod.vehicle.getReferenceFrameValue());
            Matrix33 toCharacter = mod.getOrientationAsAxes();
            Matrix33 base_axis_inv = new Matrix33(this.base_axis);
            base_axis_inv.invert();
            this.model_transform = Matrix33.multiply(toCharacter, base_axis_inv);
            this.base_position = MathUtilities.subtract(mod.getPosition(), this.base_position);
        }
        ListIterator li = this.children.listIterator();
        while (li.hasNext()) {
            ASFBone child = (ASFBone)li.next();
            Model part = (Model)mod.getChildNamed(child.name);
            if (part == null) {
                BoneSelectDialog bsd = new BoneSelectDialog(child.name, mod.getChildren(Model.class));
                bsd.pack();
                bsd.setVisible(true);
                if (bsd.getSelectedPart() != null) {
                    part = (Model)bsd.getSelectedPart();
                } else if (bsd.doDescend()) {
                    child.setBasePose(mod, false);
                }
            }
            if (part == null) continue;
            child.setBasePose(part);
        }
    }

    public void addFrames() {
        this.addFrames(false, Matrix44.IDENTITY);
    }

    public void addFrames(Matrix44 accum) {
        this.addFrames(true, accum);
    }

    public void addFrames(boolean hasAccum, Matrix44 accum) {
        Matrix44 newAccum = Matrix44.IDENTITY;
        if (hasAccum) {
            this.accumulated = true;
        }
        if (this.hasFrame || hasAccum) {
            newAccum = Matrix44.multiply(new Matrix44(this.axis, this.position), accum);
            if (this.realMod != null) {
                if (this.dof.contains(DOF_TX) || this.dof.contains(DOF_TY) || this.dof.contains(DOF_TZ)) {
                    this.positionSpline.addKey(new Vector3SimpleKey(this.lastTime, Matrix44.multiply(new Matrix44(this.model_transform, new Vector3d()), Matrix44.multiply(newAccum, new Matrix44(this.base_axis, new Vector3d()))).getPosition()));
                }
                if (this.dof.contains(DOF_RX) || this.dof.contains(DOF_RY) || this.dof.contains(DOF_RZ) || hasAccum) {
                    this.quaternionSpline.addKey(new QuaternionKey(this.lastTime, Matrix33.multiply(this.model_transform, Matrix33.multiply(newAccum.getAxes(), this.base_axis)).getQuaternion()));
                }
            }
        }
        ListIterator li = this.children.listIterator();
        while (li.hasNext()) {
            ASFBone child = (ASFBone)li.next();
            if (this.realMod == null && (this.hasFrame || hasAccum)) {
                Matrix44 newInvBase = child.model.getPointOfView(this.model);
                newInvBase.invert();
                child.addFrames(Matrix44.multiply(Matrix44.multiply(child.model.getPointOfView(this.model), newAccum), newInvBase));
                continue;
            }
            child.addFrames();
        }
        this.hasFrame = false;
    }

    public Response buildAnim(CompositeResponse anim) {
        if (this.realMod != null) {
            if (this.dof.contains(DOF_TX) || this.dof.contains(DOF_TY) || this.dof.contains(DOF_TZ)) {
                this.positionKeyframeAnim.subject.set(this.realMod);
                this.positionKeyframeAnim.name.set(this.name.concat(this.positionKeyframeAnim.name.getStringValue()));
                anim.addChild(this.positionKeyframeAnim);
                anim.componentResponses.add(this.positionKeyframeAnim);
            }
            if (this.dof.contains(DOF_RX) || this.dof.contains(DOF_RY) || this.dof.contains(DOF_RZ) || this.accumulated) {
                this.quaternionKeyframeAnim.subject.set(this.realMod);
                this.quaternionKeyframeAnim.name.set(this.name.concat(this.quaternionKeyframeAnim.name.getStringValue()));
                anim.addChild(this.quaternionKeyframeAnim);
                anim.componentResponses.add(this.quaternionKeyframeAnim);
            }
        }
        ListIterator li = this.children.listIterator();
        while (li.hasNext()) {
            ASFBone child = (ASFBone)li.next();
            child.buildAnim(anim);
        }
        return anim;
    }

    public void buildPoses(Model rootMod, Pose startPose, Pose endPose) {
        if (this.realMod != null) {
            Key quaternionKey;
            Key positionKey;
            Vector3 position = this.realMod.getPosition();
            if (this.dof.contains(DOF_TX) || this.dof.contains(DOF_TY) || this.dof.contains(DOF_TZ)) {
                positionKey = this.positionSpline.getFirstKey();
                position = (Vector3)positionKey.createSample(positionKey.getValueComponents());
            }
            Quaternion orientation = this.realMod.getOrientationAsQuaternion();
            if (this.dof.contains(DOF_RX) || this.dof.contains(DOF_RY) || this.dof.contains(DOF_RZ) || this.accumulated) {
                quaternionKey = this.quaternionSpline.getFirstKey();
                orientation = (Quaternion)quaternionKey.createSample(quaternionKey.getValueComponents());
            }
            ((Hashtable)startPose.poseMap.getDictionaryValue()).put(this.realMod.getKey(rootMod), new Matrix44(orientation, position));
            if (this.dof.contains(DOF_TX) || this.dof.contains(DOF_TY) || this.dof.contains(DOF_TZ)) {
                positionKey = this.positionSpline.getLastKey();
                position = (Vector3)positionKey.createSample(positionKey.getValueComponents());
            }
            if (this.dof.contains(DOF_RX) || this.dof.contains(DOF_RY) || this.dof.contains(DOF_RZ) || this.accumulated) {
                quaternionKey = this.quaternionSpline.getLastKey();
                orientation = (Quaternion)quaternionKey.createSample(quaternionKey.getValueComponents());
            }
            ((Hashtable)endPose.poseMap.getDictionaryValue()).put(this.realMod.getKey(rootMod), new Matrix44(orientation, position));
        }
        ListIterator li = this.children.listIterator();
        while (li.hasNext()) {
            ASFBone child = (ASFBone)li.next();
            child.buildPoses(rootMod, startPose, endPose);
        }
    }
}

