/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.importers.mocap;

import edu.cmu.cs.stage3.alice.authoringtool.AbstractImporter;
import edu.cmu.cs.stage3.alice.authoringtool.importers.mocap.ASFBone;
import edu.cmu.cs.stage3.alice.authoringtool.importers.mocap.ASFSkeleton;
import edu.cmu.cs.stage3.alice.authoringtool.util.BackslashConverterFilterInputStream;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.io.EStreamTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ASFImporter
extends AbstractImporter {
    protected ASFSkeleton skel = new ASFSkeleton();
    private static final World scene = new World();

    @Override
    public Map getExtensionMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ASF", "Acclaim Skeleton File");
        return map;
    }

    /*
     * Unable to fully structure code
     */
    private Model parseASF(InputStream is) throws IOException {
        this.skel.anglescale = 1.0;
        this.skel.lengthscale = 0.0254;
        bcfis = new BackslashConverterFilterInputStream(is);
        br = new BufferedReader(new InputStreamReader(bcfis));
        tokenizer = new EStreamTokenizer(br);
        tokenizer.commentChar(35);
        tokenizer.eolIsSignificant(true);
        tokenizer.lowerCaseMode(true);
        tokenizer.parseNumbers();
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(58, 58);
        while (tokenizer.ttype != -3 || !tokenizer.sval.equals(":units") && !tokenizer.sval.equals(":root")) {
            tokenizer.nextToken();
        }
        if (tokenizer.sval.equals(":units")) {
            tokenizer.nextToken();
            while (tokenizer.ttype != -3 || tokenizer.sval.charAt(0) != ':') {
                if (tokenizer.ttype != -3) {
                    tokenizer.nextToken();
                    continue;
                }
                if (tokenizer.sval.equals("length")) {
                    tokenizer.nextToken();
                    this.skel.lengthscale /= tokenizer.nval;
                } else if (tokenizer.sval.equals("angle")) {
                    tokenizer.nextToken();
                    if (tokenizer.sval.equals("deg")) {
                        this.skel.anglescale = 0.017453292519943295;
                    }
                }
                tokenizer.nextToken();
            }
            while (tokenizer.ttype != -3 || !tokenizer.sval.equals(":root")) {
                tokenizer.nextToken();
            }
            tokenizer.nextToken();
        }
        this.skel.bones.addElement(new ASFBone("root"));
        this.skel.bones_dict.put("root", this.skel.bones.lastElement());
        bone = this.skel.getRoot();
        while (tokenizer.ttype != -3 || tokenizer.sval.charAt(0) != ':') {
            if (tokenizer.ttype != -3) {
                tokenizer.nextToken();
                continue;
            }
            if (tokenizer.sval.equals("position")) {
                tokenizer.nextToken();
                bone.base_position.x = tokenizer.nval * this.skel.lengthscale;
                tokenizer.nextToken();
                bone.base_position.y = tokenizer.nval * this.skel.lengthscale;
                tokenizer.nextToken();
                bone.base_position.z = -tokenizer.nval * this.skel.lengthscale;
            } else if (tokenizer.sval.equals("orientation")) {
                tokenizer.nextToken();
                bone.base_axis.rotateX(-tokenizer.nval * this.skel.anglescale);
                tokenizer.nextToken();
                bone.base_axis.rotateY(-tokenizer.nval * this.skel.anglescale);
                tokenizer.nextToken();
                bone.base_axis.rotateZ(tokenizer.nval * this.skel.anglescale);
            } else if (tokenizer.sval.equals("order")) {
                while (tokenizer.nextToken() != 10) {
                    if (tokenizer.sval.equals("tx")) {
                        bone.dof.addElement(ASFBone.DOF_TX);
                        continue;
                    }
                    if (tokenizer.sval.equals("ty")) {
                        bone.dof.addElement(ASFBone.DOF_TY);
                        continue;
                    }
                    if (tokenizer.sval.equals("tz")) {
                        bone.dof.addElement(ASFBone.DOF_TZ);
                        continue;
                    }
                    if (tokenizer.sval.equals("rx")) {
                        bone.dof.addElement(ASFBone.DOF_RX);
                        continue;
                    }
                    if (tokenizer.sval.equals("ry")) {
                        bone.dof.addElement(ASFBone.DOF_RY);
                        continue;
                    }
                    if (!tokenizer.sval.equals("rz")) continue;
                    bone.dof.addElement(ASFBone.DOF_RZ);
                }
            }
            tokenizer.nextToken();
        }
        while (tokenizer.ttype != -3 || !tokenizer.sval.equals(":bonedata")) {
            tokenizer.nextToken();
        }
        tokenizer.nextToken();
        ** GOTO lbl180
        {
            tokenizer.nextToken();
            do {
                if (tokenizer.ttype != -3 || tokenizer.sval.charAt(0) != ':' && !tokenizer.sval.equals("begin")) continue block6;
                if (tokenizer.sval.charAt(0) == ':') break block6;
                tokenizer.nextToken();
                bone = new ASFBone();
                while (tokenizer.ttype != -3 || !tokenizer.sval.equals("end")) {
                    if (tokenizer.ttype != -3) {
                        tokenizer.nextToken();
                        continue;
                    }
                    if (tokenizer.sval.equals("axis")) {
                        tokenizer.nextToken();
                        bone.base_axis.rotateX(-tokenizer.nval * this.skel.anglescale);
                        tokenizer.nextToken();
                        bone.base_axis.rotateY(-tokenizer.nval * this.skel.anglescale);
                        tokenizer.nextToken();
                        bone.base_axis.rotateZ(tokenizer.nval * this.skel.anglescale);
                    } else if (tokenizer.sval.equals("direction")) {
                        tokenizer.nextToken();
                        bone.direction.x = tokenizer.nval;
                        tokenizer.nextToken();
                        bone.direction.y = tokenizer.nval;
                        tokenizer.nextToken();
                        bone.direction.z = -tokenizer.nval;
                    } else if (tokenizer.sval.equals("length")) {
                        tokenizer.nextToken();
                        bone.length = tokenizer.nval * this.skel.lengthscale;
                    } else if (tokenizer.sval.equals("name")) {
                        tokenizer.nextToken();
                        bone.name = tokenizer.sval;
                    } else if (tokenizer.sval.equals("dof")) {
                        while (tokenizer.nextToken() != 10) {
                            if (tokenizer.sval.equals("tx")) {
                                bone.dof.addElement(ASFBone.DOF_TX);
                                continue;
                            }
                            if (tokenizer.sval.equals("ty")) {
                                bone.dof.addElement(ASFBone.DOF_TY);
                                continue;
                            }
                            if (tokenizer.sval.equals("tz")) {
                                bone.dof.addElement(ASFBone.DOF_TZ);
                                continue;
                            }
                            if (tokenizer.sval.equals("rx")) {
                                bone.dof.addElement(ASFBone.DOF_RX);
                                continue;
                            }
                            if (tokenizer.sval.equals("ry")) {
                                bone.dof.addElement(ASFBone.DOF_RY);
                                continue;
                            }
                            if (tokenizer.sval.equals("rz")) {
                                bone.dof.addElement(ASFBone.DOF_RZ);
                                continue;
                            }
                            if (!tokenizer.sval.equals("l")) continue;
                            bone.dof.addElement(ASFBone.DOF_L);
                        }
                    }
                    tokenizer.nextToken();
                }
                tokenizer.nextToken();
                this.skel.bones.addElement(bone);
                this.skel.bones_dict.put(bone.name, bone);
lbl180:
                // 2 sources

            } while (tokenizer.ttype != -3 || tokenizer.sval.charAt(0) != ':');
        }
        while (tokenizer.ttype != -3 || !tokenizer.sval.equals(":hierarchy")) {
            tokenizer.nextToken();
        }
        tokenizer.nextToken();
        while (tokenizer.ttype != -3 || !tokenizer.sval.equals("begin")) {
            tokenizer.nextToken();
        }
        tokenizer.nextToken();
        while (tokenizer.ttype != -3 || !tokenizer.sval.equals("end")) {
            if (tokenizer.ttype != -3) {
                tokenizer.nextToken();
                continue;
            }
            bone = (ASFBone)this.skel.bones_dict.get(tokenizer.sval);
            while (tokenizer.nextToken() != 10) {
                bone.children.addElement(this.skel.bones_dict.get(tokenizer.sval));
            }
        }
        return this.skel.buildBones();
    }

    @Override
    protected Element load(InputStream is, String ext) throws IOException {
        return this.parseASF(is);
    }

    public ASFSkeleton loadSkeleton(InputStream is) throws IOException {
        this.parseASF(is);
        return this.skel;
    }

    public ASFSkeleton getSkeleton() {
        return this.skel;
    }
}

