/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.importers.mocap;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class MocapImporterOptionsDialog
extends JDialog {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JList partsList = new JList();
    JLabel promptLabel = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JComboBox nativeFPSCombo = new JComboBox();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JComboBox aliceFPSCombo = new JComboBox();
    JButton okButton = new JButton();
    JLabel jLabel3 = new JLabel();
    JTextField jSkelFile = new JTextField();
    JButton jFileBoxButton = new JButton();
    JButton cancelButton = new JButton();
    public Element selectedPart = null;
    public double fps = 30.0;
    public int nativeFPS = 60;
    public String asfFile = "etc/Skeleton.asf";
    public File ASFPath = new File("");
    public boolean ok = false;

    public MocapImporterOptionsDialog() {
        try {
            this.setContentPane(new JPanel());
            this.jbInit();
            this.guiInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void guiInit() {
        DefaultListModel<ElementOrNullWrapper> listOfStuff = new DefaultListModel<ElementOrNullWrapper>();
        this.partsList.setModel(listOfStuff);
        listOfStuff.addElement(new ElementOrNullWrapper(null, Messages.getString("Build_Model_from_skeleton_file")));
        Sandbox[] possibilities = (Sandbox[])AuthoringTool.getHack().getWorld().sandboxes.getArrayValue();
        int i = 0;
        while (i < possibilities.length) {
            listOfStuff.addElement(new ElementOrNullWrapper(possibilities[i]));
            ++i;
        }
        this.partsList.setSelectedIndex(0);
        this.aliceFPSCombo.insertItemAt("15", 0);
        this.aliceFPSCombo.insertItemAt("30", 1);
        this.aliceFPSCombo.setSelectedIndex(1);
        this.nativeFPSCombo.insertItemAt("60", 0);
        this.nativeFPSCombo.insertItemAt("120", 1);
        this.nativeFPSCombo.setSelectedIndex(0);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.partsList.setSelectionMode(0);
        this.promptLabel.setText(Messages.getString("Which_character_shall_I_animate_"));
        this.setModal(true);
        this.setTitle(Messages.getString("Mocap_Importer_Options"));
        this.jLabel1.setText(Messages.getString("Motion_Captured_FPS_"));
        this.jLabel2.setText(Messages.getString("Alice_KeyFrames_sec_"));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MocapImporterOptionsDialog.this.okButton_actionPerformed(e);
            }
        });
        this.jLabel3.setText(Messages.getString("Skeleton_File_"));
        this.jSkelFile.setPreferredSize(new Dimension(100, 21));
        this.jSkelFile.setText("etc/Skeleton.asf");
        this.jFileBoxButton.setText("...");
        this.jFileBoxButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MocapImporterOptionsDialog.this.jFileBoxButton_actionPerformed(e);
            }
        });
        this.nativeFPSCombo.setEditable(true);
        this.aliceFPSCombo.setEditable(true);
        this.cancelButton.setText(Messages.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MocapImporterOptionsDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.promptLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 60));
        this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jLabel2, new GridBagConstraints(0, 4, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.nativeFPSCombo, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.aliceFPSCombo, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jSkelFile, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.partsList, null);
        this.getContentPane().add((Component)this.jFileBoxButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 1, 0, 5), -19, -8));
        this.getContentPane().add((Component)this.okButton, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.cancelButton, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.selectedPart = ((ElementOrNullWrapper)this.partsList.getSelectedValue()).obj;
        this.asfFile = this.jSkelFile.getText();
        this.fps = Double.parseDouble((String)this.aliceFPSCombo.getSelectedItem());
        this.nativeFPS = Integer.parseInt((String)this.nativeFPSCombo.getSelectedItem());
        this.ok = true;
        this.setVisible(false);
    }

    public Element getSelectedPart() {
        return this.selectedPart;
    }

    public double getFPS() {
        return this.fps;
    }

    public int getNativeFPS() {
        return this.nativeFPS;
    }

    public String getASFFile() {
        return this.asfFile;
    }

    public void setNativeFPS(int nfps) {
        this.nativeFPS = nfps;
        if (nfps == 60) {
            this.nativeFPSCombo.setSelectedIndex(0);
        } else if (nfps == 120) {
            this.nativeFPSCombo.setSelectedIndex(1);
        } else {
            this.nativeFPSCombo.insertItemAt(String.valueOf(this.nativeFPS), 2);
            this.nativeFPSCombo.setSelectedIndex(2);
        }
    }

    public void setASFFile(String filename) {
        this.jSkelFile.setText(filename);
    }

    public void setASFPath(File path) {
        this.ASFPath = path;
    }

    void jFileBoxButton_actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        class ASFFileFilter
        extends FileFilter {
            ASFFileFilter() {
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.toString().toLowerCase().endsWith(".asf");
            }

            @Override
            public String getDescription() {
                return "ASF - Acclaim Skeleton File";
            }
        }
        chooser.setFileFilter(new ASFFileFilter());
        try {
            chooser.setCurrentDirectory(this.ASFPath);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            this.jSkelFile.setText(chooser.getSelectedFile().getPath());
        }
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.ok = false;
        this.setVisible(false);
    }

    class ElementOrNullWrapper {
        public Element obj = null;
        public String text = null;

        public ElementOrNullWrapper(Element o, String t) {
            this.obj = o;
            this.text = t;
        }

        public ElementOrNullWrapper(Element o) {
            this.obj = o;
        }

        public String toString() {
            if (this.text != null) {
                return this.text;
            }
            return this.obj.name.getStringValue();
        }
    }
}

