/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.AlicePopupMenu;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;

public class AliceMenu
extends JMenu
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuUI";
    private AlicePopupMenu popupMenu;
    private ChangeListener menuChangeListener = null;
    private MenuEvent menuEvent = null;
    private static Hashtable listenerRegistry = null;
    private int delay;
    private boolean receivedKeyPressed;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    protected JMenu.WinListener popupListener;

    public AliceMenu() {
        this("");
    }

    public AliceMenu(String s) {
        super(s);
    }

    public AliceMenu(Action a) {
        this();
        this.setAction(a);
    }

    public AliceMenu(String s, boolean b) {
        this(s);
    }

    @Override
    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
        if (this.popupMenu != null) {
            this.popupMenu.setUI((PopupMenuUI)UIManager.getUI(this.popupMenu));
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void setModel(ButtonModel newModel) {
        ButtonModel oldModel = this.getModel();
        super.setModel(newModel);
        if (oldModel != null && this.menuChangeListener != null) {
            oldModel.removeChangeListener(this.menuChangeListener);
            this.menuChangeListener = null;
        }
        this.model = newModel;
        if (newModel != null) {
            this.menuChangeListener = this.createMenuChangeListener();
            newModel.addChangeListener(this.menuChangeListener);
        }
    }

    @Override
    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    @Override
    public void setSelected(boolean b) {
        ButtonModel model = this.getModel();
        boolean oldValue = model.isSelected();
        if (this.accessibleContext != null && oldValue != b) {
            if (b) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        if (b != model.isSelected()) {
            this.getModel().setSelected(b);
        }
    }

    @Override
    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.popupMenu.isVisible();
    }

    @Override
    public void setPopupMenuVisible(boolean b) {
        if (!this.isEnabled()) {
            return;
        }
        boolean isVisible = this.isPopupMenuVisible();
        if (b != isVisible) {
            this.ensurePopupMenuCreated();
            if (b && this.isShowing()) {
                Point p = this.getPopupMenuOrigin();
                this.getPopupMenu().show(this, p.x, p.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    @Override
    protected Point getPopupMenuOrigin() {
        int x = 0;
        int y = 0;
        JPopupMenu pm = this.getPopupMenu();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        screenSize.height -= 28;
        Dimension s = this.getSize();
        Dimension pmSize = pm.getSize();
        if (pmSize.width == 0) {
            pmSize = pm.getPreferredSize();
        }
        Point position = this.getLocationOnScreen();
        Container parent = this.getParent();
        if (parent instanceof JPopupMenu) {
            x = this.getComponentOrientation().isLeftToRight() ? (position.x + s.width + pmSize.width < screenSize.width ? s.width : 0 - pmSize.width) : (position.x < pmSize.width ? s.width : 0 - pmSize.width);
            y = position.y + pmSize.height < screenSize.height ? 0 : s.height - pmSize.height;
        } else {
            x = this.getComponentOrientation().isLeftToRight() ? (position.x + pmSize.width < screenSize.width ? 0 : s.width - pmSize.width) : (position.x + s.width < pmSize.width ? 0 : s.width - pmSize.width);
            y = position.y + s.height + pmSize.height < screenSize.height ? s.height : 0 - pmSize.height;
        }
        return new Point(x, y);
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public void setDelay(int d) {
        if (d < 0) {
            throw new IllegalArgumentException(Messages.getString("Delay_must_be_a_positive_integer"));
        }
        this.delay = d;
    }

    private void ensurePopupMenuCreated() {
        if (this.popupMenu == null) {
            AliceMenu thisMenu = this;
            this.popupMenu = new AlicePopupMenu();
            this.popupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.popupMenu);
            this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    AliceMenu.this.fireMenuCanceled();
                }
            });
        }
    }

    @Override
    public void setMenuLocation(int x, int y) {
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(x, y);
        }
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        AccessibleContext ac = menuItem.getAccessibleContext();
        ac.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        return this.popupMenu.add(menuItem);
    }

    @Override
    public Component add(Component c) {
        AccessibleContext ac;
        if (c instanceof JComponent && (ac = ((JComponent)c).getAccessibleContext()) != null) {
            ac.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(c);
        return c;
    }

    @Override
    public Component add(Component c, int index) {
        AccessibleContext ac;
        if (c instanceof JComponent && (ac = ((JComponent)c).getAccessibleContext()) != null) {
            ac.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(c, index);
        return c;
    }

    @Override
    public JMenuItem add(String s) {
        return this.add(new JMenuItem(s));
    }

    @Override
    public JMenuItem add(Action a) {
        JMenuItem mi = this.createActionComponent(a);
        mi.setAction(a);
        this.add(mi);
        return mi;
    }

    @Override
    protected JMenuItem createActionComponent(Action a) {
        JMenuItem mi = new JMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon")){

            @Override
            protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
                PropertyChangeListener pcl = AliceMenu.this.createActionChangeListener(this);
                if (pcl == null) {
                    pcl = super.createActionPropertyChangeListener(a);
                }
                return pcl;
            }
        };
        mi.setHorizontalTextPosition(4);
        mi.setVerticalTextPosition(0);
        mi.setEnabled(a.isEnabled());
        return mi;
    }

    @Override
    protected PropertyChangeListener createActionChangeListener(JMenuItem b) {
        return new ActionChangedListener(b);
    }

    @Override
    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.popupMenu.addSeparator();
    }

    @Override
    public void insert(String s, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException(Messages.getString("index_less_than_zero_"));
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JMenuItem(s), pos);
    }

    @Override
    public JMenuItem insert(JMenuItem mi, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException(Messages.getString("index_less_than_zero_"));
        }
        AccessibleContext ac = mi.getAccessibleContext();
        ac.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(mi, pos);
        return mi;
    }

    @Override
    public JMenuItem insert(Action a, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException(Messages.getString("index_less_than_zero_"));
        }
        this.ensurePopupMenuCreated();
        JMenuItem mi = new JMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
        mi.setHorizontalTextPosition(4);
        mi.setVerticalTextPosition(0);
        mi.setEnabled(a.isEnabled());
        mi.setAction(a);
        this.popupMenu.insert(mi, pos);
        return mi;
    }

    @Override
    public void insertSeparator(int index) {
        if (index < 0) {
            throw new IllegalArgumentException(Messages.getString("index_less_than_zero_"));
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JPopupMenu.Separator(), index);
    }

    @Override
    public JMenuItem getItem(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException(Messages.getString("index_less_than_zero_"));
        }
        Component c = this.getMenuComponent(pos);
        if (c instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)c;
            return mi;
        }
        return null;
    }

    @Override
    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    @Override
    public boolean isTearOff() {
        throw new Error(Messages.getString("boolean_isTearOff______not_yet_implemented"));
    }

    @Override
    public void remove(JMenuItem item) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(item);
        }
    }

    @Override
    public void remove(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException(Messages.getString("index_less_than_zero_"));
        }
        if (pos > this.getItemCount()) {
            throw new IllegalArgumentException(Messages.getString("index_greater_than_the_number_of_items_"));
        }
        if (this.popupMenu != null) {
            this.popupMenu.remove(pos);
        }
    }

    @Override
    public void remove(Component c) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(c);
        }
    }

    @Override
    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    @Override
    public int getMenuComponentCount() {
        int componentCount = 0;
        if (this.popupMenu != null) {
            componentCount = this.popupMenu.getComponentCount();
        }
        return componentCount;
    }

    @Override
    public Component getMenuComponent(int n) {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponent(n);
        }
        return null;
    }

    @Override
    public Component[] getMenuComponents() {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponents();
        }
        return new Component[0];
    }

    @Override
    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    @Override
    public boolean isMenuComponent(Component c) {
        JPopupMenu comp;
        if (c == this) {
            return true;
        }
        if (c instanceof JPopupMenu && (comp = (JPopupMenu)c) == this.getPopupMenu()) {
            return true;
        }
        int ncomponents = this.getMenuComponentCount();
        Component[] component = this.getMenuComponents();
        int i = 0;
        while (i < ncomponents) {
            AliceMenu subMenu;
            Component comp2 = component[i];
            if (comp2 == c) {
                return true;
            }
            if (comp2 instanceof AliceMenu && (subMenu = (AliceMenu)comp2).isMenuComponent(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Point translateToPopupMenu(Point p) {
        return this.translateToPopupMenu(p.x, p.y);
    }

    private Point translateToPopupMenu(int x, int y) {
        int newY;
        int newX;
        if (this.getParent() instanceof JPopupMenu) {
            newX = x - this.getSize().width;
            newY = y;
        } else {
            newX = x;
            newY = y - this.getSize().height;
        }
        return new Point(newX, newY);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    @Override
    public void addMenuListener(MenuListener l) {
        this.listenerList.add(MenuListener.class, l);
    }

    @Override
    public void removeMenuListener(MenuListener l) {
        this.listenerList.remove(MenuListener.class, l);
    }

    @Override
    protected void fireMenuSelected() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == MenuListener.class) {
                if (listeners[i + 1] == null) {
                    throw new Error(String.valueOf(this.getText()) + " " + Messages.getString("has_a_NULL_Listener_") + i);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)listeners[i + 1]).menuSelected(this.menuEvent);
            }
            i -= 2;
        }
    }

    @Override
    protected void fireMenuDeselected() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == MenuListener.class) {
                if (listeners[i + 1] == null) {
                    throw new Error(String.valueOf(this.getText()) + " " + Messages.getString("has_a_NULL_Listener_") + i);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)listeners[i + 1]).menuDeselected(this.menuEvent);
            }
            i -= 2;
        }
    }

    @Override
    protected void fireMenuCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == MenuListener.class) {
                if (listeners[i + 1] == null) {
                    throw new Error(String.valueOf(this.getText()) + " " + Messages.getString("has_a_NULL_Listener_") + i);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)listeners[i + 1]).menuCanceled(this.menuEvent);
            }
            i -= 2;
        }
    }

    private ChangeListener createMenuChangeListener() {
        return new MenuChangeListener();
    }

    @Override
    protected JMenu.WinListener createWinListener(JPopupMenu p) {
        return new JMenu.WinListener(this, p);
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        this.setSelected(isIncluded);
    }

    @Override
    public MenuElement[] getSubElements() {
        if (this.popupMenu == null) {
            return new MenuElement[0];
        }
        MenuElement[] result = new MenuElement[]{this.popupMenu};
        return result;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error(Messages.getString("setAccelerator___is_not_defined_for_AliceMenu___Use_setMnemonic___instead_"));
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        switch (e.getID()) {
            case 1005: {
                this.receivedKeyPressed = false;
                break;
            }
        }
        super.processFocusEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        boolean createMenuEvent = false;
        switch (e.getID()) {
            case 401: {
                if (this.isSelected()) {
                    this.receivedKeyPressed = true;
                    createMenuEvent = true;
                    break;
                }
                this.receivedKeyPressed = false;
                break;
            }
            case 402: {
                if (!this.receivedKeyPressed) break;
                this.receivedKeyPressed = false;
                createMenuEvent = true;
                break;
            }
            default: {
                createMenuEvent = this.receivedKeyPressed;
            }
        }
        if (createMenuEvent) {
            MenuSelectionManager.defaultManager().processKeyEvent(e);
        }
        if (e.isConsumed()) {
            return;
        }
        if (this.isSelected() && (e.getKeyCode() == 9 || e.getKeyChar() == '\t')) {
            if ((Boolean)UIManager.get("Menu.consumesTabs") == Boolean.TRUE) {
                e.consume();
                return;
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        super.processKeyEvent(e);
    }

    @Override
    public void doClick(int pressTime) {
        MenuElement[] me = this.buildMenuElementArray(this);
        MenuSelectionManager.defaultManager().setSelectedPath(me);
    }

    private MenuElement[] buildMenuElementArray(AliceMenu leaf) {
        Vector<JComponent> elements = new Vector<JComponent>();
        Component current = leaf.getPopupMenu();
        while (true) {
            if (current instanceof JPopupMenu) {
                JPopupMenu pop = current;
                elements.insertElementAt(pop, 0);
                current = pop.getInvoker();
                continue;
            }
            if (current instanceof AliceMenu) {
                AliceMenu menu = (AliceMenu)current;
                elements.insertElementAt(menu, 0);
                current = menu.getParent();
                continue;
            }
            if (current instanceof JMenuBar) break;
        }
        JMenuBar bar = (JMenuBar)current;
        elements.insertElementAt(bar, 0);
        Object[] me = new MenuElement[elements.size()];
        elements.copyInto(me);
        return me;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    @Override
    protected String paramString() {
        return super.paramString();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJMenu
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener,
    AccessibleSelection {
        public AccessibleJMenu() {
            super(AliceMenu.this);
            AliceMenu.this.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        @Override
        public int getAccessibleChildrenCount() {
            Component[] children = AliceMenu.this.getMenuComponents();
            int count = 0;
            int j = 0;
            while (j < children.length) {
                if (children[j] instanceof Accessible) {
                    ++count;
                }
                ++j;
            }
            return count;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            Component[] children = AliceMenu.this.getMenuComponents();
            int count = 0;
            int j = 0;
            while (j < children.length) {
                if (children[j] instanceof Accessible) {
                    if (count == i) {
                        if (children[j] instanceof JComponent) {
                            AccessibleContext ac = ((Accessible)((Object)children[j])).getAccessibleContext();
                            ac.setAccessibleParent(AliceMenu.this);
                        }
                        return (Accessible)((Object)children[j]);
                    }
                    ++count;
                }
                ++j;
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                int i = 0;
                while (i < me.length) {
                    if (me[i] == AliceMenu.this && i + 1 < me.length) {
                        return 1;
                    }
                    ++i;
                }
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            if (i < 0 || i >= AliceMenu.this.getItemCount()) {
                return null;
            }
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                int j = 0;
                while (j < me.length) {
                    if (me[j] == AliceMenu.this) {
                        while (++j < me.length) {
                            if (!(me[j] instanceof JMenuItem)) continue;
                            return (Accessible)((Object)me[j]);
                        }
                    }
                    ++j;
                }
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                JMenuItem mi = AliceMenu.this.getItem(i);
                int j = 0;
                while (j < me.length) {
                    if (me[j] == mi) {
                        return true;
                    }
                    ++j;
                }
            }
            return false;
        }

        @Override
        public void addAccessibleSelection(int i) {
            if (i < 0 || i >= AliceMenu.this.getItemCount()) {
                return;
            }
            JMenuItem mi = AliceMenu.this.getItem(i);
            if (mi != null) {
                if (mi instanceof AliceMenu) {
                    MenuElement[] me = AliceMenu.this.buildMenuElementArray((AliceMenu)mi);
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                } else {
                    mi.doClick();
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
            }
        }

        @Override
        public void removeAccessibleSelection(int i) {
            if (i < 0 || i >= AliceMenu.this.getItemCount()) {
                return;
            }
            JMenuItem mi = AliceMenu.this.getItem(i);
            if (mi != null && mi instanceof AliceMenu && ((AliceMenu)mi).isSelected()) {
                MenuElement[] old = MenuSelectionManager.defaultManager().getSelectedPath();
                MenuElement[] me = new MenuElement[old.length - 2];
                int j = 0;
                while (j < old.length - 2) {
                    me[j] = old[j];
                    ++j;
                }
                MenuSelectionManager.defaultManager().setSelectedPath(me);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            MenuElement[] old = MenuSelectionManager.defaultManager().getSelectedPath();
            if (old != null) {
                int j = 0;
                while (j < old.length) {
                    if (old[j] == AliceMenu.this) {
                        MenuElement[] me = new MenuElement[j + 1];
                        System.arraycopy(old, 0, me, 0, j);
                        me[j] = AliceMenu.this.getPopupMenu();
                        MenuSelectionManager.defaultManager().setSelectedPath(me);
                    }
                    ++j;
                }
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.setTarget(mi);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
            } else if (e.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)e.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            }
        }

        public void setTarget(JMenuItem b) {
            this.menuItem = b;
        }
    }

    class MenuChangeListener
    implements ChangeListener,
    Serializable {
        boolean isSelected = false;

        MenuChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ButtonModel model = (ButtonModel)e.getSource();
            boolean modelSelected = model.isSelected();
            if (modelSelected != this.isSelected) {
                if (modelSelected) {
                    AliceMenu.this.fireMenuSelected();
                } else {
                    AliceMenu.this.fireMenuDeselected();
                }
                this.isSelected = modelSelected;
            }
        }
    }
}

