/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.ContextAssignableUndoableRedoable;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;

public class ChildChangeUndoableRedoable
implements ContextAssignableUndoableRedoable {
    protected Element parent;
    protected Element child;
    protected int changeType;
    protected int oldIndex;
    protected int newIndex;
    protected Object context;

    public ChildChangeUndoableRedoable(ChildrenEvent childrenEvent) {
        this.parent = (Element)childrenEvent.getSource();
        this.child = childrenEvent.getChild();
        this.changeType = childrenEvent.getChangeType();
        this.oldIndex = childrenEvent.getOldIndex();
        this.newIndex = childrenEvent.getNewIndex();
    }

    public ChildChangeUndoableRedoable(ChildrenEvent childrenEvent, Object context) {
        this.parent = (Element)childrenEvent.getSource();
        this.child = childrenEvent.getChild();
        this.changeType = childrenEvent.getChangeType();
        this.oldIndex = childrenEvent.getOldIndex();
        this.newIndex = childrenEvent.getNewIndex();
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    @Override
    public void undo() {
        if (this.changeType == 1) {
            this.child.removeFromParent();
        } else if (this.changeType == 3) {
            this.parent.insertChildAt(this.child, this.oldIndex);
        } else if (this.changeType == 2) {
            this.parent.insertChildAt(this.child, this.oldIndex);
        }
    }

    @Override
    public void redo() {
        if (this.changeType == 1) {
            this.parent.insertChildAt(this.child, this.newIndex);
        } else if (this.changeType == 3) {
            this.parent.removeChild(this.child);
        } else if (this.changeType == 2) {
            this.parent.insertChildAt(this.child, this.newIndex);
        }
    }

    @Override
    public Object getAffectedObject() {
        return this.child;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    public String getLogString() {
        String logString = "TIME=<" + System.currentTimeMillis() + "> ";
        if (this.child instanceof Response) {
            if (this.child instanceof CallToUserDefinedResponse) {
                String responseType = this.child.getClass().getName();
                UserDefinedResponse udResponse = (UserDefinedResponse)((CallToUserDefinedResponse)this.child).userDefinedResponse.get();
                String methodName = "methodCopied";
                if (udResponse != null) {
                    methodName = udResponse.getKey();
                }
                ElementArrayProperty eaProp = ((CallToUserDefinedResponse)this.child).requiredActualParameters;
                Element[] elems = eaProp.getElementArrayValue();
                String params = "";
                int i = 0;
                while (i < elems.length) {
                    if (elems[i] instanceof Variable) {
                        Variable var = (Variable)elems[i];
                        params = String.valueOf(params) + var.getKey(this.child).toUpperCase() + "=<" + var.getValue() + "> ";
                    }
                    ++i;
                }
                if (this.changeType == 1) {
                    logString = String.valueOf(logString) + "EVENT=<insertCallToUserResponse> RESPONSETYPE=<" + responseType + "> " + "RESPONSENAME=<" + methodName + "> " + params + "PARENTCLASS=<" + this.parent.getClass().getName() + "> " + "PARENTKEY=<" + this.parent.getKey() + "> " + "NEWINDEX=<" + this.newIndex + ">";
                } else if (this.changeType == 3) {
                    logString = String.valueOf(logString) + "EVENT=<deleteCallToUserResponse> RESPONSETYPE=<" + responseType + "> " + "RESPONSENAME=<" + methodName + "> " + params + "PARENTCLASS=<" + this.parent.getClass().getName() + "> " + "PARENTKEY=<" + this.parent.getKey() + "> " + "OLDINDEX=<" + this.oldIndex + ">";
                } else if (this.changeType == 2) {
                    logString = String.valueOf(logString) + "EVENT=<shiftCallToUserResponse> RESPONSETYPE=<" + responseType + "> " + "RESPONSENAME=<" + methodName + "> " + params + "PARENTCLASS=<" + this.parent.getClass().getName() + "> " + "PARENTKEY=<" + this.parent.getKey() + "> " + "OLDINDEX=<" + this.oldIndex + "> " + "NEWINDEX=<" + this.newIndex + ">";
                }
            } else {
                String responseType = AuthoringToolResources.getReprForValue(this.child.getClass());
                if (responseType.indexOf("set") != -1) {
                    responseType = "set";
                } else {
                    if (responseType.indexOf("<<<") != -1 && responseType.indexOf(">>>") != -1) {
                        responseType = responseType.substring(responseType.indexOf(">>>") + 3, responseType.length());
                    }
                    if (responseType.indexOf("<") != -1 && responseType.indexOf(">") != -1) {
                        responseType = responseType.substring(0, responseType.indexOf("<"));
                    }
                }
                responseType = "<" + responseType.trim() + ">";
                Response resp = (Response)this.child;
                String[] propNames = AuthoringToolResources.getInitialVisibleProperties(this.child.getClass());
                String propValues = "";
                int i = 0;
                while (i < propNames.length) {
                    Property prop = this.child.getPropertyNamed(propNames[i]);
                    propValues = String.valueOf(propValues) + propNames[i].toUpperCase() + "=<" + AuthoringToolResources.getReprForValue(prop.get()) + "> ";
                    ++i;
                }
                if (this.changeType == 1) {
                    logString = String.valueOf(logString) + "EVENT=<insertResponse> RESPONSETYPE=<" + this.child.getClass().getName() + "> " + "RESPONSENAME=<" + responseType + "> " + propValues + " " + "PARENTCLASS=<" + this.parent.getClass().getName() + "> " + "PARENTKEY=<" + this.parent.getKey() + "> " + "NEWINDEX=<" + this.newIndex + ">";
                } else if (this.changeType == 3) {
                    logString = String.valueOf(logString) + "EVENT=<deleteResponse> RESPONSETYPE=<" + this.child.getClass().getName() + "> " + "RESPONSENAME=<" + responseType + "> " + propValues + " " + "PARENTCLASS=<" + this.parent.getClass().getName() + "> " + "PARENTKEY=<" + this.parent.getKey() + "> " + "OLDINDEX=<" + this.oldIndex + ">";
                } else if (this.changeType == 2) {
                    logString = String.valueOf(logString) + "EVENT=<shiftResponse> RESPONSETYPE=<" + this.child.getClass().getName() + "> " + "RESPONSENAME=<" + responseType + "> " + propValues + " " + "PARENTCLASS=<" + this.parent.getClass().getName() + "> " + "PARENTKEY=<" + this.parent.getKey() + "> " + "OLDINDEX=<" + this.oldIndex + "> " + "NEWINDEX=<" + this.newIndex + ">";
                }
            }
        } else if (this.changeType == 1) {
            logString = String.valueOf(logString) + "EVENT=<insertChild> CHILDTYPE=<" + this.child.getClass().getName() + "> " + "CHILDKEY=<" + this.child.getKey() + "> " + "PARENTKEY=<" + this.parent.getKey() + "> " + "NEWINDEX=<" + this.newIndex + ">";
        } else if (this.changeType == 3) {
            logString = String.valueOf(logString) + "EVENT=<deleteChild> CHILDTYPE=<" + this.child.getClass().getName() + "> " + "CHILDKEY=<" + this.child.getKey() + "> " + "PARENTKEY=<" + this.parent.getKey() + "> " + "OLDINDEX=<" + this.oldIndex + ">";
        } else if (this.changeType == 2) {
            logString = String.valueOf(logString) + "EVENT=<shiftChild> CHILDTYPE=<" + this.child.getClass().getName() + "> " + "CHILDKEY=<" + this.child.getKey() + "> " + "PARENTKEY=<" + this.parent.getKey() + "> " + "OLDINDEX=<" + this.oldIndex + "> " + "NEWINDEX=<" + this.newIndex + ">";
        }
        return logString;
    }
}

