/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class ColorRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer,
TreeCellRenderer {
    public Component getListCellRendererComponent(JList list, Object color, int index, boolean isSelected, boolean cellHasFocus) {
        return this.getComponent(color, isSelected, list.getBackground(), list.getSelectionBackground(), list.getFixedCellHeight(), list.getFont());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getComponent(color, isSelected, table.getBackground(), table.getSelectionBackground(), table.getRowHeight(), table.getFont());
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object color, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.getComponent(color, isSelected, tree.getBackground(), tree.getBackground(), tree.getRowHeight(), tree.getFont());
    }

    public Component getComponent(Object color, boolean isSelected, Color backgroundColor, Color selectionBackgroundColor, int cellHeight, Font font) {
        this.setOpaque(true);
        this.setBackground(isSelected ? selectionBackgroundColor : backgroundColor);
        this.setFont(font);
        if (color instanceof edu.cmu.cs.stage3.alice.scenegraph.Color) {
            edu.cmu.cs.stage3.alice.scenegraph.Color c = (edu.cmu.cs.stage3.alice.scenegraph.Color)color;
            color = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        } else if (color instanceof String) {
            this.setIcon(null);
            this.setText((String)color);
            return this;
        }
        int height = cellHeight - 4;
        if (height < 10) {
            height = 10;
        }
        int width = height * 2;
        this.setIcon(ColorRenderer.getIconFromColor((Color)color, width, height));
        this.setText(ColorRenderer.getTextFromColor((Color)color));
        return this;
    }

    public static Icon getIconFromColor(Color color, int width, int height) {
        BufferedImage colorImage = new BufferedImage(width, height, 1);
        Graphics2D g = colorImage.createGraphics();
        g.setColor(color);
        g.fill3DRect(0, 0, width, height, true);
        return new ImageIcon(colorImage);
    }

    public static String getTextFromColor(Color color) {
        String text = "";
        if (color.equals(Color.black)) {
            text = Messages.getString("black");
        } else if (color.equals(Color.blue)) {
            text = Messages.getString("blue");
        } else if (color.equals(Color.cyan)) {
            text = Messages.getString("cyan");
        } else if (color.equals(Color.darkGray)) {
            text = Messages.getString("darkGray");
        } else if (color.equals(Color.gray)) {
            text = Messages.getString("gray");
        } else if (color.equals(Color.green)) {
            text = Messages.getString("green");
        } else if (color.equals(Color.lightGray)) {
            text = Messages.getString("lightGray");
        } else if (color.equals(Color.magenta)) {
            text = Messages.getString("magenta");
        } else if (color.equals(Color.orange)) {
            text = Messages.getString("orange");
        } else if (color.equals(Color.pink)) {
            text = Messages.getString("pink");
        } else if (color.equals(Color.red)) {
            text = Messages.getString("red");
        } else if (color.equals(Color.white)) {
            text = Messages.getString("white");
        } else if (color.equals(Color.yellow)) {
            text = Messages.getString("yellow");
        } else {
            float[] rgba = new float[4];
            color.getComponents(rgba);
            text = String.valueOf(Messages.getString("_red___")) + rgba[0] + Messages.getString("__green___") + rgba[1] + Messages.getString("__blue___") + rgba[2] + Messages.getString("__alpha___") + rgba[3] + ">";
        }
        return text;
    }
}

