/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class CustomMouseAdapter
extends MouseAdapter {
    protected double clickDistMargin = 5.0;
    protected long clickTimeMargin = 300L;
    protected long multipleClickTimeMargin = 600L;
    protected Point pressPoint = new Point();
    protected long pressTime = 0L;
    protected int clickCount = 0;

    public double getClickDistanceMargin() {
        return this.clickDistMargin;
    }

    public void setClickDistanceMargin(double dist) {
        this.clickDistMargin = dist;
    }

    public long getClickTimeMargin() {
        return this.clickTimeMargin;
    }

    public void setClickTimeMargin(long time) {
        this.clickTimeMargin = time;
    }

    public long getMultipleClickTimeMargin() {
        return this.multipleClickTimeMargin;
    }

    public void setMultipleClickTimeMargin(long time) {
        this.multipleClickTimeMargin = time;
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        long dt = System.currentTimeMillis() - this.pressTime;
        if (dt > this.multipleClickTimeMargin) {
            this.clickCount = 0;
        }
        this.pressPoint.setLocation(ev.getPoint());
        this.pressTime = System.currentTimeMillis();
        if (ev.isPopupTrigger() || ev.getButton() == 3) {
            this.popupResponse(ev);
        } else {
            this.mouseDownResponse(ev);
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (ev.isPopupTrigger() || ev.getButton() == 3) {
            this.popupResponse(ev);
        } else {
            this.mouseUpResponse(ev);
        }
        double dist = this.pressPoint.distance(ev.getPoint());
        long dt = System.currentTimeMillis() - this.pressTime;
        if (dist < this.clickDistMargin && dt < this.clickTimeMargin) {
            ++this.clickCount;
            if (this.clickCount == 1) {
                this.singleClickResponse(ev);
            } else if (this.clickCount == 2) {
                this.doubleClickResponse(ev);
            } else if (this.clickCount == 3) {
                this.tripleClickResponse(ev);
            }
        }
    }

    protected void singleClickResponse(MouseEvent ev) {
    }

    protected void doubleClickResponse(MouseEvent ev) {
    }

    protected void tripleClickResponse(MouseEvent ev) {
    }

    protected void mouseUpResponse(MouseEvent ev) {
    }

    protected void mouseDownResponse(MouseEvent ev) {
    }

    protected void popupResponse(MouseEvent ev) {
    }
}

