/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.authoringtool.MainUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.PointOfViewUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.RenderTargetManipulatorMode;
import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Scheduler;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.camera.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix44;
import java.awt.event.MouseEvent;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class DefaultMoveMode
extends RenderTargetManipulatorMode {
    protected Transformable pickedTransformable;
    protected Transformable helper = new Transformable();
    protected World world;
    protected Camera camera = null;
    protected Transformable identity = new Transformable();
    protected Vector3d tempVec = new Vector3d();
    protected Vector3d zeroVec = new Vector3d(0.0, 0.0, 0.0);
    protected Vector4d tempVec4 = new Vector4d();
    protected Vector3d cameraForward = new Vector3d();
    protected Vector3d cameraUp = new Vector3d();
    protected Matrix44 oldTransformation;
    protected MainUndoRedoStack undoRedoStack;
    protected Scheduler scheduler;

    public DefaultMoveMode() {
        this(null, null);
    }

    public DefaultMoveMode(MainUndoRedoStack undoRedoStack, Scheduler scheduler) {
        this.undoRedoStack = undoRedoStack;
        this.scheduler = scheduler;
        this.init();
    }

    private void init() {
        this.helper.name.set("helper");
    }

    @Override
    public boolean requiresPickedObject() {
        return true;
    }

    @Override
    public boolean hideCursorOnDrag() {
        return true;
    }

    @Override
    public void mousePressed(MouseEvent ev, Transformable pickedTransformable, PickInfo pickInfo) {
        this.pickedTransformable = pickedTransformable;
        if (pickedTransformable != null) {
            this.camera = (Camera)pickInfo.getSource().getBonus();
            this.world = (World)this.camera.getSceneGraphCamera().getRoot().getBonus();
            this.oldTransformation = pickedTransformable.getLocalTransformation();
            this.helper.vehicle.set(this.world);
            this.identity.vehicle.set(this.world);
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (this.pickedTransformable != null && this.undoRedoStack != null && !ev.isPopupTrigger()) {
            this.undoRedoStack.push(new PointOfViewUndoableRedoable(this.pickedTransformable, this.oldTransformation, this.pickedTransformable.getLocalTransformation(), this.scheduler));
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev, int dx, int dy) {
        if (this.pickedTransformable != null) {
            boolean controlDown = ev.isControlDown();
            if (AikMin.isMAC()) {
                controlDown = ev.isAltDown();
            }
            boolean shiftDown = ev.isShiftDown();
            if (this.camera instanceof OrthographicCamera) {
                OrthographicCamera orthoCamera = (OrthographicCamera)this.camera;
                double nearClipHeightInScreen = this.renderTarget.getAWTComponent().getHeight();
                double nearClipHeightInWorld = orthoCamera.getSceneGraphOrthographicCamera().getPlane()[3] - orthoCamera.getSceneGraphOrthographicCamera().getPlane()[1];
                double deltaFactor = nearClipHeightInWorld / nearClipHeightInScreen;
                if (controlDown) {
                    if (shiftDown) {
                        this.helper.setTransformationRightNow(MathUtilities.createIdentityMatrix4d(), this.camera);
                        this.helper.setPositionRightNow(this.zeroVec, this.pickedTransformable);
                        this.pickedTransformable.rotateRightNow(MathUtilities.getXAxis(), (double)(-dy) * 0.01, this.helper);
                        this.pickedTransformable.rotateRightNow(MathUtilities.getYAxis(), (double)(-dx) * 0.01, this.pickedTransformable);
                    } else {
                        this.helper.setTransformationRightNow(MathUtilities.createIdentityMatrix4d(), this.camera);
                        this.helper.setPositionRightNow(this.zeroVec, this.pickedTransformable);
                        this.pickedTransformable.rotateRightNow(MathUtilities.getZAxis(), (double)(-dx) * 0.01, this.helper);
                    }
                } else if (shiftDown) {
                    this.helper.setTransformationRightNow(MathUtilities.createIdentityMatrix4d(), this.camera);
                    this.helper.setPositionRightNow(this.zeroVec, this.pickedTransformable);
                    this.tempVec.x = 0.0;
                    this.tempVec.y = (double)(-dy) * deltaFactor;
                    this.tempVec.z = 0.0;
                    this.pickedTransformable.moveRightNow(this.tempVec, (ReferenceFrame)this.helper);
                } else {
                    this.helper.setTransformationRightNow(MathUtilities.createIdentityMatrix4d(), this.camera);
                    this.helper.setPositionRightNow(this.zeroVec, this.pickedTransformable);
                    this.tempVec.x = (double)dx * deltaFactor;
                    this.tempVec.y = (double)(-dy) * deltaFactor;
                    this.tempVec.z = 0.0;
                    this.pickedTransformable.moveRightNow(this.tempVec, (ReferenceFrame)this.helper);
                }
            } else {
                double projectionMatrix11 = this.renderTarget.getProjectionMatrix(this.camera.getSceneGraphCamera()).getElement(1, 1);
                double nearClipDist = this.camera.nearClippingPlaneDistance.doubleValue();
                double nearClipHeightInWorld = 2.0 * (nearClipDist / projectionMatrix11);
                double nearClipHeightInScreen = this.renderTarget.getAWTComponent().getHeight();
                double pixelHeight = nearClipHeightInWorld / nearClipHeightInScreen;
                double objectDist = this.pickedTransformable.getPosition(this.camera).getLength();
                double deltaFactor = objectDist * pixelHeight / nearClipDist;
                if (controlDown) {
                    if (shiftDown) {
                        this.helper.setTransformationRightNow(MathUtilities.createIdentityMatrix4d(), this.camera);
                        this.helper.setPositionRightNow(this.zeroVec, this.pickedTransformable);
                        this.pickedTransformable.rotateRightNow(MathUtilities.getXAxis(), (double)(-dy) * 0.01, this.helper);
                        this.pickedTransformable.rotateRightNow(MathUtilities.getYAxis(), (double)(-dx) * 0.01, this.pickedTransformable);
                    } else {
                        this.helper.setTransformationRightNow(MathUtilities.createIdentityMatrix4d(), this.world);
                        this.helper.setPositionRightNow(this.zeroVec, this.pickedTransformable);
                        this.pickedTransformable.rotateRightNow(MathUtilities.getYAxis(), (double)(-dx) * 0.01, this.helper);
                    }
                } else if (shiftDown) {
                    this.helper.setTransformationRightNow(MathUtilities.createIdentityMatrix4d(), this.world);
                    this.helper.setPositionRightNow(this.zeroVec, this.pickedTransformable);
                    this.tempVec.x = 0.0;
                    this.tempVec.y = (double)(-dy) * deltaFactor;
                    this.tempVec.z = 0.0;
                    this.pickedTransformable.moveRightNow(this.tempVec, (ReferenceFrame)this.helper);
                } else {
                    Matrix4d cameraTransformation = this.camera.getSceneGraphTransformable().getAbsoluteTransformation();
                    this.cameraUp.x = cameraTransformation.m10;
                    this.cameraUp.y = cameraTransformation.m11;
                    this.cameraUp.z = cameraTransformation.m12;
                    this.cameraForward.x = cameraTransformation.m20;
                    this.cameraForward.y = cameraTransformation.m21;
                    this.cameraForward.z = cameraTransformation.m22;
                    this.helper.setPositionRightNow(this.zeroVec, this.pickedTransformable);
                    if (Math.abs(this.cameraForward.y) < Math.abs(this.cameraUp.y)) {
                        this.cameraForward.y = 0.0;
                        this.helper.setOrientationRightNow(this.cameraForward, this.cameraUp, (ReferenceFrame)this.world);
                    } else {
                        this.cameraUp.y = 0.0;
                        this.cameraForward.negate();
                        this.helper.setOrientationRightNow(this.cameraUp, this.cameraForward, (ReferenceFrame)this.world);
                    }
                    this.tempVec.x = (double)dx * deltaFactor;
                    this.tempVec.y = 0.0;
                    this.tempVec.z = (double)(-dy) * deltaFactor;
                    this.pickedTransformable.moveRightNow(this.tempVec, (ReferenceFrame)this.helper);
                }
            }
        }
    }
}

