/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.UndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import java.util.LinkedList;
import java.util.ListIterator;

public class DefaultUndoRedoStack
extends LinkedList
implements UndoRedoStack {
    private int currentIndex = -1;

    @Override
    public synchronized void push(UndoableRedoable ur) {
        if (this.currentIndex < this.size() - 1) {
            this.removeRange(this.currentIndex + 1, this.size());
        }
        this.addLast(ur);
        this.currentIndex = this.size() - 1;
    }

    @Override
    public synchronized UndoableRedoable pop_() {
        if (this.currentIndex == this.size() - 1) {
            --this.currentIndex;
        }
        return (UndoableRedoable)this.removeLast();
    }

    @Override
    public synchronized UndoableRedoable undo() {
        if (this.currentIndex > -1) {
            UndoableRedoable ur = (UndoableRedoable)this.get(this.currentIndex);
            ur.undo();
            --this.currentIndex;
            return ur;
        }
        return null;
    }

    @Override
    public synchronized UndoableRedoable redo() {
        if (this.currentIndex < this.size() - 1) {
            ++this.currentIndex;
            UndoableRedoable ur = (UndoableRedoable)this.get(this.currentIndex);
            ur.redo();
            return ur;
        }
        return null;
    }

    @Override
    public synchronized UndoableRedoable removeUndoable(int index) {
        UndoableRedoable ur;
        if (index < 0 || index > this.size() - 1) {
            return null;
        }
        if (index > this.currentIndex) {
            return (UndoableRedoable)this.remove(index);
        }
        UndoableRedoable removedItem = null;
        ListIterator iter = this.listIterator();
        while (iter.nextIndex() <= this.currentIndex) {
            iter.next();
        }
        while (iter.previousIndex() >= index) {
            ur = (UndoableRedoable)iter.previous();
            ur.undo();
            removedItem = ur;
        }
        iter.remove();
        --this.currentIndex;
        while (iter.nextIndex() <= this.currentIndex) {
            ur = (UndoableRedoable)iter.next();
            ur.redo();
        }
        return removedItem;
    }

    @Override
    public synchronized int getCurrentUndoableRedoableIndex() {
        return this.currentIndex;
    }

    public synchronized UndoableRedoable getCurrentUndoableRedoable() {
        return (UndoableRedoable)this.get(this.currentIndex);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.currentIndex = -1;
    }
}

