/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.DeleteContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Code;
import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Geometry;
import edu.cmu.cs.stage3.alice.core.Group;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Pose;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Sound;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.camera.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.core.light.DirectionalLight;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Composite;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.core.response.DoInOrder;
import edu.cmu.cs.stage3.alice.core.response.DoTogether;
import edu.cmu.cs.stage3.alice.core.response.PointAtAnimation;
import edu.cmu.cs.stage3.alice.core.response.PointOfViewAnimation;
import edu.cmu.cs.stage3.alice.core.response.PropertyAnimation;
import edu.cmu.cs.stage3.alice.core.response.RollAnimation;
import edu.cmu.cs.stage3.alice.core.response.TurnAnimation;
import edu.cmu.cs.stage3.alice.core.response.Wait;
import edu.cmu.cs.stage3.alice.core.style.TraditionalAnimationStyle;
import edu.cmu.cs.stage3.alice.core.util.IndexedTriangleArrayCounter;
import edu.cmu.cs.stage3.alice.core.util.TextureMapCounter;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ElementPopupUtilities {
    protected static Configuration authoringToolConfig = Configuration.getLocalConfiguration(AuthoringTool.class.getPackage());
    protected static Class[] elementPopupRunnableParams = new Class[]{Element.class};
    private static Runnable emptyRunnable = new Runnable(){

        @Override
        public void run() {
        }
    };

    public static void createAndShowElementPopupMenu(Element element, Vector structure, Component component, int x, int y) {
        JPopupMenu popup = ElementPopupUtilities.makeElementPopupMenu(element, structure);
        popup.show(component, x, y);
        PopupMenuUtilities.ensurePopupIsOnScreen(popup);
    }

    public static JPopupMenu makeElementPopup(Element element, Vector structure) {
        return ElementPopupUtilities.makeElementPopupMenu(element, structure);
    }

    public static JPopupMenu makeElementPopupMenu(Element element, Vector structure) {
        if (element != null && structure != null) {
            Object[] initArgs = new Object[]{element};
            ElementPopupUtilities.substituteRunnables(initArgs, structure);
            return PopupMenuUtilities.makePopupMenu(structure);
        }
        return null;
    }

    public static void substituteRunnables(Object[] initArgs, Vector structure) {
        ListIterator<StringObjectPair> iter = structure.listIterator();
        while (iter.hasNext()) {
            StringObjectPair newPair;
            ElementPopupRunnable r;
            Object o = iter.next();
            if (o instanceof Class && ElementPopupRunnable.class.isAssignableFrom((Class)o)) {
                try {
                    r = (ElementPopupRunnable)((Class)o).getConstructor(elementPopupRunnableParams).newInstance(initArgs);
                    newPair = new StringObjectPair(r.getDefaultLabel(), r);
                    iter.set(newPair);
                }
                catch (NoSuchMethodException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_building_popup_"), e);
                }
                catch (IllegalAccessException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_building_popup_"), e);
                }
                catch (InstantiationException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_building_popup_"), e);
                }
                catch (InvocationTargetException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_building_popup_"), e);
                }
                continue;
            }
            if (o instanceof ElementPopupRunnable) {
                r = (ElementPopupRunnable)o;
                newPair = new StringObjectPair(r.getDefaultLabel(), r);
                iter.set(newPair);
                continue;
            }
            if (!(o instanceof StringObjectPair)) continue;
            StringObjectPair pair = (StringObjectPair)o;
            if (pair.getObject() instanceof Class && ElementPopupRunnable.class.isAssignableFrom((Class)pair.getObject())) {
                try {
                    newPair = new StringObjectPair(pair.getString(), ((Class)pair.getObject()).getConstructor(elementPopupRunnableParams).newInstance(initArgs));
                    iter.set(newPair);
                }
                catch (NoSuchMethodException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_building_popup_"), e);
                }
                catch (IllegalAccessException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_building_popup_"), e);
                }
                catch (InstantiationException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_building_popup_"), e);
                }
                catch (InvocationTargetException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_building_popup_"), e);
                }
                continue;
            }
            if (!(pair.getObject() instanceof Vector)) continue;
            ElementPopupUtilities.substituteRunnables(initArgs, (Vector)pair.getObject());
        }
    }

    public static Vector makeCoerceToStructure(final Element element) {
        block5: {
            if (element == null || !element.isCoercionSupported()) break block5;
            Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
            Vector<StringObjectPair> subStructure = new Vector<StringObjectPair>();
            Class[] classes = element.getSupportedCoercionClasses();
            if (classes == null) break block5;
            int i = 0;
            while (i < classes.length) {
                block7: {
                    Class c;
                    block6: {
                        c = classes[i];
                        if (!(element instanceof TurnAnimation)) break block6;
                        TurnAnimation turnAnimation = (TurnAnimation)element;
                        if ((turnAnimation.direction.get() == Direction.FORWARD || turnAnimation.direction.get() == Direction.BACKWARD) && RollAnimation.class.isAssignableFrom(c)) break block7;
                    }
                    String repr = AuthoringToolResources.getReprForValue(c);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            AuthoringTool.getHack().getUndoRedoStack().startCompound();
                            element.coerceTo(c);
                            AuthoringTool.getHack().getUndoRedoStack().stopCompound();
                        }
                    };
                    subStructure.add(new StringObjectPair(repr, runnable));
                }
                ++i;
            }
            if (subStructure.size() > 0) {
                structure.add(new StringObjectPair(Messages.getString("change_to"), subStructure));
                return structure;
            }
            return null;
        }
        return null;
    }

    public static Vector getDefaultStructure(Element element) {
        return ElementPopupUtilities.getDefaultStructure(element, true, null, null, null);
    }

    public static Vector getDefaultStructure(Element element, boolean elementEnabled, AuthoringTool authoringTool, JTree jtree, TreePath treePath) {
        if (element instanceof Response) {
            return ElementPopupUtilities.getDefaultResponseStructure((Response)element);
        }
        if (element instanceof Question) {
            return ElementPopupUtilities.getDefaultQuestionStructure((Question)element);
        }
        if (AuthoringToolResources.characterCriterion.accept(element)) {
            return ElementPopupUtilities.getDefaultCharacterStructure(element, elementEnabled, authoringTool, jtree, treePath);
        }
        if (element instanceof World) {
            return ElementPopupUtilities.getDefaultWorldStructure((World)element);
        }
        if (element instanceof Group) {
            return ElementPopupUtilities.getDefaultGroupStructure((Group)element, jtree, treePath);
        }
        return ElementPopupUtilities.getDefaultElementStructure(element, jtree, treePath);
    }

    public static Vector getDefaultCharacterStructure(Element element, boolean elementEnabled, AuthoringTool authoringTool, JTree jtree, TreePath treePath) {
        Vector<Object> popupStructure = new Vector<Object>();
        popupStructure.add(new StringObjectPair(AuthoringToolResources.getReprForValue(element), null));
        popupStructure.add(new StringObjectPair("separator", JSeparator.class));
        if (elementEnabled) {
            popupStructure.add(new StringObjectPair(Messages.getString("methods"), PopupMenuUtilities.makeDefaultOneShotStructure(element)));
        }
        if (jtree != null && treePath != null) {
            RenameRunnable renameRunnable = new RenameRunnable(element, jtree, treePath);
            popupStructure.add(renameRunnable);
        }
        if (element instanceof Sandbox && authoringToolConfig.getValue("enableScripting").equalsIgnoreCase("true")) {
            popupStructure.add(EditScriptRunnable.class);
        }
        if (AuthoringToolResources.characterCriterion.accept(element)) {
            if (element instanceof Transformable && !(element instanceof Camera)) {
                popupStructure.add(GetAGoodLookAtRunnable.class);
                popupStructure.add(StorePoseRunnable.class);
            }
            popupStructure.add(DeleteRunnable.class);
            popupStructure.add(SaveCharacterRunnable.class);
        } else {
            popupStructure.add(DeleteRunnable.class);
        }
        return popupStructure;
    }

    public static Vector getDefaultWorldStructure(World world) {
        Vector<Class<EditScriptRunnable>> popupStructure = new Vector<Class<EditScriptRunnable>>();
        popupStructure.add(EditScriptRunnable.class);
        return popupStructure;
    }

    public static Vector getDefaultResponseStructure(Response response) {
        Vector<Class<ToggleCommentingRunnable>> structure = new Vector<Class<ToggleCommentingRunnable>>();
        structure.add(MakeCopyRunnable.class);
        structure.add(DeleteRunnable.class);
        structure.add(ToggleCommentingRunnable.class);
        Vector coerceToStructure = ElementPopupUtilities.makeCoerceToStructure(response);
        if (coerceToStructure != null) {
            structure.addAll(coerceToStructure);
        }
        return structure;
    }

    public static Vector getDefaultQuestionStructure(Question question) {
        Vector<Class<DeleteRunnable>> structure = new Vector<Class<DeleteRunnable>>();
        structure.add(DeleteRunnable.class);
        Vector coerceToStructure = ElementPopupUtilities.makeCoerceToStructure(question);
        if (coerceToStructure != null) {
            structure.addAll(coerceToStructure);
        }
        return structure;
    }

    public static Vector getDefaultGroupStructure(Group group, JTree jtree, TreePath treePath) {
        Vector<Object> structure = new Vector<Object>();
        structure.add(new StringObjectPair(AuthoringToolResources.getReprForValue(group), emptyRunnable));
        structure.add(new StringObjectPair("separator", JSeparator.class));
        structure.add(SortGroupAlphabeticallyRunnable.class);
        if (jtree != null && treePath != null) {
            RenameRunnable renameRunnable = new RenameRunnable(group, jtree, treePath);
            structure.add(renameRunnable);
        }
        structure.add(DeleteRunnable.class);
        return structure;
    }

    public static Vector getDefaultElementStructure(Element element, JTree jtree, TreePath treePath) {
        Vector<Object> structure = new Vector<Object>();
        if (jtree != null && treePath != null) {
            RenameRunnable renameRunnable = new RenameRunnable(element, jtree, treePath);
            structure.add(renameRunnable);
        }
        structure.add(DeleteRunnable.class);
        return structure;
    }

    public static class DeleteRunnable
    extends ElementPopupRunnable {
        public static final Criterion namedHeadCriterion = new Criterion(){

            @Override
            public boolean accept(Object o) {
                return o instanceof Transformable && "head".equalsIgnoreCase(((Transformable)o).name.getStringValue());
            }
        };
        protected AuthoringTool authoringTool;

        public DeleteRunnable(Element element) {
            super(element);
            this.authoringTool = AuthoringTool.getHack();
        }

        public DeleteRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("delete");
        }

        @Override
        public void run() {
            int i;
            String message;
            int result;
            if (this.element instanceof Camera ? (result = DialogManager.showConfirmDialog(message = Messages.getString("The_Camera_is_a_critical_part_of_the_World___Very_bad_things_can_happen_if_you_delete_the_Camera__nAre_you_sure_you_want_to_delete_it_"), Messages.getString("Delete_Camera_"), 0)) != 0 : this.element instanceof DirectionalLight && this.element.getRoot().getDescendants(DirectionalLight.class).length == 1 && (result = DialogManager.showConfirmDialog(message = Messages.getString("You_are_about_to_delete_the_last_directional_light_in_the_World___If_you_do_this__everything_will_probably_become_very_dark__nAre_you_sure_you_want_to_delete_it_"), Messages.getString("Delete_Light_"), 0)) != 0) {
                return;
            }
            PropertyReference[] references = this.element.getRoot().getPropertyReferencesTo(this.element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            if (references.length > 0) {
                AuthoringToolResources.garbageCollectIfPossible(references);
                references = this.element.getRoot().getPropertyReferencesTo(this.element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            }
            if (references.length > 0) {
                i = 0;
                while (i < references.length) {
                    Element refReferenceI = references[i].getReference();
                    Property refPropertyI = references[i].getProperty();
                    Element refOwnerI = refPropertyI.getOwner();
                    if (references[i].getProperty().isAlsoKnownAs(Sandbox.class, "textureMaps") && refOwnerI instanceof Sandbox) {
                        refReferenceI.setParent(refOwnerI);
                    }
                    if (references[i].getProperty().isAlsoKnownAs(Model.class, "geometry") && refOwnerI instanceof Model) {
                        refReferenceI.setParent(refOwnerI);
                    }
                    ++i;
                }
                references = this.element.getRoot().getPropertyReferencesTo(this.element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            }
            if (references.length > 0) {
                DeleteContentPane.showDeleteDialog(this, this.authoringTool);
            } else {
                Element parent;
                AuthoringTool.getHack().getUndoRedoStack().startCompound();
                if (this.element instanceof Group) {
                    i = 0;
                    while (i < this.element.getChildCount()) {
                        if (this.element.getChildAt(i) instanceof Transformable) {
                            if (this.element.getChildAt(i) instanceof Model) {
                                Model model = (Model)this.element.getChildAt(i);
                                if (model.vehicle.get() instanceof ReferenceFrame) {
                                    Property[] affectedProperties = this.calculateAffectedProperties(model);
                                    this.authoringTool.performOneShot(this.createDestroyResponse(model), this.createDestroyUndoResponse(model), affectedProperties);
                                } else {
                                    model.vehicle.set(null);
                                }
                            } else {
                                ((Transformable)this.element).vehicle.set(null);
                            }
                        }
                        ++i;
                    }
                }
                if (this.element instanceof Transformable) {
                    if (this.element instanceof Model) {
                        Model model = (Model)this.element;
                        if (model.vehicle.get() instanceof ReferenceFrame) {
                            Property[] affectedProperties = this.calculateAffectedProperties(model);
                            this.authoringTool.performOneShot(this.createDestroyResponse(model), this.createDestroyUndoResponse(model), affectedProperties);
                        } else {
                            model.vehicle.set(null);
                        }
                    } else {
                        ((Transformable)this.element).vehicle.set(null);
                    }
                }
                if ((parent = this.element.getParent()) != null) {
                    Property[] properties = parent.getProperties();
                    int i2 = 0;
                    while (i2 < properties.length) {
                        if (properties[i2].get() == this.element) {
                            properties[i2].set(AuthoringToolResources.getDefaultValueForClass(properties[i2].getValueClass()));
                        } else if (properties[i2] instanceof ObjectArrayProperty) {
                            ObjectArrayProperty oap = (ObjectArrayProperty)properties[i2];
                            int j = 0;
                            while (j < oap.size()) {
                                if (oap.get(j) == this.element) {
                                    oap.remove(j);
                                    continue;
                                }
                                ++j;
                            }
                        }
                        ++i2;
                    }
                    parent.removeChild(this.element);
                }
                AuthoringTool.getHack().getUndoRedoStack().stopCompound();
            }
        }

        protected Response createDestroyResponse(Model model) {
            Camera camera;
            Element head;
            TurnAnimation turnAnimation = new TurnAnimation();
            turnAnimation.subject.set(model);
            turnAnimation.direction.set(Direction.LEFT);
            turnAnimation.amount.set(new Double(10.0));
            turnAnimation.style.set(TraditionalAnimationStyle.BEGIN_GENTLY_AND_END_ABRUPTLY);
            PropertyAnimation opacityAnimation = new PropertyAnimation();
            opacityAnimation.element.set(model);
            opacityAnimation.propertyName.set("opacity");
            opacityAnimation.value.set(new Double(0.0));
            opacityAnimation.howMuch.set(HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
            opacityAnimation.style.set(TraditionalAnimationStyle.BEGIN_GENTLY_AND_END_ABRUPTLY);
            DoTogether doTogether = new DoTogether();
            doTogether.componentResponses.add(turnAnimation);
            doTogether.componentResponses.add(opacityAnimation);
            PropertyAnimation vehicleAnimation = new PropertyAnimation();
            vehicleAnimation.element.set(model);
            vehicleAnimation.propertyName.set("vehicle");
            vehicleAnimation.value.set(null);
            vehicleAnimation.duration.set(new Double(0.0));
            vehicleAnimation.howMuch.set(HowMuch.INSTANCE);
            Wait wait = new Wait();
            wait.duration.set(new Double(0.2));
            DoInOrder doInOrder = new DoInOrder();
            doInOrder.componentResponses.add(wait);
            Element[] heads = model.search(namedHeadCriterion);
            if (heads != null && heads.length > 0 && (head = heads[0]) instanceof Transformable && (camera = this.authoringTool.getCurrentCamera()) != null) {
                PointAtAnimation pointAt = new PointAtAnimation();
                pointAt.subject.set(head);
                pointAt.target.set(camera);
                pointAt.duration.set(new Double(0.5));
                doInOrder.componentResponses.add(pointAt);
                Wait wait2 = new Wait();
                wait2.duration.set(new Double(0.4));
                doInOrder.componentResponses.add(wait2);
            }
            doInOrder.componentResponses.add(doTogether);
            doInOrder.componentResponses.add(vehicleAnimation);
            return doInOrder;
        }

        protected Response createDestroyUndoResponse(Model model) {
            Element head;
            TurnAnimation turnAnimation = new TurnAnimation();
            turnAnimation.subject.set(model);
            turnAnimation.direction.set(Direction.RIGHT);
            turnAnimation.amount.set(new Double(5.0));
            turnAnimation.style.set(TraditionalAnimationStyle.BEGIN_ABRUPTLY_AND_END_GENTLY);
            PropertyAnimation opacityAnimation = new PropertyAnimation();
            opacityAnimation.element.set(model);
            opacityAnimation.propertyName.set("opacity");
            opacityAnimation.value.set(model.opacity.get());
            opacityAnimation.howMuch.set(HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
            opacityAnimation.style.set(TraditionalAnimationStyle.BEGIN_ABRUPTLY_AND_END_GENTLY);
            opacityAnimation.duration.set(new Double(0.8));
            DoTogether doTogether = new DoTogether();
            doTogether.componentResponses.add(turnAnimation);
            doTogether.componentResponses.add(opacityAnimation);
            PropertyAnimation vehicleAnimation = new PropertyAnimation();
            vehicleAnimation.element.set(model);
            vehicleAnimation.propertyName.set("vehicle");
            vehicleAnimation.value.set(model.vehicle.get());
            vehicleAnimation.duration.set(new Double(0.0));
            vehicleAnimation.howMuch.set(HowMuch.INSTANCE);
            DoInOrder doInOrder = new DoInOrder();
            doInOrder.componentResponses.add(vehicleAnimation);
            doInOrder.componentResponses.add(doTogether);
            Element[] heads = model.search(namedHeadCriterion);
            if (heads != null && heads.length > 0 && (head = heads[0]) instanceof Transformable) {
                Wait wait2 = new Wait();
                wait2.duration.set(new Double(0.4));
                doInOrder.componentResponses.add(wait2);
                PointOfViewAnimation povAnimation = new PointOfViewAnimation();
                povAnimation.subject.set(head);
                povAnimation.pointOfView.set(((Transformable)head).getPointOfView());
                povAnimation.duration.set(new Double(0.5));
                doInOrder.componentResponses.add(povAnimation);
            }
            return doInOrder;
        }

        protected Property[] calculateAffectedProperties(Model model) {
            Vector<ObjectProperty> properties = new Vector<ObjectProperty>();
            properties.add(model.localTransformation);
            properties.add(model.vehicle);
            Element[] descendants = model.getDescendants();
            int i = 0;
            while (i < descendants.length) {
                if (descendants[i] instanceof Model) {
                    properties.add(((Model)descendants[i]).opacity);
                    properties.add(((Model)descendants[i]).localTransformation);
                }
                ++i;
            }
            return properties.toArray(new Property[0]);
        }
    }

    public static class EditScriptRunnable
    extends ElementPopupRunnable {
        protected AuthoringTool authoringTool;

        public EditScriptRunnable(Element element) {
            this(element, AuthoringTool.getHack());
        }

        public EditScriptRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("edit_script");
        }

        @Override
        public void run() {
            if (this.element instanceof Sandbox) {
                this.authoringTool.editObject(((Sandbox)this.element).script);
            }
        }
    }

    public static abstract class ElementPopupRunnable
    implements Runnable {
        protected Element element;

        protected ElementPopupRunnable(Element element) {
            this.element = element;
        }

        public Element getElement() {
            return this.element;
        }

        public abstract String getDefaultLabel();
    }

    public static class GetAGoodLookAtRunnable
    extends ElementPopupRunnable {
        protected AuthoringTool authoringTool;

        public GetAGoodLookAtRunnable(Element element) {
            this(element, AuthoringTool.getHack());
        }

        public GetAGoodLookAtRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("Camera_get_a_good_look_at_this");
        }

        @Override
        public void run() {
            if (this.authoringTool.getCurrentCamera() instanceof SymmetricPerspectiveCamera) {
                if (this.element instanceof Transformable) {
                    this.authoringTool.getAGoodLookAt((Transformable)this.element, (SymmetricPerspectiveCamera)this.authoringTool.getCurrentCamera());
                } else {
                    AuthoringTool.showErrorDialog(Messages.getString("Can_t_get_a_good_look__element_is_not_a_Transformable"), null);
                }
            } else {
                AuthoringTool.showErrorDialog(Messages.getString("Can_t_get_a_good_look__camera_is_not_symmetric_perspective"), null);
            }
        }
    }

    public static class MakeCopyRunnable
    extends ElementPopupRunnable {
        public MakeCopyRunnable(Element element) {
            super(element);
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("make_copy");
        }

        @Override
        public void run() {
            AuthoringTool.getHack().getUndoRedoStack().startCompound();
            String name = AuthoringToolResources.getNameForNewChild(this.element.name.getStringValue(), this.element.getParent());
            if (this.element.getParent() instanceof CompositeResponse) {
                int index = ((CompositeResponse)this.element.getParent()).componentResponses.indexOf(this.element);
                Element copy = this.element.HACK_createCopy(name, this.element.getParent(), index + 1, null, null);
                ((CompositeResponse)this.element.getParent()).componentResponses.add(index + 1, copy);
            } else if (this.element.getParent() instanceof Composite) {
                int index = ((Composite)this.element.getParent()).components.indexOf(this.element);
                Element copy = this.element.HACK_createCopy(name, this.element.getParent(), index + 1, null, null);
                ((Composite)this.element.getParent()).components.add(index + 1, copy);
            } else {
                Element copy = this.element.createCopyNamed(name);
                AuthoringToolResources.addElementToAppropriateProperty(copy, copy.getParent());
            }
            AuthoringTool.getHack().getUndoRedoStack().stopCompound();
        }
    }

    public static class MakeSharedCopyRunnable
    extends ElementPopupRunnable {
        protected Class[] classesToShare = new Class[]{Geometry.class, Sound.class, TextureMap.class};

        public MakeSharedCopyRunnable(Element element) {
            super(element);
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("make_shared_copy");
        }

        @Override
        public void run() {
            AuthoringTool.getHack().getUndoRedoStack().startCompound();
            String name = AuthoringToolResources.getNameForNewChild(this.element.name.getStringValue(), this.element.getParent());
            Element copy = this.element.createCopyNamed(name, this.classesToShare);
            AuthoringToolResources.addElementToAppropriateProperty(copy, copy.getParent());
            AuthoringTool.getHack().getUndoRedoStack().stopCompound();
        }
    }

    public static class PrintStatisticsRunnable
    extends ElementPopupRunnable {
        public PrintStatisticsRunnable(Element element) {
            super(element);
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("print_statistics");
        }

        @Override
        public void run() {
            IndexedTriangleArrayCounter itaCounter = new IndexedTriangleArrayCounter();
            TextureMapCounter textureMapCounter = new TextureMapCounter();
            this.element.visit(itaCounter, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
            this.element.visit(textureMapCounter, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
            System.out.println(String.valueOf(Messages.getString("Statistics_for_")) + AuthoringToolResources.getReprForValue(this.element) + ":");
            System.out.println("  " + Messages.getString("object_count__") + itaCounter.getShownIndexedTriangleArrayCount());
            System.out.println("    " + Messages.getString("face_count__") + itaCounter.getShownIndexCount() / 3);
            System.out.println("  " + Messages.getString("vertex_count__") + itaCounter.getShownVertexCount());
            System.out.println(" " + Messages.getString("texture_count__") + textureMapCounter.getTextureMapCount());
            System.out.println(String.valueOf(Messages.getString("texture_memory__")) + textureMapCounter.getTextureMapMemoryCount() + " bytes");
        }
    }

    public static class RenameRunnable
    extends ElementPopupRunnable {
        private JTree jtree;
        private TreePath treePath;

        public RenameRunnable(Element element, JTree jtree, TreePath treePath) {
            super(element);
            this.jtree = jtree;
            this.treePath = treePath;
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("rename");
        }

        @Override
        public void run() {
            this.jtree.startEditingAtPath(this.treePath);
        }
    }

    public static class SaveCharacterRunnable
    extends ElementPopupRunnable {
        protected AuthoringTool authoringTool;

        public SaveCharacterRunnable(Element element) {
            this(element, AuthoringTool.getHack());
        }

        public SaveCharacterRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("save_object___");
        }

        @Override
        public void run() {
            this.authoringTool.saveCharacter(this.element);
        }
    }

    public static class SetElementScopeRunnable
    extends ElementPopupRunnable {
        private AuthoringTool authoringTool;

        public SetElementScopeRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("switch_to_this_element_s_scope");
        }

        @Override
        public void run() {
            this.authoringTool.setElementScope(this.element);
        }
    }

    public static class SortGroupAlphabeticallyRunnable
    extends ElementPopupRunnable {
        protected Comparator sorter = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof Element && o2 instanceof Element) {
                    String name1 = ((Element)o1).name.getStringValue();
                    String name2 = ((Element)o2).name.getStringValue();
                    return name1.compareTo(name2);
                }
                return 0;
            }
        };

        public SortGroupAlphabeticallyRunnable(Element element) {
            super(element);
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("sort_alphabetically");
        }

        @Override
        public void run() {
            if (this.element instanceof Group) {
                Group group = (Group)this.element;
                Object[] values = group.values.getArrayValue();
                Arrays.sort(values, this.sorter);
                group.values.clear();
                group.values.set(values);
            } else {
                AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Unable_to_sort_")) + this.element + " " + Messages.getString("alphabetically_because_it_is_not_a_Group_"), null);
            }
        }
    }

    public static class StorePoseRunnable
    extends ElementPopupRunnable {
        protected AuthoringTool authoringTool;

        public StorePoseRunnable(Element element) {
            this(element, AuthoringTool.getHack());
        }

        public StorePoseRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        @Override
        public String getDefaultLabel() {
            return Messages.getString("capture_pose");
        }

        @Override
        public void run() {
            if (this.element instanceof Transformable) {
                Transformable transformable = (Transformable)this.element;
                Pose pose = Pose.manufacturePose(transformable, transformable);
                pose.name.set(AuthoringToolResources.getNameForNewChild("pose", this.element));
                this.element.addChild(pose);
                transformable.poses.add(pose);
            }
        }
    }

    public static class ToggleCommentingRunnable
    extends ElementPopupRunnable {
        public ToggleCommentingRunnable(Element element) {
            super(element);
            if (!(element instanceof Code)) {
                throw new IllegalArgumentException(String.valueOf(Messages.getString("ToggleCommentRunnable_only_accepts_Responses_or_User_Defined_Questions__found__")) + element);
            }
        }

        @Override
        public String getDefaultLabel() {
            Code code = (Code)this.element;
            if (code.isCommentedOut.booleanValue()) {
                return Messages.getString("enable");
            }
            return Messages.getString("disable");
        }

        @Override
        public void run() {
            Code code = (Code)this.element;
            code.isCommentedOut.set(code.isCommentedOut.booleanValue() ? Boolean.FALSE : Boolean.TRUE);
        }
    }
}

