/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.ExtensionFileFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;

public class ExtensionGroupFileFilter
extends FileFilter
implements Comparable {
    private ArrayList extensions;
    private String description = "";
    private String baseDescription = "";

    public ExtensionGroupFileFilter(String baseDescription) {
        this.extensions = new ArrayList();
        this.baseDescription = baseDescription;
    }

    public ExtensionGroupFileFilter(ArrayList extensions, String baseDescription) {
        this.extensions = extensions;
        this.baseDescription = baseDescription;
    }

    public void addExtensionFileFilter(ExtensionFileFilter ext) {
        this.extensions.add(ext);
    }

    private void recalculateDescription() {
        ExtensionFileFilter ext;
        StringBuffer d = new StringBuffer(this.baseDescription);
        d.append(" (");
        Iterator iter = this.extensions.iterator();
        if (iter.hasNext()) {
            ext = (ExtensionFileFilter)iter.next();
            d.append(ext.getExtension());
        }
        while (iter.hasNext()) {
            ext = (ExtensionFileFilter)iter.next();
            d.append(";" + ext.getExtension());
        }
        d.append(")");
        this.description = d.toString();
    }

    @Override
    public boolean accept(File f) {
        for (ExtensionFileFilter ext : this.extensions) {
            if (!ext.accept(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        this.recalculateDescription();
        return this.description;
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.description.compareTo((String)o);
        }
        return -1;
    }
}

