/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FeedBackEnabledJTree
extends JTree {
    protected Point cursorLocation;
    protected boolean dropLinesActive;
    protected boolean showDropLines = false;
    protected int totalChildIndent;
    protected Insets insets;
    protected int depthOffset;
    protected int legBuffer = 8;
    protected TreePath fromPath = null;
    protected TreePath toPath = null;

    public FeedBackEnabledJTree() {
        this.init();
    }

    public FeedBackEnabledJTree(Hashtable value) {
        super(value);
        this.init();
    }

    public FeedBackEnabledJTree(Object[] value) {
        super(value);
        this.init();
    }

    public FeedBackEnabledJTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    public FeedBackEnabledJTree(TreeNode root) {
        super(root);
        this.init();
    }

    public FeedBackEnabledJTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public FeedBackEnabledJTree(Vector value) {
        super(value);
        this.init();
    }

    private void init() {
        this.cursorLocation = new Point(0, 0);
        BasicTreeUI ui = (BasicTreeUI)this.getUI();
        this.totalChildIndent = ui.getLeftChildIndent() + ui.getRightChildIndent();
        this.insets = this.getInsets();
        this.updateVars();
        this.dropLinesActive = true;
        this.needChange();
        this.dropLinesActive = false;
    }

    protected void paintLines(Graphics g, Rectangle clipBounds, Insets insets, TreePath from, TreePath to) {
        int lineX = (from.getPathCount() - 1 + this.depthOffset) * this.totalChildIndent + 8 + insets.left;
        int clipLeft = 0;
        int clipRight = clipBounds.width - 1;
        if (lineX > clipLeft && lineX < clipRight) {
            int clipTop = 0;
            int clipBottom = clipBounds.height - 1;
            Rectangle fromBounds = this.getPathBounds(from);
            Rectangle toBounds = this.getPathBounds(to);
            int top = fromBounds == null ? Math.max(insets.top, clipTop) : Math.max(fromBounds.y + fromBounds.height - this.legBuffer, clipTop);
            int bottom = toBounds == null ? Math.min(insets.bottom, clipBottom) : Math.min(toBounds.y + toBounds.height, clipBottom);
            g.drawLine(lineX, top, lineX, bottom);
            g.drawLine(lineX, bottom, clipRight, bottom);
        }
    }

    public void setCursorLocation(Point p) {
        this.cursorLocation = p;
        if (this.needChange()) {
            this.repaint();
        }
        this.autoscrollIfNecessary();
    }

    protected synchronized boolean needChange() {
        if (this.dropLinesActive && this.cursorLocation != null) {
            TreePath pathToDrawFrom;
            TreePath pathToDrawTo;
            int lastRow = 0;
            while (this.getPathForRow(lastRow) != null) {
                ++lastRow;
            }
            if (--lastRow > 0 && this.getPathForRow(lastRow).equals(this.getPathForRow(0))) {
                --lastRow;
            }
            Rectangle lastBounds = this.getRowBounds(lastRow);
            int bottomy = 0;
            if (lastBounds != null) {
                bottomy = lastBounds.y + lastBounds.height;
            }
            if (this.cursorLocation.y > bottomy) {
                pathToDrawTo = this.getPathForRow(lastRow);
                pathToDrawFrom = new TreePath(this.getModel().getRoot());
            } else {
                int cursorLocationRow = this.getClosestRowForLocation(this.cursorLocation.x, this.cursorLocation.y);
                pathToDrawTo = this.getPathForRow(cursorLocationRow);
                Object toNode = pathToDrawTo.getLastPathComponent();
                if (this.getModel().getChildCount(toNode) != 0 && this.isExpanded(pathToDrawTo)) {
                    pathToDrawFrom = pathToDrawTo;
                } else {
                    pathToDrawFrom = pathToDrawTo;
                    Rectangle bounds = this.getRowBounds(cursorLocationRow);
                    if (bounds.y + bounds.height - this.cursorLocation.y < this.legBuffer) {
                        int minLevel;
                        int cursorLevel = (int)(((double)(this.cursorLocation.x - this.insets.left - 8) + (double)this.totalChildIndent / 2.0) / (double)this.totalChildIndent);
                        int maxLevel = pathToDrawTo.getPathCount() - 1;
                        if (cursorLocationRow == lastRow) {
                            minLevel = 1;
                        } else {
                            TreePath next = this.getPathForRow(cursorLocationRow + 1);
                            minLevel = next.getPathCount() - 1;
                        }
                        cursorLevel = Math.min(cursorLevel, maxLevel);
                        cursorLevel = Math.max(cursorLevel, minLevel);
                        int depthDelta = maxLevel - cursorLevel + 1;
                        while (depthDelta > 0) {
                            pathToDrawFrom = pathToDrawFrom.getParentPath();
                            --depthDelta;
                        }
                    }
                }
            }
            if (!pathToDrawFrom.equals(this.fromPath) || !pathToDrawTo.equals(this.toPath)) {
                this.fromPath = pathToDrawFrom;
                this.toPath = pathToDrawTo;
                return true;
            }
        }
        return false;
    }

    public boolean getDropLinesActive() {
        return this.dropLinesActive;
    }

    public void setDropLinesActive(boolean a) {
        if (this.dropLinesActive != a) {
            this.dropLinesActive = a;
            if (a) {
                this.updateVars();
            }
            this.repaint();
        }
    }

    public boolean getShowDropLines() {
        return this.showDropLines;
    }

    public void setShowDropLines(boolean b) {
        this.showDropLines = b;
        this.repaint();
    }

    protected void updateVars() {
        this.updateDepthOffset();
        this.insets = this.getInsets();
    }

    protected void updateDepthOffset() {
        this.depthOffset = this.isRootVisible() ? (this.getShowsRootHandles() ? 1 : 0) : (!this.getShowsRootHandles() ? -1 : 0);
    }

    public TreePath getParentPath() {
        return this.fromPath;
    }

    public TreePath[] getParentToPredecessorPaths() {
        return this.getPathBetweenRows(this.getRowForPath(this.fromPath), this.getRowForPath(this.toPath));
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
        }
        catch (NullPointerException e) {
            AuthoringTool.showErrorDialog(Messages.getString("Error_painting_tree_"), e);
        }
        if (this.dropLinesActive && this.showDropLines) {
            this.paintLines(g, this.getBounds(), this.insets, this.fromPath, this.toPath);
        }
    }

    public synchronized void autoscrollIfNecessary() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            Rectangle viewRect = ((JViewport)parent).getViewRect();
            int desiredRow = -1;
            if (this.cursorLocation.y < viewRect.y + 10) {
                desiredRow = this.getClosestRowForLocation(this.cursorLocation.x, this.cursorLocation.y) - 1;
            } else if (this.cursorLocation.y > viewRect.y + viewRect.height - 10) {
                desiredRow = this.getClosestRowForLocation(this.cursorLocation.x, this.cursorLocation.y) + 1;
            }
            int lastRow = this.getRowCount() - 1 - (this.isRootVisible() ? 0 : 1);
            if (desiredRow > -1 && desiredRow <= lastRow) {
                this.scrollRowToVisible(desiredRow);
            }
        }
    }
}

