/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.ContextAssignableUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultUndoRedoStack;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;

public class ObjectArrayPropertyUndoableRedoable
implements ContextAssignableUndoableRedoable {
    protected ObjectArrayProperty property;
    protected int changeType;
    protected int oldIndex;
    protected int newIndex;
    protected Object value;
    protected Object context;

    public ObjectArrayPropertyUndoableRedoable(ObjectArrayProperty property, int changeType, int oldIndex, int newIndex, Object value) {
        this.property = property;
        this.changeType = changeType;
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.value = value;
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    @Override
    public void undo() {
        if (this.changeType == 1) {
            this.property.remove(this.value);
        } else if (this.changeType == 3) {
            this.property.add(this.oldIndex, this.value);
        } else if (this.changeType == 2) {
            this.property.shift(this.newIndex, this.oldIndex);
        }
    }

    @Override
    public void redo() {
        if (this.changeType == 1) {
            this.property.add(this.newIndex, this.value);
        } else if (this.changeType == 3) {
            this.property.remove(this.value);
        } else if (this.changeType == 2) {
            this.property.shift(this.oldIndex, this.newIndex);
        }
    }

    @Override
    public Object getAffectedObject() {
        return this.property.getOwner();
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyUndoableRedoable[ ");
        s.append("property=" + this.property + "; ");
        s.append("changeType=" + this.changeType + "; ");
        s.append("oldIndex=" + this.oldIndex + "; ");
        s.append("newIndex=" + this.newIndex + "; ");
        s.append("value=" + this.value + "; ");
        if (this.context != this && !(this.context instanceof DefaultUndoRedoStack)) {
            s.append("context=" + this.context + "; ");
        } else {
            s.append("context=" + this.context.getClass() + "; ");
        }
        s.append(" ]");
        return s.toString();
    }

    public String getLogString() {
        String logString = "TIME=<" + System.currentTimeMillis() + "> ";
        String valueString = "";
        if (this.value instanceof Element) {
            valueString = ((Element)this.value).getKey();
        } else if (this.value != null) {
            valueString = this.value.toString();
        }
        if (this.changeType == 1) {
            logString = String.valueOf(logString) + "EVENT=<objectArrayInsert> ELEMENT=<" + valueString + "> " + "OBJECTARRAYPROPERTY=<" + this.property.getName() + "> " + "PROPERTYOWNERTYPE=<" + this.property.getOwner().getClass().getName() + "> " + "PROPERTYOWNERNAME=<" + this.property.getOwner().getKey() + "> " + "NEWINDEX=<" + this.newIndex + ">";
        } else if (this.changeType == 3) {
            logString = String.valueOf(logString) + "EVENT=<objectArrayDelete> ELEMENT=<" + valueString + "> " + "OBJECTARRAYPROPERTY=<" + this.property.getName() + "> " + "PROPERTYOWNERTYPE=<" + this.property.getOwner().getClass().getName() + "> " + "PROPERTYOWNERNAME=<" + this.property.getOwner().getKey() + "> " + "OLDINDEX=<" + this.oldIndex + ">";
        } else if (this.changeType == 2) {
            logString = String.valueOf(logString) + "EVENT=<objectArrayShift> ELEMENT=<" + valueString + "> " + "OBJECTARRAYPROPERTY=<" + this.property.getName() + "> " + "PROPERTYOWNERTYPE=<" + this.property.getOwner().getClass().getName() + "> " + "PROPERTYOWNERNAME=<" + this.property.getOwner().getKey() + "> " + "OLDINDEX=<" + this.oldIndex + "> " + "NEWINDEX=<" + this.newIndex + ">";
        }
        return logString;
    }
}

