/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.ContextAssignableUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.OneShotSimpleBehavior;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Scheduler;

public class OneShotUndoableRedoable
implements ContextAssignableUndoableRedoable {
    protected Object context;
    protected Response redoResponse;
    protected Response undoResponse;
    protected OneShotSimpleBehavior oneShotBehavior;
    protected Scheduler scheduler;

    public OneShotUndoableRedoable(Response redoResponse, Response undoResponse, OneShotSimpleBehavior oneShotBehavior, Scheduler scheduler) {
        this.redoResponse = redoResponse;
        this.undoResponse = undoResponse;
        this.oneShotBehavior = oneShotBehavior;
        this.scheduler = scheduler;
    }

    public OneShotUndoableRedoable(Response redoResponse, Response undoResponse, Property[] affectedProperties, Scheduler scheduler) {
        this.redoResponse = redoResponse;
        this.undoResponse = undoResponse;
        this.oneShotBehavior = new OneShotSimpleBehavior();
        this.oneShotBehavior.setAffectedProperties(affectedProperties);
        this.scheduler = scheduler;
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    @Override
    public void undo() {
        this.oneShotBehavior.stopRunningResponse(AuthoringToolResources.getCurrentTime());
        this.oneShotBehavior.setResponse(this.undoResponse);
        this.oneShotBehavior.start(this.scheduler);
    }

    @Override
    public void redo() {
        this.oneShotBehavior.stopRunningResponse(AuthoringToolResources.getCurrentTime());
        this.oneShotBehavior.setResponse(this.redoResponse);
        this.oneShotBehavior.start(this.scheduler);
    }

    @Override
    public Object getAffectedObject() {
        return this;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    public Response getRedoResponse() {
        return this.redoResponse;
    }

    public Response getUndoResponse() {
        return this.undoResponse;
    }

    public OneShotSimpleBehavior getOneShotBehavior() {
        return this.oneShotBehavior;
    }

    public String getLogString() {
        String logString = "TIME=<" + System.currentTimeMillis() + "> ";
        String responseType = AuthoringToolResources.getReprForValue(this.redoResponse.getClass());
        if (responseType.indexOf("set") != -1) {
            responseType = "set";
        } else {
            if (responseType.indexOf("<<<") != -1 && responseType.indexOf(">>>") != -1) {
                responseType = responseType.substring(responseType.indexOf(">>>") + 3, responseType.length());
            }
            if (responseType.indexOf("<") != -1 && responseType.indexOf(">") != -1) {
                responseType = responseType.substring(0, responseType.indexOf("<"));
            }
        }
        responseType = "<" + responseType.trim() + ">";
        String[] propNames = AuthoringToolResources.getInitialVisibleProperties(this.redoResponse.getClass());
        String propValues = "";
        int i = 0;
        while (i < propNames.length) {
            Property prop = this.redoResponse.getPropertyNamed(propNames[i]);
            propValues = String.valueOf(propValues) + propNames[i].toUpperCase() + "=<" + AuthoringToolResources.getReprForValue(prop.get()) + "> ";
            ++i;
        }
        logString = String.valueOf(logString) + "EVENT=<oneshot>  RESPONSE=" + responseType + " " + propValues;
        return logString;
    }
}

