/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.MainUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.RenderTargetManipulatorMode;
import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Scheduler;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.camera.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class OrthographicZoomMode
extends RenderTargetManipulatorMode {
    protected AuthoringTool authoringTool;
    protected MainUndoRedoStack undoRedoStack;
    protected Scheduler scheduler;
    protected Point pressPoint = new Point();
    protected Dimension renderSize = new Dimension();
    protected Camera camera = null;

    public OrthographicZoomMode(AuthoringTool authoringTool, MainUndoRedoStack undoRedoStack, Scheduler scheduler) {
        this.authoringTool = authoringTool;
        this.undoRedoStack = undoRedoStack;
        this.scheduler = scheduler;
    }

    @Override
    public boolean requiresPickedObject() {
        return false;
    }

    @Override
    public boolean hideCursorOnDrag() {
        return true;
    }

    @Override
    public void mousePressed(MouseEvent ev, Transformable pickedTransformable, PickInfo pickInfo) {
        this.camera = (Camera)pickInfo.getSource().getBonus();
        this.pressPoint.setLocation(ev.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (ev.getPoint().equals(this.pressPoint)) {
            DialogManager.showMessageDialog(Messages.getString("Click_and_drag_to_zoom_"), Messages.getString("Zoom_Message"), 1);
        } else if (this.undoRedoStack != null) {
            ev.isPopupTrigger();
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev, int dx, int dy) {
        if (this.camera instanceof OrthographicCamera && (dx != 0 || dy != 0)) {
            double divisor = ev.isShiftDown() ? 1000.0 : 50.0;
            double scaleFactor = Math.abs(dx) > Math.abs(dy) ? 1.0 - (double)dx / divisor : 1.0 - (double)dy / divisor;
            OrthographicCamera orthoCamera = (OrthographicCamera)this.camera;
            this.renderTarget.getAWTComponent().getSize(this.renderSize);
            double oldMinY = orthoCamera.minimumY.getNumberValue().doubleValue();
            double oldMaxY = orthoCamera.maximumY.getNumberValue().doubleValue();
            double oldPosX = orthoCamera.getPosition().x;
            double oldPosY = orthoCamera.getPosition().y;
            double oldHeight = oldMaxY - oldMinY;
            double pixelHeight = oldHeight / this.renderSize.getHeight();
            double pressDX = (this.pressPoint.getX() - this.renderSize.getWidth() / 2.0) * pixelHeight;
            double pressDY = -(this.pressPoint.getY() - this.renderSize.getHeight() / 2.0) * pixelHeight;
            double pressX = oldPosX + pressDX;
            double pressY = oldPosY + pressDY;
            double newPosX = pressX - scaleFactor * pressDX;
            double newPosY = pressY - scaleFactor * pressDY;
            double newHeight = oldHeight * scaleFactor;
            double newMinY = -newHeight / 2.0;
            double newMaxY = -newMinY;
            orthoCamera.setPositionRightNow(newPosX, newPosY, 0.0);
            orthoCamera.minimumY.set(new Double(newMinY));
            orthoCamera.maximumY.set(new Double(newMaxY));
        }
    }
}

